﻿using RimWorld;
using RimWorld.Planet;
using System.Collections.Generic;
using UnityEngine;
using Verse;
using Verse.Sound;

namespace MedTimes
{
    [StaticConstructorOnStartup]
    public class ITabButton
    {
        public static readonly Texture2D Drop = ContentFinder<Texture2D>.Get("UI/Buttons/Drop", true);
    }
    
    public class ITab_StorageInventory : ITab
    {
        private Vector2 scrollPosition = Vector2.zero;

        private float scrollViewHeight;

        private const float TopPadding = 20f;

        private static readonly Color ThingLabelColor = new Color(0.9f, 0.9f, 0.9f, 1f);

        private static readonly Color HighlightColor = new Color(0.5f, 0.5f, 0.5f, 1f);

        private const float ThingIconSize = 28f;

        private const float ThingRowHeight = 28f;

        private const float ThingLeftX = 36f;

        private const float StandardLineHeight = 22f;

        private static List<Thing> workingInvList = new List<Thing>();

        public override bool IsVisible
        {
            get
            {
                return true;
            }
        }

        private Building_ContainerShelf selStorage
        {
            get
            {
                if (base.SelThing != null && base.SelThing is Building_ContainerShelf bld)
                {
                    return bld;
                }
                return null;
            }
        }

        private bool CanControl
        {
            get
            {
                return selStorage.Spawned && selStorage.Faction == Faction.OfPlayer;
            }
        }  

        public ITab_StorageInventory()
        {
            this.size = new Vector2(460f, 450f);
            this.labelKey = ResourceBank.Strings.BookCaseInventoryLabel;
        }

        protected override void FillTab()
        {
            if (selStorage.TryGetInnerInteractableThingOwner() is ThingOwner t && t.Count > 0)
            {
                Text.Font = GameFont.Small;
                Rect rect = new Rect(0f, 20f, this.size.x, this.size.y - 20f);
                Rect rect2 = rect.ContractedBy(10f);
                Rect position = new Rect(rect2.x, rect2.y, rect2.width, rect2.height);
                GUI.BeginGroup(position);
                Text.Font = GameFont.Small;
                GUI.color = Color.white;
                Rect outRect = new Rect(0f, 0f, position.width, position.height);
                Rect viewRect = new Rect(0f, 0f, position.width - 16f, this.scrollViewHeight);
                Widgets.BeginScrollView(outRect, ref this.scrollPosition, viewRect, true);
                float num = 0f;

                Widgets.ListSeparator(ref num, viewRect.width, "Inventory".Translate());
                ITab_StorageInventory.workingInvList.Clear();
                ITab_StorageInventory.workingInvList.AddRange(t);
                for (int i = 0; i < ITab_StorageInventory.workingInvList.Count; i++)
                {
                    this.DrawThingRow(ref num, viewRect.width, ITab_StorageInventory.workingInvList[i], true);
                }

                if (Event.current.type == EventType.Layout)
                {
                    this.scrollViewHeight = num + 30f;
                }
                Widgets.EndScrollView();
                GUI.EndGroup();
                GUI.color = Color.white;
                Text.Anchor = TextAnchor.UpperLeft;
            }
            else
            {
                Text.Anchor = TextAnchor.MiddleCenter;
                GUI.color = Color.grey;
                Widgets.Label(new Rect(0f, 0f, size.x, size.y), "(" + "None".Translate() + ")");
                Text.Anchor = TextAnchor.UpperLeft;
                GUI.color = Color.white;
            }
        }

        private void DrawThingRow(ref float y, float width, Thing thing, bool inventory = false)
        {
            Rect rect = new Rect(0f, y, width, 28f);
            Widgets.InfoCardButton(rect.width - 24f, y, thing);
            rect.width -= 24f;
            if (this.CanControl)
            {
                Rect rect2 = new Rect(rect.width - 24f, y, 24f, 24f);
                TooltipHandler.TipRegion(rect2, "DropThing".Translate());
                if (Widgets.ButtonImage(rect2, ITabButton.Drop))
                {
                    SoundDefOf.Tick_High.PlayOneShotOnCamera(null);
                    this.InterfaceDrop(thing);
                }
                rect.width -= 24f;
            }
            Rect rect4 = rect;
            rect4.xMin = rect4.xMax - 60f;
            
            CaravanThingsTabUtility.DrawMass(thing, rect4);
            rect.width -= 60f;
            if (Mouse.IsOver(rect))
            {
                GUI.color = ITab_StorageInventory.HighlightColor;
                GUI.DrawTexture(rect, TexUI.HighlightTex);
            }
            if (thing.def.DrawMatSingle != null && thing.def.DrawMatSingle.mainTexture != null)
            {
                Widgets.ThingIcon(new Rect(4f, y, 28f, 28f), thing, 1f);
            }
            Text.Anchor = TextAnchor.MiddleLeft;
            GUI.color = ITab_StorageInventory.ThingLabelColor;
            Rect rect5 = new Rect(36f, y, rect.width - 36f, rect.height);   
            string text = GenLabel.ThingLabel(thing, thing.stackCount);    
            Text.WordWrap = false;
            Widgets.Label(rect5, text.Truncate(rect5.width, null));
            Text.WordWrap = true;            
                                    
            TooltipHandler.TipRegion(rect, text);
            y += 28f;
        }       

        private void InterfaceDrop(Thing t)
        {
            ThingWithComps thingWithComps = t as ThingWithComps;
            this.selStorage.TryDrop(t);
        }
        
    }
}
