﻿using Verse;

namespace MedTimes
{
    class Building_Terrain : Building
    {
                                  
        public override void SpawnSetup(Map map, bool respawningAfterLoad)
        {
            base.SpawnSetup(map, respawningAfterLoad);

            var defTerra = (TerraformDef)def;

            map.terrainGrid.SetTerrain(this.Position, defTerra.ResultTerrain);

            this.Destroy(DestroyMode.Vanish);

            if (defTerra.buildProducts != null)
                for (int k = 0; k < defTerra.buildProducts.Count; k++)
                {
                    ThingDefCountClass thingDefCountClass = defTerra.buildProducts[k];
                    Thing thing = ThingMaker.MakeThing(stuff: null, def: thingDefCountClass.thingDef);
                    thing.stackCount = thingDefCountClass.count;
                             
                    GenSpawn.Spawn(thing, base.Position, map, base.Rotation, WipeMode.VanishOrMoveAside);
                }     
        }
    }
}
