﻿using RimWorld;
using Verse;
using Verse.AI;

namespace MedTimes
{
    class WorkGiver_TakeCheeseOutOfCheesePress : WorkGiver_Scanner
    {
        public override ThingRequest PotentialWorkThingRequest => ThingRequest.ForDef(ResourceBank.ThingDefOf.MedTimes_CheesePress);

        public override PathEndMode PathEndMode => PathEndMode.Touch;

        public override bool HasJobOnThing(Pawn pawn, Thing t, bool forced = false)
        {
            Building_CheesePress building_CheesePress = t as Building_CheesePress;
            if (building_CheesePress == null || !building_CheesePress.Coagulated)
            {
                return false;
            }
            if (t.IsBurning())
            {
                return false;
            }
            if (!t.IsForbidden(pawn))
            {
                LocalTargetInfo target = t;
                bool ignoreOtherReservations = forced;
                if (pawn.CanReserve(target, 1, -1, null, ignoreOtherReservations))
                {
                    return true;
                }
            }
            return false;
        }

        public override Job JobOnThing(Pawn pawn, Thing t, bool forced = false)
        {
            return new Job(ResourceBank.JobDefOf.TakeCheeseOutOfCheesePress, t);
        }
    }
}
