﻿using RimWorld;
using Verse;

namespace MedTimes
{
    public class RecipeWorkerCounter_LargestProductCount : RecipeWorkerCounter
    {
        public override bool CanCountProducts(Bill_Production bill)
        {
            return bill.recipe.products.Count > 0;
        }

        public override int CountProducts(Bill_Production bill)
        {
            ThingDef largestCountProduct = LargestCountProduct(bill).thingDef;
 
            return bill.Map.resourceCounter.GetCount(largestCountProduct);
        }

        public override string ProductsDescription(Bill_Production bill)
        {
            return LargestCountProduct(bill).thingDef.label;
        }

        public override bool CanPossiblyStoreInStockpile(Bill_Production bill, Zone_Stockpile stockpile)
        {
            ThingDef largestCountProduct = LargestCountProduct(bill).thingDef;

            return stockpile.GetStoreSettings().AllowedToAccept(largestCountProduct);
        }

        public static ThingDefCountClass LargestCountProduct(Bill_Production bill)
        {
            return bill.recipe.products.MaxBy(t => t.count);
        }
    }
}
