local CTPPcamera = {
	title = "CarTPPcamera",
	version = "v1.26"
}
	local config = require("config")
	local GameUI = require("GameUI")
	local settings = config.loadFile("tppvalues.json")
	local incar = false
	local consoleopen = false
	local showlegacybtn = false -- change to 'true' if you want legacy button to appear.

-- Default values, copy legacy below values

-- Option1 - Close
local cboom = 3.5  -- Higher number means camera farther from character - default 3.5
local ccamera = 1.2 -- Higher number means camera higher from character - default 1.2
local ccamang = 20 -- Changes pitch of camera angle - default 8

-- Option2 - FAR
local fboom = 4.5  -- Higher number means camera farther from character  - default 4.5
local fcamera = 1.2 -- Higher number means camera higher from character - default 1.2
local fcamang = 4.5 -- Changes pitch of camera angle - default 4.5

--FOV and Speed Distance
local vfov = 75 -- Change FOV - default 69, going above 85 will cause texture glitches to occur
local vspd = 0 -- Camera distance when going fast - Positive number means camera gets farther when closer - default 3;
local coll = false -- Changing to 'false' will avoid camera glitch to occur when there is a collision with camera (not neccesarly with V) - default true

-- Above - Default values

config.tryCreateFile("tppvalues.json", {cboom = 0, cvert = 0, chorz = 0, fboom = 0, fvert = 0, fhorz = 0, vfov = 0, vspd = 0, ccamang = 0, fcamang = 0, coll = false})
config.backwardComp("tppvalues.json", {cboom = 0, cvert = 0, chorz = 0, fboom = 0, fvert = 0, fhorz = 0, vfov = 0, vspd = 0, ccamang = 0, fcamang = 0, coll = false})

function CTPPcamera()
--All car types below, even tank

--4w_911
--4w_911_Low_Close
TweakDB:SetFlat("Camera.VehicleTPP_4w_911_Low_Close.boomLength", settings.cboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_911_Low_Close.lookAtOffset", ToVector3{x=settings.chorz, y=0.5, z=settings.cvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_911_Low_Close.defaultRotationPitch", settings.ccamang)

--4w_911_High_Close
TweakDB:SetFlat("Camera.VehicleTPP_4w_911_High_Close.boomLength", settings.cboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_911_High_Close.lookAtOffset", ToVector3{x=settings.chorz, y=0.5, z=settings.cvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_911_High_Close.defaultRotationPitch", settings.ccamang)

--4w_911_Low_Far
TweakDB:SetFlat("Camera.VehicleTPP_4w_911_Low_Far.boomLength", settings.fboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_911_Low_Far.lookAtOffset", ToVector3{x=settings.fhorz, y=0.5, z=settings.fvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_911_Low_Far.defaultRotationPitch", settings.fcamang)

--4w_911_High_Far
TweakDB:SetFlat("Camera.VehicleTPP_4w_911_High_Far.boomLength", settings.fboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_911_High_Far.lookAtOffset", ToVector3{x=settings.fhorz, y=0.5, z=settings.fvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_911_High_Far.defaultRotationPitch", settings.fcamang)

--4w_aerondight
--4w_aerondight_Low_Close
TweakDB:SetFlat("Camera.VehicleTPP_4w_aerondight_Low_Close.boomLength", settings.cboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_aerondight_Low_Close.lookAtOffset", ToVector3{x=settings.chorz, y=0.5, z=settings.cvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_aerondight_Low_Close.defaultRotationPitch", settings.ccamang)

--4w_aerondight_High_Close
TweakDB:SetFlat("Camera.VehicleTPP_4w_aerondight_High_Close.boomLength", settings.cboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_aerondight_High_Close.lookAtOffset", ToVector3{x=settings.chorz, y=0.5, z=settings.cvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_aerondight_High_Close.defaultRotationPitch", settings.ccamang)

--4w_aerondight_Low_Far
TweakDB:SetFlat("Camera.VehicleTPP_4w_aerondight_Low_Far.boomLength", settings.fboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_aerondight_Low_Far.lookAtOffset", ToVector3{x=settings.fhorz, y=0.5, z=settings.fvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_aerondight_Low_Far.defaultRotationPitch", settings.fcamang)

--4w_aerondight_High_Far
TweakDB:SetFlat("Camera.VehicleTPP_4w_aerondight_High_Far.boomLength", settings.fboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_aerondight_High_Far.lookAtOffset", ToVector3{x=settings.fhorz, y=0.5, z=settings.fvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_aerondight_High_Far.defaultRotationPitch", settings.fcamang)

--4w_Alvarado
--4w_Alvarado_Low_Close
TweakDB:SetFlat("Camera.VehicleTPP_4w_Alvarado_Low_Close.boomLength", settings.cboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Alvarado_Low_Close.lookAtOffset", ToVector3{x=settings.chorz, y=0.5, z=settings.cvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Alvarado_Low_Close.defaultRotationPitch", settings.ccamang)

--4w_Alvarado_High_Close
TweakDB:SetFlat("Camera.VehicleTPP_4w_Alvarado_High_Close.boomLength", settings.cboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Alvarado_High_Close.lookAtOffset", ToVector3{x=settings.chorz, y=0.5, z=settings.cvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Alvarado_High_Close.defaultRotationPitch", settings.ccamang)

--4w_Alvarado_Low_Far
TweakDB:SetFlat("Camera.VehicleTPP_4w_Alvarado_Low_Far.boomLength", settings.fboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Alvarado_Low_Far.lookAtOffset", ToVector3{x=settings.fhorz, y=0.5, z=settings.fvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Alvarado_Low_Far.defaultRotationPitch", settings.fcamang)

--4w_Alvarado_High_Far
TweakDB:SetFlat("Camera.VehicleTPP_4w_Alvarado_High_Far.boomLength", settings.fboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Alvarado_High_Far.lookAtOffset", ToVector3{x=settings.fhorz, y=0.5, z=settings.fvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Alvarado_High_Far.defaultRotationPitch", settings.fcamang)

--4w_Alvarado_Preset
--4w_Alvarado_Preset_Low_Close
TweakDB:SetFlat("Camera.VehicleTPP_4w_Alvarado_Preset_Low_Close.boomLength", settings.cboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Alvarado_Preset_Low_Close.lookAtOffset", ToVector3{x=settings.chorz, y=0.5, z=settings.cvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Alvarado_Preset_Low_Close.defaultRotationPitch", settings.ccamang)

--4w_Alvarado_Preset_High_Close
TweakDB:SetFlat("Camera.VehicleTPP_4w_Alvarado_Preset_High_Close.boomLength", settings.cboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Alvarado_Preset_High_Close.lookAtOffset", ToVector3{x=settings.chorz, y=0.5, z=settings.cvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Alvarado_Preset_High_Close.defaultRotationPitch", settings.ccamang)

--4w_Alvarado_Preset_Low_Far
TweakDB:SetFlat("Camera.VehicleTPP_4w_Alvarado_Preset_Low_Far.boomLength", settings.fboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Alvarado_Preset_Low_Far.lookAtOffset", ToVector3{x=settings.fhorz, y=0.5, z=settings.fvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Alvarado_Preset_Low_Far.defaultRotationPitch", settings.fcamang)

--4w_Alvarado_Preset_High_Far
TweakDB:SetFlat("Camera.VehicleTPP_4w_Alvarado_Preset_High_Far.boomLength", settings.fboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Alvarado_Preset_High_Far.lookAtOffset", ToVector3{x=settings.fhorz, y=0.5, z=settings.fvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Alvarado_Preset_High_Far.defaultRotationPitch", settings.fcamang)

--4w_Archer_Hella
--4w_Archer_Hella_Low_Close
TweakDB:SetFlat("Camera.VehicleTPP_4w_Archer_Hella_Low_Close.boomLength", settings.cboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Archer_Hella_Low_Close.lookAtOffset", ToVector3{x=settings.chorz, y=0.5, z=settings.cvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Archer_Hella_Low_Close.defaultRotationPitch", settings.ccamang)

--4w_Archer_Hella_High_Close
TweakDB:SetFlat("Camera.VehicleTPP_4w_Archer_Hella_High_Close.boomLength", settings.cboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Archer_Hella_High_Close.lookAtOffset", ToVector3{x=settings.chorz, y=0.5, z=settings.cvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Archer_Hella_High_Close.defaultRotationPitch", settings.ccamang)

--4w_Archer_Hella_Low_Far
TweakDB:SetFlat("Camera.VehicleTPP_4w_Archer_Hella_Low_Far.boomLength", settings.fboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Archer_Hella_Low_Far.lookAtOffset", ToVector3{x=settings.fhorz, y=0.5, z=settings.fvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Archer_Hella_Low_Far.defaultRotationPitch", settings.fcamang)

--4w_Archer_Hella_High_Far
TweakDB:SetFlat("Camera.VehicleTPP_4w_Archer_Hella_High_Far.boomLength", settings.fboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Archer_Hella_High_Far.lookAtOffset", ToVector3{x=settings.fhorz, y=0.5, z=settings.fvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Archer_Hella_High_Far.defaultRotationPitch", settings.fcamang)

--4w_Archer_Quarz
--4w_Archer_Quarz_Low_Close
TweakDB:SetFlat("Camera.VehicleTPP_4w_Archer_Quarz_Low_Close.boomLength", settings.cboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Archer_Quarz_Low_Close.lookAtOffset", ToVector3{x=settings.chorz, y=0.5, z=settings.cvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Archer_Quarz_Low_Close.defaultRotationPitch", settings.ccamang)

--4w_Archer_Quarz_High_Close
TweakDB:SetFlat("Camera.VehicleTPP_4w_Archer_Quarz_High_Close.boomLength", settings.cboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Archer_Quarz_High_Close.lookAtOffset", ToVector3{x=settings.chorz, y=0.5, z=settings.cvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Archer_Quarz_High_Close.defaultRotationPitch", settings.ccamang)

--4w_Archer_Quarz_Low_Far
TweakDB:SetFlat("Camera.VehicleTPP_4w_Archer_Quarz_Low_Far.boomLength", settings.fboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Archer_Quarz_Low_Far.lookAtOffset", ToVector3{x=settings.fhorz, y=0.5, z=settings.fvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Archer_Quarz_Low_Far.defaultRotationPitch", settings.fcamang)

--4w_Archer_Quarz_High_Far
TweakDB:SetFlat("Camera.VehicleTPP_4w_Archer_Quarz_High_Far.boomLength", settings.fboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Archer_Quarz_High_Far.lookAtOffset", ToVector3{x=settings.fhorz, y=0.5, z=settings.fvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Archer_Quarz_High_Far.defaultRotationPitch", settings.fcamang)

--4w_caliburn
--4w_caliburn_Low_Close
TweakDB:SetFlat("Camera.VehicleTPP_4w_caliburn_Low_Close.boomLength", settings.cboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_caliburn_Low_Close.lookAtOffset", ToVector3{x=settings.chorz, y=0.5, z=settings.cvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_caliburn_Low_Close.defaultRotationPitch", settings.ccamang)

--4w_caliburn_High_Close
TweakDB:SetFlat("Camera.VehicleTPP_4w_caliburn_High_Close.boomLength", settings.cboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_caliburn_High_Close.lookAtOffset", ToVector3{x=settings.chorz, y=0.5, z=settings.cvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_caliburn_High_Close.defaultRotationPitch", settings.ccamang)

--4w_caliburn_Low_Far
TweakDB:SetFlat("Camera.VehicleTPP_4w_caliburn_Low_Far.boomLength", settings.fboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_caliburn_Low_Far.lookAtOffset", ToVector3{x=settings.fhorz, y=0.5, z=settings.fvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_caliburn_Low_Far.defaultRotationPitch", settings.fcamang)

--4w_caliburn_High_Far
TweakDB:SetFlat("Camera.VehicleTPP_4w_caliburn_High_Far.boomLength", settings.fboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_caliburn_High_Far.lookAtOffset", ToVector3{x=settings.fhorz, y=0.5, z=settings.fvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_caliburn_High_Far.defaultRotationPitch", settings.fcamang)

--4w_Columbus
--4w_Columbus_Low_Close
TweakDB:SetFlat("Camera.VehicleTPP_4w_Columbus_Low_Close.boomLength", settings.cboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Columbus_Low_Close.lookAtOffset", ToVector3{x=settings.chorz, y=0.5, z=settings.cvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Columbus_Low_Close.defaultRotationPitch", settings.ccamang)

--4w_Columbus_High_Close
TweakDB:SetFlat("Camera.VehicleTPP_4w_Columbus_High_Close.boomLength", settings.cboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Columbus_High_Close.lookAtOffset", ToVector3{x=settings.chorz, y=0.5, z=settings.cvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Columbus_High_Close.defaultRotationPitch", settings.ccamang)

--4w_Columbus_Low_Far
TweakDB:SetFlat("Camera.VehicleTPP_4w_Columbus_Low_Far.boomLength", settings.fboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Columbus_Low_Far.lookAtOffset", ToVector3{x=settings.fhorz, y=0.5, z=settings.fvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Columbus_Low_Far.defaultRotationPitch", settings.fcamang)

--4w_Columbus_High_Far
TweakDB:SetFlat("Camera.VehicleTPP_4w_Columbus_High_Far.boomLength", settings.fboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Columbus_High_Far.lookAtOffset", ToVector3{x=settings.fhorz, y=0.5, z=settings.fvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Columbus_High_Far.defaultRotationPitch", settings.fcamang)

--4w_Cortes_Preset
--4w_Cortes_Preset_Low_Close
TweakDB:SetFlat("Camera.VehicleTPP_4w_Cortes_Preset_Low_Close.boomLength", settings.cboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Cortes_Preset_Low_Close.lookAtOffset", ToVector3{x=settings.chorz, y=0.5, z=settings.cvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Cortes_Preset_Low_Close.defaultRotationPitch", settings.ccamang)

--4w_Cortes_Preset_High_Close
TweakDB:SetFlat("Camera.VehicleTPP_4w_Cortes_Preset_High_Close.boomLength", settings.cboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Cortes_Preset_High_Close.lookAtOffset", ToVector3{x=settings.chorz, y=0.5, z=settings.cvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Cortes_Preset_High_Close.defaultRotationPitch", settings.ccamang)

--4w_Cortes_Preset_Low_Far
TweakDB:SetFlat("Camera.VehicleTPP_4w_Cortes_Preset_Low_Far.boomLength", settings.fboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Cortes_Preset_Low_Far.lookAtOffset", ToVector3{x=settings.fhorz, y=0.5, z=settings.fvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Cortes_Preset_Low_Far.defaultRotationPitch", settings.fcamang)

--4w_Cortes_Preset_High_Far
TweakDB:SetFlat("Camera.VehicleTPP_4w_Cortes_Preset_High_Far.boomLength", settings.fboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Cortes_Preset_High_Far.lookAtOffset", ToVector3{x=settings.fhorz, y=0.5, z=settings.fvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Cortes_Preset_High_Far.defaultRotationPitch", settings.fcamang)

--4w_Galena
--4w_Galena_Low_Close
TweakDB:SetFlat("Camera.VehicleTPP_4w_Galena_Low_Close.boomLength", settings.cboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Galena_Low_Close.lookAtOffset", ToVector3{x=settings.chorz, y=0.5, z=settings.cvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Galena_Low_Close.defaultRotationPitch", settings.ccamang)

--4w_Galena_High_Close
TweakDB:SetFlat("Camera.VehicleTPP_4w_Galena_High_Close.boomLength", settings.cboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Galena_High_Close.lookAtOffset", ToVector3{x=settings.chorz, y=0.5, z=settings.cvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Galena_High_Close.defaultRotationPitch", settings.ccamang)

--4w_Galena_Low_Far
TweakDB:SetFlat("Camera.VehicleTPP_4w_Galena_Low_Far.boomLength", settings.fboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Galena_Low_Far.lookAtOffset", ToVector3{x=settings.fhorz, y=0.5, z=settings.fvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Galena_Low_Far.defaultRotationPitch", settings.fcamang)

--4w_Galena_High_Far
TweakDB:SetFlat("Camera.VehicleTPP_4w_Galena_High_Far.boomLength", settings.fboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Galena_High_Far.lookAtOffset", ToVector3{x=settings.fhorz, y=0.5, z=settings.fvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Galena_High_Far.defaultRotationPitch", settings.fcamang)

--4w_herrera_outlaw
--4w_herrera_outlaw_Low_Close
TweakDB:SetFlat("Camera.VehicleTPP_4w_herrera_outlaw_Low_Close.boomLength", settings.cboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_herrera_outlaw_Low_Close.lookAtOffset", ToVector3{x=settings.chorz, y=0.5, z=settings.cvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_herrera_outlaw_Low_Close.defaultRotationPitch", settings.ccamang)

--4w_herrera_outlaw_High_Close
TweakDB:SetFlat("Camera.VehicleTPP_4w_herrera_outlaw_High_Close.boomLength", settings.cboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_herrera_outlaw_High_Close.lookAtOffset", ToVector3{x=settings.chorz, y=0.5, z=settings.cvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_herrera_outlaw_High_Close.defaultRotationPitch", settings.ccamang)

--4w_herrera_outlaw_Low_Far
TweakDB:SetFlat("Camera.VehicleTPP_4w_herrera_outlaw_Low_Far.boomLength", settings.fboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_herrera_outlaw_Low_Far.lookAtOffset", ToVector3{x=settings.fhorz, y=0.5, z=settings.fvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_herrera_outlaw_Low_Far.defaultRotationPitch", settings.fcamang)

--4w_herrera_outlaw_High_Far
TweakDB:SetFlat("Camera.VehicleTPP_4w_herrera_outlaw_High_Far.boomLength", settings.fboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_herrera_outlaw_High_Far.lookAtOffset", ToVector3{x=settings.fhorz, y=0.5, z=settings.fvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_herrera_outlaw_High_Far.defaultRotationPitch", settings.fcamang)

--4w_Limo_Thrax
--4w_Limo_Thrax_Low_Close
TweakDB:SetFlat("Camera.VehicleTPP_4w_Limo_Thrax_Low_Close.boomLength", settings.cboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Limo_Thrax_Low_Close.lookAtOffset", ToVector3{x=settings.chorz, y=0.5, z=settings.cvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Limo_Thrax_Low_Close.defaultRotationPitch", settings.ccamang)

--4w_Limo_Thrax_High_Close
TweakDB:SetFlat("Camera.VehicleTPP_4w_Limo_Thrax_High_Close.boomLength", settings.cboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Limo_Thrax_High_Close.lookAtOffset", ToVector3{x=settings.chorz, y=0.5, z=settings.cvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Limo_Thrax_High_Close.defaultRotationPitch", settings.ccamang)

--4w_Limo_Thrax_Low_Far
TweakDB:SetFlat("Camera.VehicleTPP_4w_Limo_Thrax_Low_Far.boomLength", settings.fboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Limo_Thrax_Low_Far.lookAtOffset", ToVector3{x=settings.fhorz, y=0.5, z=settings.fvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Limo_Thrax_Low_Far.defaultRotationPitch", settings.fcamang)

--4w_Limo_Thrax_High_Far
TweakDB:SetFlat("Camera.VehicleTPP_4w_Limo_Thrax_High_Far.boomLength", settings.fboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Limo_Thrax_High_Far.lookAtOffset", ToVector3{x=settings.fhorz, y=0.5, z=settings.fvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Limo_Thrax_High_Far.defaultRotationPitch", settings.fcamang)

--4w_Makigai
--4w_Makigai_Low_Close
TweakDB:SetFlat("Camera.VehicleTPP_4w_Makigai_Low_Close.boomLength", settings.cboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Makigai_Low_Close.lookAtOffset", ToVector3{x=settings.chorz, y=0.5, z=settings.cvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Makigai_Low_Close.defaultRotationPitch", settings.ccamang)

--4w_Makigai_High_Close
TweakDB:SetFlat("Camera.VehicleTPP_4w_Makigai_High_Close.boomLength", settings.cboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Makigai_High_Close.lookAtOffset", ToVector3{x=settings.chorz, y=0.5, z=settings.cvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Makigai_High_Close.defaultRotationPitch", settings.ccamang)

--4w_Makigai_Low_Far
TweakDB:SetFlat("Camera.VehicleTPP_4w_Makigai_Low_Far.boomLength", settings.fboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Makigai_Low_Far.lookAtOffset", ToVector3{x=settings.fhorz, y=0.5, z=settings.fvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Makigai_Low_Far.defaultRotationPitch", settings.fcamang)

--4w_Makigai_High_Far
TweakDB:SetFlat("Camera.VehicleTPP_4w_Makigai_High_Far.boomLength", settings.fboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Makigai_High_Far.lookAtOffset", ToVector3{x=settings.fhorz, y=0.5, z=settings.fvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Makigai_High_Far.defaultRotationPitch", settings.fcamang)

--4w_Medium_Preset
--4w_Medium_Preset_Low_Close
TweakDB:SetFlat("Camera.VehicleTPP_4w_Medium_Preset_Low_Close.boomLength", settings.cboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Medium_Preset_Low_Close.lookAtOffset", ToVector3{x=settings.chorz, y=0.5, z=settings.cvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Medium_Preset_Low_Close.defaultRotationPitch", settings.ccamang)

--4w_Medium_Preset_High_Close
TweakDB:SetFlat("Camera.VehicleTPP_4w_Medium_Preset_High_Close.boomLength", settings.cboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Medium_Preset_High_Close.lookAtOffset", ToVector3{x=settings.chorz, y=0.5, z=settings.cvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Medium_Preset_High_Close.defaultRotationPitch", settings.ccamang)

--4w_Medium_Preset_Low_Far
TweakDB:SetFlat("Camera.VehicleTPP_4w_Medium_Preset_Low_Far.boomLength", settings.fboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Medium_Preset_Low_Far.lookAtOffset", ToVector3{x=settings.fhorz, y=0.5, z=settings.fvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Medium_Preset_Low_Far.defaultRotationPitch", settings.fcamang)

--4w_Medium_Preset_High_Far
TweakDB:SetFlat("Camera.VehicleTPP_4w_Medium_Preset_High_Far.boomLength", settings.fboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Medium_Preset_High_Far.lookAtOffset", ToVector3{x=settings.fhorz, y=0.5, z=settings.fvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Medium_Preset_High_Far.defaultRotationPitch", settings.fcamang)

--4w_Preset
--4w_Preset_Low_Close
TweakDB:SetFlat("Camera.VehicleTPP_4w_Preset_Low_Close.boomLength", settings.cboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Preset_Low_Close.lookAtOffset", ToVector3{x=settings.chorz, y=0.5, z=settings.cvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Preset_Low_Close.defaultRotationPitch", settings.ccamang)

--4w_Preset_High_Close
TweakDB:SetFlat("Camera.VehicleTPP_4w_Preset_High_Close.boomLength", settings.cboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Preset_High_Close.lookAtOffset", ToVector3{x=settings.chorz, y=0.5, z=settings.cvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Preset_High_Close.defaultRotationPitch", settings.ccamang)

--4w_Preset_Low_Far
TweakDB:SetFlat("Camera.VehicleTPP_4w_Preset_Low_Far.boomLength", settings.fboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Preset_Low_Far.lookAtOffset", ToVector3{x=settings.fhorz, y=0.5, z=settings.fvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Preset_Low_Far.defaultRotationPitch", settings.fcamang)

--4w_Preset_High_Far
TweakDB:SetFlat("Camera.VehicleTPP_4w_Preset_High_Far.boomLength", settings.fboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Preset_High_Far.lookAtOffset", ToVector3{x=settings.fhorz, y=0.5, z=settings.fvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Preset_High_Far.defaultRotationPitch", settings.fcamang)

--4w_Quadra66
--4w_Quadra66_Low_Close
TweakDB:SetFlat("Camera.VehicleTPP_4w_Quadra66_Low_Close.boomLength", settings.cboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Quadra66_Low_Close.lookAtOffset", ToVector3{x=settings.chorz, y=0.5, z=settings.cvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Quadra66_Low_Close.defaultRotationPitch", settings.ccamang)

--4w_Quadra66_High_Close
TweakDB:SetFlat("Camera.VehicleTPP_4w_Quadra66_High_Close.boomLength", settings.cboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Quadra66_High_Close.lookAtOffset", ToVector3{x=settings.chorz, y=0.5, z=settings.cvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Quadra66_High_Close.defaultRotationPitch", settings.ccamang)

--4w_Quadra66_Low_Far
TweakDB:SetFlat("Camera.VehicleTPP_4w_Quadra66_Low_Far.boomLength", settings.fboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Quadra66_Low_Far.lookAtOffset", ToVector3{x=settings.fhorz, y=0.5, z=settings.fvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Quadra66_Low_Far.defaultRotationPitch", settings.fcamang)

--4w_Quadra66_High_Far
TweakDB:SetFlat("Camera.VehicleTPP_4w_Quadra66_High_Far.boomLength", settings.fboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Quadra66_High_Far.lookAtOffset", ToVector3{x=settings.fhorz, y=0.5, z=settings.fvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Quadra66_High_Far.defaultRotationPitch", settings.fcamang)

--4w_Quadra66_Nomad
--4w_Quadra66_Nomad_Low_Close
TweakDB:SetFlat("Camera.VehicleTPP_4w_Quadra66_Nomad_Low_Close.boomLength", settings.cboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Quadra66_Nomad_Low_Close.lookAtOffset", ToVector3{x=settings.chorz, y=0.5, z=settings.cvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Quadra66_Nomad_Low_Close.defaultRotationPitch", settings.ccamang)

--4w_Quadra66_Nomad_High_Close
TweakDB:SetFlat("Camera.VehicleTPP_4w_Quadra66_Nomad_High_Close.boomLength", settings.cboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Quadra66_Nomad_High_Close.lookAtOffset", ToVector3{x=settings.chorz, y=0.5, z=settings.cvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Quadra66_Nomad_High_Close.defaultRotationPitch", settings.ccamang)

--4w_Quadra66_Nomad_Low_Far
TweakDB:SetFlat("Camera.VehicleTPP_4w_Quadra66_Nomad_Low_Far.boomLength", settings.fboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Quadra66_Nomad_Low_Far.lookAtOffset", ToVector3{x=settings.fhorz, y=0.5, z=settings.fvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Quadra66_Nomad_Low_Far.defaultRotationPitch", settings.fcamang)

--4w_Quadra66_Nomad_High_Far
TweakDB:SetFlat("Camera.VehicleTPP_4w_Quadra66_Nomad_High_Far.boomLength", settings.fboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Quadra66_Nomad_High_Far.lookAtOffset", ToVector3{x=settings.fhorz, y=0.5, z=settings.fvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Quadra66_Nomad_High_Far.defaultRotationPitch", settings.fcamang)

--4w_Quadra
--4w_Quadra_Low_Close
TweakDB:SetFlat("Camera.VehicleTPP_4w_Quadra_Low_Close.boomLength", settings.cboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Quadra_Low_Close.lookAtOffset", ToVector3{x=settings.chorz, y=0.5, z=settings.cvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Quadra_Low_Close.defaultRotationPitch", settings.ccamang)

--4w_Quadra_High_Close
TweakDB:SetFlat("Camera.VehicleTPP_4w_Quadra_High_Close.boomLength", settings.cboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Quadra_High_Close.lookAtOffset", ToVector3{x=settings.chorz, y=0.5, z=settings.cvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Quadra_High_Close.defaultRotationPitch", settings.ccamang)

--4w_Quadra_Low_Far
TweakDB:SetFlat("Camera.VehicleTPP_4w_Quadra_Low_Far.boomLength", settings.fboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Quadra_Low_Far.lookAtOffset", ToVector3{x=settings.fhorz, y=0.5, z=settings.fvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Quadra_Low_Far.defaultRotationPitch", settings.fcamang)

--4w_Quadra_High_Far
TweakDB:SetFlat("Camera.VehicleTPP_4w_Quadra_High_Far.boomLength", settings.fboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Quadra_High_Far.lookAtOffset", ToVector3{x=settings.fhorz, y=0.5, z=settings.fvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Quadra_High_Far.defaultRotationPitch", settings.fcamang)

--4w_Shion
--4w_Shion_Low_Close
TweakDB:SetFlat("Camera.VehicleTPP_4w_Shion_Low_Close.boomLength", settings.cboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Shion_Low_Close.lookAtOffset", ToVector3{x=settings.chorz, y=0.5, z=settings.cvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Shion_Low_Close.defaultRotationPitch", settings.ccamang)

--4w_Shion_High_Close
TweakDB:SetFlat("Camera.VehicleTPP_4w_Shion_High_Close.boomLength", settings.cboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Shion_High_Close.lookAtOffset", ToVector3{x=settings.chorz, y=0.5, z=settings.cvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Shion_High_Close.defaultRotationPitch", settings.ccamang)

--4w_Shion_Low_Far
TweakDB:SetFlat("Camera.VehicleTPP_4w_Shion_Low_Far.boomLength", settings.fboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Shion_Low_Far.lookAtOffset", ToVector3{x=settings.fhorz, y=0.5, z=settings.fvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Shion_Low_Far.defaultRotationPitch", settings.fcamang)

--4w_Shion_High_Far
TweakDB:SetFlat("Camera.VehicleTPP_4w_Shion_High_Far.boomLength", settings.fboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Shion_High_Far.lookAtOffset", ToVector3{x=settings.fhorz, y=0.5, z=settings.fvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Shion_High_Far.defaultRotationPitch", settings.fcamang)

--4w_SubCompact
--4w_SubCompact_Low_Close
TweakDB:SetFlat("Camera.VehicleTPP_4w_SubCompact_Low_Close.boomLength", settings.cboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_SubCompact_Low_Close.lookAtOffset", ToVector3{x=settings.chorz, y=0.5, z=settings.cvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_SubCompact_Low_Close.defaultRotationPitch", settings.ccamang)

--4w_SubCompact_High_Close
TweakDB:SetFlat("Camera.VehicleTPP_4w_SubCompact_High_Close.boomLength", settings.cboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_SubCompact_High_Close.lookAtOffset", ToVector3{x=settings.chorz, y=0.5, z=settings.cvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_SubCompact_High_Close.defaultRotationPitch", settings.ccamang)

--4w_SubCompact_Low_Far
TweakDB:SetFlat("Camera.VehicleTPP_4w_SubCompact_Low_Far.boomLength", settings.fboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_SubCompact_Low_Far.lookAtOffset", ToVector3{x=settings.fhorz, y=0.5, z=settings.fvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_SubCompact_Low_Far.defaultRotationPitch", settings.fcamang)

--4w_SubCompact_High_Far
TweakDB:SetFlat("Camera.VehicleTPP_4w_SubCompact_High_Far.boomLength", settings.fboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_SubCompact_High_Far.lookAtOffset", ToVector3{x=settings.fhorz, y=0.5, z=settings.fvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_SubCompact_High_Far.defaultRotationPitch", settings.fcamang)

--4w_Thorton_Colby
--4w_Thorton_Colby_Low_Close
TweakDB:SetFlat("Camera.VehicleTPP_4w_Thorton_Colby_Low_Close.boomLength", settings.cboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Thorton_Colby_Low_Close.lookAtOffset", ToVector3{x=settings.chorz, y=0.5, z=settings.cvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Thorton_Colby_Low_Close.defaultRotationPitch", settings.ccamang)

--4w_Thorton_Colby_High_Close
TweakDB:SetFlat("Camera.VehicleTPP_4w_Thorton_Colby_High_Close.boomLength", settings.cboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Thorton_Colby_High_Close.lookAtOffset", ToVector3{x=settings.chorz, y=0.5, z=settings.cvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Thorton_Colby_High_Close.defaultRotationPitch", settings.ccamang)

--4w_Thorton_Colby_Low_Far
TweakDB:SetFlat("Camera.VehicleTPP_4w_Thorton_Colby_Low_Far.boomLength", settings.fboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Thorton_Colby_Low_Far.lookAtOffset", ToVector3{x=settings.fhorz, y=0.5, z=settings.fvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Thorton_Colby_Low_Far.defaultRotationPitch", settings.fcamang)

--4w_Thorton_Colby_High_Far
TweakDB:SetFlat("Camera.VehicleTPP_4w_Thorton_Colby_High_Far.boomLength", settings.fboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Thorton_Colby_High_Far.lookAtOffset", ToVector3{x=settings.fhorz, y=0.5, z=settings.fvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Thorton_Colby_High_Far.defaultRotationPitch", settings.fcamang)

--4w_Thorton_Colby_Pickup
--4w_Thorton_Colby_Pickup_Low_Close
TweakDB:SetFlat("Camera.VehicleTPP_4w_Thorton_Colby_Pickup_Low_Close.boomLength", settings.cboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Thorton_Colby_Pickup_Low_Close.lookAtOffset", ToVector3{x=settings.chorz, y=0.5, z=settings.cvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Thorton_Colby_Pickup_Low_Close.defaultRotationPitch", settings.ccamang)

--4w_Thorton_Colby_Pickup_High_Close
TweakDB:SetFlat("Camera.VehicleTPP_4w_Thorton_Colby_Pickup_High_Close.boomLength", settings.cboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Thorton_Colby_Pickup_High_Close.lookAtOffset", ToVector3{x=settings.chorz, y=0.5, z=settings.cvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Thorton_Colby_Pickup_High_Close.defaultRotationPitch", settings.ccamang)

--4w_Thorton_Colby_Pickup_Low_Far
TweakDB:SetFlat("Camera.VehicleTPP_4w_Thorton_Colby_Pickup_Low_Far.boomLength", settings.fboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Thorton_Colby_Pickup_Low_Far.lookAtOffset", ToVector3{x=settings.fhorz, y=0.5, z=settings.fvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Thorton_Colby_Pickup_Low_Far.defaultRotationPitch", settings.fcamang)

--4w_Thorton_Colby_Pickup_High_Far
TweakDB:SetFlat("Camera.VehicleTPP_4w_Thorton_Colby_Pickup_High_Far.boomLength", settings.fboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Thorton_Colby_Pickup_High_Far.lookAtOffset", ToVector3{x=settings.fhorz, y=0.5, z=settings.fvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Thorton_Colby_Pickup_High_Far.defaultRotationPitch", settings.fcamang)

--4w_Truck_Preset
--4w_Truck_Preset_Low_Close
TweakDB:SetFlat("Camera.VehicleTPP_4w_Truck_Preset_Low_Close.boomLength", settings.cboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Truck_Preset_Low_Close.lookAtOffset", ToVector3{x=settings.chorz, y=0.5, z=settings.cvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Truck_Preset_Low_Close.defaultRotationPitch", settings.ccamang)

--4w_Truck_Preset_High_Close
TweakDB:SetFlat("Camera.VehicleTPP_4w_Truck_Preset_High_Close.boomLength", settings.cboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Truck_Preset_High_Close.lookAtOffset", ToVector3{x=settings.chorz, y=0.5, z=settings.cvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Truck_Preset_High_Close.defaultRotationPitch", settings.ccamang)

--4w_Truck_Preset_Low_Far
TweakDB:SetFlat("Camera.VehicleTPP_4w_Truck_Preset_Low_Far.boomLength", settings.fboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Truck_Preset_Low_Far.lookAtOffset", ToVector3{x=settings.fhorz, y=0.5, z=settings.fvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Truck_Preset_Low_Far.defaultRotationPitch", settings.fcamang)

--4w_Truck_Preset_High_Far
TweakDB:SetFlat("Camera.VehicleTPP_4w_Truck_Preset_High_Far.boomLength", settings.fboom)
TweakDB:SetFlat("Camera.VehicleTPP_4w_Truck_Preset_High_Far.lookAtOffset", ToVector3{x=settings.fhorz, y=0.5, z=settings.fvert})
TweakDB:SetFlat("Camera.VehicleTPP_4w_Truck_Preset_High_Far.defaultRotationPitch", settings.fcamang)

--v_standard25_mahir_supron_CameraPreset
--v_standard25_mahir_supron_CameraPreset_Low_Close
TweakDB:SetFlat("Camera.VehicleTPP_v_standard25_mahir_supron_CameraPreset_Low_Close.boomLength", settings.cboom)
TweakDB:SetFlat("Camera.VehicleTPP_v_standard25_mahir_supron_CameraPreset_Low_Close.lookAtOffset", ToVector3{x=settings.chorz, y=0.5, z=settings.cvert})
TweakDB:SetFlat("Camera.VehicleTPP_v_standard25_mahir_supron_CameraPreset_Low_Close.defaultRotationPitch", settings.ccamang)

--v_standard25_mahir_supron_CameraPreset_High_Close
TweakDB:SetFlat("Camera.VehicleTPP_v_standard25_mahir_supron_CameraPreset_High_Close.boomLength", settings.cboom)
TweakDB:SetFlat("Camera.VehicleTPP_v_standard25_mahir_supron_CameraPreset_High_Close.lookAtOffset", ToVector3{x=settings.chorz, y=0.5, z=settings.cvert})
TweakDB:SetFlat("Camera.VehicleTPP_v_standard25_mahir_supron_CameraPreset_High_Close.defaultRotationPitch", settings.ccamang)

--v_standard25_mahir_supron_CameraPreset_Low_Far
TweakDB:SetFlat("Camera.VehicleTPP_v_standard25_mahir_supron_CameraPreset_Low_Far.boomLength", settings.fboom)
TweakDB:SetFlat("Camera.VehicleTPP_v_standard25_mahir_supron_CameraPreset_Low_Far.lookAtOffset", ToVector3{x=settings.fhorz, y=0.5, z=settings.fvert})
TweakDB:SetFlat("Camera.VehicleTPP_v_standard25_mahir_supron_CameraPreset_Low_Far.defaultRotationPitch", settings.fcamang)

--v_standard25_mahir_supron_CameraPreset_High_Far
TweakDB:SetFlat("Camera.VehicleTPP_v_standard25_mahir_supron_CameraPreset_High_Far.boomLength", settings.fboom)
TweakDB:SetFlat("Camera.VehicleTPP_v_standard25_mahir_supron_CameraPreset_High_Far.lookAtOffset", ToVector3{x=settings.fhorz, y=0.5, z=settings.fvert})
TweakDB:SetFlat("Camera.VehicleTPP_v_standard25_mahir_supron_CameraPreset_High_Far.defaultRotationPitch", settings.fcamang)

--v_utility4_kaukaz_bratsk_Preset
--v_utility4_kaukaz_bratsk_Preset_Low_Close
TweakDB:SetFlat("Camera.VehicleTPP_v_utility4_kaukaz_bratsk_Preset_Low_Close.boomLength", settings.cboom)
TweakDB:SetFlat("Camera.VehicleTPP_v_utility4_kaukaz_bratsk_Preset_Low_Close.lookAtOffset", ToVector3{x=settings.chorz, y=0.5, z=settings.cvert})
TweakDB:SetFlat("Camera.VehicleTPP_v_utility4_kaukaz_bratsk_Preset_Low_Close.defaultRotationPitch", settings.ccamang)

--v_utility4_kaukaz_bratsk_Preset_High_Close
TweakDB:SetFlat("Camera.VehicleTPP_v_utility4_kaukaz_bratsk_Preset_High_Close.boomLength", settings.cboom)
TweakDB:SetFlat("Camera.VehicleTPP_v_utility4_kaukaz_bratsk_Preset_High_Close.lookAtOffset", ToVector3{x=settings.chorz, y=0.5, z=settings.cvert})
TweakDB:SetFlat("Camera.VehicleTPP_v_utility4_kaukaz_bratsk_Preset_High_Close.defaultRotationPitch", settings.ccamang)

--v_utility4_kaukaz_bratsk_Preset_Low_Far
TweakDB:SetFlat("Camera.VehicleTPP_v_utility4_kaukaz_bratsk_Preset_Low_Far.boomLength", settings.fboom)
TweakDB:SetFlat("Camera.VehicleTPP_v_utility4_kaukaz_bratsk_Preset_Low_Far.lookAtOffset", ToVector3{x=settings.fhorz, y=0.5, z=settings.fvert})
TweakDB:SetFlat("Camera.VehicleTPP_v_utility4_kaukaz_bratsk_Preset_Low_Far.defaultRotationPitch", settings.fcamang)

--v_utility4_kaukaz_bratsk_Preset_High_Far
TweakDB:SetFlat("Camera.VehicleTPP_v_utility4_kaukaz_bratsk_Preset_High_Far.boomLength", settings.fboom)
TweakDB:SetFlat("Camera.VehicleTPP_v_utility4_kaukaz_bratsk_Preset_High_Far.lookAtOffset", ToVector3{x=settings.fhorz, y=0.5, z=settings.fvert})
TweakDB:SetFlat("Camera.VehicleTPP_v_utility4_kaukaz_bratsk_Preset_High_Far.defaultRotationPitch", settings.fcamang)

--v_utility4_kaukaz_zeya_Preset
--v_utility4_kaukaz_zeya_Preset_Low_Close
TweakDB:SetFlat("Camera.VehicleTPP_v_utility4_kaukaz_zeya_Preset_Low_Close.boomLength", settings.cboom)
TweakDB:SetFlat("Camera.VehicleTPP_v_utility4_kaukaz_zeya_Preset_Low_Close.lookAtOffset", ToVector3{x=settings.chorz, y=0.5, z=settings.cvert})
TweakDB:SetFlat("Camera.VehicleTPP_v_utility4_kaukaz_zeya_Preset_Low_Close.defaultRotationPitch", settings.ccamang)

--v_utility4_kaukaz_zeya_Preset_High_Close
TweakDB:SetFlat("Camera.VehicleTPP_v_utility4_kaukaz_zeya_Preset_High_Close.boomLength", settings.cboom)
TweakDB:SetFlat("Camera.VehicleTPP_v_utility4_kaukaz_zeya_Preset_High_Close.lookAtOffset", ToVector3{x=settings.chorz, y=0.5, z=settings.cvert})
TweakDB:SetFlat("Camera.VehicleTPP_v_utility4_kaukaz_zeya_Preset_High_Close.defaultRotationPitch", settings.ccamang)

--v_utility4_kaukaz_zeya_Preset_Low_Far
TweakDB:SetFlat("Camera.VehicleTPP_v_utility4_kaukaz_zeya_Preset_Low_Far.boomLength", settings.fboom)
TweakDB:SetFlat("Camera.VehicleTPP_v_utility4_kaukaz_zeya_Preset_Low_Far.lookAtOffset", ToVector3{x=settings.fhorz, y=0.5, z=settings.fvert})
TweakDB:SetFlat("Camera.VehicleTPP_v_utility4_kaukaz_zeya_Preset_Low_Far.defaultRotationPitch", settings.fcamang)

--v_utility4_kaukaz_zeya_Preset_High_Far
TweakDB:SetFlat("Camera.VehicleTPP_v_utility4_kaukaz_zeya_Preset_High_Far.boomLength", settings.fboom)
TweakDB:SetFlat("Camera.VehicleTPP_v_utility4_kaukaz_zeya_Preset_High_Far.lookAtOffset", ToVector3{x=settings.fhorz, y=0.5, z=settings.fvert})
TweakDB:SetFlat("Camera.VehicleTPP_v_utility4_kaukaz_zeya_Preset_High_Far.defaultRotationPitch", settings.fcamang)

--v_utility4_militech_behemoth_Preset
--v_utility4_militech_behemoth_Preset_Low_Close
TweakDB:SetFlat("Camera.VehicleTPP_v_utility4_militech_behemoth_Preset_Low_Close.boomLength", settings.cboom)
TweakDB:SetFlat("Camera.VehicleTPP_v_utility4_militech_behemoth_Preset_Low_Close.lookAtOffset", ToVector3{x=settings.chorz, y=0.5, z=settings.cvert})
TweakDB:SetFlat("Camera.VehicleTPP_v_utility4_militech_behemoth_Preset_Low_Close.defaultRotationPitch", settings.ccamang)

--v_utility4_militech_behemoth_Preset_High_Close
TweakDB:SetFlat("Camera.VehicleTPP_v_utility4_militech_behemoth_Preset_High_Close.boomLength", settings.cboom)
TweakDB:SetFlat("Camera.VehicleTPP_v_utility4_militech_behemoth_Preset_High_Close.lookAtOffset", ToVector3{x=settings.chorz, y=0.5, z=settings.cvert})
TweakDB:SetFlat("Camera.VehicleTPP_v_utility4_militech_behemoth_Preset_High_Close.defaultRotationPitch", settings.ccamang)

--v_utility4_militech_behemoth_Preset_Low_Far
TweakDB:SetFlat("Camera.VehicleTPP_v_utility4_militech_behemoth_Preset_Low_Far.boomLength", settings.fboom)
TweakDB:SetFlat("Camera.VehicleTPP_v_utility4_militech_behemoth_Preset_Low_Far.lookAtOffset", ToVector3{x=settings.fhorz, y=0.5, z=settings.fvert})
TweakDB:SetFlat("Camera.VehicleTPP_v_utility4_militech_behemoth_Preset_Low_Far.defaultRotationPitch", settings.fcamang)

--v_utility4_militech_behemoth_Preset_High_Far
TweakDB:SetFlat("Camera.VehicleTPP_v_utility4_militech_behemoth_Preset_High_Far.boomLength", settings.fboom)
TweakDB:SetFlat("Camera.VehicleTPP_v_utility4_militech_behemoth_Preset_High_Far.lookAtOffset", ToVector3{x=settings.fhorz, y=0.5, z=settings.fvert})
TweakDB:SetFlat("Camera.VehicleTPP_v_utility4_militech_behemoth_Preset_High_Far.defaultRotationPitch", settings.fcamang)

--v_militech_basilisk_CameraPreset_
--v_militech_basilisk_CameraPreset_Low_Close
TweakDB:SetFlat("Camera.VehicleTPP_v_militech_basilisk_CameraPreset_Low_Close.boomLength", settings.cboom)
TweakDB:SetFlat("Camera.VehicleTPP_v_militech_basilisk_CameraPreset_Low_Close.lookAtOffset", ToVector3{x=settings.chorz, y=0.5, z=settings.cvert})
TweakDB:SetFlat("Camera.VehicleTPP_v_militech_basilisk_CameraPreset_Low_Close.defaultRotationPitch", settings.ccamang)

--_v_militech_basilisk_CameraPreset_High_Close
TweakDB:SetFlat("Camera.VehicleTPP_v_militech_basilisk_CameraPreset_High_Close.boomLength", settings.cboom)
TweakDB:SetFlat("Camera.VehicleTPP_v_militech_basilisk_CameraPreset_High_Close.lookAtOffset", ToVector3{x=settings.chorz, y=0.5, z=settings.cvert})
TweakDB:SetFlat("Camera.VehicleTPP_v_militech_basilisk_CameraPreset_High_Close.defaultRotationPitch", settings.ccamang)

--_v_militech_basilisk_CameraPreset_Low_Far
TweakDB:SetFlat("Camera.VehicleTPP_v_militech_basilisk_CameraPreset_Low_Far.boomLength", settings.fboom)
TweakDB:SetFlat("Camera.VehicleTPP_v_militech_basilisk_CameraPreset_Low_Far.lookAtOffset", ToVector3{x=settings.fhorz, y=0.5, z=settings.fvert})
TweakDB:SetFlat("Camera.VehicleTPP_v_militech_basilisk_CameraPreset_Low_Far.defaultRotationPitch", settings.fcamang)

--_v_militech_basilisk_CameraPreset_High_Far
TweakDB:SetFlat("Camera.VehicleTPP_v_militech_basilisk_CameraPreset_High_Far.boomLength", settings.fboom)
TweakDB:SetFlat("Camera.VehicleTPP_v_militech_basilisk_CameraPreset_High_Far.lookAtOffset", ToVector3{x=settings.fhorz, y=0.5, z=settings.fvert})
TweakDB:SetFlat("Camera.VehicleTPP_v_militech_basilisk_CameraPreset_High_Far.defaultRotationPitch", settings.fcamang)

--v_militech_basilisk_CameraPreset
--v_militech_basilisk_CameraPreset_Low_Close
TweakDB:SetFlat("Camera.VehicleTPP_v_militech_basilisk_CameraPreset_Low_Close.boomLength", settings.cboom)
TweakDB:SetFlat("Camera.VehicleTPP_v_militech_basilisk_CameraPreset_Low_Close.lookAtOffset", ToVector3{x=settings.chorz, y=0.5, z=settings.cvert})
TweakDB:SetFlat("Camera.VehicleTPP_v_militech_basilisk_CameraPreset_Low_Close.defaultRotationPitch", settings.ccamang)

--v_militech_basilisk_CameraPreset_High_Close
TweakDB:SetFlat("Camera.VehicleTPP_v_militech_basilisk_CameraPreset_High_Close.boomLength", settings.cboom)
TweakDB:SetFlat("Camera.VehicleTPP_v_militech_basilisk_CameraPreset_High_Close.lookAtOffset", ToVector3{x=settings.chorz, y=0.5, z=settings.cvert})
TweakDB:SetFlat("Camera.VehicleTPP_v_militech_basilisk_CameraPreset_High_Close.defaultRotationPitch", settings.ccamang)

--v_militech_basilisk_CameraPreset_Low_Far
TweakDB:SetFlat("Camera.VehicleTPP_v_militech_basilisk_CameraPreset_Low_Far.boomLength", settings.fboom)
TweakDB:SetFlat("Camera.VehicleTPP_v_militech_basilisk_CameraPreset_Low_Far.lookAtOffset", ToVector3{x=settings.fhorz, y=0.5, z=settings.fvert})
TweakDB:SetFlat("Camera.VehicleTPP_v_militech_basilisk_CameraPreset_Low_Far.defaultRotationPitch", settings.fcamang)

--v_militech_basilisk_CameraPreset_High_Far
TweakDB:SetFlat("Camera.VehicleTPP_v_militech_basilisk_CameraPreset_High_Far.boomLength", settings.fboom)
TweakDB:SetFlat("Camera.VehicleTPP_v_militech_basilisk_CameraPreset_High_Far.lookAtOffset", ToVector3{x=settings.fhorz, y=0.5, z=settings.fvert})
TweakDB:SetFlat("Camera.VehicleTPP_v_militech_basilisk_CameraPreset_High_Far.defaultRotationPitch", settings.fcamang)

--Additional Changes
TweakDB:SetFlat("Camera.VehicleTPP_DefaultParams.cameraBoomExtensionSpeed", settings.vspd)
TweakDB:SetFlat("Camera.VehicleTPP_DefaultParams.fov", settings.vfov)
TweakDB:SetFlat("Camera.VehicleTPP_DefaultParams.collisionDetection", settings.coll)

end

function newcamera()
CTPPcamera()
end

function ApplyLegacy ()
		settings.cboom = cboom
		settings.cvert = ccamera
		settings.fboom = fboom
		settings.fvert = fcamera
		settings.vfov = vfov
		settings.vspd = vspd
		settings.ccamang = ccamang
		settings.fcamang = fcamang
		settings.coll = coll
		config.saveFile("tppvalues.json", settings)
		
		CTPPcamera()	
end

function Tooltip(text)
        if ImGui.IsItemHovered() then
            ImGui.BeginTooltip()
            ImGui.SetTooltip(text)
            ImGui.EndTooltip()
        end
    end

registerForEvent("onInit", function()
	Observe('hudCarController', 'OnUnmountingEvent', function()
		CTPPcamera()
	end)

	CTPPcamera()
end)

registerForEvent("onOverlayOpen", function()
	consoleopen = true
	CTPPcamera()
end)

registerForEvent("onOverlayClose", function()
	consoleopen = false	
end)

registerForEvent("onDraw", function()
	if consoleopen then
		ImGui.Begin("CarTPP Camera", ImGuiWindowFlags.AlwaysAutoResize)
		ImGui.PushItemWidth(100)
		ImGui.Text("Camera Option 1")       
		
		settings.fboom, changes = ImGui.InputFloat("Far Horizontal Position", settings.fboom, -99, 99, "%.2f")
		Tooltip("Higher number means camera farther from character  - default 4.5")
		if changes then config.saveFile("tppvalues.json", settings) newcamera()
		end
		settings.fvert, changes = ImGui.InputFloat("Far Vertical Position", settings.fvert, -99, 99, "%.2f")
		Tooltip("Higher number means camera higher from character - default 1.2")
		if changes then config.saveFile("tppvalues.json", settings) newcamera()
		end
		settings.fhorz, changes = ImGui.InputFloat("Far L/R Position", settings.fhorz, -99, 99, "%.2f")
		Tooltip("Positive number means camera to the right - default 0")
		if changes then config.saveFile("tppvalues.json", settings) newcamera()
		end
		settings.fcamang, changes = ImGui.InputFloat("Far Camera Pitch", settings.fcamang, -99, 99, "%.2f")
		Tooltip("Changes pitch of camera angle - default 8")
		if changes then config.saveFile("tppvalues.json", settings) newcamera()
		end
		
		ImGui.Text("Camera Option 2")
		
		settings.cboom, changes = ImGui.InputFloat("Close Horizontal Position", settings.cboom, -99, 99, "%.2f")
		Tooltip("Higher number means camera farther from character - default 3.5")
		if changes then config.saveFile("tppvalues.json", settings) newcamera()
		local doge = "If your character stuck during transition,\nload the latest save file and"
		end
		settings.cvert, changes = ImGui.InputFloat("Close Vertical Position", settings.cvert, -99, 99, "%.2f")
		Tooltip("Higher number means camera higher from character - default 1.2")
		if changes then config.saveFile("tppvalues.json", settings) newcamera()
		end
		settings.chorz, changes = ImGui.InputFloat("Close L/R Position", settings.chorz, -99, 99, "%.2f")
		Tooltip("Positive number means camera to the right - default 0")
		if changes then config.saveFile("tppvalues.json", settings) newcamera()
		end
		settings.ccamang, changes = ImGui.InputFloat("Close Camera Pitch", settings.ccamang, -99, 99, "%.2f")
		Tooltip("Changes pitch of camera angle - default 4.5")
		if changes then config.saveFile("tppvalues.json", settings) newcamera()
		end
		
		ImGui.Text("Additional Options")
		settings.vfov, changes = ImGui.InputFloat("FOV", settings.vfov, -99, 99, "%.2f")
		Tooltip("Change FOV - default 69, going above 85 WILL cause texture glitches to occur")
		if changes then config.saveFile("tppvalues.json", settings) newcamera()
		end
		settings.vspd, changes = ImGui.InputFloat("Speed Camera", settings.vspd, -99, 99, "%.2f")
		Tooltip("Camera distance when going fast - Positive number means camera gets farther when faster - default 0.5")
		if changes then config.saveFile("tppvalues.json", settings) newcamera()
		end
		ImGui.Text(" ")
		if showlegacybtn then
		if ImGui.Button("Reset to default values", 200, 20) then -- Label, width, height - Use -1 as width for button to span available horizontal space
			ApplyLegacy()
		end
		end
		Tooltip("Clicking on this button will overwrite all values to default.\nYou can change DEFAULT values or hide this button in the init.lua file.")		
		ImGui.Text("")
		ImGui.Button("!", 20, 20)
		Tooltip("1.25 - Changes will save on each input edit and will only be noticeable AFTER you enter a car.\nIf made changes while in a car, exit and enter again to see changes.\nVs hair/head might dissapear if you have the camera TOO close, looking for a way to avoid this from happening.\nIf Vs head dissapears even after exiting a car, reload game.")		
		
		ImGui.PopItemWidth()

		ImGui.End()
		
	end
end)


