@addField(ItemTooltipCommonController)
let itemLevelModule: ref<ItemLevelModule>;


@wrapMethod(ItemTooltipCommonController)
protected func UpdateLayout() -> Void {
	wrappedMethod();
	if Equals(this.m_data.displayContext, InventoryTooltipDisplayContext.Crafting) || Equals(this.m_data.displayContext, InventoryTooltipDisplayContext.Upgrading) {
		if !IsDefined(this.itemLevelModule) {
			ItemLevelModule.Create(this);
		}
		if IsDefined(this.itemLevelModule) {
			this.itemLevelModule.Update(this.m_data);
		}
	}
}


public class ItemLevelModule extends inkVerticalPanel {

	public static final func Create(controller: ref<ItemTooltipCommonController>) -> Void {
		let container: ref<inkCompoundWidget> = controller.GetRootCompoundWidget().GetWidgetByPathName(n"contentWrapper\\contentFlexWrapper\\categoriesWrapper") as inkCompoundWidget;
		if !IsDefined(container) {
			return;
		}

		let levelModule: ref<ItemLevelModule> = new ItemLevelModule();

		let label: ref<inkText> = new inkText();
		label.SetName(n"levelText");
		label.SetFontFamily("base\\gameplay\\gui\\fonts\\raj\\raj.inkfontfamily");
		label.SetFontStyle(n"Medium");
		label.SetFontSize(42);
		label.SetMargin(new inkMargin(20.0, 2.0, 0.0, 0.0));
		label.SetTintColor(Cast<Uint8>(239), Cast<Uint8>(78), Cast<Uint8>(71), Cast<Uint8>(255)); // Red
		// label.SetTintColor(new HDRColor(0.368627459, 0.964705944, 1.0, 1.0)); // LightBlue

		let line: ref<inkRectangle> = new inkRectangle();
		line.SetSize(new Vector2(1.0, 6.0));
		line.SetMargin(new inkMargin(0.0, 8.0, 0.0, 15.0));
		line.SetTintColor(new HDRColor(0.266666681, 0.0862745121, 0.0784313753, 1.0));

		levelModule.AddChildWidget(label);
		levelModule.AddChildWidget(line);
		levelModule.Reparent(container, 1);
		levelModule.SetVisible(false);

		controller.itemLevelModule = levelModule;
	}

	public final func Update(data: ref<MinimalItemTooltipData>) -> Void {
		(this.GetWidgetByPathName(n"levelText") as inkText).SetText(s"\(GetLocalizedText("LocKey#727")) \(Cast<Int32>(data.itemData.GetStatValueByType(gamedataStatType.ItemLevel) / 10.0))");
		this.SetVisible(Equals(data.itemCategory, gamedataItemCategory.Weapon) || Equals(data.itemCategory, gamedataItemCategory.Clothing));
	}
}
