import TTFCore.TTF
import TTFAdditions.*



@addField(gameuiTooltipsManager)
private final let ttf: ref<TTF>;

@wrapMethod(gameuiTooltipsManager)
protected cb func OnInitialize() -> Bool {
	wrappedMethod();
	this.ttf = TTF.GetInstance();
}

@replaceMethod(gameuiTooltipsManager)
public final func ShowTooltip(tooltipController: wref<AGenericTooltipController>, tooltipData: ref<ATooltipData>, margin: inkMargin) -> Void {
	this.HideTooltips();
	if tooltipController == null {
		LogUIError("[TooltipManager] Tried to use not spawned tooltip!");
		return;
	};
	this.SetCustomMargin(margin);
	if IsDefined(tooltipController) {
		tooltipController.SetData(tooltipData);
		if IsDefined(this.ttf) {
			this.ttf.SetTooltipData(tooltipController);
			this.ttf.UpdateTooltipsContainer(this.GetTooltipsContainerRef());
		}
		tooltipController.Show();
	};
	this.MarkToShow();
}

@replaceMethod(gameuiTooltipsManager)
public final func ShowTooltips(tooltipData: array<ref<ATooltipData>>, margin: inkMargin, opt playAnim: Bool) -> Void {
	let i: Int32;
	let identifiedData: ref<IdentifiedWrappedTooltipData>;
	let limit: Int32;
	let tooltipController: wref<AGenericTooltipController>;
	this.HideTooltips();
	this.SetCustomMargin(margin);
	limit = ArraySize(tooltipData);
	i = 0;
	while i < limit {
		identifiedData = tooltipData[i] as IdentifiedWrappedTooltipData;
		if IsDefined(identifiedData) && IsNameValid(identifiedData.m_identifier) {
			tooltipController = this.GetNamedWidget(identifiedData.m_identifier);
		} else {
			if i >= ArraySize(this.m_IndexedTooltips) {
				LogUIError("[TooltipManager] Tried to use not spawned tooltip!");
				return;
			};
			tooltipController = this.m_IndexedTooltips[i];
		};
		if IsDefined(tooltipController) {
			tooltipController.SetData(IsDefined(identifiedData) ? identifiedData.m_data : tooltipData[i]);
			if IsDefined(this.ttf) {
				this.ttf.SetTooltipData(tooltipController);
			}
			tooltipController.Show();
		};
		i += 1;
	};
	if limit > 0 {
		if IsDefined(this.ttf) {
			this.ttf.UpdateTooltipsContainer(this.GetTooltipsContainerRef());
		}
		this.MarkToShow();
	};
}

@wrapMethod(ItemTooltipStatController)
private final func UpdateComparedValue(diff: Int32, isPercentage: Bool, displayPlus: Bool, inMeters: Bool, inSeconds: Bool, inSpeed: Bool) -> Void {
	wrappedMethod(diff, isPercentage, displayPlus, inMeters, inSeconds, inSpeed);
	ManageComparisonArrows(this.m_arrow);
}

@wrapMethod(ItemTooltipEvolutionModule)
public func Update(data: ref<MinimalItemTooltipData>) -> Void {
	wrappedMethod(data);
	FixEvoTechPowerIcons(this.m_weaponEvolutionIcon, data.itemEvolution);
	ManageEvoDescription(this.m_weaponEvolutionDescription);
}

@wrapMethod(ItemTooltipEvolutionModule)
public func NEW_Update(data: wref<UIInventoryItem>) -> Void {
	wrappedMethod(data);
	FixEvoTechPowerIcons(this.m_weaponEvolutionIcon, data.GetWeaponEvolution());
	ManageEvoDescription(this.m_weaponEvolutionDescription);
}

@wrapMethod(ItemTooltipIconModule)
public func Update(data: ref<MinimalItemTooltipData>) -> Void {
	wrappedMethod(data);
	ItemLevelIndicator.Add(this.m_icon, data);
	CraftedIndicator.Add(this.m_icon, data);
}

@wrapMethod(ItemTooltipIconModule)
public func NEW_Update(data: wref<UIInventoryItem>) -> Void {
	wrappedMethod(data);
	ItemLevelIndicator.Add(this.m_icon, data);
	CraftedIndicator.Add(this.m_icon, data);
}

@wrapMethod(ItemTooltipCommonController)
protected func UpdateCraftedModule() -> Void {
	wrappedMethod();
	ManageCraftedModule(this.m_itemCraftedContainer);
}

@wrapMethod(ItemTooltipCommonController)
protected func NEW_UpdateCraftedModule() -> Void {
	wrappedMethod();
	ManageCraftedModule(this.m_itemCraftedContainer);
}

// Fix from Ink Playground - TESTING

// @wrapMethod(gameuiTooltipsManager)
// public final func ShowTooltipAtWidget(tooltipController: wref<AGenericTooltipController>, widget: wref<inkWidget>, tooltipData: ref<ATooltipData>, opt placement: gameuiETooltipPlacement, opt playAnim: Bool, opt margin: inkMargin) -> Void {
// 	wrappedMethod(tooltipController, widget, tooltipData, placement, false, margin);
// 	inkWidgetRef.SetVisible(this.GetTooltipsContainerRef(), true);
// }

// @wrapMethod(gameuiTooltipsManager)
// public final func ShowTooltips(tooltipData: array<ref<ATooltipData>>, margin: inkMargin, opt playAnim: Bool) -> Void {
// 	wrappedMethod(tooltipData, margin, false);
// 	inkWidgetRef.SetVisible(this.GetTooltipsContainerRef(), true);
// }
