module TTFMisc



public static func GetQualityColor(quality: gamedataQuality, boost: Float) -> HDRColor {
	let r: Float;
	let g: Float;
	let b: Float;
	switch quality {
		case gamedataQuality.Common:    r = 0.8431; g = 0.8117; b = 0.8117; break;
		case gamedataQuality.Uncommon:  r = 0.1176; g = 0.9294; b = 0.5176; break;
		case gamedataQuality.Rare:      r = 0.149;  g = 0.4353; b = 0.8314; break;
		case gamedataQuality.Epic:      r = 0.6157; g = 0.1725; b = 0.9608; break;
		case gamedataQuality.Legendary: // drop down
		case gamedataQuality.Iconic:    r = 0.9725; g = 0.5804; b = 0.1765; break;
		default:                        r = 0.902;  g = 0.902;  b = 0.902;
	}
	return new HDRColor(r * boost, g * boost, b * boost, 1.0);
}
