module TTFAdditions

import TTFCore.TTF
import TTFSettings.TTFSettings
import TTFMisc.*


@if(!ModuleExists("Codeware"))
@addField(inkWidget)
native let parentWidget: wref<inkWidget>;

@addMethod(inkWidget)
public func GetParentW() -> wref<inkWidget> {
	return this.parentWidget;
}

public static final func FixEvoTechPowerIcons(icon: inkImageRef, evo: gamedataWeaponEvolution) -> Void {
	if Equals(evo, gamedataWeaponEvolution.Power) {
		inkImageRef.SetTexturePart(icon, n"ico_tech");
		return;
	}
	if Equals(evo, gamedataWeaponEvolution.Tech) {
		inkImageRef.SetTexturePart(icon, n"ico_power");
	}
}

public static final func ManageCraftedModule(module: inkWidgetRef) -> Void {
	if TTF.GetInstance().settings.replaceCrafted {
		inkTextRef.SetVisible(module, false);
	}
}

public static final func ManageEvoDescription(evo: inkTextRef) -> Void {
	inkTextRef.SetVisible(evo, !TTF.GetInstance().settings.hideEvoDescription);
}

public static final func ManageComparisonArrows(arrow: inkImageRef) -> Void {
	if TTF.GetInstance().settings.useSimpleArrows {
		inkImageRef.SetTexturePart(arrow, n"icon_compare");
		inkWidgetRef.SetMargin(arrow, new inkMargin(10.0, 15.0, -2.0, 0.0));
	}
}

public class ItemLevelIndicator {

	public static final func Add(icon: inkImageRef, data: ref<MinimalItemTooltipData>) -> Void {
		if !TTF.GetInstance().settings.showLevel {
			return;
		}
		let root: ref<inkCanvas> = inkImageRef.Get(icon).GetParentW() as inkCanvas;
		if !IsDefined(root) {
			return;
		}
		let ilvl: Float = data.itemData.GetStatValueByType(gamedataStatType.ItemLevel);
		let needShow: Bool = (Equals(data.itemCategory, gamedataItemCategory.Weapon) || Equals(data.itemCategory, gamedataItemCategory.Clothing)) && !Equals(data.equipmentArea, gamedataEquipmentArea.Invalid);
		ItemLevelIndicator.UpdateItemLevelLabel(root, ilvl, needShow);
	}

	public static final func Add(icon: inkImageRef, data: wref<UIInventoryItem>) -> Void {
		if !TTF.GetInstance().settings.showLevel {
			return;
		}
		let root: ref<inkCanvas> = inkImageRef.Get(icon).GetParentW() as inkCanvas;
		if !IsDefined(root) {
			return;
		}
		let ilvl: Float = data.m_itemData.GetStatValueByType(gamedataStatType.ItemLevel);
		let needShow: Bool = (data.IsWeapon() || data.IsClothing()) && !Equals(data.GetEquipmentArea(), gamedataEquipmentArea.Invalid);
		ItemLevelIndicator.UpdateItemLevelLabel(root, ilvl, needShow);
	}

	private static final func UpdateItemLevelLabel(root: ref<inkCanvas>, ilvl: Float, needShow: Bool) -> Void {
		let levelLabel: ref<inkText> = root.GetWidgetByPathName(n"levelLabel") as inkText;
		if !IsDefined(levelLabel) {
			levelLabel = ItemLevelIndicator.NewLevelLabel();
			levelLabel.SetVisible(false);
			root.AddChildWidget(levelLabel);
		}
		if needShow {
			levelLabel.SetText(s"\(GetLocalizedText("LocKey#727")) \(Cast<Int32>(ilvl / 10.0))");
		}
		levelLabel.SetVisible(needShow);
	}

	private static final func NewLevelLabel() -> ref<inkText> {
		let label: ref<inkText> = new inkText();
		label.SetName(n"levelLabel");
		label.SetFontFamily("base\\gameplay\\gui\\fonts\\raj\\raj.inkfontfamily");
		label.SetFontStyle(n"Medium");
		label.SetFontSize(29);
		label.SetMargin(new inkMargin(-14.0, 0.0, 0.0, 0.0));
		label.SetTintColor(Cast<Uint8>(239), Cast<Uint8>(78), Cast<Uint8>(71), Cast<Uint8>(255));
		return label;
	}

}

public class CraftedIndicator {

	public static final func Add(icon: inkImageRef, data: ref<MinimalItemTooltipData>) -> Void {
		if !TTF.GetInstance().settings.replaceCrafted {
			return;
		}
		let root: ref<inkCanvas> = inkImageRef.Get(icon).GetParentW() as inkCanvas;
		if !IsDefined(root) {
			return;
		}
		let needShow: Bool = Cast<Bool>(data.itemData.GetStatValueByType(gamedataStatType.IsItemCrafted));
		CraftedIndicator.UpdateCraftedLabel(root, data.quality, needShow);
	}

	public static final func Add(icon: inkImageRef, data: wref<UIInventoryItem>) -> Void {
		if !TTF.GetInstance().settings.replaceCrafted {
			return;
		}
		let root: ref<inkCanvas> = inkImageRef.Get(icon).GetParentW() as inkCanvas;
		if !IsDefined(root) {
			return;
		}
		let needShow: Bool = data.IsCrafted();
		CraftedIndicator.UpdateCraftedLabel(root, data.GetQuality(), needShow);
	}

	private static final func UpdateCraftedLabel(root: ref<inkCanvas>, quality: gamedataQuality, needShow: Bool) -> Void {
		let craftedIcon: ref<inkImage> = root.GetWidgetByPathName(n"craftedIcon") as inkImage;
		if !IsDefined(craftedIcon) {
			craftedIcon = CraftedIndicator.NewCraftedIcon();
			craftedIcon.SetVisible(false);
			root.AddChildWidget(craftedIcon);
		}
		if needShow {
			craftedIcon.SetTintColor(GetQualityColor(quality, 1.1));
		}
		craftedIcon.SetVisible(needShow);
	}

	private static final func NewCraftedIcon() -> ref<inkImage> {
		let icon: ref<inkImage> = new inkImage();
		icon.SetName(n"craftedIcon");
		icon.SetAtlasResource(r"base\\gameplay\\gui\\common\\icons\\atlas_common.inkatlas");
		icon.SetTexturePart(n"crafted_item");
		icon.SetHAlign(inkEHorizontalAlign.Center);
		icon.SetVAlign(inkEVerticalAlign.Center);
		icon.SetAnchorPoint(new Vector2(0.5, 0.5));
		icon.SetSizeRule(inkESizeRule.Stretch);
		icon.SetSize(new Vector2(52.0, 56.0));
		icon.SetMargin(new inkMargin(606.0, 140.0, 0.0, 0.0));
		return icon;
	}
}