module TTFConfig



public class TTFConfig {
	public static func GetScaleLevel(lines: Int32) -> ScaleLevel {
		lines += 4; // fast fix for best visual
		if lines < 28 { return ScaleLevel.Default; } // 1.0
		if lines < 31 { return ScaleLevel.Lvl1; }    // 0.95
		if lines < 34 { return ScaleLevel.Lvl2; }    // 0.9
		if lines < 37 { return ScaleLevel.Lvl3; }    // 0.85
		if lines < 40 { return ScaleLevel.Lvl4; }    // 0.8
		if lines < 44 { return ScaleLevel.Lvl5; }    // 0.75
		if lines < 47 { return ScaleLevel.Lvl6; }    // 0.7
		return ScaleLevel.Lowest;                    // 0.65
	}

	public static func GetVShift(scaleLevel: ScaleLevel, aspect: Int32) -> Float {
		switch aspect {
			case 177: return TTFConfig.vShiftTable0(scaleLevel); // 16:9 also 1360x768(1.770) and 1366x768(1.778)
			case 160: return TTFConfig.vShiftTable1(scaleLevel); // 16:10
			case 133: return TTFConfig.vShiftTable2(scaleLevel); // 4:3
			case 125: return TTFConfig.vShiftTable3(scaleLevel); // 5:4
			case 156: return TTFConfig.vShiftTable1(scaleLevel); // 25:16 e.g. 1600x1024
			case 166: return TTFConfig.vShiftTable1(scaleLevel); // 5:3 e.g. 1280x768
			default: return 0.0;
		}
	}

	// 16:9
	private static func vShiftTable0(scaleLevel: ScaleLevel) -> Float {
		switch scaleLevel {
			case ScaleLevel.Default: return 120.0;
			case ScaleLevel.Lvl1: return 120.0;
			case ScaleLevel.Lvl2: return 130.0;
			case ScaleLevel.Lvl3: return 140.0;
			case ScaleLevel.Lvl4: return 150.0;
			case ScaleLevel.Lvl5: return 160.0;
			case ScaleLevel.Lvl6: return 170.0;
			case ScaleLevel.Lowest: return 180.0;
			default: return 120.0;
		}
	}

	// 16:10
	private static func vShiftTable1(scaleLevel: ScaleLevel) -> Float {
		switch scaleLevel {
			case ScaleLevel.Default: return 340.0;
			case ScaleLevel.Lvl1: return 380.0;
			case ScaleLevel.Lvl2: return 400.0;
			case ScaleLevel.Lvl3: return 420.0;
			case ScaleLevel.Lvl4: return 440.0;
			case ScaleLevel.Lvl5: return 460.0;
			case ScaleLevel.Lvl6: return 480.0;
			case ScaleLevel.Lowest: return 500.0;
			default: return 340.0;
		}
	}

	// 4:3
	private static func vShiftTable2(scaleLevel: ScaleLevel) -> Float {
		switch scaleLevel {
			case ScaleLevel.Default: return 820.0;
			case ScaleLevel.Lvl1: return 860.0;
			case ScaleLevel.Lvl2: return 900.0;
			case ScaleLevel.Lvl3: return 960.0;
			case ScaleLevel.Lvl4: return 1020.0;
			case ScaleLevel.Lvl5: return 1100.0;
			case ScaleLevel.Lvl6: return 1140.0;
			case ScaleLevel.Lowest: return 1180.0;
			default: return 820.0;
		}
	}

	// 5:4
	private static func vShiftTable3(scaleLevel: ScaleLevel) -> Float {
		switch scaleLevel {
			case ScaleLevel.Default: return 1020.0;
			case ScaleLevel.Lvl1: return 1060.0;
			case ScaleLevel.Lvl2: return 1120.0;
			case ScaleLevel.Lvl3: return 1200.0;
			case ScaleLevel.Lvl4: return 1280.0;
			case ScaleLevel.Lvl5: return 1360.0;
			case ScaleLevel.Lvl6: return 1440.0;
			case ScaleLevel.Lowest: return 1500.0;
			default: return 1020.0;
		}
	}

	public static func GetMagicNumber(lang: CName, idx: MagicIndex) -> Int32 {
		let nums: array<Int32>;
		switch lang {
			case n"pl-pl": nums = [160, 160, 116, 150, 173, 203]; break;
			case n"en-us": nums = [160, 160,  96, 166, 168, 198]; break;
			case n"es-mx": // drop down
			case n"es-es": nums = [160, 158, 103, 158, 168, 199]; break;
			case n"fr-fr": nums = [160, 161, 103, 158, 164, 205]; break;
			case n"it-it": nums = [160, 161, 117, 156, 162, 212]; break;
			case n"de-de": nums = [170, 169,  98, 156, 170, 198]; break;
			case n"kr-kr": // drop down
			case n"jp-jp": nums = [221, 221, 125, 240, 230, 305]; break;
			case n"zh-tw": // drop down
			case n"zh-cn": nums = [205, 205, 114, 208, 208, 248]; break;
			case n"ru-ru": nums = [254, 254, 192, 262, 248, 333]; break;
			case n"pt-br": nums = [160, 161, 103, 158, 168, 192]; break;
			case n"ar-ar": nums = [300, 300, 270, 288, 300, 366]; break;
			case n"cz-cz": nums = [189, 189, 106, 174, 189, 219]; break;
			case n"hu-hu": // drop down
			case n"tr-tr": nums = [201, 201, 129, 173, 185, 209]; break;
			case n"th-th": nums = [500, 500, 300, 510, 520, 565]; break;
			default: break;
		}
		// 9999 will always give scale 1.0
		return ArraySize(nums) == 0 ? 9999 : nums[EnumInt(idx)];
	}
}

// Used scale value * 1000
enum ScaleLevel {
	Default = 1000,
	Lvl1 = 950,
	Lvl2 = 900,
	Lvl3 = 850,
	Lvl4 = 800,
	Lvl5 = 750,
	Lvl6 = 700,
	Lowest = 650,
}

enum MagicIndex {
	REQ = 0,
	EVO = 1,
	STATS = 2,
	DMODS = 3,
	MODS = 4,
	DESC = 5,
}
