module TTFSettings


public class TTFSettings {

	@runtimeProperty("ModSettings.mod", "Tooltips Fixer V5")
	@runtimeProperty("ModSettings.category", "Basics")
	@runtimeProperty("ModSettings.displayName", "Apply dynamic scaling")
	@runtimeProperty("ModSettings.description", "Apply dynamic rescaling for tooltips.")
	let useRescale: Bool = true;

	@runtimeProperty("ModSettings.mod", "Tooltips Fixer V5")
	@runtimeProperty("ModSettings.category", "Basics")
	@runtimeProperty("ModSettings.displayName", "Apply position correction")
	@runtimeProperty("ModSettings.description", "Apply dynamic position correction for tooltips. Vanilla style sets them too high." )
	let useCorrection: Bool = true;

	@runtimeProperty("ModSettings.mod", "Tooltips Fixer V5")
	@runtimeProperty("ModSettings.category", "Basics")
	@runtimeProperty("ModSettings.displayName", "Use simple comparison arrows")
	@runtimeProperty("ModSettings.description", "IMPORTANT! Required mod 'Smaller item arrows'!")
	let useSimpleArrows: Bool = false;

	@runtimeProperty("ModSettings.mod", "Tooltips Fixer V5")
	@runtimeProperty("ModSettings.category", "Basics")
	@runtimeProperty("ModSettings.displayName", "Hide weapon evolution description")
	@runtimeProperty("ModSettings.description", "Hide long weapon evolution description, e.g. 'Bullets can ricochet off surfaces.'")
	let hideEvoDescription: Bool = false;

	@runtimeProperty("ModSettings.mod", "Tooltips Fixer V5")
	@runtimeProperty("ModSettings.category", "Basics")
	@runtimeProperty("ModSettings.displayName", "Show item level indicator")
	@runtimeProperty("ModSettings.description", "Show item level over icon image for weapons and clothes. Translation supported.")
	let showLevel: Bool = false;

	@runtimeProperty("ModSettings.mod", "Tooltips Fixer V5")
	@runtimeProperty("ModSettings.category", "Basics")
	@runtimeProperty("ModSettings.displayName", "Replace 'Crafted' indicator")
	@runtimeProperty("ModSettings.description", "Show new 'Crafted' indicator over icon image and hide original massive bottom line.")
	let replaceCrafted: Bool = false;

	@runtimeProperty("ModSettings.mod", "Tooltips Fixer V5")
	@runtimeProperty("ModSettings.category", "Custom adjustments")
	@runtimeProperty("ModSettings.displayName", "Scale offset")
	@runtimeProperty("ModSettings.description", "Custom offset for each scaling level. Lower value -> smaller tooltip on each level.")
	@runtimeProperty("ModSettings.step", "0.01")
	@runtimeProperty("ModSettings.min", "-0.2")
	@runtimeProperty("ModSettings.max", "0.2")
	let customScaleOffset: Float = 0.0;

	@runtimeProperty("ModSettings.mod", "Tooltips Fixer V5")
	@runtimeProperty("ModSettings.category", "Custom adjustments")
	@runtimeProperty("ModSettings.displayName", "Scale multiplier")
	@runtimeProperty("ModSettings.description", "Custom multiplier for each scaling level. Not affect on Default level.")
	@runtimeProperty("ModSettings.step", "0.01")
	@runtimeProperty("ModSettings.min", "0.75")
	@runtimeProperty("ModSettings.max", "1.25")
	let customScaleMultiplier: Float = 1.0;

	@runtimeProperty("ModSettings.mod", "Tooltips Fixer V5")
	@runtimeProperty("ModSettings.category", "Custom adjustments")
	@runtimeProperty("ModSettings.displayName", "Content limit offset")
	@runtimeProperty("ModSettings.description", "Tooltip content size limit offset. Higher value -> earlier switch down to lower scale level.")
	@runtimeProperty("ModSettings.step", "1")
	@runtimeProperty("ModSettings.min", "-15")
	@runtimeProperty("ModSettings.max", "15")
	let customLimitOffset: Int32 = 0;
}
