/*
  Author: L0L3k 2021.
  A radio companion experiment for CP'77.
  Version: 0.2
  TODO:
    - Workaround despawning the radio by game engine when leaving area / network (find a way to re-spawn a radio copy in OnDetached());
    - Make the radio invisible when acquiring;
    - Port to CET and control radio via CET UI (spawn a radio with a hotkey);
    - New mod: Make the face/head wearable equipment (BD players etc) include radio audio components controlled via CET UI to play the music anywhere anytime.
*/

@addField(AllBlackboardDefinitions)
public let m_modRadioCompanion: wref<Radio>;

@addMethod(Radio)
protected func AdoptRadioCompanion(devicePs: wref<ScriptableDeviceComponentPS>) {
  let player: wref<PlayerPuppet> = GetPlayer(this.GetGame());
  let radioPosition: Vector4;
  let radioRotationV: Vector4;
  GetAllBlackboardDefs().m_modRadioCompanion = this;
  Log(" Adopting a companion radio: " + this.GetDisplayName() + "; id: " + EntityID.ToDebugString(this.GetEntityID()));
  devicePs.SetDurabilityType(EDeviceDurabilityType.INDESTRUCTIBLE);
  devicePs.SetDurabilityType(EDeviceDurabilityType.INVULNERABLE);
  this.UpdateDeviceState();
  if IsDefined(player) {
    radioPosition = player.GetWorldPosition() + (player.GetWorldUp() * 2.5) + (player.GetWorldForward() * 0.5);
    radioRotationV = (player.GetWorldForward() * -0.5) + (player.GetWorldUp() * 0.5);
    GameInstance.GetTeleportationFacility(this.GetGame()).Teleport(this, radioPosition, Vector4.ToRotation(radioRotationV));
  }
}

@addMethod(Radio)
protected func ReleaseRadioCompanion(devicePs: wref<ScriptableDeviceComponentPS>) {
  Log(" Releasing the companion radio: " + this.GetDisplayName() + "; id: " + EntityID.ToDebugString(this.GetEntityID()));
  devicePs.SetDurabilityType(EDeviceDurabilityType.DESTRUCTIBLE);
  this.UpdateDeviceState();
  GetAllBlackboardDefs().m_modRadioCompanion = null;
}

@replaceMethod(GameObject)
protected cb func OnLookedAtEvent(evt : ref<LookedAtEvent>) -> Bool {
  let aRadio: wref<Radio>;
  let devicePs: wref<ScriptableDeviceComponentPS>;

  if this.IsDevice() && this.IsA(n"Radio") {
    aRadio = this as Radio;
    devicePs = aRadio.GetDevicePS();
    if devicePs.IsInteractive() {
      if evt.isLookedAt {
        Log(" Looking at a radio TDBID: " + TDBID.ToStringDEBUG(devicePs.GetTweakDBRecord()) + "; appearance: " + NameToString(this.GetCurrentAppearanceName()) + "; id: " + EntityID.ToDebugString(aRadio.GetEntityID()) );
        if IsDefined(GetAllBlackboardDefs().m_modRadioCompanion) && NotEquals(aRadio, GetAllBlackboardDefs().m_modRadioCompanion) {
          aRadio.ReleaseRadioCompanion(devicePs);
        };
        if !IsDefined(GetAllBlackboardDefs().m_modRadioCompanion) {
          aRadio.AdoptRadioCompanion(devicePs);
        };
      }
    }
  }
}

@replaceMethod(VehicleObject)
protected cb func OnVehicleFinishedMounting(evt: ref<VehicleFinishedMountingEvent>) -> Bool {
  let aRadio: wref<Radio>;
  if evt.character == null {
    return false;
  };
  if evt.character.IsPlayer() && IsDefined(GetAllBlackboardDefs().m_modRadioCompanion) {
    aRadio = GetAllBlackboardDefs().m_modRadioCompanion;
    if evt.isMounting {
      Log(" Turning off the companion radio");
      aRadio.TurnOffDevice();
      aRadio.CutPower();
    } else {
      Log(" Turning on the companion radio");
      aRadio.TurnOnDevice();
    };
  };
}

@addMethod(LocomotionEventsTransition) 
protected func RadioCompanionFollowPlayer(scriptInterface: ref<StateGameScriptInterface>) {
  let aRadio: wref<Radio>;
  let radioPosition: Vector4;
  let radioRotationV: Vector4;
  let player: wref<PlayerPuppet> = this.GetPlayerPuppet(scriptInterface);
  
  if IsDefined(GetAllBlackboardDefs().m_modRadioCompanion) && IsDefined(player) {
    aRadio = GetAllBlackboardDefs().m_modRadioCompanion as Radio;
    radioPosition = player.GetWorldPosition() + (player.GetWorldUp() * 2.5) + (player.GetWorldForward() * 0.5);
    radioRotationV = (player.GetWorldForward() * -0.5) + (player.GetWorldUp() * 0.5);
    GameInstance.GetTeleportationFacility(player.GetGame()).Teleport(aRadio, radioPosition, Vector4.ToRotation(radioRotationV));
  }
}

@replaceMethod(LocomotionEventsTransition)
public func OnUpdate(timeDelta: Float, stateContext: ref<StateContext>, scriptInterface: ref<StateGameScriptInterface>) -> Void {
  this.UpdateIsPlayerMovingHorizontallyBB(stateContext, scriptInterface);
  this.UpdateIsPlayerMovingVerticallyBB(stateContext, scriptInterface);
  this.ProcessSprintInputLock(stateContext, scriptInterface);
  
  this.RadioCompanionFollowPlayer(scriptInterface);
}
