@replaceMethod(AIWeapon)
public final static func Fire(weaponOwner: wref<GameObject>, weapon: wref<WeaponObject>, const timeStamp: Float, tbhCoefficient: Float, requestedTriggerMode: gamedataTriggerMode, opt targetPosition: Vector4, opt target: ref<GameObject>, opt rangedAttack: TweakDBID, opt maxSpreadOverride: Float, opt aimingDelay: Float, opt offset: Vector4, opt shouldTrackTarget: Bool, opt predictionTime: Float, opt posProviderOverride: ref<IPositionProvider>) -> Void {
  let ammoPerShot: Int32;
  let attackAttemptEvent: ref<AIAttackAttemptEvent>;
  let bestTargetingComponent: wref<TargetingComponent>;
  let broadcaster: ref<StimBroadcasterComponent>;
  let cameraTransform: Transform;
  let chargeLevel: Float;
  let currentShootAtPos: Vector4;
  let maxSpread: Float;
  let miss: Bool;
  let playerShotOrigin: Vector4;
  let positionProvider: ref<IPositionProvider>;
  let projectileParams: gameprojectileWeaponParams;
  let projectilesPerShot: Int32;
  let statsSystem: ref<StatsSystem>;
  let targetShootComponent: ref<TargetShootComponent>;
  let weaponID: EntityID;
  let worldPos: WorldPosition;
  let playerShotOffset: Float = 0.40;
  let targetAsPuppet: ref<ScriptedPuppet> = target as ScriptedPuppet;
  if !IsDefined(weapon) || !weapon.IsAttached() {
    return;
  };
  weaponOwner.QueueEventForEntityID(weapon.GetEntityID(), new SetWeaponOwnerEvent());
  WeaponObject.SendMuzzleOffset(weapon, weaponOwner);
  if AIWeapon.CanWeaponOverheat(weapon) {
    AIWeapon.ProcessWeaponOverheatStatPool(weapon, weaponOwner);
    if AIWeapon.GetWeaponOverheatBB(weapon) {
      return;
    };
  };
  weaponID = weapon.GetEntityID();
  statsSystem = GameInstance.GetStatsSystem(weapon.GetGame());
  maxSpread = statsSystem.GetStatValue(Cast(weaponID), gamedataStatType.SpreadMaxAI);
  ammoPerShot = Cast(statsSystem.GetStatValue(Cast(weaponID), gamedataStatType.NumShotsToFire));
  projectilesPerShot = Cast(statsSystem.GetStatValue(Cast(weaponID), gamedataStatType.ProjectilesPerShot));
  if AIWeapon.GetChargeLevel(weapon, timeStamp, chargeLevel) {
    projectileParams.charge = chargeLevel;
  };
  if NotEquals(RPGManager.GetWeaponEvolution(weapon.GetItemID()), gamedataWeaponEvolution.Tech) && RPGManager.IsTechPierceEnabled(weaponOwner.GetGame(), weaponOwner, weapon.GetItemID()) {
    projectileParams.charge = 1.00;
  };
  chargeLevel *= 100.00;
  positionProvider = posProviderOverride;
  if aimingDelay > 0.00 && IsDefined(targetAsPuppet) {
    positionProvider = IPositionProvider.CreateEntityHistoryPositionProvider(targetAsPuppet.GetTransformHistoryComponent(), aimingDelay);
  };
  if IsDefined(target) {
    if target.IsPlayer() {
      bestTargetingComponent = (target as PlayerPuppet).GetPrimaryTargetingComponent();
    } else {
      bestTargetingComponent = GameInstance.GetTargetingSystem(weaponOwner.GetGame()).GetBestComponentOnTargetObject(weapon.GetWorldPosition(), weapon.GetWorldForward(), target, TargetComponentFilterType.Shooting);
    };
    // Mod change: Always do these calculations, even if the target is invisible.
    // evasion is calculated in the targetShootComponent.HandleWeaponShoot() call below
    if true {
    // if weaponOwner.GetSensesComponent().IsAgentVisible(target) || shouldTrackTarget {
      if IsDefined(bestTargetingComponent) {
        positionProvider = IsDefined(positionProvider) ? positionProvider : IPositionProvider.CreatePlacedComponentPositionProvider(bestTargetingComponent);
        if shouldTrackTarget {
          projectileParams.smartGunAccuracy = 1.00;
          projectileParams.smartGunIsProjectileGuided = true;
          projectileParams.trackedTargetComponent = bestTargetingComponent;
        };
      } else {
        positionProvider = IsDefined(positionProvider) ? positionProvider : IPositionProvider.CreateSlotPositionProvider(target, n"Head");
      };
      positionProvider.CalculatePosition(currentShootAtPos);
      if target.IsPlayer() {
        currentShootAtPos.Z -= 0.15;
      };
      if maxSpreadOverride > 0.00 {
        maxSpread = maxSpreadOverride;
      };
      targetShootComponent = target.GetTargetShootComponent();
      if IsDefined(targetShootComponent) && aimingDelay == 0.00 {
        offset += targetShootComponent.HandleWeaponShoot(weaponOwner, weapon, currentShootAtPos, maxSpread, tbhCoefficient, miss);
        if miss && shouldTrackTarget {
          gameprojectileWeaponParams.AddObjectToIgnoreCollisionWith(projectileParams, target.GetEntityID());
        };
      };
    };
  } else {
    WorldPosition.SetVector4(worldPos, targetPosition);
    positionProvider = IsDefined(positionProvider) ? positionProvider : IPositionProvider.CreateStaticPositionProvider(worldPos);
    currentShootAtPos = targetPosition;
  };
  if rangedAttack == t"Attacks.SuicideBullet" {
    projectileParams.ignoreWeaponOwnerCollision = false;
  } else {
    projectileParams.shootingOffset = statsSystem.GetStatValue(Cast(weaponID), gamedataStatType.ShootingOffsetAI);
  };
  AIWeapon.SetAttackBasedOnTimeDilation(weaponOwner, weapon, rangedAttack);
  projectileParams.hitPlaneOffset = offset;
  if rangedAttack == t"Attacks.SuicideBullet" && !GameInstance.GetTargetingSystem(weapon.GetGame()).IsVisibleTarget(GameInstance.GetPlayerSystem(weapon.GetGame()).GetLocalPlayerMainGameObject(), weaponOwner) {
    GameObject.ToggleForcedVisibilityInAnimSystemEvent(weaponOwner, n"SuicideBullet", true);
    weapon.AI_ShootSelfOffScreen(target as gamePuppet, Cast(ammoPerShot), projectileParams, Cast(projectilesPerShot), chargeLevel);
  } else {
    if IsDefined(weaponOwner as PlayerPuppet) {
      if GameInstance.GetCameraSystem(weaponOwner.GetGame()).GetActiveCameraWorldTransform(cameraTransform) {
        playerShotOrigin = Transform.GetPosition(cameraTransform) + Transform.GetForward(cameraTransform) * playerShotOffset;
        weapon.AI_ShootForwards(weaponOwner, Cast(ammoPerShot), projectileParams, Cast(projectilesPerShot), chargeLevel, playerShotOrigin, Transform.GetForward(cameraTransform));
      };
    } else {
      if AIActionHelper.ShouldShootDirectlyAtTarget(weaponOwner, weapon, currentShootAtPos) {
        if predictionTime > 0.00 {
          offset += Vector4.ClampLength((target as gamePuppet).GetVelocity(), 0.00, 15.00) * predictionTime;
        };
        positionProvider.SetWorldOffset(offset);
        weapon.AI_ShootAt(positionProvider, target, weaponOwner, Cast(ammoPerShot), projectileParams, Cast(projectilesPerShot), chargeLevel, maxSpread);
      } else {
        if !Vector4.IsZero(currentShootAtPos) && weaponOwner.GetTargetTrackerComponent().IsPositionValid(currentShootAtPos) {
          positionProvider.SetWorldOffset(offset);
          weapon.AI_ShootAt(positionProvider, target, weaponOwner, Cast(ammoPerShot), projectileParams, Cast(projectilesPerShot), chargeLevel, maxSpread);
        } else {
          weapon.AI_ShootForwards(weaponOwner, Cast(ammoPerShot), projectileParams, Cast(projectilesPerShot), chargeLevel);
        };
      };
    };
  };
  if IsDefined(target) {
    attackAttemptEvent = new AIAttackAttemptEvent();
    attackAttemptEvent.instigator = weaponOwner;
    attackAttemptEvent.target = target;
    weaponOwner.QueueEvent(attackAttemptEvent);
  };
  AnimationControllerComponent.PushEventToReplicate(weaponOwner, n"Shoot");
  AnimationControllerComponent.PushEventToReplicate(weapon, n"Shoot");
  WeaponObject.TriggerWeaponEffects(weapon, gamedataFxAction.Shoot);
  WeaponObject.SendAmmoUpdateEvent(weaponOwner, weapon);
  broadcaster = weaponOwner.GetStimBroadcasterComponent();
  if IsDefined(broadcaster) && !weaponOwner.IsPlayer() {
    broadcaster.TriggerSingleBroadcast(weapon, gamedataStimType.Gunshot);
  };
  AIWeapon.OnShotFired(weapon, requestedTriggerMode, timeStamp);
}