local Tweaks = { }
Tweaks.modName = "KiroshiOpticsMod."
Tweaks.createdRecords = { }

function Tweaks.checkForCreatedRecord(recordName)
	if Tweaks.createdRecords[tostring(Tweaks.modName .. recordName)] then
		return tostring(Tweaks.modName .. recordName)
	end
	
	return tostring(recordName)
end

function Tweaks.New(recordName)
	recordName = Tweaks.checkForCreatedRecord(recordName)
	return TweakDBID.new(recordName)
end

function Tweaks.CreateRecord(recordName, recordType)
	recordName = tostring(Tweaks.modName .. recordName)
	TweakDB:CreateRecord(recordName, recordType)
	Tweaks.createdRecords[recordName] = true
end

function Tweaks.CloneRecord(recordName, oldRecord)
	recordName = tostring(Tweaks.modName .. recordName)
	pcall(function()
		TweakDB:CloneRecord(recordName, oldRecord)
	end)
	Tweaks.createdRecords[recordName] = true
end

function Tweaks.SetFlatNoUpdate(recordName, flat, value)
	recordName = Tweaks.checkForCreatedRecord(recordName)
	recordName = recordName .. "." .. flat
	TweakDB:SetFlatNoUpdate(recordName, value)
end

function Tweaks.SetFlat(recordName, flat, value)
	recordName = Tweaks.checkForCreatedRecord(recordName)
	recordName = recordName .. "." .. flat
	TweakDB:SetFlat(recordName, value)
end

function Tweaks.SetFlats(recordName, flats)
	if type(flats) ~= "table" then return end
	recordName = Tweaks.checkForCreatedRecord(recordName)
	TweakDB:SetFlats(recordName, flats)
end

function Tweaks.GetFlat(recordName, flat)
	recordName = Tweaks.checkForCreatedRecord(recordName)
	return TweakDB:GetFlat(recordName .. "." .. flat)
end

function Tweaks.UpdateRecord(recordName)
	recordName = Tweaks.checkForCreatedRecord(recordName)
	TweakDB:Update(recordName)
end

function Tweaks.UpdateAll()
	for record in pairs(Tweaks.createdRecords) do
		TweakDB:Update(record)
	end
end

checkForCreatedRecord = Tweaks.checkForCreatedRecord
New = Tweaks.New
CreateRecord = Tweaks.CreateRecord
CloneRecord = Tweaks.CloneRecord
SetFlatNoUpdate = Tweaks.SetFlatNoUpdate
SetFlat = Tweaks.SetFlat
SetFlats = Tweaks.SetFlats
GetFlat = Tweaks.GetFlat
UpdateRecord = Tweaks.UpdateRecord
UpdateAll = Tweaks.UpdateAll

function Tweaks.Init()
	SetFlat("Items.KiroshiOpticsFragment4", "OnEquip", { })
end

return Tweaks