local GameUI = require("GameUI")
local Tweaks = require("Tweaks")
local Cron = require("Cron")

local gameLoaded = false

local revealedNPCs = { }
local opticFragmentID
local hasOpticsFragment = false

function hasOpticalPart()
    local equipSys = Game.GetScriptableSystemsContainer():Get(CName.new("EquipmentSystem")):GetPlayerData(Game.GetPlayer())
    equipSys['boobies'] = equipSys["GetItemInEquipSlot;gamedataEquipmentAreaInt32"]

    local hasOptics = equipSys:boobies(gamedataEquipmentArea.EyesCW, 0)

    if hasOptics.id.hash ~= 0 then
        local opticData = Game.GetTransactionSystem():GetItemData(Game.GetPlayer(), hasOptics)
        local parts = opticData:GetItemParts()
        for i, v in pairs(parts) do
            if ItemID.GetTDBID(InnerItemData.GetItemID(v)) == opticFragmentID then
                hasOpticsFragment = true
            end
        end
    end
end

function foundInRevealedNPCS(hash)
    for index, hashid in pairs(revealedNPCs) do
        if hashid == hash then
            return true
        end
    end
    
    return false
end

registerForEvent("onInit", function()
    opticFragmentID = TweakDBID.new("Items.KiroshiOpticsFragment4")
    Tweaks.Init()

    Observe("EquipmentSystemPlayerData", "OnPartInstallRequest", function(self, request)
        hasOpticalPart()
    end)

    Observe("EquipmentSystemPlayerData", "OnPartUninstallRequest", function(self, request)
        hasOpticalPart()
    end)

    Observe("NPCPuppet", "OnDeath", function(self)
        if self:IsPlayer() then return end
        for index, hashid in pairs(revealedNPCs) do
            if self:GetEntityID().hash == hashid then
                table.remove(revealedNPCs, index)
            end
        end
    end)

    Cron.Every(10, function()
        for index, hash in pairs(revealedNPCs) do
            local entity = Game.FindEntityByID(EntityID.new({ hash = hash }))
            if entity ~= nil then
                if Vector4.Distance(Game.GetPlayer():GetWorldPosition(), entity:GetWorldPosition()) > 250 then
                    entity:SendForceRevealObjectEvent(false, CName.new("AutomaticTagging"), Game.GetPlayer():GetEntityID(), 0)
                    table.remove(revealedNPCs, index)
                end
            else
                table.remove(revealedNPCs, index)
            end
        end
    end)

    GameUI.Observe("SessionStart", function()
        hasOpticalPart()
        gameLoaded = true
    end)

    GameUI.Observe("SessionEnd", function()
        gameLoaded = false
    end)
end)

registerForEvent("onUpdate", function(delta)
    Cron.Update(delta)
    if hasOpticsFragment and gameLoaded then
        local search = Game.TSQ_ALL()
        search.maxDistance = 150
        search.searchFilter = Game.TSF_NPC()
        local sex, parts
        sex, parts = Game.GetTargetingSystem():GetTargetParts(Game.GetPlayer(), search)
        for _, v in pairs(parts) do
            local obj = v:GetComponent(v):GetEntity()
            if obj then
                if obj:IsAlive() and (obj:IsHostile() or obj.isCyberpsycho or obj.isGanger) and not foundInRevealedNPCS(obj:GetEntityID().hash) then
                    local revealEvt = RevealObjectEvent.new()
                    revealEvt.reveal = true
                    revealEvt.reason.reason = CName.new("AutomaticTagging")
                    revealEvt.reason.sourceEntityId = Game.GetPlayer():GetEntityID()
                    revealEvt.lifetime = 99999999
                    table.insert(revealedNPCs, obj:GetEntityID().hash)
                    obj:QueueEvent(revealEvt)
                end
            end
        end
    end
end)