@replaceMethod(MinimalItemTooltipData)
  public final static func GetMinimalTooltipDataRequirements(itemData: wref<gameItemData>, hasSmartlink: Bool, playerStrength: Int32, playerReflex: Int32, playerLevel: Int32) -> ref<MinimalItemTooltipDataRequirements> {
    let result: ref<MinimalItemTooltipDataRequirements> = new MinimalItemTooltipDataRequirements();
    result.isSmartlinkRequirementNotMet = RPGManager.HasSmartLinkRequirement(itemData) && !hasSmartlink;
    let requiredStrength: Int32 = Cast(itemData.GetStatValueByType(gamedataStatType.Strength));
    let requiredReflex: Int32 = Cast(itemData.GetStatValueByType(gamedataStatType.Reflexes));
    let requiredLevel: Int32 = Cast(itemData.GetStatValueByType(gamedataStatType.Level));
	let itemLevel: Int32 = Cast(itemData.GetStatValueByType(gamedataStatType.ItemLevel)/10);
    if requiredLevel > 0 {
      result.isLevelRequirementNotMet = true;
	  if playerLevel < requiredLevel {
        result.requiredLevel = requiredLevel;
	  } else {
	    result.requiredLevel = itemLevel;
	  }
    };
    if requiredStrength > 0 && playerStrength < requiredStrength {
      result.strengthOrReflexStatName = UILocalizationHelper.GetStatNameLockey(RPGManager.GetStatRecord(gamedataStatType.Strength));
      result.strengthOrReflexValue = requiredStrength;
      result.isStrengthRequirementNotMet = true;
    };
    if requiredReflex > 0 && playerReflex < requiredReflex {
      result.strengthOrReflexStatName = UILocalizationHelper.GetStatNameLockey(RPGManager.GetStatRecord(gamedataStatType.Reflexes));
      result.strengthOrReflexValue = requiredReflex;
      result.isReflexRequirementNotMet = true;
    };
    return result;
  }

@replaceMethod(MinimalItemTooltipData)
  public final static func GetMinimalTooltipDataRequirements(itemData: wref<gameItemData>, tooltipData: ref<InventoryTooltipData>) -> ref<MinimalItemTooltipDataRequirements> {
    let requirement: SItemStackRequirementData;
    let statRecord: ref<Stat_Record>;
    let result: ref<MinimalItemTooltipDataRequirements> = new MinimalItemTooltipDataRequirements();
    result.isSmartlinkRequirementNotMet = RPGManager.HasSmartLinkRequirement(itemData) && !tooltipData.m_HasPlayerSmartGunLink;
    let requiredStrength: Int32 = Cast(itemData.GetStatValueByType(gamedataStatType.Strength));
    let requiredReflex: Int32 = Cast(itemData.GetStatValueByType(gamedataStatType.Reflexes));
    let requiredLevel: Int32 = Cast(itemData.GetStatValueByType(gamedataStatType.Level));
	let itemLevel: Int32 = Cast(itemData.GetStatValueByType(gamedataStatType.ItemLevel)/10);
    if requiredLevel > 0 {
      result.isLevelRequirementNotMet = true;
	  if tooltipData.m_PlayerLevel < requiredLevel {
        result.requiredLevel = requiredLevel;
	  } else {
	    result.requiredLevel = itemLevel;
	  }
    };
    if requiredStrength > 0 && tooltipData.m_PlayerStrenght < requiredStrength {
      result.strengthOrReflexStatName = UILocalizationHelper.GetStatNameLockey(RPGManager.GetStatRecord(gamedataStatType.Strength));
      result.strengthOrReflexValue = requiredStrength;
      result.isStrengthRequirementNotMet = true;
    };
    if requiredReflex > 0 && tooltipData.m_PlayerReflexes < requiredReflex {
      result.strengthOrReflexStatName = UILocalizationHelper.GetStatNameLockey(RPGManager.GetStatRecord(gamedataStatType.Reflexes));
      result.strengthOrReflexValue = requiredReflex;
      result.isReflexRequirementNotMet = true;
    };
    if !InventoryItemData.IsEmpty(tooltipData.inventoryItemData) {
      requirement = InventoryItemData.GetRequirement(tooltipData.inventoryItemData);
      if NotEquals(requirement.statType, gamedataStatType.Invalid) && !InventoryItemData.IsRequirementMet(tooltipData.inventoryItemData) {
        result.isAnyStatRequirementNotMet = true;
        result.anyStatValue = RoundF(requirement.requiredValue);
        statRecord = RPGManager.GetStatRecord(requirement.statType);
        result.anyStatName = GetLocalizedText(UILocalizationHelper.GetStatNameLockey(statRecord));
        result.anyStatColor = "StatTypeColor." + EnumValueToString("gamedataStatType", Cast(EnumInt(requirement.statType)));
        result.anyStatLocKey = "LocKey#49215";
      };
    };
    if !InventoryItemData.IsEquippable(tooltipData.inventoryItemData) {
      result.isAnyStatRequirementNotMet = true;
      requirement = InventoryItemData.GetEquipRequirement(tooltipData.inventoryItemData);
      result.anyStatValue = RoundF(requirement.requiredValue);
      statRecord = RPGManager.GetStatRecord(requirement.statType);
      result.anyStatName = GetLocalizedText(UILocalizationHelper.GetStatNameLockey(statRecord));
      result.anyStatColor = "StatTypeColor." + EnumValueToString("gamedataStatType", Cast(EnumInt(requirement.statType)));
      result.anyStatLocKey = "LocKey#77652";
    };
    return result;
  }