local Engine = {}

-- functionality comes courtesy of user Bart Kiers on StackOverflow
function Engine.Inventory(fileName)

	-- see if the file exists
	function file_exists(file)
	
		local f = io.open(file, "rb")
		if f then f:close() end
		return f ~= nil
	
	end

	-- get all lines from a file, returns an empty list/table if the file does not exist
	function lines_from(file)
	
	if not file_exists(file) then return {} end
		lines = {}
		
		for line in io.lines(file) do 
			lines[#lines + 1] = line
		end
		
		return lines
	
	end

	-- tests the functions above
	local file = fileName
	local lines = lines_from(file)

	-- table for returning file data
	inventoryResults = {}

	-- populates inventoryResults with file data
	for k,v in pairs(lines) do
				
		inventoryResults[k] = v
				
	end
	
	return inventoryResults

end

return Engine