local UI = {}

local Engine = require('engine')

	function UI.run(version)
		local showUI = false

		registerForEvent("onOverlayOpen", function()
			showUI = true
		end)

		registerForEvent("onOverlayClose", function()
			
			showUI = false
		
		end)
		
		-- define button dimensions
		local buttonWidth1 = 130
		local buttonHeight1 = 28
		local buttonWidth2 = 80
		local buttonHeight2 = 20
		local buttonWidth3 = 170
		local buttonHeight3 = 28
		
		-- table used to store search results
		inventoryResults = {}
		
		-- display search results from buttons as a list
		local function DisplayResults(inventoryResults)
		
			local n = 1 -- Counter used as a unique identifier for "Buy Now" buttons.  Button functions would only apply to the first button generated in a list when they all had the same name.

			for k,v in pairs(inventoryResults) do
				
				addItem = string.format("Items.%s", v) -- converts the item ID from the text file into the required format for spawning items with Game.AddToInventory()

				if (ImGui.Button("Buy Now##" .. n, buttonWidth2, buttonHeight2)) then -- button names generated with unique names (number from the counter used to distinguish them from each other).  ## hides itself and the following number
					
					-- print(addItem) -- Debug function for checking item IDs and comparing to the items spawned.  For testing purposes only.
					Game.AddToInventory(addItem,1)
		
				end

				ImGui.SameLine()
				ImGui.Text(" ")
				ImGui.SameLine()
				
				ImGui.Text(Game.GetLocalizedTextByKey(Game['TDB::GetLocKey;TweakDBID'](TweakDBID.new("Items." .. v .. ".displayName")))) -- receives the item ID from the text files and converts it to the in-game display name
				
				ImGui.Separator()
				
				n = n+1 -- increments the button ID counter on each iteration
				
			end
				
		end

		-- generates the UI
		registerForEvent("onDraw", function()
			if (not showUI) then return end

			ImGui.SetNextWindowPos(0, 250, ImGuiCond.FirstUseEver)
			ImGui.SetNextWindowSize(615, 575, ImGuiCond.Appearing)

			if ImGui.Begin("Digital Couture") then

				ImGui.Spacing()

				ImGui.Text("What kind of clothing are you looking for?")
				
				ImGui.Spacing()

				-- item search tabs
				if (ImGui.BeginTabBar("DigitalCouture")) then -- primary tab bar
				
					if (ImGui.BeginTabItem("Tops")) then -- individual tab
					
						if (ImGui.BeginTabBar("Tops")) then -- secondary tab bar (below the first)
						
							if (ImGui.BeginTabItem("Undershirts")) then
							
								ImGui.Spacing()
								ImGui.Text("All Available Styles for Undershirts:")
								ImGui.Spacing()
							
								if (ImGui.Button("All Undershirts", buttonWidth1, buttonHeight1)) then -- button in search area

									Engine.Inventory("inventory/undershirts.txt")
							
								end
							
							ImGui.EndTabItem()
							
							end
							
							if (ImGui.BeginTabItem("T-Shirts")) then

								ImGui.Spacing()
								ImGui.Text("All Available Styles for T-Shirts:")
								ImGui.Spacing()

								if (ImGui.Button("Discount", buttonWidth1, buttonHeight1)) then
							
									Engine.Inventory("inventory/tshirtsdiscount.txt")
							
								end
								
								ImGui.SameLine()
								
								if (ImGui.Button("Casual", buttonWidth1, buttonHeight1)) then
							
									Engine.Inventory("inventory/tshirtscasual.txt")
							
								end
								
								ImGui.SameLine()
								
								if (ImGui.Button("Designer", buttonWidth1, buttonHeight1)) then
							
									Engine.Inventory("inventory/tshirtsdesigner.txt")
							
								end
							
							ImGui.EndTabItem()
							
							end
							
							if (ImGui.BeginTabItem("Shirts")) then
							
								ImGui.Spacing()
								ImGui.Text("All Available Styles for Shirts:")
								ImGui.Spacing()
						
								if (ImGui.Button("Discount", buttonWidth1, buttonHeight1)) then
							
									Engine.Inventory("inventory/shirtsdiscount.txt")
							
								end
								
								ImGui.SameLine()
								
								if (ImGui.Button("Casual", buttonWidth1, buttonHeight1)) then
							
									Engine.Inventory("inventory/shirtscasual.txt")
							
								end
								
								ImGui.SameLine()
								
								if (ImGui.Button("Designer", buttonWidth1, buttonHeight1)) then
							
									Engine.Inventory("inventory/shirtsdesigner.txt")
							
								end
								
								ImGui.SameLine()
								
								if (ImGui.Button("Formal", buttonWidth1, buttonHeight1)) then
							
									Engine.Inventory("inventory/shirtsformal.txt")
							
								end
						
							ImGui.EndTabItem()
							
							end
							
							if (ImGui.BeginTabItem("Vests")) then
							
								ImGui.Spacing()
								ImGui.Text("All Available Styles for Vests:")
								ImGui.Spacing()
						
								if (ImGui.Button("Discount", buttonWidth1, buttonHeight1)) then
							
									Engine.Inventory("inventory/vestsdiscount.txt")
							
								end
								
								ImGui.SameLine()
								
								if (ImGui.Button("Casual", buttonWidth1, buttonHeight1)) then
							
									Engine.Inventory("inventory/vestscasual.txt")
							
								end
								
								ImGui.SameLine()
								
								if (ImGui.Button("Designer", buttonWidth1, buttonHeight1)) then
							
									Engine.Inventory("inventory/vestsdesigner.txt")
							
								end
						
							ImGui.EndTabItem()
							
							end
						
						ImGui.EndTabBar()
						
						end
						
					ImGui.EndTabItem()
					
					end
					
					if (ImGui.BeginTabItem("Bottoms")) then
						
							if (ImGui.BeginTabBar("Bottoms")) then
							
								if (ImGui.BeginTabItem("Pants")) then
								
									ImGui.Spacing()
									ImGui.Text("All Available Styles for Pants:")
									ImGui.Spacing()
								
									if (ImGui.Button("Discount", buttonWidth1, buttonHeight1)) then
							
										Engine.Inventory("inventory/pantsdiscount.txt")
								
									end
									
									ImGui.SameLine()
									
									if (ImGui.Button("Casual", buttonWidth1, buttonHeight1)) then
								
										Engine.Inventory("inventory/pantscasual.txt")
								
									end
									
									ImGui.SameLine()
									
									if (ImGui.Button("Designer", buttonWidth1, buttonHeight1)) then
								
										Engine.Inventory("inventory/pantsdesigner.txt")
								
									end
									
									ImGui.SameLine()
									
									if (ImGui.Button("Formal", buttonWidth1, buttonHeight1)) then
								
										Engine.Inventory("inventory/pantsformal.txt")
								
									end
								
								ImGui.EndTabItem()
								
								end
								
								if (ImGui.BeginTabItem("Skirts")) then
								
									ImGui.Spacing()
									ImGui.Text("All Available Styles for Skirts:")
									ImGui.Spacing()
								
									if (ImGui.Button("All Skirts", buttonWidth1, buttonHeight1)) then
							
										Engine.Inventory("inventory/skirts.txt")
								
									end
								
								ImGui.EndTabItem()
								
								end
							
							ImGui.EndTabBar()
							
							end
						
					ImGui.EndTabItem()
					
					end
					
					if (ImGui.BeginTabItem("Full Body Outfits")) then
					
						if (ImGui.BeginTabBar("Full Body Outfits")) then
					
							if (ImGui.BeginTabItem("Dresses")) then
							
								ImGui.Spacing()
								ImGui.Text("All Available Styles for Dresses:")
								ImGui.Spacing()

								if (ImGui.Button("All Dresses", buttonWidth1, buttonHeight1)) then

									Engine.Inventory("inventory/dresses.txt")
							
								end
								
							ImGui.EndTabItem()
							
							end
							
							if (ImGui.BeginTabItem("Jumpsuits")) then
							
								ImGui.Spacing()
								ImGui.Text("All Available Styles for Jumpsuits:")
								ImGui.Spacing()

								if (ImGui.Button("All Jumpsuits", buttonWidth1, buttonHeight1)) then

									Engine.Inventory("inventory/jumpsuits.txt")
							
								end
								
							ImGui.EndTabItem()
							
							end
						
						ImGui.EndTabBar()
						
						end
						
					ImGui.EndTabItem()
					
					end
					
					if (ImGui.BeginTabItem("Outerwear")) then
					
						if (ImGui.BeginTabBar("Outerwear")) then
						
							if (ImGui.BeginTabItem("Coats")) then
							
								ImGui.Spacing()
								ImGui.Text("All Available Styles for Coats:")
								ImGui.Spacing()
							
								if (ImGui.Button("All Coats", buttonWidth1, buttonHeight1)) then

									Engine.Inventory("inventory/coats.txt")
							
								end
							
							ImGui.EndTabItem()
							
							end
							
							if (ImGui.BeginTabItem("Jackets")) then
							
								ImGui.Spacing()
								ImGui.Text("All Available Styles for Jackets:")
								ImGui.Spacing()
							
								if (ImGui.Button("Discount", buttonWidth1, buttonHeight1)) then
							
										Engine.Inventory("inventory/jacketsdiscount.txt")
								
									end
									
									ImGui.SameLine()
									
									if (ImGui.Button("Casual", buttonWidth1, buttonHeight1)) then
								
										Engine.Inventory("inventory/jacketscasual.txt")
								
									end
									
									ImGui.SameLine()
									
									if (ImGui.Button("Designer", buttonWidth1, buttonHeight1)) then
								
										Engine.Inventory("inventory/jacketsdesigner.txt")
								
									end
									
									ImGui.SameLine()
									
									if (ImGui.Button("Formal", buttonWidth1, buttonHeight1)) then
								
										Engine.Inventory("inventory/jacketsformal.txt")
								
									end
							
							ImGui.EndTabItem()
							
							end
						
						ImGui.EndTabBar()
						
						end
					
					ImGui.EndTabItem()
					
					end
					
					if (ImGui.BeginTabItem("Footwear")) then
					
						if (ImGui.BeginTabBar("Footwear")) then
						
							if (ImGui.BeginTabItem("Shoes")) then
							
								ImGui.Spacing()
								ImGui.Text("All Available Styles for Shoes:")
								ImGui.Spacing()
							
								if (ImGui.Button("Casual", buttonWidth1, buttonHeight1)) then
								
										Engine.Inventory("inventory/shoescasual.txt")
								
									end
									
									ImGui.SameLine()
									
									if (ImGui.Button("Formal", buttonWidth1, buttonHeight1)) then
								
										Engine.Inventory("inventory/shoesformal.txt")
								
									end
							
							ImGui.EndTabItem()
							
							end
							
							if (ImGui.BeginTabItem("Boots")) then
							
								ImGui.Spacing()
								ImGui.Text("All Available Styles for Boots:")
								ImGui.Spacing()
							
								if (ImGui.Button("All Boots", buttonWidth1, buttonHeight1)) then

									Engine.Inventory("inventory/boots.txt")
							
								end
							
							ImGui.EndTabItem()
							
							end
						
						ImGui.EndTabBar()
						
						end
						
					ImGui.EndTabItem()
					
					end
					
					if (ImGui.BeginTabItem("Headwear")) then
					
						if (ImGui.BeginTabBar("Headwear")) then
					
							if (ImGui.BeginTabItem("Hats")) then
							
								ImGui.Spacing()
								ImGui.Text("All Available Styles for Hats:")
								ImGui.Spacing()

								if (ImGui.Button("All Hats", buttonWidth1, buttonHeight1)) then
									
									Engine.Inventory("inventory/hats.txt")
									
								end
								
							ImGui.EndTabItem()
					
							end
							
							if (ImGui.BeginTabItem("Caps")) then
							
								ImGui.Spacing()
								ImGui.Text("All Available Styles for Caps:")
								ImGui.Spacing()
					
								if (ImGui.Button("All Caps", buttonWidth1, buttonHeight1)) then

									Engine.Inventory("inventory/caps.txt")
									
								end
								
							ImGui.EndTabItem()
							
							end
							
							if (ImGui.BeginTabItem("Balaclavas")) then
							
								ImGui.Spacing()
								ImGui.Text("All Available Styles for Balaclavas:")
								ImGui.Spacing()
							
								if (ImGui.Button("All Balaclavas", buttonWidth1, buttonHeight1)) then

									Engine.Inventory("inventory/balaclavas.txt")
									
								end
								
							ImGui.EndTabItem()
							
							end
							
							if (ImGui.BeginTabItem("Helmets")) then
							
								ImGui.Spacing()
								ImGui.Text("All Available Styles for Helmets:")
								ImGui.Spacing()
								
								if (ImGui.Button("All Helmets", buttonWidth1, buttonHeight1)) then

									Engine.Inventory("inventory/helmets.txt")
									
								end
								
							ImGui.EndTabItem()
							
							end
							
							if (ImGui.BeginTabItem("Bandanas And Hijabs")) then
								
								ImGui.Spacing()
								ImGui.Text("All Available Styles for Bandanas and Hijabs:")
								ImGui.Spacing()
							
								if (ImGui.Button("All Bandanas and Hijabs", buttonWidth3, buttonHeight3)) then

									Engine.Inventory("inventory/scarves.txt")

								end
								
							ImGui.EndTabItem()
							
							end
						
						ImGui.EndTabBar()
						
						end
						
					ImGui.EndTabItem()
					
					end
					
					if (ImGui.BeginTabItem("Accessories")) then
					
						if (ImGui.BeginTabBar("Accessories")) then
					
							if (ImGui.BeginTabItem("Eyewear")) then
							
								ImGui.Spacing()
								ImGui.Text("All Available Styles for Eyewear:")
								ImGui.Spacing()
					
								if (ImGui.Button("Glasses", buttonWidth1, buttonHeight1)) then

									Engine.Inventory("inventory/glasses.txt")
									
								end
								
								ImGui.SameLine()
								
								if (ImGui.Button("Visors", buttonWidth1, buttonHeight1)) then

									Engine.Inventory("inventory/visors.txt")
									
								end
								
							ImGui.EndTabItem()
							
							end
							
							if (ImGui.BeginTabItem("Masks")) then
							
								ImGui.Spacing()
								ImGui.Text("All Available Styles for Masks:")
								ImGui.Spacing()
								
									if (ImGui.Button("All Masks", buttonWidth1, buttonHeight1)) then

										Engine.Inventory("inventory/masks.txt")
										
									end
							
							ImGui.EndTabItem()
							
							end
							
							if (ImGui.BeginTabItem("Tech")) then
							
								ImGui.Spacing()
								ImGui.Text("All Available Styles for Tech:")
								ImGui.Spacing()
							
								if (ImGui.Button("All Tech", buttonWidth1, buttonHeight1)) then

									Engine.Inventory("inventory/tech.txt")
									
								end
							
							ImGui.EndTabItem()
							
							end
							
						ImGui.EndTabBar()
						
						end
						
					ImGui.EndTabItem()
					
					end
				
				ImGui.EndTabBar()
				
				end
				
				ImGui.Spacing()

				-- display area for search results
				ImGui.BeginChild("Items Display", 600, 400, true)
				
					DisplayResults(inventoryResults)
					
				ImGui.EndChild()

				ImGui.Spacing()
				
			end
			
			ImGui.End()
		
		end)
		
	end

return UI