-------------------------------------------------------------------------------------------------------------------------------
-- This mod was created by keanuWheeze from CP2077 Modding Tools Discord.
--
-- You are free to use this mod as long as you follow the following license guidelines:
--    * It may not be uploaded to any other site without my express permission.
--    * Using any code contained herein in another mod requires credits / asking me.
--    * You may not fork this code and make your own competing version of this mod available for download without my permission.
--
-------------------------------------------------------------------------------------------------------------------------------
-- Credits: psiberx for GameSettings.lua and Cron.lua
-------------------------------------------------------------------------------------------------------------------------------

bs = {
    runtimeData = {
        cetOpen = false,
        nativeSettingsInstalled = true
    },

    defaultSettings = {
        ar = {levels = 2, amount = 2.2},
        lmg = {levels = 2, amount = 1},
        smg = {levels = 2, amount = 1.5},
        handgun = {levels = 1, amount = 0.6},
        sniper = {levels = 3, amount = 3},
        shotgun = {levels = 2, amount = 0.8}
    },
    settings = {},

    config = require("modules/config"),
    settingsUI = require("modules/settingsUI"),
    observers = require("modules/observers"),
    GameSettings = require("modules/external/GameSettings"),
    Cron = require("modules/external/Cron")
}

function bs:new()
    registerForEvent("onInit", function()
        bs.config.tryCreateConfig("config/config.json", bs.defaultSettings)
        bs.config.backwardComp("config/config.json", bs.defaultSettings)
        bs.settings = bs.config.loadFile("config/config.json")

        bs.settingsUI.setupNativeUI(bs)
        bs.observers.startInputObserver(bs)
        bs.observers.startListeners(GetPlayer())

        bs.GameSettings.Set("/gameplay/difficulty/SwayEffect", 1)
        bs.GameSettings.Save()
    end)

    registerForEvent("onShutdown", function ()
        bs.observers.isAds = false
    end)

    registerForEvent("onUpdate", function (deltaTime)
        bs.Cron.Update(deltaTime)
    end)

    registerForEvent("onDraw", function()
        if not bs.runtimeData.nativeSettingsInstalled and bs.runtimeData.cetOpen then
            bs.settingsUI.drawImGui(bs)
        end
    end)

    registerForEvent("onOverlayOpen", function()
        bs.runtimeData.cetOpen = true
    end)

    registerForEvent("onOverlayClose", function()
        bs.runtimeData.cetOpen = false
    end)

    registerHotkey("betterScopesToggle", "Optional change zoom level hotkey", function()
        if bs.observers.isAds then
            bs.observers.zoom(bs)
        end
    end)

    return bs

end

return bs:new()