local config = require("modules/config")

ui = {
    maxLevels = 3,
    maxAmount = 3
}

function ui.setupNativeUI(bs)
    local nativeSettings = GetMod("nativeSettings")

    if not nativeSettings then
        print("[Better Scopes] Error: NativeSettings lib not found!")
        bs.runtimeData.nativeSettingsInstalled = false
        return
    end

    local cetVer = tonumber((GetVersion():gsub('^v(%d+)%.(%d+)%.(%d+)(.*)', function(major, minor, patch, wip) -- <-- This has been made by psiberx, all credits to him
        return ('%d.%02d%02d%d'):format(major, minor, patch, (wip == '' and 0 or 1))
    end)))

    if cetVer < 1.18 then
        print("[Better Scopes] Error: CET version below recommended, switched to ImGui settings UI!")
        bs.runtimeData.nativeSettingsInstalled = false
        return
    end

    nativeSettings.addTab("/betterScopes", "Better Scopes")
    nativeSettings.addSubcategory("/betterScopes/sniper", "Sniper Rifle")
    nativeSettings.addSubcategory("/betterScopes/ar", "Assault Rifle")
    nativeSettings.addSubcategory("/betterScopes/smg", "SMG")
    nativeSettings.addSubcategory("/betterScopes/lmg", "LMG")
    nativeSettings.addSubcategory("/betterScopes/handgun", "Pistols and Handguns")
    nativeSettings.addSubcategory("/betterScopes/shotgun", "Shotgun")

    -- Sniper
    nativeSettings.addRangeInt("/betterScopes/sniper", "Zoom levels", "How many zoom levels there are, 1 means just the default zoom level", 1, ui.maxLevels, 1, bs.settings.sniper.levels, bs.defaultSettings.sniper.levels, function(value)
        bs.settings.sniper.levels = value
        config.saveFile("config/config.json", bs.settings)
    end)

    nativeSettings.addRangeFloat("/betterScopes/sniper", "Zoom level amount", "How much each level zooms in", 0.5, ui.maxAmount, 0.1, "%.1f", bs.settings.sniper.amount, bs.defaultSettings.sniper.amount, function(value)
        bs.settings.sniper.amount = value
        config.saveFile("config/config.json", bs.settings)
    end)

    -- AR
    nativeSettings.addRangeInt("/betterScopes/ar", "Zoom levels", "How many zoom levels there are, 1 means just the default zoom level", 1, ui.maxLevels, 1, bs.settings.ar.levels, bs.defaultSettings.ar.levels, function(value)
        bs.settings.ar.levels = value
        config.saveFile("config/config.json", bs.settings)
    end)

    nativeSettings.addRangeFloat("/betterScopes/ar", "Zoom level amount", "How much each level zooms in", 0.5, ui.maxAmount, 0.1, "%.1f", bs.settings.ar.amount, bs.defaultSettings.ar.amount, function(value)
        bs.settings.ar.amount = value
        config.saveFile("config/config.json", bs.settings)
    end)

    -- SMG
    nativeSettings.addRangeInt("/betterScopes/smg", "Zoom levels", "How many zoom levels there are, 1 means just the default zoom level", 1, ui.maxLevels, 1, bs.settings.smg.levels, bs.defaultSettings.smg.levels, function(value)
        bs.settings.smg.levels = value
        config.saveFile("config/config.json", bs.settings)
    end)

    nativeSettings.addRangeFloat("/betterScopes/smg", "Zoom level amount", "How much each level zooms in", 0.5, ui.maxAmount, 0.1, "%.1f", bs.settings.smg.amount, bs.defaultSettings.smg.amount, function(value)
        bs.settings.smg.amount = value
        config.saveFile("config/config.json", bs.settings)
    end)

    -- LMG
    nativeSettings.addRangeInt("/betterScopes/lmg", "Zoom levels", "How many zoom levels there are, 1 means just the default zoom level", 1, ui.maxLevels, 1, bs.settings.lmg.levels, bs.defaultSettings.lmg.levels, function(value)
        bs.settings.lmg.levels = value
        config.saveFile("config/config.json", bs.settings)
    end)

    nativeSettings.addRangeFloat("/betterScopes/lmg", "Zoom level amount", "How much each level zooms in", 0.5, ui.maxAmount, 0.1, "%.1f", bs.settings.lmg.amount, bs.defaultSettings.lmg.amount, function(value)
        bs.settings.lmg.amount = value
        config.saveFile("config/config.json", bs.settings)
    end)

    -- Pistol
    nativeSettings.addRangeInt("/betterScopes/handgun", "Zoom levels", "How many zoom levels there are, 1 means just the default zoom level", 1, ui.maxLevels, 1, bs.settings.handgun.levels, bs.defaultSettings.handgun.levels, function(value)
        bs.settings.handgun.levels = value
        config.saveFile("config/config.json", bs.settings)
    end)

    nativeSettings.addRangeFloat("/betterScopes/handgun", "Zoom level amount", "How much each level zooms in", 0.5, ui.maxAmount, 0.1, "%.1f", bs.settings.handgun.amount, bs.defaultSettings.handgun.amount, function(value)
        bs.settings.handgun.amount = value
        config.saveFile("config/config.json", bs.settings)
    end)

    -- Shotgun
    nativeSettings.addRangeInt("/betterScopes/shotgun", "Zoom levels", "How many zoom levels there are, 1 means just the default zoom level", 1, ui.maxLevels, 1, bs.settings.shotgun.levels, bs.defaultSettings.shotgun.levels, function(value)
        bs.settings.shotgun.levels = value
        config.saveFile("config/config.json", bs.settings)
    end)

    nativeSettings.addRangeFloat("/betterScopes/shotgun", "Zoom level amount", "How much each level zooms in", 0.5, ui.maxAmount, 0.1, "%.1f", bs.settings.shotgun.amount, bs.defaultSettings.shotgun.amount, function(value)
        bs.settings.shotgun.amount = value
        config.saveFile("config/config.json", bs.settings)
    end)
end

function ui.drawImGui(bs)
    if (ImGui.Begin("Better Scopes", ImGuiWindowFlags.AlwaysAutoResize)) then
        -- Sniper
        ImGui.BeginChild("sniper", 220, 80, true)
        ImGui.Text("Sniper")
        ImGui.Separator()
        ImGui.PushItemWidth(125)

        bs.settings.sniper.levels, changed = ImGui.InputInt("Zoom Levels", bs.settings.sniper.levels, 1, 10)
        bs.settings.sniper.levels = math.max(1, math.min(bs.settings.sniper.levels, ui.maxLevels))
        if changed then config.saveFile("config/config.json", bs.settings) end

        bs.settings.sniper.amount, changed = ImGui.InputFloat("Zoom Amount", bs.settings.sniper.amount, 1, 10, "%.1f")
        bs.settings.sniper.amount = math.max(1, math.min(bs.settings.sniper.amount, ui.maxAmount))
        if changed then config.saveFile("config/config.json", bs.settings) end

        ImGui.PopItemWidth(125)
        ImGui.EndChild()

        -- AR

        ImGui.BeginChild("ar", 220, 80, true)
        ImGui.Text("Assault Rifle")
        ImGui.Separator()
        ImGui.PushItemWidth(125)

        bs.settings.ar.levels, changed = ImGui.InputInt("Zoom Levels", bs.settings.ar.levels, 1, 10)
        bs.settings.ar.levels = math.max(1, math.min(bs.settings.ar.levels, ui.maxLevels))
        if changed then config.saveFile("config/config.json", bs.settings) end

        bs.settings.ar.amount, changed = ImGui.InputFloat("Zoom Amount", bs.settings.ar.amount, 1, 10, "%.1f")
        bs.settings.ar.amount = math.max(1, math.min(bs.settings.ar.amount, ui.maxAmount))
        if changed then config.saveFile("config/config.json", bs.settings) end

        ImGui.PopItemWidth(125)
        ImGui.EndChild()

        -- SMG

        ImGui.BeginChild("smg", 220, 80, true)
        ImGui.Text("SMG")
        ImGui.Separator()
        ImGui.PushItemWidth(125)

        bs.settings.smg.levels, changed = ImGui.InputInt("Zoom Levels", bs.settings.smg.levels, 1, 10)
        bs.settings.smg.levels = math.max(1, math.min(bs.settings.smg.levels, ui.maxLevels))
        if changed then config.saveFile("config/config.json", bs.settings) end

        bs.settings.smg.amount, changed = ImGui.InputFloat("Zoom Amount", bs.settings.smg.amount, 1, 10, "%.1f")
        bs.settings.smg.amount = math.max(1, math.min(bs.settings.smg.amount, ui.maxAmount))
        if changed then config.saveFile("config/config.json", bs.settings) end

        ImGui.PopItemWidth(125)
        ImGui.EndChild()

        -- LMG

        ImGui.BeginChild("lmg", 220, 80, true)
        ImGui.Text("LMG")
        ImGui.Separator()
        ImGui.PushItemWidth(125)

        bs.settings.lmg.levels, changed = ImGui.InputInt("Zoom Levels", bs.settings.lmg.levels, 1, 10)
        bs.settings.lmg.levels = math.max(1, math.min(bs.settings.lmg.levels, ui.maxLevels))
        if changed then config.saveFile("config/config.json", bs.settings) end

        bs.settings.lmg.amount, changed = ImGui.InputFloat("Zoom Amount", bs.settings.lmg.amount, 1, 10, "%.1f")
        bs.settings.lmg.amount = math.max(1, math.min(bs.settings.lmg.amount, ui.maxAmount))
        if changed then config.saveFile("config/config.json", bs.settings) end

        ImGui.PopItemWidth(125)
        ImGui.EndChild()

        -- Pistol

        ImGui.BeginChild("pistol", 220, 80, true)
        ImGui.Text("Pistols and Handguns")
        ImGui.Separator()
        ImGui.PushItemWidth(125)

        bs.settings.handgun.levels, changed = ImGui.InputInt("Zoom Levels", bs.settings.handgun.levels, 1, 10)
        bs.settings.handgun.levels = math.max(1, math.min(bs.settings.handgun.levels, ui.maxLevels))
        if changed then config.saveFile("config/config.json", bs.settings) end

        bs.settings.handgun.amount, changed = ImGui.InputFloat("Zoom Amount", bs.settings.handgun.amount, 1, 10, "%.1f")
        bs.settings.handgun.amount = math.max(1, math.min(bs.settings.handgun.amount, ui.maxAmount))
        if changed then config.saveFile("config/config.json", bs.settings) end

        ImGui.PopItemWidth(125)
        ImGui.EndChild()

        -- Shotgun

        ImGui.BeginChild("shotgun", 220, 80, true)
        ImGui.Text("Shotgun")
        ImGui.Separator()
        ImGui.PushItemWidth(125)

        bs.settings.shotgun.levels, changed = ImGui.InputInt("Zoom Levels", bs.settings.shotgun.levels, 1, 10)
        bs.settings.shotgun.levels = math.max(1, math.min(bs.settings.shotgun.levels, ui.maxLevels))
        if changed then config.saveFile("config/config.json", bs.settings) end

        bs.settings.shotgun.amount, changed = ImGui.InputFloat("Zoom Amount", bs.settings.shotgun.amount, 1, 10, "%.1f")
        bs.settings.shotgun.amount = math.max(1, math.min(bs.settings.shotgun.amount, ui.maxAmount))
        if changed then config.saveFile("config/config.json", bs.settings) end

        ImGui.PopItemWidth(125)
        ImGui.EndChild()

        ImGui.Separator()
        if ImGui.Button("Reset all") then
            bs.settings = bs.defaultSettings
            config.saveFile("config/config.json", bs.settings)
        end

        ImGui.End()
    end
end

return ui