#include "ReShadeUI.fxh"
#include "ReShade.fxh"

uniform float GAIN < __UNIFORM_SLIDER_INT1
    ui_label = "Gain";
	//ui_tooltip = "Amount of depth information that will replace the color information";
	ui_min = 0.0; ui_max = 1.0;
> = 0.25;
uniform uint cyan < __UNIFORM_SLIDER_INT1
	ui_min = 0; ui_max = 10;
	ui_label = "cyan";
> = 0;
uniform uint magenta < __UNIFORM_SLIDER_INT1
	ui_min = 0; ui_max = 10;
	ui_label = "magenta";
> = 1;
uniform uint yellow < __UNIFORM_SLIDER_INT1
	ui_min = 0; ui_max = 10;
	ui_label = "yellow";
> = 0;
uniform float Saturation < __UNIFORM_SLIDER_INT1
	ui_min = 0.0; ui_max = 2.0;
	ui_label = "Saturation";
> = 1.0;
float3 Adjustments(float4 vpos : SV_Position, float2 texcoord : TexCoord) : SV_Target
{
	float3 color = tex2D(ReShade::BackBuffer, texcoord).rgb;
	float gray = dot(color,1)*0.3333;
	float3 chroma = saturate((color-gray)/gray);
	float3 orig = color;

	float dep = tex2D(ReShade::DepthBuffer, texcoord).r;
	float e = tex2Doffset(ReShade::DepthBuffer, texcoord, int2(0, 1)).r;
	float f = tex2Doffset(ReShade::DepthBuffer, texcoord, int2(1, 0)).r;
	float g = tex2Doffset(ReShade::DepthBuffer, texcoord, int2(0, -1)).r;
	float h = tex2Doffset(ReShade::DepthBuffer, texcoord, int2(-1, 0)).r;

	float2 tex = (texcoord-0.5)*2;	
	float oval = 1-sqrt(tex.x*tex.x + tex.y*tex.y);
	float face = (1-sqrt(abs(dep-e) + abs(dep-f))*100);

	float UI = min(gray-0.2,0.2)*5;

	color = lerp(max((lerp(dot(chroma,1),chroma,Saturation)*face+min(gray,0.5)*20)*(1/(gray+1))*saturate(oval)*GAIN,color),color,(1-pow(1/(gray+1),2))*UI);
	color = (color*(1+Saturation) - (float3(cyan,magenta,yellow).rgb+Saturation)*rcp(255.0)*(Saturation*3));
	return lerp(orig,color, min((min(dep,0.001)*1000),1));
}
technique NightVision
{
    pass Adjustments
    {
        VertexShader = PostProcessVS;
        PixelShader = Adjustments;
    }
}