#include "ReShadeUI.fxh"
#include "ReShade.fxh"
uniform float Sharpness < __UNIFORM_SLIDER_INT1
    ui_label = "Sharpening strength";
	ui_min = 0.0; ui_max = 5.0;
	ui_tooltip = "Sharpen the finer details according to the contrast between it neighboring pixels";
> = 2.0;

uniform float Clarity < __UNIFORM_SLIDER_INT1
    ui_label = "Clarity strength";
	ui_tooltip = "Emphasizes borders and crevices";
	ui_min = 0.0; ui_max = 1.0;
> = 0.25;

float3 Adjustments(float4 vpos : SV_Position, float2 texcoord : TexCoord) : SV_Target
{
	float3 color = tex2D(ReShade::BackBuffer, texcoord).rgb;
	float gray = dot(color,1)*0.3333;
	float3 a = tex2Doffset(ReShade::BackBuffer, texcoord, int2(-1, 0)).rgb;
	float3 b = tex2Doffset(ReShade::BackBuffer, texcoord, int2(1, 0)).rgb;
	float3 c = tex2Doffset(ReShade::BackBuffer, texcoord, int2(0, -1)).rgb;
	float3 d = tex2Doffset(ReShade::BackBuffer, texcoord, int2(0, 1)).rgb;

    float3 mnRGB = min(min(min(a, b), min(c, d)), color);
    float3 mxRGB = max(max(max(a, b), max(c, d)), color);

    // Smooth minimum distance to signal limit divided by smooth max.
    float3 ampRGB = saturate(min(mnRGB, 1.0 - mxRGB) * rcp(mxRGB));   
    float3 wRGB = -rcp(rsqrt(ampRGB) * (8.0-3.0 * Clarity ));
    float3 rcpWeightRGB = rcp(4.0 * wRGB + 1.0);
    float3 outColor = ((a+b+c+d) * wRGB + color) * rcpWeightRGB;
    
	return lerp(color, outColor, Sharpness);
}
technique S_sharpening
{
    pass Adjustments
    {
        VertexShader = PostProcessVS;
        PixelShader = Adjustments;
    }
}