
@replaceMethod(EquipmentSystemPlayerData)
public final func EquipItem(itemID: ItemID, opt addToInventory: Bool, opt blockActiveSlotsUpdate: Bool, opt forceEquipWeapon: Bool) -> Void {
  let equipArea: SEquipArea;
  let equipAreaIndex: Int32;
  let equipAreaType: gamedataEquipmentArea;
  let equipAtIndex: Int32;
  let i: Int32;
  if ItemID.IsValid(itemID) && !this.CheckWeaponAgainstGameplayRestrictions(itemID) {
      Log("[EquipmentSystemPlayerData].EquipItem() weapon equipping forbidden; forceEquipWeapon: " + BoolToString(forceEquipWeapon) + "; blockActiveSlotsUpdate: " + BoolToString(blockActiveSlotsUpdate));
      return ;
  }
  if ItemID.IsValid(itemID) && !this.IsEquipped(itemID) {
    equipAreaType = EquipmentSystem.GetEquipAreaType(itemID);
    equipAreaIndex = this.GetEquipAreaIndex(equipAreaType);
    equipArea = this.m_equipment.equipAreas[equipAreaIndex];
    i = 0;
    while i < ArraySize(equipArea.equipSlots) {
      if !ItemID.IsValid(equipArea.equipSlots[i].itemID) {
        this.EquipItem(itemID, i, addToInventory, blockActiveSlotsUpdate, forceEquipWeapon);
        return ;
      };
      i += 1;
    };
    this.EquipItem(itemID, equipArea.activeIndex, addToInventory, blockActiveSlotsUpdate, forceEquipWeapon);
  } else {
    if ItemID.IsValid(itemID) && this.IsEquipped(itemID) {
      equipAtIndex = this.GetSlotIndex(itemID);
      if equipAtIndex >= 0 {
        this.EquipItem(itemID, equipAtIndex, false, blockActiveSlotsUpdate, forceEquipWeapon);
      };
    };
  };
}
