
local zone,tm

local SEC_TO_HOUR = 1 / (60 * 60)
local MIN_TO_HOUR = 1/ 60

local tune = STAR_MODS.RealRealTime.tune
local OPTIONS = STAR_MODS.RealRealTime.OPTIONS


local function makeRealTime()
	local ingame = tm:getTimeOfDay() --in hours
	--print("ingame", ingame)
	
	local HH,MM,SS
	if zone and zone ~= 0 then
		local s = os.date()
		HH,MM,SS = s:match("(%d%d):(%d%d):(%d%d)")
	else
		local s = os.date("%H:%M:%S")
		HH,MM,SS = s:match("^(%d%d):(%d%d):(%d%d)$")
	end
	local current = HH + (MM + 5) * MIN_TO_HOUR + SS * SEC_TO_HOUR --in hours
	--print("current", current)
	--print('diff',current - ingame)
	
	if current >= 24 then
		current = 0
	end
	if current > ingame + 0.002 then
		tm:setTimeOfDay(current)
	elseif current < ingame - 0.002 then
		if current < ingame - 5 and current < 1 then -- 0 < 23, midnight
			current = current + 24 --!! bug if paused
			if current > ingame + 0.01 then
				tm:setTimeOfDay(current)
			end
		else
			tm:setTimeOfDay(current) --set time back
		end
	end
end


local save_old_perday = nil
local function SetRealTime(bool) --print('SetRealTime ',bool) print_r(OPTIONS)
	if bool then
		return tm:setMinutesPerDay(1440) --real time
	elseif save_old_perday then
		--print(save_old_perday)
		return tm:setMinutesPerDay(save_old_perday) 
	end
	print('ERROR: cant set real time!')
end


--Events.OnGameTimeLoaded.Add(
local function init() --print('RealRealInit') print_r(OPTIONS)
	--print('core ',getCore():isChallenge(),getCore():getGameMode())
	--do return end
	tm = getGameTime() --print(getGameTime():getMinutesPerDay())
	save_old_perday = tm:getMinutesPerDay()
	SetRealTime(OPTIONS.set_realtime)
	
	
	local s = os.date("%Y-%m-%d %H:%M:%S %Z") --utc
	local y,m,d,H,M,S,z = s:match("^(%d%d%d%d)-(%d%d)-(%d%d) (%d%d):(%d%d):(%d%d) (.*)$")
	y=tonumber(y); m=tonumber(m); d=tonumber(d); H=tonumber(H); M=tonumber(M); S=tonumber(S)
	if z == 'UTC' then --get local zone
		local s = os.date()
		print('Local date: ',s)
		local Day = s:match(" (%d%d?) ")
		if Day then
			Day = tonumber(Day)
			local HH,MM,SS = s:match("(%d%d):(%d%d):(%d%d)")
			if HH then
				zone = HH - H
				if Day ~= d then
					local diff = math.abs(Day - d)
					if diff == 1 then
						zone = zone + 24 * (Day - d)
					else -- (Day or d) equal to 1
						zone = zone + (Day == 1 and 24 or -24)
					end
				end
			end
		end
	else
		zone = 0
	end

	H = H + (zone or 0)
	if H < 0 then
		H = H + 24
		if d > 1 then
			d = d - 1
		elseif m > 1 then
			m = m - 1
			if m == 2 then
				d = y % 4 == 0 and 29 or 28
			else
				d = (m == 4 or m == 6 or m == 9 or m == 11) and 30 or 31
			end
		else
			year = year - 1
			m = 12
			d = 31
		end
	end
	
	local current = H + (M + 5) * MIN_TO_HOUR + S * SEC_TO_HOUR -- in hours
	
	tm:setDay(d-1)
	tm:setMonth(m-1)
	tm:setYear(y)
	tm:setTimeOfDay(current)
	--print('core ',getCore():isChallenge(),getCore():getGameMode())
	print('ZONE = ',zone)
end

local is_singleplayer = false
local is_server = false --TODO: test in multiplayer


local function update_pure()
	if not tm then
		return
	end
	if getGameSpeed() > 1 then
		return
	end
	if is_singleplayer then
		for num=0,getNumActivePlayers()-1 do --TODO: check if it's useful in multiplayer
			local player = getSpecificPlayer(num)
			if player and player:isAsleep() then
				return
			end
		end
	end
	makeRealTime()
end

local cnt = 0
local function update()
	cnt = cnt + 1
	if cnt < 100 then
		return
	end
	--print('CHECK')
	cnt = 0
	update_pure()
end

-- 0 = fast, 1 = every ingame 1 min, 2 = every ingame 10 min
local current_update_speed = nil
local function setUpdateSpeed(num) --triggers when mod settings are changed
	--print('setUpdateSpeed ',num) print_r(OPTIONS)
	if not (is_singleplayer or is_server) then
		return print('makeRealTime - disabled on client!!!')
	end
	if num == nil or num == current_update_speed then
		return
	end
	if current_update_speed ~= nil then
		if current_update_speed == 0 then
			if is_singleplayer then
				Events.OnPostUIDraw.Remove(update)
			elseif is_server then
				Events.OnTick.Remove(update)
			end
		elseif current_update_speed == 1 then
			Events.EveryOneMinute.Remove(update_pure)
		elseif current_update_speed == 2 then
			Events.EveryTenMinutes.Remove(update_pure)
		end
		current_update_speed = nil
	end
	current_update_speed = num
	if num == 0 then --real time
		if is_server then
			Events.OnTick.Add(update)
		elseif is_singleplayer then
			Events.OnPostUIDraw.Add(update)
		end
	elseif num == 1 then
		Events.EveryOneMinute.Add(update_pure)
	elseif num == 2 then
		Events.EveryTenMinutes.Add(update_pure)
	end
end



Events.OnGameStart.Add(function()
	if isServer() then
		print('makeRealTime: Server')
		is_server = true
		init()
	elseif not isClient() then
		print('makeRealTime: Singleplayer')
		is_singleplayer = true
		init()
	else
		return print('makeRealTime - disabled on client')
		--TODO: client-server issues are unknown. Feature is not tested on dedicated, or even in coop.
	end
	setUpdateSpeed(0)
	--print('is tune = ',tune)
	--print_r(STAR_MODS.RealRealTime,10)
	if tune then 
		local function updateSpeed(opt, val) --print('updateSpeed')
			if OPTIONS.lazy_update_1_min then
				setUpdateSpeed(1)
			elseif OPTIONS.lazy_update_10_min then
				setUpdateSpeed(2)
			else
				setUpdateSpeed(0)
			end
		end
		tune.options_data.lazy_update_1_min.onUpdateIngame = updateSpeed
		tune.options_data.lazy_update_10_min.onUpdateIngame = updateSpeed
		tune.options_data.set_realtime.onUpdateIngame = function(opt,val) --print('onUpdateInGame')
			SetRealTime(val)
		end
		--print_r(tune)
	end
end)











