require('TimedActions/ISTimedActionQueue');
require('TimedActions/ISInventoryTransferAction');
require('TimedActions/ISWalkToTimedAction');
require('luautils');

RPISQuickSort = {};

RPISQuickSort.MENU_ENTRY_QUICK_SORT = "Quick Sort";

RPISQuickSort.convertArrayList = function(arrayList)
    local itemTable = {};

    for i = 1, arrayList:size() do
        itemTable[i] = arrayList:get(i - 1);
    end

    return itemTable;
end

RPISQuickSort.createInventoryMenu = function(playerIndex, context, items)
    local player = getSpecificPlayer(playerIndex);

    -- return if more than one item is selected.. maybe change this
    if #items > 1 then
        return;
    end

    local playerInventory = player:getInventory();

    local item;
    local stack;

    -- Iterate through all clicked items
    for _, entry in ipairs(items) do
        local entry2;

        if type(entry) == "table" then
            entry2 = entry['items'][1];
            --print(">>>IS A TABLE, USING THIS ENTRY:", entry2);
        else
            entry2 = entry
            --print(">>>NOT A TABLE, USING THIS ENTRY:", entry2);
        end

        local isInventoryItem = instanceof(entry2, "InventoryItem");
        local isInPlayerInventory = false;

        if playerInventory:contains(entry2) then
            isInPlayerInventory = true;
        else
            local inventoryContainers = RPISQuickSort.convertArrayList(playerInventory:getItemsFromCategory('Container'));

            for __, v in ipairs(inventoryContainers) do
                local inventoryContainer = v;

                if inventoryContainer:getInventory():contains(entry2) then
                    isInPlayerInventory = true;
                    break;
                end
            end
        end

        local isFavorite = entry2:isFavorite();
        local isEquipped = player:isEquipped(entry2);

        if isInventoryItem and isInPlayerInventory and not isFavorite and not isEquipped then
            item = entry2;
        end
    end

    if item then
        RPISQuickSort.createInventoryObjectMenuEntry(player, playerIndex, context, item);
        return;
    end
end

RPISQuickSort.onQuickStackThisItem = function(worlditems, player, playerInventory, quickStackItem)
    --print('>>> Start quick stack THIS item with:', quickStackItem);

    local playerPosition = player:getCurrentSquare();
    local playerx = playerPosition:getX();
    local playery = playerPosition:getY();
    local playerz = playerPosition:getZ();

    local worldCell = getWorld():getCell();

    -- search for containers within 10 squares of the player on the same z level
    local xrange = 10;
    local yrange = 10;
    local containerObjects = {};

    for x=(playerx-xrange), (playerx+xrange) do
        for y=(playery-yrange), (playery+yrange) do
            local containerSearchSquare = worldCell:getGridSquare(x,y,playerz);
            if(containerSearchSquare ~= nil) then
                --print('>>> Container search square not nil, checking...');
                local items = containerSearchSquare:getObjects();

                for k,v in ipairs(RPISQuickSort.convertArrayList(items)) do
                    local possibleContainerObject = v;
                    -- do any filtering of containers desired here, e.g. no zombies
                    if possibleContainerObject:getContainer() ~= nil and not possibleContainerObject:isZombie() and possibleContainerObject:getItemContainer():isExplored() then
                        --print('>>> Adding container to containerObjects:',possibleContainerObject,possibleContainerObject:getItemContainer():getType());
                        containerObjects[#containerObjects+1] = possibleContainerObject;
                    --else
                    --    if possibleContainerObject:getContainer() ~= nil then
                    --        print('>>> Ignoring object (is not container, or is zombie, or is not explored: ', possibleContainerObject:getItemContainer():getType(), possibleContainerObject:getContainer(), possibleContainerObject:isZombie(), possibleContainerObject:getItemContainer():isExplored());
                    --    end
                    end
                end
            end
        end
    end

    local quickStackItemType = quickStackItem:getType();
    local quickStackItemWeight = quickStackItem:getWeight();
    local quickStackInventoryItems = RPISQuickSort.convertArrayList(quickStackItem:getContainer():getItemsFromType(quickStackItemType));

    --print('>>> quickStackItemType:', quickStackItemType);
    --print('>>> quickStackInventoryItems:', quickStackInventoryItems);
    --print('>>> quickStackInventoryItemsSize:', #quickStackInventoryItems);

    if #containerObjects == 0 then
        player:Say("Hmm, I don't see any containers around.");
        return;
    else
        --print('Number of Containers found:',#containerObjects);
        --print('Start quick stack this item with:',quickStackItemType);
        --print('---')
        --print('')
        --print('')

        local fullTransferWeight = 0;
        local nonFavoriteQuickStackItemsInInventory = {};

        for _,v in ipairs(quickStackInventoryItems) do
            if not v:isFavorite() and not player:isEquipped(v) then
                fullTransferWeight = fullTransferWeight + v:getWeight();
                nonFavoriteQuickStackItemsInInventory[#nonFavoriteQuickStackItemsInInventory+1] = v;
            end
        end

        --print('>>> Number of non favorite quick stack items in inventory: ', #nonFavoriteQuickStackItemsInInventory);
        
        local transferData = {remainingToTransfer=#nonFavoriteQuickStackItemsInInventory, transfers={}};

        for _,v in ipairs(containerObjects) do
            local containerObject = v;
            local itemContainer = containerObject:getItemContainer();
            local containerObjectSquare = containerObject:getSquare();
            local quickStackItemsInContainer = RPISQuickSort.convertArrayList(itemContainer:getItemsFromType(quickStackItemType));

            if #quickStackItemsInContainer > 0 then
                -- the item has been found in the container, determine if we can move to it and how many can fit
                local adjacentFreeTile = AdjacentFreeTileFinder.Find(containerObjectSquare, player);

                if adjacentFreeTile ~= nil then
                    local containerType = itemContainer:getType();
                    local capacity = itemContainer:getCapacity();
                    local contentsWeight = itemContainer:getContentsWeight();

                    local availableSpace = capacity - contentsWeight;
                    local numberOfItemsThatCanBeTransferred = math.floor(availableSpace / quickStackItemWeight);

                    -- if we have more room than we need, set numberOfItemsThatCanBeTransferred = to the number of remaining items
                    if numberOfItemsThatCanBeTransferred > #nonFavoriteQuickStackItemsInInventory then
                        numberOfItemsThatCanBeTransferred = transferData['remainingToTransfer'];
                    end

                    if numberOfItemsThatCanBeTransferred > 0 then
                        local distanceToContainer = math.sqrt(((player:getCurrentSquare():getX() - containerObject:getSquare():getX())^2) + ((player:getCurrentSquare():getY() - containerObject:getSquare():getY())^2))

                        local transfer = {containerObject=containerObject, countToTransfer=numberOfItemsThatCanBeTransferred, distanceToContainer=distanceToContainer};

                        transferData['transfers'][#transferData['transfers']+1] = transfer;
                        transferData['remainingToTransfer'] = transferData['remainingToTransfer'] - numberOfItemsThatCanBeTransferred;
                    end
                end
            end

            if transferData['remainingToTransfer'] <= 0 then
                --print('>>> No more items to setup transfers for');
                break;
            end
        end

        if #transferData['transfers'] == 0 then
            player:Say("I don't see this around anywhere.")
            return;
        end

        local countOfTransferActionsQueued = 0;
        local indexMod = 1;

        local sortedTransfers = table.sort(transferData['transfers'], function(a,b) return a['distanceToContainer'] < b['distanceToContainer'] end);

        transferData['transfers'] = sortedTransfers;

        for _,v in ipairs(transferData['transfers']) do
            local transfer = v;
            local containerObjectSquare = transfer['containerObject']:getSquare();

            --print('>>> Transfer Container: ', transfer['containerObject']:getItemContainer():getType());
            --print('>>> Count to Transfer: ', transfer['countToTransfer']);
            --print('>>> Container object square: ', containerObjectSquare, transfer['containerObject']:getSquare():getX(),transfer['containerObject']:getSquare():getY());
            local adjacentFreeTile = nil;

            if AdjacentFreeTileFinder.isTileOrAdjacent(containerObjectSquare, player:getCurrentSquare()) then
                adjacentFreeTile = player:getCurrentSquare();
            else
                adjacentFreeTile = AdjacentFreeTileFinder.Find(containerObjectSquare, player);
            end

            if adjacentFreeTile ~= nil then
                ISTimedActionQueue.add(ISWalkToTimedAction:new(player, getWorld():getCell():getGridSquare((adjacentFreeTile:getX()), adjacentFreeTile:getY(), adjacentFreeTile:getZ())));

                for itemIndex = indexMod, (transfer['countToTransfer'] + countOfTransferActionsQueued) do
                    --print('>>> Queuing transfer for item with index:', itemIndex);
                    --print('>>> Item: ', nonFavoriteQuickStackItemsInInventory[itemIndex]:getType());
                    --print('>>> Container: ', transfer['containerObject']:getItemContainer():getType());

                    local itemToTransfer = nonFavoriteQuickStackItemsInInventory[itemIndex];

                    if luautils.haveToBeTransfered(player, itemToTransfer) then
                        ISTimedActionQueue.add(RPQuickStackAction:new(player, itemToTransfer, itemToTransfer:getContainer(), player:getInventory()));
                    end

                    ISTimedActionQueue.add(RPQuickStackAction:new(player, itemToTransfer, player:getInventory(), transfer['containerObject']:getItemContainer()));

                    countOfTransferActionsQueued = countOfTransferActionsQueued + 1;
                end

                --print('>>> countOfTransferActionsQueued:', countOfTransferActionsQueued);

                indexMod = indexMod + transfer['countToTransfer'];
            end
        end
    end
    --print('<<<<<<<<< End of onQuickStackThisItem');
end

RPISQuickSort.createInventoryObjectMenuEntry = function(player, playerIndex, context, quickStackItem)
    local itemsOnPlayer = RPISQuickSort.convertArrayList(player:getInventory():getItems());
    local worlditems = nil;

    context:addOption(RPISQuickSort.MENU_ENTRY_QUICK_SORT, worlditems, RPISQuickSort.onQuickStackThisItem, player, itemsOnPlayer, quickStackItem);
end

RPQuickStackAction = ISInventoryTransferAction:derive("RPQuickStackAction");

function RPQuickStackAction:update()
    if self.character ~= nil and self.destContainer ~= nil and instanceof(self.destContainer, "ItemContainer") then
        if self.destContainer:getParent() ~= nil and self.destContainer:getParent():getX() ~= nil then
            self.character:faceLocation(self.destContainer:getParent():getX(), self.destContainer:getParent():getY());
        end
    end

    ISInventoryTransferAction.update(self);
end

Events.OnPreFillInventoryObjectContextMenu.Add(RPISQuickSort.createInventoryMenu);