name = "More equip slots"
description = "Allows to add extra equipment slots for armor, clothing, and amulet. See <https://gitlab.com/AndreyMZ/dst-more-equip-slots> for details."
author = "AndreyMZ"
version = "1.1.2"

api_version = 10

-- This mod is both server and client.
all_clients_require_mod = true
client_only_mod = false

-- This mod is functional with Don't Starve Together only.
dont_starve_compatible = false
reign_of_giants_compatible = false
dst_compatible = true

-- These tags allow the server running this mod to be found with filters from the server listing screen.
server_filter_tags = {"equip equipment slot body backpack armor clothing amulet"}

icon_atlas = "images/modicon.xml"
icon = "modicon.tex"

-- Configuration options.
local slot_options_not_implemented = {
    {data = false       , description = "Original body slot"},
}
local slot_options = {
    {data = false       , description = "Original body slot"},
    {data = "extrabody1", description = "Extra body slot #1"},
    {data = "extrabody2", description = "Extra body slot #2"},
    {data = "extrabody3", description = "Extra body slot #3"},
}
configuration_options = {
    {
        name = "slot_heavy",
        label = "Heavy",
        hover = "In which slot do you want to equip heavy items?",
        default = false,
        options = slot_options_not_implemented,
    },
    {
        name = "slot_backpack",
        label = "Backpack",
        hover = "In which slot do you want to equip backpacks?",
        default = false,
        options = slot_options_not_implemented,
    },
    {
        name = "slot_band",
        label = "One-man band",
        hover = "In which slot do you want to equip a One-man Band?",
        default = false,
        options = slot_options_not_implemented,
    },
    {
        name = "slot_shell",
        label = "Snurtle Shell Armor",
        hover = "In which slot do you want to equip a Snurtle Shell Armor?",
        default = false,
        options = slot_options_not_implemented,
    },
    {
        name = "slot_armor",
        label = "Armor",
        hover = "In which slot do you want to equip armors?",
        default = false,
        options = slot_options,
    },
    {
        name = "slot_clothing",
        label = "Clothing",
        hover = "In which slot do you want to equip clothing?",
        default = "extrabody2",
        options = slot_options,
    },
    {
        name = "slot_amulet",
        label = "Amulet",
        hover = "In which slot do you want to equip amulets?",
        default = "extrabody3",
        options = slot_options,
    },
    {
        name = "config_render",
        label = "Render body equipment by this mod",
        hover = "If no, then only the last equipped/unequipped body item will be rendered. "
             .. "Switch off if there are problems (which may be with other mods).",
        default = true,
        options = {
            {data = false, description = "No"},
            {data = true,  description = "Yes"},
        },
    },
}
