local assets=
{
	Asset("ANIM", "anim/mushroombomb.zip"),
    Asset("ANIM", "anim/mushroombomb_base.zip"),
}

local prefabs=
{
	
}

local function ShakeScreen(inst)
    ShakeAllCameras(CAMERASHAKE.VERTICAL, .15 + (inst.stacksize/20), .02, .5, inst, 30 + inst.stacksize)
end

local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddSoundEmitter()
	inst.entity:AddAnimState()
	inst.entity:AddNetwork()
	
	inst:AddTag("FX")
	inst:AddTag("NOCLICK")
	
	inst.AnimState:SetBank("mushroombomb_base")
    inst.AnimState:SetBuild("mushroombomb_base")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:SetOrientation(ANIM_ORIENTATION.OnGround)
    inst.AnimState:SetLayer(LAYER_BACKGROUND)
    inst.AnimState:SetSortOrder(3)
    inst.AnimState:SetFinalOffset(-1)
    inst.AnimState:SetBloomEffectHandle("shaders/anim.ksh")
	
	inst.SoundEmitter:PlaySound("dontstarve/creatures/together/toad_stool/spore_explode")
	
	inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end
	
	inst.persists = false
	
	inst.stacksize = 0
	
	inst:DoTaskInTime(0, function(inst)
		local cloud = SpawnPrefab("rot_cloud")
		cloud.Transform:SetPosition(inst:GetPosition():Get())
		
		local x, y, z = inst.Transform:GetWorldPosition()
		local ents = TheSim:FindEntities(x, y, z, 3 + inst.stacksize, nil, {"notarget", "shadow", "INLIMBO"})
		local scale = 1 + (inst.stacksize/5)
		inst.AnimState:SetScale(scale, scale)
		cloud.AnimState:SetScale(scale, scale)
		ShakeScreen(inst, inst.stacksize)
		if #ents > 0 then
			local damage = 100 + (10 * inst.stacksize)
			for i, v in ipairs(ents) do
				if v:IsValid() and not v:IsInLimbo() and
					v.components.combat ~= nil and not (v.components.health ~= nil and v.components.health:IsDead()) then
					v.components.combat:GetAttacked(inst.owner or inst, damage)
				end
				if v.components.workable then
					v.components.workable:Destroy(inst)
				end
			end
		end
	end)
	
	inst:ListenForEvent("animover", inst.Remove)

	return inst
end

--=====Cloud========

local function cloudfn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
	inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    inst:AddTag("FX")
	inst:AddTag("NOCLICK")
	
	inst.AnimState:SetBank("poopcloud")
    inst.AnimState:SetBuild("poop_cloud")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:SetFinalOffset(-1)

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst.persists = false
	inst.entity:SetCanSleep(false)
    inst:DoTaskInTime(1, inst.Remove)

    return inst
end
-------------------------------------

return Prefab("rot_explosion", fn, assets, prefabs),
Prefab("rot_cloud", cloudfn, assets, prefabs)
