local G					= GLOBAL
local T					= G.TUNING
local P					= AddPrefabPostInit

PrefabFiles = {
	"venomdebuff",
	"firevenomdebuff",
}

Assets = {
	Asset("ANIM", "anim/spider_tropical_build.zip"),
	Asset("ANIM", "anim/spider_warrior_lavaarena_build.zip"),
	Asset("ANIM", "anim/spider_scorch.zip"),
	Asset("ANIM", "anim/spider_winter.zip"),
	Asset("SOUND", "sound/hound.fsb"),
}



function G.AddLoot(inst, loot, amount, chance) -- Add several identical loot with a line of code!
	if not G.TheWorld.ismastersim then return end
	for i = 1, amount do
		inst.components.lootdropper:AddChanceLoot(loot, chance)
	end
end

if G.TheNet:GetIsServer() then
	
	local function SetBuild(inst, build, name)
		inst.AnimState:SetBuild(build) -- Spawn looking like this
		inst:DoTaskInTime(0, function() inst.AnimState:SetBuild(build) end) -- Failsafe
	end
	local function SetName(inst, name)
		if inst.components.named == nil then inst:AddComponent("named") end
		inst:DoTaskInTime(0, function() inst.components.named:SetName(name) end)
	end

	--[[----------------------------
		  Spider Special Effects
	----------------------------]]--
	--==[ Ice Explosion for Snow Spiders ]==--
	local function DoIceExplosion(inst)
		local NO_TAGS = { "FX", "NOCLICK", "DECOR", "INLIMBO", "snow_spider_immunity" }
		local FREEZABLE_TAGS = { "freezable" }

	    if inst.components.freezable == nil then
	        MakeMediumFreezableCharacter(inst, "body")
	    end
	    inst.components.freezable:SpawnShatterFX()
	    inst:RemoveComponent("freezable")
	    local x, y, z = inst.Transform:GetWorldPosition()
	    local ents = TheSim:FindEntities(x, y, z, 2, FREEZABLE_TAGS, NO_TAGS)
	    for i, v in pairs(ents) do
	        if v.components.freezable ~= nil and not v:HasTag("snow_spider_immunity") then
	            v.components.freezable:AddColdness(2)
	        end
    	end
    	inst.SoundEmitter:PlaySound("dontstarve/creatures/hound/icehound_explo")
	end
	--==[ Fire Explosion for Scorch Spiders ]==--
	local function PlayFireExplosionSound(inst)
    	inst.SoundEmitter:PlaySound("dontstarve/creatures/hound/firehound_explo")
	end

	--[[----------------------------
		  Spider Other Effects
	----------------------------]]--
	--==[ Snow Spider ]==--
	local function SnowSpider_Effect(inst)
		inst.components.freezable:SetResistance(8)
		inst.components.freezable:SetDefaultWearOffTime(1.5)
		inst.components.lootdropper:AddChanceLoot("blue_gem", .002)
		inst:AddTag("snow_spider_immunity")

		inst:ListenForEvent("death", DoIceExplosion)
	end
	--==[ Scorch Spider ]==--
	local function ScorchSpider_Effect(inst)
		inst.components.freezable:SetResistance(8)
		inst.components.freezable:SetDefaultWearOffTime(1.5)
		inst.components.lootdropper:AddChanceLoot("red_gem", .006)
		inst.components.lootdropper:AddChanceLoot("houndfire", 1)
		inst.components.lootdropper:AddChanceLoot("houndfire", .5)
		inst.components.lootdropper:AddChanceLoot("houndfire", .3)

		inst:ListenForEvent("onattackother", function(inst, data)
    		if (data.target ~= nil and data.target.components.debuffable ~= nil and data.target.components.temperature ~= nil) then
      			data.target.components.debuffable:AddDebuff("firevenomdebuff", "firevenomdebuff")
    		end
  		end)
  		inst:ListenForEvent("death", PlayFireExplosionSound)
	end
	--==[ Lava (Forge) Spider ]==--
	local function LavaSpider_Effect(inst)
		inst.components.freezable:SetResistance(7)
		inst.components.freezable:SetDefaultWearOffTime(2)

		inst:ListenForEvent("onattackother", function(inst, data)
    		if (data.target ~= nil and data.target.components.debuffable ~= nil and data.target.components.temperature ~= nil) then
      			data.target.components.debuffable:AddDebuff("firevenomdebuff", "firevenomdebuff")
    		end
  		end)
	end
	--==[ Venomous (Tropical) Spider ]==--
	local function TropicalSpider_Effect(inst)
		inst.components.lootdropper:AddChanceLoot("spidergland", 1)
		inst.components.lootdropper:AddChanceLoot("spidergland", .25)

		inst:ListenForEvent("onattackother", function(inst, data)
    		if (data.target ~= nil and data.target.components.debuffable ~= nil and data.target.components.temperature ~= nil) then
      			data.target.components.debuffable:AddDebuff("venomdebuff", "venomdebuff")
    		end
  		end)
	end
	--[[----------------------------
				Spiders
	----------------------------]]--
	--==[ Spider ]==--
	P("spider", function(inst)
		inst.components.locomotor.walkspeed = T.SPIDER_WALK_SPEED
		inst.components.locomotor.runspeed = T.SPIDER_RUN_SPEED
		
		if G.TheWorld.state.iswinter and (math.random(1, 100) <= GetModConfigData("Seasonal_Spiders_Rate")) then
			SetBuild(inst, "spider_winter")
			SetName(inst, "Snow Spider")
			if GetModConfigData("Spider_Abilities") then
				inst:DoTaskInTime(0, SnowSpider_Effect)
			end
		elseif G.TheWorld.state.issummer and (math.random(1, 100) <= GetModConfigData("Seasonal_Spiders_Rate")) then
			SetBuild(inst, "spider_warrior_lavaarena_build")
			SetName(inst, "Hot Spider")
			if GetModConfigData("Spider_Abilities") then
				inst:DoTaskInTime(0, LavaSpider_Effect)
			end
		end
	end)
	--==[ Spider Warrior ]==--
	P("spider_warrior", function(inst)
		inst.components.health:SetMaxHealth(T.SPIDER_WARRIOR_HEALTH)
		inst.components.locomotor.walkspeed = T.SPIDER_WARRIOR_WALK_SPEED
		inst.components.locomotor.runspeed = T.SPIDER_WARRIOR_RUN_SPEED
		if G.TheWorld.state.issummer and (math.random(1, 100) <= GetModConfigData("Seasonal_Spiders_Rate")*1.3) then
			SetBuild(inst, "spider_scorch")
			SetName(inst, "Scorch Spider")
			if GetModConfigData("Spider_Abilities") then
				inst:DoTaskInTime(0, ScorchSpider_Effect)
			end
		elseif G.TheWorld.state.isspring and (math.random(1, 100) <= GetModConfigData("Seasonal_Spiders_Rate")*1.3) then
			--SetBank("spider")
    		SetBuild(inst, "spider_tropical_build")
			SetName(inst, "Venomous Spider")
			if GetModConfigData("Spider_Abilities") then
				inst:DoTaskInTime(0, TropicalSpider_Effect)
			end
		end
	end)
end