local lowQualityTuningModifier = 70
local lowQualityTuningDuration = 45

--[[local function OnTick(inst, target)
    if target.components.health ~= nil and
        not target.components.health:IsDead() and
        not target:HasTag("playerghost") then
        target.components.health:DoDelta(lowQualityTuningDamage, nil, "venomdebuff")
    else
        inst.components.debuff:Stop()
    end
end]]--

local function OnAttached(inst, target)
    inst.entity:SetParent(target.entity)
    inst.Transform:SetPosition(0, 0, 0) --in case of loading

    if target.components.temperature ~= nil then
        target.components.temperature:SetModifier("firenettle_toxin", lowQualityTuningModifier)
    end
    inst:ListenForEvent("death", function()
        inst.components.debuff:Stop()
    end, target)
end

local function OnDetached(inst, target)
    if target ~= nil and target:IsValid() and target.components.temperature ~= nil then
        target.components.temperature:RemoveModifier("firenettle_toxin")
    end
    inst:Remove()
end

local function expire(inst)
    if inst.components.debuff ~= nil then
        inst.components.debuff:Stop()
    end
end

local function OnExtended(inst, target)
    if inst.task ~= nil then
        inst.task:Cancel()
    end
    inst.task = inst:DoTaskInTime(lowQualityTuningDuration, expire)
end

local function fn()
    local inst = CreateEntity()

    if not TheWorld.ismastersim then
        --Not meant for client!
        inst:DoTaskInTime(0, inst.Remove)

        return inst
    end

    inst.entity:AddTransform()

    --[[Non-networked entity]]
    --inst.entity:SetCanSleep(false)
    inst.entity:Hide()
    --inst.persists = false

    inst:AddTag("CLASSIFIED")

    inst:AddComponent("debuff")
    inst.components.debuff:SetAttachedFn(OnAttached)
    inst.components.debuff:SetDetachedFn(OnDetached)
    inst.components.debuff:SetExtendedFn(OnExtended)
    inst.components.debuff.keepondespawn = true

    OnExtended(inst)
    return inst
end

return Prefab("firevenomdebuff", fn)