local function PushItem(thing_to_launch, vx, vz)
	local x, y, z = thing_to_launch.Transform:GetWorldPosition()
    if thing_to_launch ~= nil and thing_to_launch.Physics ~= nil and thing_to_launch.Physics:IsActive() and thing_to_launch:GetCurrentPlatform() == nil and (not thing_to_launch:HasTag("locomotor")) and y <= .2 then
		thing_to_launch.Transform:SetRotation(0) --Make sure rotation of inventory item is 0... sometimes it can be other rotations for some reason
        thing_to_launch.Physics:SetVel(vx*4, 0, vz*4)
    end
end

local function IsOceanMob(inst)
	return (inst:HasTag("swimming"))
		or (inst.components.locomotor.pathcaps ~= nil and inst.components.locomotor.pathcaps.allowocean)
end

local function vector(p1, p2)
	local vector2d = {
		x = (p2.x - p1.x),
		y = (p2.y - p1.y)
	}
    return vector2d
end

local function dot(u, v)
    return u.x * v.x + u.y * v.y
end

local function pointInRectangle(m, r)
    local AB = vector(r.A, r.B)
    local AM = vector(r.A, m)
    local BC = vector(r.B, r.C)
    local BM = vector(r.B, m)
    local dotABAM = dot(AB, AM)
    local dotABAB = dot(AB, AB)
    local dotBCBM = dot(BC, BM)
    local dotBCBC = dot(BC, BC)
    return 0 <= dotABAM and dotABAM <= dotABAB and 0 <= dotBCBM and dotBCBM <= dotBCBC
end

local function Degs(rads)
	return rads*(180/math.pi)
end

local function Rads(degs)
	return degs*(math.pi/180)
end

local function OceanCurrentSpeedTimer(inst)
	local x, y, z = inst.Transform:GetWorldPosition()
	if RoadManager:IsOnRoad(x, 0, z) then
		inst.oceancurrent_speedtimer = nil
		inst.oceancurrent_speedtimer = inst:DoTaskInTime(20 * FRAMES, OceanCurrentSpeedTimer)
	else
		inst.components.locomotor:RemoveExternalSpeedMultiplier(inst, "current_speedup")
		inst.components.locomotor:RemoveExternalSpeedMultiplier(inst, "current_slowdown")
	end
end

local NO_PUSH_TAGS = {"INLIMBO", "outofreach", "smallcreature"}
local function CheckForItems(inst)
	if inst.currentgroup == nil then
		return --We're not in a group of currents
	end

    if inst.key == nil then
		for k, v in pairs(inst.currentgroup) do
			if v == inst then
				inst.key = k
			end
		end
	end

	if #inst.currentgroup == inst.key then
		return --We're the last tracker in the current, return!
	end
	
	local nextcurrent = inst.currentgroup[inst.key + 1]

    local x, y, z = inst.Transform:GetWorldPosition()
	local x2, y2, z2 = nextcurrent.Transform:GetWorldPosition()
	
	local difference_x = (x + x2) / 2
	local difference_z = (z + z2) / 2
	
	local angle = math.atan((z2 - z)/(x2 - x))
	local pointangle = Rads(Degs(angle) + 90)
	local xoff = math.cos(pointangle)
	local yoff = math.sin(pointangle)
	
	local halfwidth = TUNING.OCEAN_CURRENTS.CURRENT_SIZE
	local r = {
		A = {x = x + xoff * halfwidth, y = z + yoff * halfwidth},
		B = {x = x + xoff * -halfwidth, y = z + yoff * -halfwidth},
		C = {x = x2 + xoff * halfwidth, y = z2 + yoff * halfwidth},
		D = {x = x2 + xoff * -halfwidth, y = z2 + yoff * -halfwidth}
	}
	
	local vx, vz = VecUtil_Normalize(x - x2, z - z2)
	vx = vx * TUNING.OCEAN_CURRENTS.CURRENT_STRENGTH
	vz = vz * TUNING.OCEAN_CURRENTS.CURRENT_STRENGTH

	local PICKUP_TAGS
	
	if inst:IsAsleep() then
		PICKUP_TAGS = {"boat", "burnable_locator"}
	else
		PICKUP_TAGS = {"_inventoryitem", "kelp", "boat", "burnable_locator", "locomotor", "fishinghook"}
	end

    local nearby_inventory_entities = TheSim:FindEntities(
        difference_x, 0, difference_z,
        (math.sqrt(inst:GetDistanceSqToInst(nextcurrent)))/2,
        nil,
        NO_PUSH_TAGS,
        PICKUP_TAGS
    )

    if #nearby_inventory_entities > 0 then
        for i, ent in ipairs(nearby_inventory_entities) do
			local ent_x, ent_y, ent_z = ent.Transform:GetWorldPosition()
			local m = {x = ent_x, y = ent_z}
			if pointInRectangle(m, r) then
				local forcex, forcez = VecUtil_Normalize(x - ent_x, z - ent_z)
				forcex = forcex * TUNING.OCEAN_CURRENTS.CURRENT_STRENGTH
				forcez = forcez * TUNING.OCEAN_CURRENTS.CURRENT_STRENGTH
				if ent:HasTag("burnable_locator") and ent.boat ~= nil and ent.boat.components.boatphysics then
					ent.boat.components.boatphysics:ApplyForce(forcex, forcez, 0.080)
				elseif ent.components.boatphysics ~= nil then
					ent.components.boatphysics:ApplyForce(vx, vz, 0.2)
				elseif ent.components.locomotor ~= nil and IsOceanMob(ent) then
					local rotation = ent.Transform:GetRotation()
					local angle_to_current = ent:GetAngleToPoint(x, y, z)
					if rotation >= (angle_to_current - 90) and rotation <= (angle_to_current + 90) then
						ent.components.locomotor:SetExternalSpeedMultiplier(ent, "current_speedup", ent:HasTag("oceanfish") and 2 or 1.33) --make ocean fish go CRAZY fast!
						ent.components.locomotor:RemoveExternalSpeedMultiplier(ent, "current_slowdown")
					else
						ent.components.locomotor:SetExternalSpeedMultiplier(ent, "current_slowdown", 0.67)
						ent.components.locomotor:RemoveExternalSpeedMultiplier(ent, "current_speedup")
					end
					if ent.oceancurrent_speedtimer ~= nil then
						ent.oceancurrent_speedtimer:Cancel()
						ent.oceancurrent_speedtimer = nil
					end
					ent.oceancurrent_speedtimer = ent:DoTaskInTime(20 * FRAMES, OceanCurrentSpeedTimer)
				else
					PushItem(ent, vx, vz)
				end
			end
        end
    end
end

local function OnEntitySleep(inst)
	if inst._pushcurrenttask ~= nil then
		inst._pushcurrenttask:Cancel()
		inst._pushcurrenttask = nil
	end
end

local function OnEntityWake(inst)
	if not inst.inlimbo and inst._pushcurrenttask == nil then
		inst._pushcurrenttask = inst:DoPeriodicTask(10*FRAMES, CheckForItems, 0)
	end
end

local function fn()
    local inst = CreateEntity()
    inst.entity:AddTransform()
	
	--[[Non-networked entity]]

	inst:AddTag("ignorewalkableplatforms")
	inst:AddTag("NOBLOCK")
	inst:AddTag("oceancurrent")
	
	inst._pushcurrenttask = inst:DoPeriodicTask(10*FRAMES, CheckForItems, 0)

	--inst.OnEntitySleep = OnEntitySleep
    --inst.OnEntityWake = OnEntityWake

    return inst
end

return Prefab("oceancurrent_tracker", fn)