﻿using HarmonyLib;
using RimWorld;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using UnityEngine;
using Verse;
using Verse.AI;

namespace Nanosuit
{
    [DefOf]
    public static class NS_DefOf
    {
        public static HediffDef NS_CloakMode;
        public static KeyBindingDef NS_JumpMode;
        public static KeyBindingDef NS_SpeedMode;
        public static KeyBindingDef NS_StrengthMode;
        public static KeyBindingDef NS_CloakModeKey;
        public static KeyBindingDef NS_ArmorMode;
        public static KeyBindingDef NS_HackShields;
        public static KeyBindingDef NS_SymbiosysMode;
        public static ThingDef NS_Apparel_Nanosuit;
        public static ThingDef NS_Apparel_NanosuitHelmet;
    }
    public static class Utils
    {
        public static IEnumerable<Apparel_Nanosuit> GetNanosuits(this Pawn pawn)
        {
            var apparels = pawn.apparel?.WornApparel?.OfType<Apparel_Nanosuit>();
            if (apparels != null)
            {
                foreach (var apparel in apparels)
                {
                    yield return apparel;
                }
            }
        }
        private static HashSet<JobDef> combatJobs = new HashSet<JobDef>
                                                    {
                                                        JobDefOf.AttackMelee,
                                                        JobDefOf.AttackStatic,
                                                        JobDefOf.FleeAndCower,
                                                        JobDefOf.ManTurret,
                                                        JobDefOf.Wait_Combat,
                                                        JobDefOf.Flee
                                                    };

        public static bool InCombat(this Pawn pawn)
        {
            if (combatJobs.Contains(pawn.CurJobDef))
            {
                return true;
            }
            else if (pawn.mindState?.duty?.def.alwaysShowWeapon ?? false)
            {
                return true;
            }
            else if (pawn.CurJobDef?.alwaysShowWeapon ?? false)
            {
                return true;
            }

            return false;
        }
        public static bool ShouldBeDowned(this Pawn pawn)
        {
            if (!pawn.health.InPainShock && pawn.health.capacities.CanBeAwake)
            {
                return !pawn.health.capacities.CapableOf(PawnCapacityDefOf.Moving);
            }
            return true;
        }
    }
}
