﻿using HarmonyLib;
using RimWorld;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using UnityEngine;
using Verse;
using Verse.AI;

namespace Nanosuit
{
	[StaticConstructorOnStartup]
	public static class ModCompatibility
	{
		public static Type ShieldMechBubbleType;
		public static Type ArchotechShieldBelt;
		public static Type RangedShieldBelt;
		static ModCompatibility()
		{
			if (GenCollection.Any<ModContentPack>(LoadedModManager.RunningModsListForReading, (ModContentPack x) => x.Name == "Save Our Ship 2"))
			{
				try
				{
					var type = AccessTools.TypeByName("ShipInteriorMod2");
					HarmonyContainer.harmony.Patch(AccessTools.Method(type, "HasSpaceSuitSlow", null, null), null, 
						new HarmonyMethod(typeof(ModCompatibility), "HasSpaceSuitSlow_Postfix", null), null, null);
					HarmonyContainer.harmony.Patch(AccessTools.Method(type, "hasSpaceSuit", null, null), null, 
						new HarmonyMethod(typeof(ModCompatibility), "hasSpaceSuit_Postfix", null), null, null);
				}
				catch (Exception ex)
				{

				}
			}
			ShieldMechBubbleType = AccessTools.TypeByName("ShieldMechBubble");
			ArchotechShieldBelt = AccessTools.TypeByName("VFEI.ArchotechShieldBelt");
			RangedShieldBelt = AccessTools.TypeByName("RangedShieldBelt");
		}

		public static void hasSpaceSuit_Postfix(Pawn pawn, ref bool __result)
		{
			if (!__result)
			{
				__result = HasSpaceProtection(pawn);
			}
		}
		public static void HasSpaceSuitSlow_Postfix(Pawn pawn, ref bool __result)
		{
			if (!__result)
            {
				__result = HasSpaceProtection(pawn);
			}
		}

		private static bool HasSpaceProtection(Pawn pawn)
        {
			foreach (var apparel in pawn.GetNanosuits())
			{
				if (apparel.def.rebreather)
				{
					return true;
				}
			}
			return false;
		}
	}
}