﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Reflection;
using System.Runtime.CompilerServices;
using HarmonyLib;
using RimWorld;
using UnityEngine;
using Verse;
using Verse.AI;

namespace Nanosuit
{
    class NanosuitSettings : ModSettings
    {
        public bool nanosuitModesAtTheSameTime;
        public bool useSkipForJumping;
        public override void ExposeData()
        {
            base.ExposeData();
            Scribe_Values.Look(ref nanosuitModesAtTheSameTime, "nanosuitModesAtTheSameTime");
            Scribe_Values.Look(ref useSkipForJumping, "useSkipForJumping");
        }

        public void DoSettingsWindowContents(Rect inRect)
        {
            Listing_Standard listingStandard = new Listing_Standard();
            listingStandard.Begin(inRect);
            listingStandard.CheckboxLabeled("NS.MultipleModesAtTheSameTime".Translate(), ref nanosuitModesAtTheSameTime);
            listingStandard.CheckboxLabeled("NS.UseSkipForJumping".Translate(), ref useSkipForJumping);
            listingStandard.End();
            base.Write();
        }
        private static Vector2 scrollPosition = Vector2.zero;

    }
}

