﻿using HarmonyLib;
using RimWorld;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using UnityEngine;
using Verse;
using Verse.AI;

namespace Nanosuit
{
    public class Recipe_RemoveNanosuit : Recipe_Surgery
    {
        public override bool AvailableOnNow(Thing thing)
        {
            if (thing is Pawn pawn)
            {
                foreach (var apparel in pawn.GetNanosuits())
                {
                    if (apparel.def.hardRemoval != null && apparel.def.hardRemoval.surgeryList.Contains(this.recipe))
                    {
                        return true;
                    }
                }
            }
            return false;
        }
        public override void ApplyOnPawn(Pawn pawn, BodyPartRecord part, Pawn billDoer, List<Thing> ingredients, Bill bill)
        {
            MedicalRecipesUtility.IsClean(pawn, part);
            bool flag = IsViolationOnPawn(pawn, part, Faction.OfPlayer);
            if (billDoer != null)
            {
                if (CheckSurgeryFail(billDoer, pawn, ingredients, part, bill))
                {
                    Log.Message("Recipe_RemoveNanosuit : Recipe_Surgery - ApplyOnPawn - return; - 13", true);
                    return;
                }
                TaleRecorder.RecordTale(TaleDefOf.DidSurgery, billDoer, pawn);

                var apparel = pawn.GetNanosuits().Where(x => x.def.hardRemoval != null && x.def.hardRemoval.surgeryList.Contains(this.recipe)).FirstOrDefault();
                Log.Message("Recipe_RemoveNanosuit : Recipe_Surgery - ApplyOnPawn - pawn.apparel.TryDrop(apparel); - 16", true);
                pawn.apparel.TryDrop(apparel);
            }
            if (flag)
            {
                ReportViolation(pawn, billDoer, pawn.FactionOrExtraMiniOrHomeFaction, -70, "GoodwillChangedReason_RemovedImplant".Translate(part.LabelShort));
            }
        }
    }
}