﻿using System;
using RimWorld;

namespace FCPFalloutPlantsTeaser
{
	public class Plant_StopsGrowingInToxins : Plant
	{

		public override float GrowthRate
		{
			get
			{
				if (base.Blighted)
				{
					return 0f;
				}
				if (base.Spawned && !PlantUtility.GrowthSeasonNow(base.Position, base.Map, false))
				{
					return 0f;
				}
				return base.GrowthRateFactor_Fertility * base.GrowthRateFactor_Temperature * base.GrowthRateFactor_Light * this.GrowthRateFactor_Toxins;
			}
		}

		public float GrowthRateFactor_Toxins
		{
			get
			{
				if (base.Map.gameConditionManager.GetActiveCondition(GameConditionDefOf.ToxicFallout) != null)
				{
					return 0f;
				}
				return 1f;
			}
		}
	}
}