﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using RimWorld;
using Verse;
namespace DarkBraziers
{
	public class RoomRequirement_ThingCount_DarkBraziers : RoomRequirement_Thing
	{
		public ThingDef thingDef2;
		public override bool Met(Room r, Pawn p = null) //boolean has room met requirement
		{
			return this.Count(r) >= this.count; //return true if count function for current room is greater than or equal to the current count
		}

		public int Count(Room r) //number of thingdefs in a room
		{
			return (r.ThingCount(this.thingDef)+r.ThingCount(this.thingDef2));
		}


		public override string Label(Room r = null)
		{
			bool flag = !this.labelKey.NullOrEmpty();
			string text = flag ? this.labelKey.Translate() : this.thingDef.label;
			if (r != null)
			{
				return string.Concat(new object[]
				{
					text,
					" ",
					this.Count(r),
					"/",
					this.count
				});
			}
			if (!flag)
			{
				return GenLabel.ThingLabel(this.thingDef, null, this.count);
			}
			return text + " x" + this.count;
		}

		public override IEnumerable<string> ConfigErrors()
		{
			foreach (string text in base.ConfigErrors())
			{
				yield return text;
			}
			IEnumerator<string> enumerator = null;
			if (this.count <= 0)
			{
				yield return "count must be larger than 0";
			}
			yield break;
		}

		public override void ExposeData()
		{
			base.ExposeData();
			Scribe_Values.Look<int>(ref this.count, "count", 0, false);
		}

		public int count;
	}
}

