-- Jump Through Windows
-- Author: AbraxasDusk
-- Version: 1.0

-- If the character is sprinting and enters a collision,  
-- check if the character is colliding with a window and jump out.
function jumpThroughWindow(character, collider)
    if collider then
        if character:isSprinting() and string.find(tostring(collider), "zombie%.iso%.objects%.IsoWindow") and not collider:isBarricaded() then
            
            -- If the window is closed, smash it.
            if not collider:IsOpen() then
                collider:smashWindow();
                collider:update();
            end

            character:setSprinting(false); -- set false to enable window climb.
            character:climbThroughWindow(collider);

            return;
        end
    end
end

-- Check on every character/object collision.
Events.OnObjectCollide.Add(jumpThroughWindow);