local assets = {
	Asset("ANIM", "anim/armor_spidertux.zip"),
	Asset("ATLAS", "images/inventoryimages/tuxedo.xml"),
	Asset("IMAGE", "images/inventoryimages/tuxedo.tex"),
	Asset("ANIM", "anim/ajit_pai.zip"),
	Asset("ANIM", "anim/ajit_pai_white.zip"),
}

local TUXEDO_SANITY_REDUCTION = .5

local function White_Tux(inst)
	inst.AnimState:OverrideSymbol("torso", "ajit_pai_white", "torso")
	inst.AnimState:OverrideSymbol("arm_upper", "ajit_pai_white", "arm_upper")
	inst.AnimState:OverrideSymbol("torso_pelvis", "ajit_pai_white", "torso_pelvis")
	inst.AnimState:OverrideSymbol("leg", "ajit_pai_white", "leg")
	inst.AnimState:Hide("SKIRT")
end

local function Dark_Tux(inst)
	inst.AnimState:OverrideSymbol("torso", "ajit_pai", "torso")
	inst.AnimState:OverrideSymbol("arm_upper", "ajit_pai", "arm_upper")
	inst.AnimState:OverrideSymbol("torso_pelvis", "ajit_pai", "torso_pelvis")
	inst.AnimState:OverrideSymbol("leg", "ajit_pai", "leg")
	inst.AnimState:Hide("SKIRT")
end

local function Apply_Texture(inst)
	if math.random(1,2) == 1 then
		Dark_Tux(inst)
	else
		White_Tux(inst)
	end
end

local function OnEquip(inst, owner)
	Apply_Texture(owner)
	
	if owner.components.sanity then
		owner.components.sanity.neg_aura_mult = owner.components.sanity.neg_aura_mult - TUXEDO_SANITY_REDUCTION
		owner.components.sanity.night_drain_mult = owner.components.sanity.night_drain_mult - TUXEDO_SANITY_REDUCTION
	end
	
	owner.dodgemaster = true
	if owner.dodger == nil then owner.dodger = "armor_body" end -- Only add if owner can't do it
	if owner.slider == nil then owner.slider = "armor_body" end -- Only add if owner can't do it
end

local function Apply_On_Join(inst)
	if inst.components.inventoryitem.owner and inst.components.equippable:IsEquipped(true) then
		Apply_Texture(inst.components.inventoryitem.owner)
	end
end

local function OnUnequip(inst, owner)
	owner.AnimState:ClearOverrideSymbol("torso")
	owner.AnimState:ClearOverrideSymbol("arm_upper")
	owner.AnimState:ClearOverrideSymbol("leg")
	owner.AnimState:Show("SKIRT")
	
	if owner.components.sanity then
		owner.components.sanity.neg_aura_mult = owner.components.sanity.neg_aura_mult + TUXEDO_SANITY_REDUCTION
		owner.components.sanity.night_drain_mult = owner.components.sanity.night_drain_mult + TUXEDO_SANITY_REDUCTION
	end
	
	owner.dodgemaster = nil
	if owner.dodger == "armor_body"  then owner.dodger = nil end -- Only remove if we added the ability
	if owner.slider == "armor_body"  then owner.slider = nil end -- Only remove if we added the ability
end

local function fn()
	local inst = CreateEntity()

	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddNetwork()

	MakeInventoryPhysics(inst)
	MakeInventoryFloatable(inst)

	inst.AnimState:SetBank("armor_spidertux")
	inst.AnimState:SetBuild("armor_spidertux")
	inst.AnimState:PlayAnimation("idle")
	inst.AnimState:OverrideSymbol("idle", "ajit_pai", "torso")

	inst.entity:SetPristine()

	if not TheWorld.ismastersim then return inst end

	inst.Transform:SetScale(1.25, 1.25, 1.25)

	inst:AddComponent("inspectable")
	inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/tuxedo.xml"

	inst:AddComponent("equippable")
	inst.components.equippable.equipslot = EQUIPSLOTS.BODY
	inst.components.equippable.walkspeedmult = 1.15

	inst:AddComponent("armor")
	inst.components.armor:InitCondition(500, .5)

	inst:DoTaskInTime(0, Apply_On_Join) -- Without this armor won't show up on join

	inst.components.equippable:SetOnEquip(OnEquip)
	inst.components.equippable:SetOnUnequip(OnUnequip)
	
	inst:AddComponent("insulator")
	inst.components.insulator:SetInsulation(TUNING.INSULATION_TINY)

	MakeHauntableLaunch(inst)

	return inst
end

return Prefab("tuxedo", fn, assets)