# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTIBILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.

bl_info = {
    "name" : "Kaboom",
    "author" : "picto filmo", 
    "description" : "",
    "blender" : (3, 3, 0),
    "version" : (1, 5, 0),
    "location" : "",
    "warning" : "",
    "doc_url": "", 
    "tracker_url": "", 
    "category" : "3D View" 
}


import bpy
import bpy.utils.previews
import os
import webbrowser
from bpy.app.handlers import persistent
import random
import math
import addon_utils
from math import *
import bmesh
from mathutils import Vector
import itertools
from math import sqrt
from mathutils import Vector, kdtree
import time


addon_keymaps = {}
_icons = None
fracture = {'sna_kb_object_tmp': None, 'sna_kb_string_tmp': '', 'sna_kb_integer_tmp': 0, 'sna_kb_vector_tmp': [], 'sna_kb_list_tmp': [], }
kaboomtree = {'sna_kb_string_tmp': '', 'sna_kb_object_tmp': None, 'sna_kb_material_tmp': None, 'sna_kb_bool_tmp': False, 'sna_kb_list_tmp': [], 'sna_kb_collection_tmp': None, 'sna_kb_integer_tmp': 0, 'sna_kb_index_var': 0, }
noisy_innerrough_cut = {'sna_objects_list': [], 'sna_rough_cut_copy': [], }
particles = {'sna_tmp_bool': False, }


def sna_move_outliner_collection_object_A90B9_4C0CF(object, collection_name):
    object = object
    collection_name = collection_name
    object_old_coll = object.users_collection
    collection = bpy.data.collections.get( collection_name )
    if collection not in object_old_coll:
        if collection is None:
            collection = bpy.data.collections.new( collection_name )
            bpy.context.scene.collection.children.link( collection )
        collection.objects.link( object )
        for coll in object_old_coll:
            coll.objects.unlink(object)


def sna_move_outliner_collection_object_A90B9_BF9CA(object, collection_name):
    object = object
    collection_name = collection_name
    object_old_coll = object.users_collection
    collection = bpy.data.collections.get( collection_name )
    if collection not in object_old_coll:
        if collection is None:
            collection = bpy.data.collections.new( collection_name )
            bpy.context.scene.collection.children.link( collection )
        collection.objects.link( object )
        for coll in object_old_coll:
            coll.objects.unlink(object)


def sna_move_outliner_collection_object_A90B9_3D312(object, collection_name):
    object = object
    collection_name = collection_name
    object_old_coll = object.users_collection
    collection = bpy.data.collections.get( collection_name )
    if collection not in object_old_coll:
        if collection is None:
            collection = bpy.data.collections.new( collection_name )
            bpy.context.scene.collection.children.link( collection )
        collection.objects.link( object )
        for coll in object_old_coll:
            coll.objects.unlink(object)


def property_exists(prop_path, glob, loc):
    try:
        eval(prop_path, glob, loc)
        return True
    except:
        return False


def sna_update_sna_kb_show_smoke_parts_B9F27(self, context):
    sna_updated_prop = self.sna_kb_show_smoke_parts
    bpy.ops.sna.kb_op_show_hide_particles_af372('INVOKE_DEFAULT', sna_particle_type='Smoke')


def sna_update_sna_kb_show_debris_parts_D8E01(self, context):
    sna_updated_prop = self.sna_kb_show_debris_parts
    bpy.ops.sna.kb_op_show_hide_particles_af372('INVOKE_DEFAULT', sna_particle_type='Debris')


def sna_move_outliner_collection_object_A90B9_9A727(object, collection_name):
    object = object
    collection_name = collection_name
    object_old_coll = object.users_collection
    collection = bpy.data.collections.get( collection_name )
    if collection not in object_old_coll:
        if collection is None:
            collection = bpy.data.collections.new( collection_name )
            bpy.context.scene.collection.children.link( collection )
        collection.objects.link( object )
        for coll in object_old_coll:
            coll.objects.unlink(object)


def sna_move_outliner_collection_object_A90B9_46FD3(object, collection_name):
    object = object
    collection_name = collection_name
    object_old_coll = object.users_collection
    collection = bpy.data.collections.get( collection_name )
    if collection not in object_old_coll:
        if collection is None:
            collection = bpy.data.collections.new( collection_name )
            bpy.context.scene.collection.children.link( collection )
        collection.objects.link( object )
        for coll in object_old_coll:
            coll.objects.unlink(object)


def display_collection_id(uid, vars):
    id = f"coll_{uid}"
    for var in vars.keys():
        if var.startswith("i_"):
            id += f"_{var}_{vars[var]}"
    return id


class SNA_UL_display_collection_list_A9E63(bpy.types.UIList):

    def draw_item(self, context, layout, data, item_A9E63, icon, active_data, active_propname, index_A9E63):
        row = layout
        layout.label(text=item_A9E63.kaboom_col.name, icon_value=(874 if item_A9E63.is_iteration else 250))
        if item_A9E63.has_constraints:
            layout.label(text='', icon_value=175)
        if item_A9E63.is_baked:
            layout.label(text='', icon_value=115)
        if item_A9E63.has_debris:
            layout.label(text='', icon_value=653)
        if item_A9E63.has_smoke:
            layout.label(text='', icon_value=656)
        op = layout.operator('sna.kb_op_select_kaboom_parts_d8203', text='', icon_value=256, emboss=True, depress=False)
        op.sna_index = index_A9E63
        op = layout.operator('sna.kb_op_delete_kaboom_cf826', text='', icon_value=3, emboss=True, depress=False)
        op.sna_index = index_A9E63

    def filter_items(self, context, data, propname):
        flt_flags = []
        for item in getattr(data, propname):
            if not self.filter_name or self.filter_name.lower() in item.name.lower():
                if True:
                    flt_flags.append(self.bitflag_filter_item)
                else:
                    flt_flags.append(0)
            else:
                flt_flags.append(0)
        return flt_flags, []


def sna_interface_about_pictofilmo_5B4B0(layout_function, ):
    row_E0127 = layout_function.row(heading='', align=True)
    row_E0127.alert = False
    row_E0127.enabled = True
    row_E0127.active = True
    row_E0127.use_property_split = False
    row_E0127.use_property_decorate = False
    row_E0127.scale_x = 1.0
    row_E0127.scale_y = 1.0
    row_E0127.alignment = 'Expand'.upper()
    if not True: row_E0127.operator_context = "EXEC_DEFAULT"
    row_E0127.template_icon(icon_value=_icons['pictofilmo_icon_128.png'].icon_id, scale=2.0)
    row_6FD3C = row_E0127.row(heading='', align=True)
    row_6FD3C.alert = False
    row_6FD3C.enabled = True
    row_6FD3C.active = True
    row_6FD3C.use_property_split = False
    row_6FD3C.use_property_decorate = False
    row_6FD3C.scale_x = 1.0
    row_6FD3C.scale_y = 2.0
    row_6FD3C.alignment = 'Expand'.upper()
    if not True: row_6FD3C.operator_context = "EXEC_DEFAULT"
    op = row_6FD3C.operator('sna.kb_op_web_link_8f33d', text='Picto Filmo', icon_value=0, emboss=True, depress=False)
    op.sna_weblink = 'http://www.pictofilmo.com'
    row_A04F5 = layout_function.row(heading='', align=True)
    row_A04F5.alert = False
    row_A04F5.enabled = True
    row_A04F5.active = True
    row_A04F5.use_property_split = False
    row_A04F5.use_property_decorate = False
    row_A04F5.scale_x = 1.0
    row_A04F5.scale_y = 1.0
    row_A04F5.alignment = 'Expand'.upper()
    if not True: row_A04F5.operator_context = "EXEC_DEFAULT"
    row_A04F5.template_icon(icon_value=_icons['Blender+Market_ico_128.png'].icon_id, scale=1.0)
    row_FB09E = row_A04F5.row(heading='', align=True)
    row_FB09E.alert = False
    row_FB09E.enabled = True
    row_FB09E.active = True
    row_FB09E.use_property_split = False
    row_FB09E.use_property_decorate = False
    row_FB09E.scale_x = 1.0
    row_FB09E.scale_y = 1.0
    row_FB09E.alignment = 'Expand'.upper()
    if not True: row_FB09E.operator_context = "EXEC_DEFAULT"
    op = row_FB09E.operator('sna.kb_op_web_link_8f33d', text='Blender Market', icon_value=0, emboss=True, depress=False)
    op.sna_weblink = 'https://blendermarket.com/creators/picto-filmo'
    row_A16FF = layout_function.row(heading='', align=True)
    row_A16FF.alert = False
    row_A16FF.enabled = True
    row_A16FF.active = True
    row_A16FF.use_property_split = False
    row_A16FF.use_property_decorate = False
    row_A16FF.scale_x = 1.0
    row_A16FF.scale_y = 1.0
    row_A16FF.alignment = 'Expand'.upper()
    if not True: row_A16FF.operator_context = "EXEC_DEFAULT"
    row_A16FF.template_icon(icon_value=_icons['gumraod_icon_128.png'].icon_id, scale=1.0)
    row_8A16E = row_A16FF.row(heading='', align=True)
    row_8A16E.alert = False
    row_8A16E.enabled = True
    row_8A16E.active = True
    row_8A16E.use_property_split = False
    row_8A16E.use_property_decorate = False
    row_8A16E.scale_x = 1.0
    row_8A16E.scale_y = 1.0
    row_8A16E.alignment = 'Expand'.upper()
    if not True: row_8A16E.operator_context = "EXEC_DEFAULT"
    op = row_8A16E.operator('sna.kb_op_web_link_8f33d', text='Gumroad', icon_value=0, emboss=True, depress=False)
    op.sna_weblink = 'https://pictofilmo.gumroad.com/'


class SNA_OT_Kb_Op_Web_Link_8F33D(bpy.types.Operator):
    bl_idname = "sna.kb_op_web_link_8f33d"
    bl_label = "KB_OP_Web_Link"
    bl_description = ""
    bl_options = {"REGISTER", "UNDO"}
    sna_weblink: bpy.props.StringProperty(name='WebLink', description='', default='', subtype='NONE', maxlen=0)

    @classmethod
    def poll(cls, context):
        if bpy.app.version >= (3, 0, 0) and False:
            cls.poll_message_set()
        return not False

    def execute(self, context):
        webpath = self.sna_weblink
        webbrowser.open(webpath)
        return {"FINISHED"}

    def invoke(self, context, event):
        return self.execute(context)


class SNA_OT_Kb_Op_Add_Blaster_47645(bpy.types.Operator):
    bl_idname = "sna.kb_op_add_blaster_47645"
    bl_label = "kb_op_add_blaster"
    bl_description = ""
    bl_options = {"REGISTER", "UNDO"}

    @classmethod
    def poll(cls, context):
        if bpy.app.version >= (3, 0, 0) and False:
            cls.poll_message_set()
        return not False

    def execute(self, context):
        bpy.ops.outliner.orphans_purge(do_recursive=True)
        if property_exists("bpy.data.objects[bpy.context.scene.sna_kb_blaster_object_name]", globals(), locals()):
            pass
        else:
            before_data = list(bpy.data.objects)
            bpy.ops.wm.append(directory=os.path.join(os.path.dirname(__file__), 'assets', 'KB_asset.blend') + r'\Object', filename='WreckingBallOuter-KrumblR', link=False)
            new_data = list(filter(lambda d: not d in before_data, list(bpy.data.objects)))
            appended_C0143 = None if not new_data else new_data[0]
            blaster_obj = bpy.data.objects['WreckingBallOuter-KrumblR']
            ### link to scene collection root
            object_old_coll = blaster_obj.users_collection
            if len(object_old_coll)>0:
                for col in  object_old_coll:
                    print(col.name)
                    col.objects.unlink(blaster_obj)
                    bpy.context.view_layer.update()
                    print(blaster_obj.users_collection)
            bpy.context.scene.collection.objects.link(blaster_obj)
            print('tt',blaster_obj.users_collection)
            ### deselect all
            bpy.ops.object.select_all(action='DESELECT')
            # cleaning   ##################### 
            bpy.data.objects['Blaster_Core_Shape'].select_set(True)
            bpy.data.objects['Blaster_Range_Shape'].select_set(True)
            bpy.ops.object.delete(use_global=False)
            bpy.data.objects['WreckingBallOuter-KrumblR'].select_set(True)
            bpy.context.view_layer.objects.active = bpy.data.objects['WreckingBallOuter-KrumblR']
            bpy.context.scene.sna_kb_blaster_object_name = bpy.context.object.name
        return {"FINISHED"}

    def invoke(self, context, event):
        return self.execute(context)


def sna_blaster_D0A07(layout_function, ):
    if property_exists("bpy.data.objects[bpy.context.scene.sna_kb_blaster_object_name]", globals(), locals()):
        col_FC884 = layout_function.column(heading='', align=False)
        col_FC884.alert = False
        col_FC884.enabled = True
        col_FC884.active = True
        col_FC884.use_property_split = False
        col_FC884.use_property_decorate = False
        col_FC884.scale_x = 1.0
        col_FC884.scale_y = 1.0
        col_FC884.alignment = 'Expand'.upper()
        if not True: col_FC884.operator_context = "EXEC_DEFAULT"
        col_FC884.label(text='BLASTER:', icon_value=0)
        col_B923A = col_FC884.column(heading='', align=False)
        col_B923A.alert = False
        col_B923A.enabled = True
        col_B923A.active = True
        col_B923A.use_property_split = False
        col_B923A.use_property_decorate = False
        col_B923A.scale_x = 1.0
        col_B923A.scale_y = 1.0
        col_B923A.alignment = 'Expand'.upper()
        if not True: col_B923A.operator_context = "EXEC_DEFAULT"
        row_B1354 = col_B923A.row(heading='', align=False)
        row_B1354.alert = False
        row_B1354.enabled = True
        row_B1354.active = True
        row_B1354.use_property_split = False
        row_B1354.use_property_decorate = False
        row_B1354.scale_x = 1.0
        row_B1354.scale_y = 1.0
        row_B1354.alignment = 'Expand'.upper()
        if not True: row_B1354.operator_context = "EXEC_DEFAULT"
        row_B1354.template_icon(icon_value=_icons['Blaster_icon.png'].icon_id, scale=2.0)
        col_2940B = row_B1354.column(heading='', align=False)
        col_2940B.alert = False
        col_2940B.enabled = True
        col_2940B.active = True
        col_2940B.use_property_split = False
        col_2940B.use_property_decorate = False
        col_2940B.scale_x = 1.0
        col_2940B.scale_y = 1.0
        col_2940B.alignment = 'Expand'.upper()
        if not True: col_2940B.operator_context = "EXEC_DEFAULT"
        attr_93776 = '["' + str('INNER' + '"]') 
        col_2940B.prop(bpy.data.objects[bpy.context.scene.sna_kb_blaster_object_name], attr_93776, text='Core Radius', icon_value=0, emboss=True)
        attr_06FB3 = '["' + str('OUTER' + '"]') 
        col_2940B.prop(bpy.data.objects[bpy.context.scene.sna_kb_blaster_object_name], attr_06FB3, text='Dynamic Range', icon_value=0, emboss=True)
        col_FC884.label(text='FORCES:', icon_value=0)
        box_ED64A = col_FC884.box()
        box_ED64A.alert = False
        box_ED64A.enabled = True
        box_ED64A.active = True
        box_ED64A.use_property_split = False
        box_ED64A.use_property_decorate = False
        box_ED64A.alignment = 'Expand'.upper()
        box_ED64A.scale_x = 1.0
        box_ED64A.scale_y = 1.0
        if not True: box_ED64A.operator_context = "EXEC_DEFAULT"
        split_B8434 = box_ED64A.split(factor=0.5, align=False)
        split_B8434.alert = False
        split_B8434.enabled = True
        split_B8434.active = True
        split_B8434.use_property_split = False
        split_B8434.use_property_decorate = False
        split_B8434.scale_x = 1.0
        split_B8434.scale_y = 1.0
        split_B8434.alignment = 'Expand'.upper()
        if not True: split_B8434.operator_context = "EXEC_DEFAULT"
        row_8B2D7 = split_B8434.row(heading='', align=False)
        row_8B2D7.alert = False
        row_8B2D7.enabled = True
        row_8B2D7.active = True
        row_8B2D7.use_property_split = False
        row_8B2D7.use_property_decorate = False
        row_8B2D7.scale_x = 1.0
        row_8B2D7.scale_y = 1.0
        row_8B2D7.alignment = 'Expand'.upper()
        if not True: row_8B2D7.operator_context = "EXEC_DEFAULT"
        row_8B2D7.label(text='', icon_value=565)
        row_8B2D7.prop(bpy.context.window_manager, 'sna_kb_bomb_radial_force', text='', icon_value=0, emboss=True)
        row_078E0 = split_B8434.row(heading='', align=False)
        row_078E0.alert = False
        row_078E0.enabled = True
        row_078E0.active = True
        row_078E0.use_property_split = False
        row_078E0.use_property_decorate = False
        row_078E0.scale_x = 1.0
        row_078E0.scale_y = 1.0
        row_078E0.alignment = 'Expand'.upper()
        if not True: row_078E0.operator_context = "EXEC_DEFAULT"
        row_078E0.label(text='', icon_value=_icons['plusorminus_icon.png'].icon_id)
        row_078E0.prop(bpy.context.window_manager, 'sna_kb_bomb_radial_force_rand', text='', icon_value=0, emboss=True)
        row_078E0.label(text='', icon_value=_icons['percent_icon.png'].icon_id)
        split_F1E31 = box_ED64A.split(factor=0.5, align=False)
        split_F1E31.alert = False
        split_F1E31.enabled = True
        split_F1E31.active = True
        split_F1E31.use_property_split = False
        split_F1E31.use_property_decorate = False
        split_F1E31.scale_x = 1.0
        split_F1E31.scale_y = 1.0
        split_F1E31.alignment = 'Expand'.upper()
        if not True: split_F1E31.operator_context = "EXEC_DEFAULT"
        row_7ADA8 = split_F1E31.row(heading='', align=False)
        row_7ADA8.alert = False
        row_7ADA8.enabled = True
        row_7ADA8.active = True
        row_7ADA8.use_property_split = False
        row_7ADA8.use_property_decorate = False
        row_7ADA8.scale_x = 1.0
        row_7ADA8.scale_y = 1.0
        row_7ADA8.alignment = 'Expand'.upper()
        if not True: row_7ADA8.operator_context = "EXEC_DEFAULT"
        row_7ADA8.label(text='', icon_value=592)
        col_FD103 = row_7ADA8.column(heading='', align=False)
        col_FD103.alert = False
        col_FD103.enabled = True
        col_FD103.active = True
        col_FD103.use_property_split = False
        col_FD103.use_property_decorate = False
        col_FD103.scale_x = 1.0
        col_FD103.scale_y = 1.0
        col_FD103.alignment = 'Expand'.upper()
        if not True: col_FD103.operator_context = "EXEC_DEFAULT"
        col_FD103.prop(bpy.context.window_manager, 'sna_kb_bomb_directionnal_force', text='', icon_value=0, emboss=True)
        row_ADA67 = split_F1E31.row(heading='', align=False)
        row_ADA67.alert = False
        row_ADA67.enabled = True
        row_ADA67.active = True
        row_ADA67.use_property_split = False
        row_ADA67.use_property_decorate = False
        row_ADA67.scale_x = 1.0
        row_ADA67.scale_y = 1.0
        row_ADA67.alignment = 'Expand'.upper()
        if not True: row_ADA67.operator_context = "EXEC_DEFAULT"
        row_ADA67.label(text='', icon_value=_icons['plusorminus_icon.png'].icon_id)
        row_ADA67.prop(bpy.context.window_manager, 'sna_kb_bomb_directionnal_force_rand', text='', icon_value=0, emboss=True)
        row_ADA67.label(text='', icon_value=_icons['percent_icon.png'].icon_id)
        split_3C7ED = box_ED64A.split(factor=0.5, align=False)
        split_3C7ED.alert = False
        split_3C7ED.enabled = True
        split_3C7ED.active = True
        split_3C7ED.use_property_split = False
        split_3C7ED.use_property_decorate = False
        split_3C7ED.scale_x = 1.0
        split_3C7ED.scale_y = 1.0
        split_3C7ED.alignment = 'Expand'.upper()
        if not True: split_3C7ED.operator_context = "EXEC_DEFAULT"
        row_EA2A1 = split_3C7ED.row(heading='', align=False)
        row_EA2A1.alert = False
        row_EA2A1.enabled = True
        row_EA2A1.active = True
        row_EA2A1.use_property_split = True
        row_EA2A1.use_property_decorate = False
        row_EA2A1.scale_x = 1.0
        row_EA2A1.scale_y = 1.0
        row_EA2A1.alignment = 'Expand'.upper()
        if not True: row_EA2A1.operator_context = "EXEC_DEFAULT"
        row_EA2A1.label(text='', icon_value=594)
        row_EA2A1.prop(bpy.context.window_manager, 'sna_kb_part_spin', text='', icon_value=0, emboss=True)
        row_B4E02 = split_3C7ED.row(heading='', align=False)
        row_B4E02.alert = False
        row_B4E02.enabled = True
        row_B4E02.active = True
        row_B4E02.use_property_split = True
        row_B4E02.use_property_decorate = False
        row_B4E02.scale_x = 1.0
        row_B4E02.scale_y = 1.0
        row_B4E02.alignment = 'Expand'.upper()
        if not True: row_B4E02.operator_context = "EXEC_DEFAULT"
        row_B4E02.label(text='', icon_value=_icons['plusorminus_icon.png'].icon_id)
        row_B4E02.prop(bpy.context.window_manager, 'sna_kb_part_spin_rand', text='', icon_value=0, emboss=True)
        row_B4E02.label(text='', icon_value=_icons['percent_icon.png'].icon_id)
    else:
        op = layout_function.operator('sna.kb_op_add_blaster_47645', text='Add Blaster', icon_value=93, emboss=True, depress=False)


@persistent
def load_post_handler_0F448(dummy):
    #import bpy 
    """
    bo : bpy_types.Object
    """

    def update_dependencies(ob):

        def updateExp(d):
            # https://blender.stackexchange.com/questions/118350/how-to-update-the-dependencies-of-a-driver-via-python-script
            d.driver.expression += " "
            d.driver.expression = d.driver.expression[:-1]
        try:
            drivers = ob.animation_data.drivers
            for d in drivers:
                updateExp(d)
        except AttributeError:
            return
    for tex in bpy.data.textures:
        update_dependencies(tex)
    for ob in bpy.data.objects:
        update_dependencies(ob)
    for no in bpy.data.node_groups:
        update_dependencies(no)


class SNA_OT_Kb_Op_Updatedepncies_0E98C(bpy.types.Operator):
    bl_idname = "sna.kb_op_updatedepncies_0e98c"
    bl_label = "KB_OP_UpdateDepncies"
    bl_description = ""
    bl_options = {"REGISTER", "UNDO"}

    @classmethod
    def poll(cls, context):
        if bpy.app.version >= (3, 0, 0) and False:
            cls.poll_message_set()
        return not False

    def execute(self, context):
        #import bpy 
        """
        bo : bpy_types.Object
        """

        def update_dependencies(ob):

            def updateExp(d):
                # https://blender.stackexchange.com/questions/118350/how-to-update-the-dependencies-of-a-driver-via-python-script
                d.driver.expression += " "
                d.driver.expression = d.driver.expression[:-1]
            try:
                drivers = ob.animation_data.drivers
                for d in drivers:
                    updateExp(d)
            except AttributeError:
                return
        for tex in bpy.data.textures:
            update_dependencies(tex)
        for ob in bpy.data.objects:
            update_dependencies(ob)
        for no in bpy.data.node_groups:
            update_dependencies(no)
        return {"FINISHED"}

    def invoke(self, context, event):
        return self.execute(context)


def sna_fracture_2BB12(layout_function, ):
    box_D92B3 = layout_function.box()
    box_D92B3.alert = False
    box_D92B3.enabled = True
    box_D92B3.active = True
    box_D92B3.use_property_split = False
    box_D92B3.use_property_decorate = False
    box_D92B3.alignment = 'Expand'.upper()
    box_D92B3.scale_x = 1.0
    box_D92B3.scale_y = 1.0
    if not True: box_D92B3.operator_context = "EXEC_DEFAULT"
    col_22366 = box_D92B3.column(heading='', align=False)
    col_22366.alert = False
    col_22366.enabled = True
    col_22366.active = True
    col_22366.use_property_split = False
    col_22366.use_property_decorate = False
    col_22366.scale_x = 1.0
    col_22366.scale_y = 1.0
    col_22366.alignment = 'Expand'.upper()
    if not True: col_22366.operator_context = "EXEC_DEFAULT"
    grid_1A80C = col_22366.grid_flow(columns=7, row_major=False, even_columns=False, even_rows=False, align=True)
    grid_1A80C.enabled = True
    grid_1A80C.active = True
    grid_1A80C.use_property_split = False
    grid_1A80C.use_property_decorate = False
    grid_1A80C.alignment = 'Expand'.upper()
    grid_1A80C.scale_x = 1.0
    grid_1A80C.scale_y = 1.0
    if not True: grid_1A80C.operator_context = "EXEC_DEFAULT"
    grid_1A80C.prop(bpy.context.window_manager, 'sna_kb_fracture_mode', text='', icon_value=0, emboss=True, expand=True, toggle=False)
    row_8D568 = col_22366.row(heading='', align=False)
    row_8D568.alert = False
    row_8D568.enabled = True
    row_8D568.active = True
    row_8D568.use_property_split = False
    row_8D568.use_property_decorate = False
    row_8D568.scale_x = 1.0
    row_8D568.scale_y = 1.0
    row_8D568.alignment = 'Expand'.upper()
    if not True: row_8D568.operator_context = "EXEC_DEFAULT"
    row_8D568.label(text='', icon_value=592)
    row_8D568.prop(bpy.context.window_manager, 'sna_kb_fracture_axis', text='', icon_value=0, emboss=True, expand=True, toggle=False)
    col_22366.prop(bpy.context.window_manager, 'sna_kb_fracture_count', text='Count', icon_value=0, emboss=True, expand=True, toggle=False)
    row_DF4CD = box_D92B3.row(heading='', align=False)
    row_DF4CD.alert = True
    row_DF4CD.enabled = True
    row_DF4CD.active = True
    row_DF4CD.use_property_split = False
    row_DF4CD.use_property_decorate = False
    row_DF4CD.scale_x = 1.0
    row_DF4CD.scale_y = 1.0
    row_DF4CD.alignment = 'Expand'.upper()
    if not True: row_DF4CD.operator_context = "EXEC_DEFAULT"
    col_E2A4F = row_DF4CD.column(heading='', align=False)
    col_E2A4F.alert = False
    col_E2A4F.enabled = True
    col_E2A4F.active = True
    col_E2A4F.use_property_split = False
    col_E2A4F.use_property_decorate = False
    col_E2A4F.scale_x = 1.0
    col_E2A4F.scale_y = 1.0
    col_E2A4F.alignment = 'Center'.upper()
    if not True: col_E2A4F.operator_context = "EXEC_DEFAULT"
    col_E2A4F.template_icon(icon_value=_icons['Cell_Fracture_icon.png'].icon_id, scale=2.0)
    row_38C1C = row_DF4CD.row(heading='', align=True)
    row_38C1C.alert = True
    row_38C1C.enabled = 'OBJECT'==bpy.context.mode
    row_38C1C.active = 'OBJECT'==bpy.context.mode
    row_38C1C.use_property_split = False
    row_38C1C.use_property_decorate = False
    row_38C1C.scale_x = 1.0
    row_38C1C.scale_y = 2.0
    row_38C1C.alignment = 'Expand'.upper()
    if not True: row_38C1C.operator_context = "EXEC_DEFAULT"
    op = row_38C1C.operator('sna.kb_op_fracture_614c5', text='Fracture', icon_value=0, emboss=True, depress=False)
    op.sna_iterator = False
    op.sna_new_group = False
    op.sna_is_from_fracture_group = False
    op.sna_is_about_iterator = False
    op.sna_is_new_group_of_multiple = False
    op.sna_index_src = 0


def sna_fracture_go_32B98(is_iterator, to_new_group, object_src, is_from_group, is_multiple_fracture, is_new_group_of_multiple_fracture, index_src):
    print(str(to_new_group))
    if to_new_group:
        size = 4
        out = None
        out = f'{random.randrange(16**size):x}'
        fracture['sna_kb_string_tmp'] = ('Iterator_Grp_' if is_iterator else 'Frag_Grp_') + out
    else:
        exec('bpy.context.scene.frame_set(bpy.context.scene.frame_start)')
    sna_kb_fc_assign_material_to_object_93B2F(object_src)
    if is_iterator:
        fracture['sna_kb_integer_tmp'] = list(bpy.context.scene.sna_kb_kaboom_collection)[bpy.context.scene.sna_kb_col_index].iteration_degree
    fracture_mode = list(bpy.context.window_manager.sna_kb_fracture_mode)
    fracture_collection = fracture['sna_kb_string_tmp']
    fracture_count = bpy.context.window_manager.sna_kb_fracture_count
    cell_size = bpy.context.window_manager.sna_kb_fracture_axis
    is_not_iterator = (not is_iterator)
    is_iterator = is_iterator
    new_group = to_new_group
    kb = (list(bpy.context.scene.sna_kb_kaboom_collection)[bpy.context.scene.sna_kb_col_index] if is_iterator else None)
    src = object_src
    is_from_fracture_group = is_from_group
    is_multiple_fracture = is_multiple_fracture
    index_src = index_src
    is_new_group_of_multiple_fracture = is_new_group_of_multiple_fracture
    col_out_name = None
    src_animation_data = None
    tex_space_loc = None
    tex_space_scale = None

    def traverse_tree(t):
        yield t
        for child in t.children:
            yield from traverse_tree(child)

    def parent_lookup(coll):
        parent_lookup = {}
        for coll in traverse_tree(coll):
            for c in coll.children.keys():
                parent_lookup.setdefault(c, coll)
        return parent_lookup
    src.select_set(True)
    bpy.context.view_layer.objects.active = src
    if bpy.context.scene.rigidbody_world:
        bpy.context.scene.rigidbody_world.enabled = True
    else:
        bpy.ops.rigidbody.world_add()
    if not fracture_mode:
        fracture_mode = {'Own particles'}
    source_list = []
    if 'Own Vertex' in fracture_mode:
        source_list.append('VERT_OWN')
    if 'Child Vertex' in fracture_mode:
        source_list.append('VERT_CHILD')         
    if 'Own particles' in fracture_mode:
        source_list.append('PARTICLE_OWN')
    if 'Child Particles' in fracture_mode:
        source_list.append('PARTICLE_CHILD')
    if 'Grease Pencil' in fracture_mode:
        source_list.append('PENCIL')
    frame = bpy.context.scene.frame_current
    if new_group:
        if is_from_fracture_group:
            tex_space_loc = bpy.context.scene.sna_kb_kaboom_collection[index_src].tex_space_loc
            tex_space_scale = bpy.context.scene.sna_kb_kaboom_collection[index_src].tex_space_scale
            print('is new group, is_from_fractuer group ,',tex_space_loc, ',',tex_space_scale,'col index =',bpy.context.scene.sna_kb_col_index)
        else:
            tex_space_loc = src.matrix_world.translation
            tex_space_scale = src.data.texspace_size
            print('is new group, not_from_fracture group ,',tex_space_loc, ',',tex_space_scale)
    else:
        if is_from_fracture_group:#len(bpy.context.scene.sna_kb_kaboom_collection)>0:
            tex_space_loc = bpy.context.scene.sna_kb_kaboom_collection[index_src].tex_space_loc
            tex_space_scale = bpy.context.scene.sna_kb_kaboom_collection[index_src].tex_space_scale
            print('NO new group, already kaboom exists ,',tex_space_loc, ',',tex_space_scale,'col index =',bpy.context.scene.sna_kb_col_index)
        else:
            tex_space_loc = src.matrix_world.translation
            tex_space_scale = src.data.texspace_size
            print('NO new group, NO kaboom exists ,',tex_space_loc, ',',tex_space_scale)
    if new_group:
        bpy.ops.object.transform_apply(location=False, rotation=True, scale=True)
        if is_iterator:
            src.sna_kb_is_iterator_source = True
            it_deg = kb.iteration_degree
            m_world = src.matrix_world
            src_animation_data = src.animation_data.action
            src_animation_data.name = fracture_collection
            src.select_set(True)
            bpy.context.view_layer.objects.active = src
            bpy.ops.nla.bake(frame_start=bpy.context.scene.frame_start, frame_end=frame-1, use_current_action=False, visual_keying=True, clear_parents=True, bake_types={'OBJECT'})
            src.select_set(True)
            bpy.context.view_layer.objects.active = src
            bpy.ops.rigidbody.object_remove()
            bpy.ops.object.duplicate_move()
            ob_colider = bpy.context.object
            ob_colider.name = src.name + '_KB_rigidbody_collision'
            ob_colider.animation_data.action = src_animation_data.copy()
            bpy.context.scene.rigidbody_world.collection.objects.link(ob_colider)
            ob_colider.rigid_body.collision_collections[0] = False
            ob_colider.rigid_body.collision_collections[it_deg + 1] = True
            #bpy.context.object.keyframe_insert('rigid_body.collision_collections',frame=frame)
            ob_colider.parent = src
            ob_colider.matrix_world = m_world
            ob_colider.hide_render = True
            ob_colider.hide_viewport = True
            ob_colider.hide_select = True
            src.hide_viewport = False
        # force single object operation
        bpy.ops.object.select_all(action='DESELECT')
        src.select_set(True)
        bpy.context.view_layer.objects.active = src 
        if is_not_iterator:
            try:
                src.rigid_body.type != None
                bpy.ops.rigidbody.object_remove()
            except:
                print("No RB to remove") 
        # remove all modifier
        for m in src.modifiers:
            bpy.ops.object.modifier_remove(modifier = m.name)
    else:
        if is_new_group_of_multiple_fracture:
            fracture_collection = bpy.context.scene.sna_kb_kaboom_collection[bpy.context.scene.sna_kb_col_index].kaboom_col.name
        else:
            fracture_collection = bpy.context.scene.sna_kb_kaboom_collection[index_src].kaboom_col.name
        ###### clean kinematic fcurve
        if src.animation_data:
            for fcu in src.animation_data.action.fcurves:
                if fcu.data_path in ['location','rotation_euler','scale','quaternion']:
                    src.animation_data.action.fcurves.remove(fcu)
        #############################
    #particles
    if 'Own particles' in fracture_mode:
        bframe = bpy.context.scene.frame_current                                   
        ps = src.modifiers.new("KB Fracture Particles", 'PARTICLE_SYSTEM')
        psys = src.particle_systems[ps.name]
        psys.settings.count = fracture_count
        psys.settings.emit_from = 'VOLUME'
        psys.settings.physics_type = 'NO'
        psys.settings.frame_start = bframe - 1
        psys.settings.frame_end = bframe - 1
        psys.settings.display_method = 'CROSS'
    scalx,scaly,scalz = cell_size
    src.select_set(True)
    bpy.context.view_layer.objects.active = src
    #####################################################cell fracture
    bpy.ops.object.add_fracture_cell_objects(
    use_debug_redraw=False, 
    collection_name=fracture_collection,
    source_limit=fracture_count,
    material_index=1,
    margin=0.000,
    use_interior_vgroup=True,
    use_data_match=True,
    use_sharp_edges_apply=False,
    cell_scale=(scalx, scaly, scalz),            
    source=set(source_list))
    col_out_name = fracture_collection
    ############################################################### move collection is new group
    if new_group:
        new_collection = bpy.data.collections[fracture_collection]
        new_collection['kb_src_list'] = ['no_name']
        if not is_not_iterator:
            new_collection.color_tag = 'COLOR_05'
        C = bpy.context
        coll_scene = C.scene.collection
        coll_parents = parent_lookup(coll_scene)
        # test si "KB_fractured_Groups" collection existe, sinon la crée
        if not(coll_scene.children.get("KB_fractured_Groups")):
            col_gps = bpy.data.collections.new( 'KB_fractured_Groups' )
            bpy.context.scene.collection.children.link( col_gps )
        # Get collection references
        coll_target = coll_scene.children.get("KB_fractured_Groups")
        active_coll = new_collection#C.view_layer.active_layer_collection.collection
        # Get parent of *active_coll*
        active_coll_parent = coll_parents.get(active_coll.name)
        if active_coll_parent:
            # Unlink *active_coll*
            active_coll_parent.children.unlink(active_coll)
            # Link *active_coll* to *coll_target*
            coll_target.children.link(active_coll)
        ##############################################################################
    if 'Own particles' in fracture_mode:
        for m in src.modifiers:
            bpy.ops.object.modifier_remove(modifier = m.name)
    if 'Grease Pencil' in fracture_mode: 
        try:    
            bpy.ops.gpencil.layer_annotation_remove() #delete grease pencil   
        except:
            print("No pencil to erase")
    bpy.context.scene.frame_current = frame
    if to_new_group:
        bpy.context.scene.sna_kb_col_index = sna_kb_fc_find_last_col_index_DCB11()
        item_91C0C = bpy.context.scene.sna_kb_kaboom_collection.add()
        item_91C0C.kaboom_col = bpy.data.collections[fracture['sna_kb_string_tmp']]
        item_91C0C.id = fracture['sna_kb_string_tmp'][int(len(fracture['sna_kb_string_tmp']) - 4.0):]
        item_91C0C.object_src = object_src
        item_91C0C.is_iteration = is_iterator
        if is_iterator:
            collision_layer_index_0_34f4c = sna_kb_fc_modulo_CE29E(int(fracture['sna_kb_integer_tmp'] + 1.0))
            item_91C0C.iteration_degree = collision_layer_index_0_34f4c
        is_iterator = is_iterator
        obj_src = item_91C0C.object_src
        kaboom_col = item_91C0C.kaboom_col
        obj_col_src = item_91C0C.obj_collection_src
        it_deg = item_91C0C.iteration_degree
        col_src = None
        action_src = None
        #import bpy
        #is_iterator = True
        #obj_src = bpy.context.object
        frame_c = bpy.context.scene.frame_current
        if is_iterator:
            ########## layer collision du parent fantoem (obj_src_collision)
            src_col_layer = int(max(1,it_deg-1))
            frags = bpy.context.selected_objects
            obj_src.select_set(True)
            bpy.context.view_layer.objects.active = obj_src
            bpy.ops.object.parent_set(type='OBJECT', keep_transform=True)
            bpy.ops.object.select_all(action='DESELECT')
            obj_src.select_set(True)
            bpy.context.view_layer.objects.active = obj_src
            obj_src_collision = bpy.data.objects[obj_src.name + '_KB_rigidbody_collision']
            for f in obj_src_collision.animation_data.action.fcurves:
                if f.data_path in ['rigid_body.kinematic','rigid_body.collision_collections', 'hide_render','hide_viewport']:
                    obj_src_collision.animation_data.action.fcurves.remove(f)
            obj_src_collision.rigid_body.kinematic = True
            obj_src_collision.hide_render = True
            obj_src_collision.hide_viewport = True
            for kb in bpy.context.scene.sna_kb_kaboom_collection:
                if obj_src in kb.kaboom_col.objects[:]:
                    if kb.is_iteration:
                        for f in kb.object_src.animation_data.action.fcurves:
                            if f.data_path == 'hide_render':
                                obj_src.hide_render = True
                                obj_src.keyframe_insert('hide_render',frame=f.keyframe_points[-1].co[0] - 1)
                                obj_src.hide_render = False
                                obj_src.keyframe_insert('hide_render',frame=f.keyframe_points[-1].co[0])
                                obj_src.hide_viewport = True
                                obj_src.keyframe_insert('hide_viewport',frame=f.keyframe_points[-1].co[0] - 1)
                                obj_src.hide_viewport = False
                                obj_src.keyframe_insert('hide_viewport',frame=f.keyframe_points[-1].co[0])
        ############ frame - 1
            #bpy.context.scene.frame_current = frame_c-1
            obj_src.keyframe_insert('display_type',frame=frame_c-1)
            obj_src.keyframe_insert('hide_render',frame=frame_c-1)
            obj_src.keyframe_insert('hide_viewport',frame=frame_c-1)
            obj_src_collision.rigid_body.collision_collections[0] = True
            obj_src_collision.rigid_body.collision_collections[src_col_layer] = False
            obj_src_collision.keyframe_insert('rigid_body.collision_collections',frame=frame_c-1)
        ########### frame
            #bpy.context.scene.frame_current = frame_c
            obj_src.display_type = 'WIRE'
            obj_src.keyframe_insert('display_type',frame=frame_c)
            obj_src.hide_render = True
            obj_src.keyframe_insert('hide_render',frame=frame_c)
            obj_src.hide_viewport = True
            obj_src.keyframe_insert('hide_viewport',frame=frame_c)
            obj_src_collision.rigid_body.collision_collections[0] = False
            obj_src_collision.rigid_body.collision_collections[src_col_layer] = True
            obj_src_collision.keyframe_insert('rigid_body.collision_collections',frame=frame_c)
            for o in kaboom_col.objects:
            ############ frame - 1    
                o.select_set(True)
                bpy.context.view_layer.objects.active = o
                if not o.rigid_body:
                    bpy.ops.rigidbody.object_add()
                o.rigid_body.kinematic = True
                o.keyframe_insert('rigid_body.kinematic',frame=frame_c-1)
                o.hide_render = True
                o.hide_viewport = True
                o.keyframe_insert('hide_render',frame=frame_c-1)
                o.keyframe_insert('hide_viewport',frame=frame_c-1)
                o.rigid_body.collision_collections[0] = False
                o.rigid_body.collision_collections[it_deg] = True
                o.keyframe_insert('rigid_body.collision_collections',frame=frame_c-1)
             ############ frame   
                o.rigid_body.kinematic = False
                o.keyframe_insert('rigid_body.kinematic',frame=frame_c)
                o.hide_render = False
                o.hide_viewport = False
                o.keyframe_insert('hide_render',frame=frame_c)
                o.keyframe_insert('hide_viewport',frame=frame_c)
                o.rigid_body.collision_collections[0] = True
                o.rigid_body.collision_collections[it_deg] = False
                o.keyframe_insert('rigid_body.collision_collections',frame=frame_c)
        else:
            obj_src.hide_viewport = True
            obj_src.hide_render = True
        for col in obj_src.users_collection:
            if col != bpy.context.scene.rigidbody_world.collection:
                col_src = col
        if is_iterator:
            item_91C0C.obj_collection_src = col_src
            item_91C0C.obj_action_src = src_animation_data
        else:
            sna_move_outliner_collection_object_A90B9_4C0CF(item_91C0C.object_src, 'KB_Objects_src')
            fracture_collection_name = fracture['sna_kb_string_tmp']
            src = object_src
            list_src = bpy.data.collections[fracture_collection_name]['kb_src_list']
            list_src.append(src.name)
            bpy.data.collections[fracture_collection_name]['kb_src_list'] = list_src
    else:
        list_obj = bpy.context.view_layer.objects.selected
        obj_src = object_src
        action = None
        if obj_src.animation_data:
            action = obj_src.animation_data.action
        for ob in list_obj:
            bpy.context.view_layer.objects.active = ob    
            if action:
                ob.animation_data_create()
                ob.animation_data.action = action.copy()
            bpy.ops.rigidbody.object_add()
            ob.data.use_auto_texspace = False
        if (is_multiple_fracture and (not is_from_group)):
            sna_move_outliner_collection_object_A90B9_BF9CA(object_src, 'KB_Objects_src')
            fracture_collection_name = fracture['sna_kb_string_tmp']
            src = object_src
            list_src = bpy.data.collections[fracture_collection_name]['kb_src_list']
            list_src.append(src.name)
            bpy.data.collections[fracture_collection_name]['kb_src_list'] = list_src
            object_src.hide_viewport = True
            object_src.hide_render = True
        else:
            sna_move_outliner_collection_object_A90B9_3D312(object_src, 'KB_Objects_src')
            fracture_collection_name = list(bpy.context.scene.sna_kb_kaboom_collection)[bpy.context.scene.sna_kb_col_index].kaboom_col.name
            src = object_src
            list_src = bpy.data.collections[fracture_collection_name]['kb_src_list']
            list_src.append(src.name)
            bpy.data.collections[fracture_collection_name]['kb_src_list'] = list_src
            object_src.hide_viewport = True
            object_src.hide_render = True
    if to_new_group:
        list(bpy.context.scene.sna_kb_kaboom_collection)[bpy.context.scene.sna_kb_col_index].tex_space_loc = tex_space_loc
        list(bpy.context.scene.sna_kb_kaboom_collection)[bpy.context.scene.sna_kb_col_index].tex_space_scale = tex_space_scale
    kaboom_col = list(bpy.context.scene.sna_kb_kaboom_collection)[bpy.context.scene.sna_kb_col_index].kaboom_col
    kb = list(bpy.context.scene.sna_kb_kaboom_collection)[bpy.context.scene.sna_kb_col_index]
    objs = bpy.context.view_layer.objects.selected
    bpy.context.scene.rigidbody_world.enabled = False
    bpy.context.scene.frame_set(bpy.context.scene.frame_start)
    bpy.context.view_layer.objects.update()
    for ob in objs:#kaboom_col.objects:
        ob.data.use_auto_smooth = True
        ob.data.use_auto_texspace = False
        ob.data.texspace_location[0] = kb.tex_space_loc[0] - ob.matrix_world.translation[0]
        ob.data.texspace_location[1] = kb.tex_space_loc[1] - ob.matrix_world.translation[1]
        ob.data.texspace_location[2] = kb.tex_space_loc[2] - ob.matrix_world.translation[2]
        print('TTTEEXXXSSAPPPECECE SSCCAAALLEEE:',kb.tex_space_scale)
        ob.data.texspace_size[0] = kb.tex_space_scale[0]
        ob.data.texspace_size[1] = kb.tex_space_scale[1]
        ob.data.texspace_size[2] = kb.tex_space_scale[2]
    bpy.context.scene.rigidbody_world.enabled = True
    if (to_new_group or (not is_from_group) or is_new_group_of_multiple_fracture):
        pass
    else:
        ob = object_src
        bpy.data.objects.remove(ob)


def sna_kb_fc_assign_material_to_object_93B2F(object):
    if property_exists("bpy.data.materials['Crushed_Stone']", globals(), locals()):
        kaboomtree['sna_kb_material_tmp'] = bpy.data.materials['Crushed_Stone']
    else:
        before_data = list(bpy.data.materials)
        bpy.ops.wm.append(directory=os.path.join(os.path.dirname(__file__), 'assets', 'KB_asset.blend') + r'\Material', filename='Crushed_Stone', link=False)
        new_data = list(filter(lambda d: not d in before_data, list(bpy.data.materials)))
        appended_436FE = None if not new_data else new_data[0]
        kaboomtree['sna_kb_material_tmp'] = appended_436FE
    inner_mat = kaboomtree['sna_kb_material_tmp']
    ob = object
    if len(ob.data.materials) == 0:
        outer_mat = bpy.data.materials.new(name="Outer_material")
        ob.data.materials.append(outer_mat)
    if len(ob.data.materials) == 1:
        ob.data.materials.append(inner_mat)


def sna_kb_fc_modulo_CE29E(it_deg):
    i_in = it_deg
    i_out = None
    modulo = math.fmod(i_in,20)
    i_out = int(max(1.0, modulo))
    return i_out


def sna_kb_fc_is_from_fracture_group_9321E(Objet, Col_Property):
    obj = Objet
    col_property = Col_Property
    out = None
    kb_group = None
    kb_index = None
    out = False
    for col in obj.users_collection:
        i = 0
        for item in col_property:
            if item.kaboom_col == col:
                out = True
                kb_group = item
                kb_index = i
            i += 1
    #            if not kb_group.is_iteration:
    #                kb_group.is_iteration = False
    #if not obj.rigid_body:
    #    out = False
    return [out, kb_group, kb_index]


class SNA_OT_Kb_Op_Fracture_614C5(bpy.types.Operator):
    bl_idname = "sna.kb_op_fracture_614c5"
    bl_label = "KB_OP_Fracture"
    bl_description = ""
    bl_options = {"REGISTER", "UNDO"}
    sna_iterator: bpy.props.BoolProperty(name='iterator', description='', default=False)
    sna_new_group: bpy.props.BoolProperty(name='new_group', description='', default=True)
    sna_is_from_fracture_group: bpy.props.BoolProperty(name='is_from_fracture_group', description='', default=False)
    sna_is_about_iterator: bpy.props.BoolProperty(name='is_about_iterator', description='', default=False)
    sna_is_new_group_of_multiple: bpy.props.BoolProperty(name='is_new_group_of_multiple', description='', default=False)
    sna_index_src: bpy.props.IntProperty(name='index_src', description='', default=0, subtype='NONE')

    @classmethod
    def poll(cls, context):
        if bpy.app.version >= (3, 0, 0) and False:
            cls.poll_message_set()
        return not False

    def execute(self, context):
        bpy.ops.preferences.addon_disable(module="object_fracture_cell")
        bpy.ops.preferences.addon_enable(module="object_fracture_cell")
        addon_utils.modules(refresh=True)
        loaded_default, loaded_state = addon_utils.check("object_fracture_cell")
        fracture['sna_kb_list_tmp'] = []
        if (len(list(bpy.context.view_layer.objects.selected)) < 1):
            self.report({'ERROR'}, message='Please Select a Mesh Object')
        if (len(list(bpy.context.scene.sna_kb_kaboom_collection)) < 1):
            self.sna_new_group = True
        for i_7EE48 in range(len(bpy.context.view_layer.objects.selected)):
            ob = bpy.context.view_layer.objects.selected[i_7EE48]
            is_from_group = self.sna_is_from_fracture_group
            group_ok = None
            type_ok = None
            if is_from_group:
                kb = bpy.context.scene.sna_kb_kaboom_collection[bpy.context.scene.sna_kb_col_index]
                collection = kb.kaboom_col
                if ob in collection.objects[:]:
                    group_ok = True
            else:
                group_ok = True
            if ob.type == 'MESH':
                type_ok = True
            if (group_ok and type_ok):
                fracture['sna_kb_list_tmp'].append(bpy.context.view_layer.objects.selected[i_7EE48])
        self.sna_is_new_group_of_multiple = (self.sna_new_group and (len(list(bpy.context.view_layer.objects.selected)) > 1))
        for i_A0733 in range(len(fracture['sna_kb_list_tmp'])):
            exec("bpy.ops.object.select_all(action='DESELECT')")
            ob = fracture['sna_kb_list_tmp'][i_A0733]
            ob.select_set(True)
            bpy.context.view_layer.objects.active = ob
            if (i_A0733 > 0):
                self.sna_new_group = False
            if self.sna_is_from_fracture_group:
                pass
            else:
                self.sna_index_src = bpy.context.scene.sna_kb_col_index
            sna_fracture_go_32B98(self.sna_iterator, self.sna_new_group, fracture['sna_kb_list_tmp'][i_A0733], self.sna_is_from_fracture_group, (i_A0733 > 0), self.sna_is_new_group_of_multiple, self.sna_index_src)
        return {"FINISHED"}

    def draw(self, context):
        layout = self.layout
        row_6D045 = layout.row(heading='', align=False)
        row_6D045.alert = False
        row_6D045.enabled = True
        row_6D045.active = True
        row_6D045.use_property_split = False
        row_6D045.use_property_decorate = False
        row_6D045.scale_x = 1.0
        row_6D045.scale_y = 1.0
        row_6D045.alignment = 'Expand'.upper()
        if not True: row_6D045.operator_context = "EXEC_DEFAULT"
        row_6D045.label(text='Fracture now ?', icon_value=0)
        row_6D045.label(text='', icon_value=1)
        if (self.sna_is_from_fracture_group and (not self.sna_is_about_iterator)):
            layout.prop(self, 'sna_new_group', text='New Group', icon_value=93, emboss=True, expand=True, toggle=True)
            if (self.sna_new_group and eval('bpy.context.object.rigid_body') and (len(list(bpy.context.view_layer.objects.selected)) < 2)):
                layout.prop(self, 'sna_iterator', text='As Iterator', icon_value=204, emboss=True, expand=True, toggle=True)
        else:
            if (self.sna_is_about_iterator if self.sna_is_from_fracture_group else False):
                col_94834 = layout.column(heading='', align=False)
                col_94834.alert = False
                col_94834.enabled = True
                col_94834.active = True
                col_94834.use_property_split = False
                col_94834.use_property_decorate = False
                col_94834.scale_x = 1.0
                col_94834.scale_y = 1.0
                col_94834.alignment = 'Expand'.upper()
                if not True: col_94834.operator_context = "EXEC_DEFAULT"
                row_4C2C7 = col_94834.row(heading='', align=False)
                row_4C2C7.alert = False
                row_4C2C7.enabled = False
                row_4C2C7.active = False
                row_4C2C7.use_property_split = False
                row_4C2C7.use_property_decorate = False
                row_4C2C7.scale_x = 1.0
                row_4C2C7.scale_y = 1.0
                row_4C2C7.alignment = 'Expand'.upper()
                if not True: row_4C2C7.operator_context = "EXEC_DEFAULT"
                row_4C2C7.label(text='Is from Iterator Group', icon_value=0)
                row_4C2C7.prop(self, 'sna_new_group', text='New Group', icon_value=93, emboss=True, expand=True, toggle=True)
                row_D31FB = col_94834.row(heading='', align=False)
                row_D31FB.alert = False
                row_D31FB.enabled = False
                row_D31FB.active = False
                row_D31FB.use_property_split = False
                row_D31FB.use_property_decorate = False
                row_D31FB.scale_x = 1.0
                row_D31FB.scale_y = 1.0
                row_D31FB.alignment = 'Expand'.upper()
                if not True: row_D31FB.operator_context = "EXEC_DEFAULT"
                if (len(list(bpy.context.view_layer.objects.selected)) < 2):
                    row_D31FB.prop(self, 'sna_iterator', text='As Iterator', icon_value=204, emboss=True, expand=True, toggle=True)
            else:
                if (len(list(bpy.context.scene.sna_kb_kaboom_collection)) > 0):
                    layout.prop(self, 'sna_new_group', text='New Group', icon_value=93, emboss=True, expand=True, toggle=True)

    def invoke(self, context, event):
        if (len(list(bpy.context.view_layer.objects.selected)) > 0):
            is_from_fracture_group_0_61c7f, kaboom_1_61c7f, index_2_61c7f = sna_kb_fc_is_from_fracture_group_9321E(bpy.context.view_layer.objects.active, bpy.context.scene.sna_kb_kaboom_collection)
            self.sna_is_from_fracture_group = is_from_fracture_group_0_61c7f
            if property_exists("kaboom_1_61c7f.is_iteration", globals(), locals()):
                self.sna_is_about_iterator = kaboom_1_61c7f.is_iteration
            self.sna_new_group = False
            if property_exists("kaboom_1_61c7f.is_iteration", globals(), locals()):
                if kaboom_1_61c7f.is_iteration:
                    self.sna_iterator = True
                    self.sna_new_group = True
                if is_from_fracture_group_0_61c7f:
                    bpy.context.scene.sna_kb_col_index = index_2_61c7f
                    self.sna_index_src = index_2_61c7f
        return context.window_manager.invoke_props_dialog(self, width=200)


class SNA_OT_Kb_Op_Frature_Help_Video_3F307(bpy.types.Operator):
    bl_idname = "sna.kb_op_frature_help_video_3f307"
    bl_label = "KB_OP_Frature_Help_Video"
    bl_description = ""
    bl_options = {"REGISTER", "UNDO"}

    @classmethod
    def poll(cls, context):
        if bpy.app.version >= (3, 0, 0) and False:
            cls.poll_message_set()
        return not False

    def execute(self, context):
        return {"FINISHED"}

    def invoke(self, context, event):
        return self.execute(context)


class SNA_OT_Kb_Op_Delete_Kaboom_Cf826(bpy.types.Operator):
    bl_idname = "sna.kb_op_delete_kaboom_cf826"
    bl_label = "kb_op_delete_kaboom"
    bl_description = ""
    bl_options = {"REGISTER", "UNDO"}
    sna_index: bpy.props.IntProperty(name='index', description='', default=0, subtype='NONE')

    @classmethod
    def poll(cls, context):
        if bpy.app.version >= (3, 0, 0) and False:
            cls.poll_message_set()
        return not False

    def execute(self, context):
        kb_col = list(bpy.context.scene.sna_kb_kaboom_collection)[self.sna_index].kaboom_col
        obj_src = list(bpy.context.scene.sna_kb_kaboom_collection)[self.sna_index].object_src
        is_iterator = list(bpy.context.scene.sna_kb_kaboom_collection)[self.sna_index].is_iteration
        index_col = self.sna_index
        list_ids = None

        def get_recursive_iterator_list(kb, list):    
            for obj in bpy.data.collections[kb.kaboom_col.name].all_objects:
                for kaboom in bpy.context.scene.sna_kb_kaboom_collection:        
                    if obj == kaboom.object_src:
                        get_recursive_iterator_list(kaboom,list)
                        list.append(kaboom.id)

        def get_recursive_id_list(kb, list):
            #for col in bpy.data.collections['KB_fractured_Groups'].children:
            for kaboom in bpy.context.scene.sna_kb_kaboom_collection:
                #if col != kb.kaboom_col:
                if kb.kaboom_col == kaboom.obj_collection_src:
                    get_recursive_id_list(kaboom, list)
                    list.append(kaboom.id)
        list_ids = []
        #get_recursive_iterator_list(bpy.context.scene.sna_kb_kaboom_collection[index_col], list_ids)
        get_recursive_id_list(bpy.context.scene.sna_kb_kaboom_collection[index_col], list_ids)
        list_ids.append(bpy.context.scene.sna_kb_kaboom_collection[index_col].id)
        #bpy.ops.sna.kb_op_delete_kaboom_cf826(sna_index=index)  
        kaboomtree['sna_kb_integer_tmp'] = self.sna_index
        print(str(list_ids))
        for i_62EB7 in range(len(list_ids)):
            index_0_581e2 = sna_kb_fc_kaboom_index_by_id_3F8AD(list_ids[i_62EB7])
            kb_col = list(bpy.context.scene.sna_kb_kaboom_collection)[index_0_581e2].kaboom_col
            obj_src = list(bpy.context.scene.sna_kb_kaboom_collection)[index_0_581e2].object_src
            col_id = list(bpy.context.scene.sna_kb_kaboom_collection)[index_0_581e2].id
            is_iterator = list(bpy.context.scene.sna_kb_kaboom_collection)[index_0_581e2].is_iteration
            obj_col_src = list(bpy.context.scene.sna_kb_kaboom_collection)[index_0_581e2].obj_collection_src
            action_src = list(bpy.context.scene.sna_kb_kaboom_collection)[index_0_581e2].obj_action_src
            is_no_baked = (not list(bpy.context.scene.sna_kb_kaboom_collection)[index_0_581e2].is_baked)
            bpy.ops.object.select_all(action='DESELECT')
            frame = bpy.context.scene.frame_start
            list_src = []
            if is_iterator:    
                try:
                    for f in obj_src.animation_data.action.fcurves:
                        if f.data_path == 'hide_render':
                            frame = f.keyframe_points[-3].co[0]
                except:
                    frame = bpy.context.scene.frame_start
                bpy.context.scene.frame_set(int(frame))
                M = obj_src.matrix_world.copy()
            bpy.context.scene.frame_current = bpy.context.scene.frame_start
            if obj_src:
                list_src = []
                for obj in bpy.data.collections[kb_col.name].all_objects:
                    if obj.type == 'MESH':
                        obj.select_set(True)
                        try:
                            bpy.context.scene.rigidbody_world.collection.objects.unlink(obj)
                        except:
                            print('not in rigibody wold collection')
                bpy.ops.object.delete(use_global=False)
                for n in range(len(bpy.data.collections[kb_col.name]['kb_src_list'])-1):
                    try:
                        list_src.append(bpy.data.objects[bpy.data.collections[kb_col.name]['kb_src_list'][n+1]])
                        bpy.data.objects[bpy.data.collections[kb_col.name]['kb_src_list'][n+1]].select_set(True)
                    except:
                        pass#bpy.data.objects.remove(bpy.data.objects[bpy.data.collections[kb_col.name]['kb_src_list'][n+1]])
                bpy.data.collections.remove( bpy.data.collections[kb_col.name] )
            else:
                for obj in bpy.data.collections[kb_col.name].all_objects:
                    if obj.type == 'MESH':
                        obj.select_set(True)
                        try:
                            bpy.context.scene.rigidbody_world.collection.objects.unlink(obj)
                        except:
                            print('not in rigibody wold collection')
                kb_col.name += '_old'
                try:
                    bpy.data.collections['KB_fractured_Groups'].children.unlink(kb_col)
                    bpy.context.scene.collection.children.link( kb_col )
                except:
                    print('No KB_fractured_Groups collection found')
            try:
                for o in list_src:
                    o.hide_viewport = False
                    o.hide_render = False
                    o.select_set(True)
                    bpy.context.view_layer.objects.active = o
            except:
                None
            try:
                for ob in bpy.data.collections['KB_Constraints'].objects:
                    if (col_id + '_KB_Link') in ob.name:
                        bpy.data.objects.remove(ob)
            except:
                print('No constraint found')
            #bpy.data.collections[col_name].objects
            if is_iterator:
                obj_src.animation_data_clear()
                obj_src.animation_data_create()
                obj_src.hide_render =  False
                obj_src.hide_viewport = False
                obj_src.display_type = 'TEXTURED'
                rg_obs = bpy.context.scene.rigidbody_world.collection.objects[:]
                bpy.context.scene.rigidbody_world.collection = bpy.data.collections.new( 'RB_World' )    
                bpy.ops.outliner.orphans_purge(do_recursive=True)
                for o in rg_obs:
                    bpy.context.scene.rigidbody_world.collection.objects.link(o)
                obj_src.select_set(True)
                bpy.context.view_layer.objects.active = obj_src
                bpy.ops.rigidbody.object_add()
                obj_src.animation_data.action = action_src
                obj_copain = next(ob for ob in obj_col_src.objects if ob != obj_src)
                if obj_copain.parent != obj_src:
                    obj_src.parent = obj_copain.parent   
                bpy.context.scene.frame_set(int(frame)) 
                obj_src.matrix_world = M
                if is_no_baked:
                    bpy.data.objects.remove(bpy.data.objects[obj_src.name + '_KB_rigidbody_collision'])
            index_0_ed3c8 = sna_kb_fc_kaboom_index_by_id_3F8AD(list_ids[i_62EB7])
            if len(bpy.context.scene.sna_kb_kaboom_collection) > index_0_ed3c8:
                bpy.context.scene.sna_kb_kaboom_collection.remove(index_0_ed3c8)
            bpy.context.scene.sna_kb_col_index = (0 if (int(index_0_ed3c8 - 1.0) < 0) else int(index_0_ed3c8 - 1.0))
        return {"FINISHED"}

    def invoke(self, context, event):
        return self.execute(context)


class SNA_OT_Kb_Op_Bake_D6841(bpy.types.Operator):
    bl_idname = "sna.kb_op_bake_d6841"
    bl_label = "KB_OP_Bake"
    bl_description = ""
    bl_options = {"REGISTER", "UNDO"}
    sna_index: bpy.props.IntProperty(name='index', description='', default=0, subtype='NONE')

    @classmethod
    def poll(cls, context):
        if bpy.app.version >= (3, 0, 0) and False:
            cls.poll_message_set()
        return not False

    def execute(self, context):
        out = None
        out = False
        if bpy.context.scene.rigidbody_world:
            out = True
        if out:
            bpy.context.scene.frame_current = (bpy.context.window_manager.sna_kb_custom_f_start if bpy.context.window_manager.sna_kb_custom_range_bool else bpy.context.scene.rigidbody_world.point_cache.frame_start)
            f_start = (bpy.context.window_manager.sna_kb_custom_f_start if bpy.context.window_manager.sna_kb_custom_range_bool else bpy.context.scene.rigidbody_world.point_cache.frame_start)
            f_end = (bpy.context.window_manager.sna_kb_custom_f_end if bpy.context.window_manager.sna_kb_custom_range_bool else bpy.context.scene.rigidbody_world.point_cache.frame_end)
            ###########  LA FONCTION VELOCITY #######

            def velocity(obj, frame):
                try:
                    D = 0
                    for curve in [c for c in obj.animation_data.action.fcurves if c.data_path.endswith( 'location' )]:
                        delta = curve.evaluate(frame) - curve.evaluate(frame - 1)
                        D += delta*delta
                    return sqrt(D)*bpy.context.scene.render.fps      
                except:
                    return 'NO'
            #################################
            ###########  LA FONCTION ACCELERATION #######

            def acceleration(obj, frame):
                try:
                    return velocity(obj, frame) - velocity(obj, frame-1)
                except:
                    return 'NO'
            #################################
            print('Initilizing for baking...')
            self.report({'INFO'}, message='Initilizing for baking...')
            list_selected = []
            ok =  False
            bpy.ops.object.select_all(action='DESELECT')
            bpy.context.scene.rigidbody_world.enabled = True
            bpy.context.view_layer.update()
            bpy.context.scene.frame_set(f_start)
            print('Start baking dynamic...')
            self.report({'INFO'}, message='Start baking dynamic...') 
            bpy.ops.ptcache.bake_all(bake=True)
            print('Baking dynamic finished !')
            self.report({'INFO'}, message='Baking dynamic finished !') 
            list_ob_collision_to_remove = []
            for item in bpy.context.scene.sna_kb_kaboom_collection:
                if not item.is_baked:
                    ok = True
                    collection = bpy.data.collections[item.kaboom_col.name]
                    for o in collection.objects:
                        if '_KB_rigidbody_collision' in o.name:
                            list_ob_collision_to_remove.append(o)
                        if o.type == 'MESH':
                            list_selected.append(o)
                            o.select_set(True)
                            #bpy.context.view_layer.objects.active = o
            bpy.context.scene.frame_set(f_end)
            for item in bpy.context.scene.sna_kb_kaboom_collection:
                if not item.is_baked:
                    collection = bpy.data.collections[item.kaboom_col.name]
                    for o in collection.objects:
                        if o.type == 'MESH':
                            o.select_set(True)
                            if o not in list_selected:
                                list_selected.append(o)
                            #bpy.context.view_layer.objects.active = o
            if ok:
                print('Start baking actions...')
                self.report({'INFO'}, message='Start baking actions...')          
                bpy.ops.nla.bake(frame_start=f_start, frame_end=f_end, use_current_action=True, visual_keying=True, clear_parents=True, bake_types={'OBJECT'})    
                print('Baking actions finished !')
                self.report({'INFO'}, message='Baking actions finished !')
                print('Calculting Velocities...')
                self.report({'INFO'}, message='Calculting Velocities...')
                for o in list_selected:
                    o.hide_viewport = False
                    o.sna_kb_shard_velocity = 0
                    o.keyframe_insert('sna_kb_shard_velocity',frame = f_start)
                    o.sna_kb_shard_acceleration = 0
                    o.keyframe_insert('sna_kb_shard_acceleration',frame = f_start)
                    o.sna_kb_shard_real_acceleration = 0
                    o.keyframe_insert('sna_kb_shard_real_acceleration',frame = f_start)
                    fcu_index = 0
                    i = 0
                    for fcu in o.animation_data.action.fcurves:
                        if fcu.data_path == 'sna_kb_shard_real_acceleration':
                            fcu_index = i
                        i += 1
                    for f in range(f_start+1,f_end+1):
                        print('frame =',f)
                        veloc = velocity(o,f)
                        acc = acceleration(o,f)
                        print('veloc =',veloc)
                        if veloc != 'NO':
                            o.sna_kb_shard_velocity = veloc
                            o.keyframe_insert('sna_kb_shard_velocity',frame = f)
                            print('insert key veloc')
                        if acc != 'NO':
                            o.sna_kb_shard_real_acceleration = acc
                            o.keyframe_insert('sna_kb_shard_real_acceleration',frame = f)
                            o.sna_kb_shard_acceleration = max(0,abs(acc) - abs(o.animation_data.action.fcurves[fcu_index].evaluate(f-1)))
                            o.keyframe_insert('sna_kb_shard_acceleration',frame = f)
                            print('insert key acc')
            ###### clean kinematic fcurve
            #        for fcu in o.animation_data.action.fcurves:
            #            print('fcurve:',fcu.data_path)
            #            if fcu.data_path in ['rigid_body.kinematic','rigid_body.collision_collections']:
            #                o.animation_data.action.fcurves.remove(fcu)
            #############################
                for o in list_selected:
                    o.select_set(True)
                for o in bpy.context.selected_objects:
                    if o.rigid_body:
                        bpy.context.view_layer.objects.active = o
                        print(o.name,' is active now')
                        break    
                bpy.ops.rigidbody.objects_remove()
                try:
                    RG_Constraints_Col = bpy.context.scene.rigidbody_world.constraints
                    for o in RG_Constraints_Col.objects:
                          if 'KB_Link' in o.name:
                              RG_Constraints_Col.objects.unlink(o)
                              bpy.data.objects.remove(o)
                except:
                    print('No constraint')
                #bpy.context.scene.rigidbody_world.enabled = False
                for o_collisions in list_ob_collision_to_remove:
                    bpy.data.objects.remove(o_collisions)
                #bpy.context.scene.frame_set(f_start)
                bpy.ops.object.select_all(action='DESELECT')
                print('Remove Constraints...') 
                self.report({'INFO'}, message='Remove Constraints...')
            else:
                self.report({'ERROR'}, message='No fractured available for baking...') 
            bpy.ops.sna.kb_op_reset_rigid_body_world_88fc2('INVOKE_DEFAULT', )
            for i_6462F in range(len(bpy.context.scene.sna_kb_kaboom_collection)):
                bpy.context.scene.sna_kb_kaboom_collection[i_6462F].is_baked = True
                bpy.context.scene.sna_kb_kaboom_collection[i_6462F].has_constraints = False
        else:
            self.report({'ERROR'}, message='No Rigid Body World in the Scene')
        return {"FINISHED"}

    def invoke(self, context, event):
        return self.execute(context)


class SNA_OT_Kb_Op_Delete_Bake_146D2(bpy.types.Operator):
    bl_idname = "sna.kb_op_delete_bake_146d2"
    bl_label = "KB_OP_Delete_Bake"
    bl_description = ""
    bl_options = {"REGISTER", "UNDO"}

    @classmethod
    def poll(cls, context):
        if bpy.app.version >= (3, 0, 0) and False:
            cls.poll_message_set()
        return not False

    def execute(self, context):
        bpy.context.scene.frame_current = (bpy.context.window_manager.sna_kb_custom_f_start if bpy.context.window_manager.sna_kb_custom_range_bool else bpy.context.scene.frame_start)
        for i_832BA in range(len(bpy.context.scene.sna_kb_kaboom_collection)):
            kb_col = bpy.context.scene.sna_kb_kaboom_collection[i_832BA].kaboom_col
            bpy.ops.object.select_all(action='DESELECT')
            bpy.context.scene.rigidbody_world.enabled = False  
            collection = bpy.data.collections[kb_col.name]
            for o in collection.objects:
                no_src = True
                for kb in bpy.context.scene.sna_kb_kaboom_collection:
                    if o == kb.object_src:
                        no_src = False
                if o.animation_data and o.animation_data.action and no_src:
                    all_fcurves = o.animation_data.action.fcurves
                    for fcurve in all_fcurves:
                        if fcurve.data_path not in ['display_type', 'hide_viewport','hide_render','rigid_body.collision_collections']:
                            all_fcurves.remove(fcurve)
                #o.animation_data_clear()
            bpy.context.scene.rigidbody_world.enabled = True  
            kb_col = bpy.context.scene.sna_kb_kaboom_collection[i_832BA].kaboom_col
            wm = bpy.context.window_manager
            collection = bpy.data.collections[kb_col.name]
            for o in collection.all_objects:    
                for m in o.modifiers:
                    o.select_set(True)
                    bpy.context.view_layer.objects.active = o
                    bpy.ops.object.modifier_remove('INVOKE_DEFAULT',modifier=m.name)
            bpy.context.scene.sna_kb_kaboom_collection[i_832BA].is_baked = False
            bpy.context.scene.sna_kb_kaboom_collection[i_832BA].has_debris = False
            bpy.context.scene.sna_kb_kaboom_collection[i_832BA].has_smoke = False
            exec('bpy.ops.screen.animation_play()')
        return {"FINISHED"}

    def invoke(self, context, event):
        return self.execute(context)


class SNA_OT_Kb_Op_Clean_Project_Ddaf5(bpy.types.Operator):
    bl_idname = "sna.kb_op_clean_project_ddaf5"
    bl_label = "KB_OP_CLEAN_PROJECT"
    bl_description = ""
    bl_options = {"REGISTER", "UNDO"}

    @classmethod
    def poll(cls, context):
        if bpy.app.version >= (3, 0, 0) and False:
            cls.poll_message_set()
        return not False

    def execute(self, context):
        kb_kaboum_col = bpy.context.scene.sna_kb_kaboom_collection
        list_obj = []
        for kb in kb_kaboum_col:
            if kb.is_baked:
                for o in kb.kaboom_col.objects[:]:
                    list_obj.append(o)
                    print(o.name)
        for o in list_obj:
            try:        
                if len(o.modifiers['noisy_inner'].node_group.animation_data.drivers) > 0:
                    # stock drivers values
                    shape = o.modifiers['noisy_inner'].node_group.path_resolve('nodes["shape"].outputs[0].default_value')
                    render = o.modifiers['noisy_inner'].node_group.path_resolve('nodes["Boolean Render"].inputs[1].default_value')
                    viewport = o.modifiers['noisy_inner'].node_group.path_resolve('nodes["Boolean Viewport"].inputs[1].default_value')
                    level = o.modifiers['noisy_inner'].node_group.path_resolve('nodes["level"].integer')
                    amount = o.modifiers['noisy_inner'].node_group.path_resolve('nodes["amount"].outputs[0].default_value')
                    size = o.modifiers['noisy_inner'].node_group.path_resolve('nodes["size"].outputs[0].default_value')
                    # delete drivers
                    for d in o.modifiers['noisy_inner'].node_group.animation_data.drivers:
                        o.modifiers['noisy_inner'].node_group.animation_data.drivers.remove(d)
                    # set values
                    o.modifiers['noisy_inner'].node_group.nodes["shape"].outputs[0] = shape
                    o.modifiers['noisy_inner'].node_group.nodes["Boolean Render"].inputs[1] = render
                    o.modifiers['noisy_inner'].node_group.nodes["Boolean Viewport"].inputs[1] = viewport
                    o.modifiers['noisy_inner'].node_group.nodes["level"] = level
                    o.modifiers['noisy_inner'].node_group.nodes["amount"].outputs[0] = amount
                    o.modifiers['noisy_inner'].node_group.nodes["size"].outputs[0] = size
            except:
                print('no rough cut geo node')        
            try:    
                # stock drivers values
                switch = o.path_resolve('modifiers["noisy_inner"]["Input_12"]')
                ratio = o.path_resolve('modifiers["noisy_inner_decimate"].ratio')
                # delete drivers
                for d in o.animation_data.drivers:
                    o.animation_data.drivers.remove(d)
                # set values
                o.modifiers["noisy_inner"]["Input_12"] = swith
                o.modifiers["noisy_inner_decimate"].ratio = ratio
            except:
                print('no rough cut modifiers')
        kb_kaboum_col = bpy.context.scene.sna_kb_kaboom_collection

        def remove_kb(kb_col, id):
            index = 0
            for kb in kb_col:
                if kb.id == id:
                    kb_col.remove(index)
                    index += 1
        list_to_remove = []
        for kb in kb_kaboum_col:    
            ###### clean kinematic fcurve
            if kb.is_baked:
                for o in kb.kaboom_col.objects[:]:
                    try:        
                        for fcu in o.animation_data.action.fcurves:
                            if fcu.data_path in ['rigid_body.kinematic','rigid_body.collision_collections']:
                                o.animation_data.action.fcurves.remove(fcu)
                    except:
                        print('pb with ' + o.name)
            ############################
                    if kb.is_noisy_inner:
                        try:
                            o.driver_remove('modifiers["kb_subdive"].levels',-1)
                            o.modifiers["kb_subdive"].levels = kb.noisy_inner_level
                            o.driver_remove('modifiers["kb_subdive"].render_levels',-1)
                            o.modifiers["kb_subdive"].render_levels = kb.noisy_inner_level
                            o.driver_remove('modifiers["kb_disp"].strength',-1)
                            o.modifiers["kb_disp"].strength = kb.noisy_inner_amount
                            o.driver_remove('modifiers["kb_decimate"].ratio',-1)
                            o.modifiers["kb_decimate"].ratio = kb.noisy_inner_decimate
                        except:
                            pass
            ############################  
            list_to_remove.append(kb.id)
        for id in list_to_remove:
            remove_kb(kb_kaboum_col, id)
        try:
            bpy.data.objects.remove(bpy.data.objects['WreckingBallOuter-KrumblR'])
        except:
            print('No Blaster in the Scene')
        if bpy.context.scene.rigidbody_world:
            bpy.ops.rigidbody.world_remove()
        bpy.ops.outliner.orphans_purge(do_recursive=True)
        return {"FINISHED"}

    def invoke(self, context, event):
        return self.execute(context)


class SNA_PT_KABOOM_21D12(bpy.types.Panel):
    bl_label = 'Kaboom'
    bl_idname = 'SNA_PT_KABOOM_21D12'
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_context = ''
    bl_category = 'FRACTURE'
    bl_order = 0
    bl_ui_units_x=0

    @classmethod
    def poll(cls, context):
        return not (False)

    def draw_header(self, context):
        layout = self.layout

    def draw(self, context):
        layout = self.layout
        op = layout.operator('sna.kb_op_clean_project_ddaf5', text='Clean Project', icon_value=182, emboss=True, depress=False)


@persistent
def load_pre_handler_0601A(dummy):
    bpy.context.window_manager.sna_kb_fracture_mode = eval("{'Own particles'}")
    bpy.context.scene.sna_kb_lock_bake_flag = True


@persistent
def frame_change_pre_handler_32C97(dummy):
    bpy.context.scene.sna_kb_lock_bake_flag = True


def sna_kb_fc_test_if_object_is_iterator_6E7F8(objects):
    ob_list = objects
    out = None
    out = True
    for ob in ob_list:
        for kb in bpy.context.scene.sna_kb_kaboom_collection:
            if ob in kb.kaboom_col.objects[:] and kb.is_iteration:
                out =False
            if ob == kb.object_src:
                out = False
    return out


def sna_kb_fc_find_last_col_index_DCB11():
    col = bpy.context.scene.sna_kb_kaboom_collection
    last_indice = None
    len_col = len(col)
    if len_col > 0:
        last_indice = int(len_col - 1)
    else:
        last_indice = 0
    return last_indice


class SNA_OT_Kb_Op_Add_Group_From_Selection_17Be0(bpy.types.Operator):
    bl_idname = "sna.kb_op_add_group_from_selection_17be0"
    bl_label = "KB_OP_Add_Group_From_Selection"
    bl_description = ""
    bl_options = {"REGISTER", "UNDO"}

    @classmethod
    def poll(cls, context):
        if bpy.app.version >= (3, 0, 0) and False:
            cls.poll_message_set()
        return not False

    def execute(self, context):
        if sna_kb_fc_test_if_object_is_iterator_6E7F8(list(bpy.context.view_layer.objects.selected)):
            #wm = bpy.context.window_manager
            #collection = bpy.data.collections[kb_col.name]
            list_obj = []
            for ob in bpy.context.selected_objects:
                if ob.name[-2:] == '_I':
                    ob.select_set(False)
            list_obj = bpy.context.selected_objects
            for ob in list_obj:
                if ob.name[-2:] == '_O':
                    bpy.ops.object.select_all(action='DESELECT')
                    ob.name = ob.name[:-2]
                    ob.select_set(True)    
                    bpy.context.view_layer.objects.active = ob
                    try:
                        bpy.data.objects[ob.name + '_I'].select_set(True)
                        bpy.ops.object.join()
                    except:
                        pass
            for ob in list_obj:
                ob.select_set(True)
            ob_list = bpy.context.view_layer.objects.selected
            tex_space_loc = None
            tex_space_scale = None
            if len(bpy.context.scene.sna_kb_kaboom_collection)>0:
                for ob in ob_list:
                    for kb in bpy.context.scene.sna_kb_kaboom_collection:
                        if ob in kb.kaboom_col.objects[:]:
                            tex_space_loc = kb.tex_space_loc
                            tex_space_scale = kb.tex_space_scale
                        else:
                            tex_space_loc = ob_list[0].matrix_world.translation
                            tex_space_scale = ob_list[0].data.texspace_size
            else:
                tex_space_loc = ob_list[0].matrix_world.translation
                tex_space_scale = ob_list[0].data.texspace_size
            size = 4
            out = None
            out = f'{random.randrange(16**size):x}'
            kaboomtree['sna_kb_string_tmp'] = 'Fracture_Group_' + out
            print('Fracture_Group_' + out)
            exec('bpy.context.scene.frame_set(bpy.context.scene.frame_start)')
            collection_name = 'Fracture_Group_' + out
            out = None

            def traverse_tree(t):
                yield t
                for child in t.children:
                    yield from traverse_tree(child)

            def parent_lookup(coll):
                parent_lookup = {}
                for coll in traverse_tree(coll):
                    for c in coll.children.keys():
                        parent_lookup.setdefault(c, coll)
                return parent_lookup
            out = ''
            i = 0
            list_full_selection=[]
            sel = bpy.context.selected_objects 
            for ob in sel:
                if ob.type == 'MESH':
                    list_full_selection.append(ob)
            col_name_list = []
            if bpy.context.scene.rigidbody_world:
                if not bpy.context.scene.rigidbody_world.collection:
                    RB_World_collection = bpy.data.collections.new( 'RB_World' )
                    bpy.context.scene.rigidbody_world.collection = RB_World_collection
                col_name_list.append(bpy.context.scene.rigidbody_world.collection.name)
            for ob in list_full_selection:
                name_list = col_name_list.copy()
                object_old_coll = ob.users_collection
                collection = bpy.data.collections.get( collection_name )
                name_list.append(collection_name)
                if collection not in object_old_coll:
                    if collection is None:
                        collection = bpy.data.collections.new( collection_name )
                        bpy.context.scene.collection.children.link( collection )
                collection.objects.link( ob )
                for col in  object_old_coll:   
                    if col.name not in name_list:#!= collection_name and col.name != bpy.context.scene.rigidbody_world.collection.name:
                        col.objects.unlink(ob)
            ############################################################### move collection
            new_collection = collection
            C = bpy.context
            coll_scene = C.scene.collection
            coll_parents = parent_lookup(coll_scene)
            # test si "KB_fractured_Groups" collection existe, sinon la créer
            if not(coll_scene.children.get("KB_fractured_Groups")):
                col_gps = bpy.data.collections.new( 'KB_fractured_Groups' )
                bpy.context.scene.collection.children.link( col_gps )
            # Get collection references
            coll_target = coll_scene.children.get("KB_fractured_Groups")
            active_coll = new_collection#C.view_layer.active_layer_collection.collection
            # Get parent of *active_coll*
            active_coll_parent = coll_parents.get(active_coll.name)
            if active_coll_parent:
                # Unlink *active_coll*
                active_coll_parent.children.unlink(active_coll)
                # Link *active_coll* to *coll_target*
                coll_target.children.link(active_coll)
            ##############################################################################
            print(out)
            item_86F02 = bpy.context.scene.sna_kb_kaboom_collection.add()
            item_86F02.kaboom_col = bpy.data.collections[kaboomtree['sna_kb_string_tmp']]
            print(kaboomtree['sna_kb_string_tmp'][int(len(kaboomtree['sna_kb_string_tmp']) - 4.0):])
            item_86F02.id = kaboomtree['sna_kb_string_tmp'][int(len(kaboomtree['sna_kb_string_tmp']) - 4.0):]
            bpy.context.scene.sna_kb_col_index = sna_kb_fc_find_last_col_index_DCB11()
            item_86F02.tex_space_loc = tex_space_loc
            item_86F02.tex_space_scale = tex_space_scale
        else:
            self.report({'ERROR'}, message='Some Objects Are Iterator Implicated')
        return {"FINISHED"}

    def invoke(self, context, event):
        return self.execute(context)


def sna_kb_fc_kaboom_index_by_id_3F8AD(id):
    id_col = id
    index_col = None
    for i in range(len(bpy.context.scene.sna_kb_kaboom_collection)):
        if bpy.context.scene.sna_kb_kaboom_collection[i].id == id_col:
            index_col = i
            #next(kb for kb in bpy.context.scene.sna_kb_kaboom_collection if kb.id == id_col)
    return index_col


class SNA_OT_Kb_Op_Select_Kaboom_Parts_D8203(bpy.types.Operator):
    bl_idname = "sna.kb_op_select_kaboom_parts_d8203"
    bl_label = "kb_op_select_kaboom_parts"
    bl_description = ""
    bl_options = {"REGISTER", "UNDO"}
    sna_index: bpy.props.IntProperty(name='index', description='', default=0, subtype='NONE')

    @classmethod
    def poll(cls, context):
        if bpy.app.version >= (3, 0, 0) and False:
            cls.poll_message_set()
        return not False

    def execute(self, context):
        kb_col = list(bpy.context.scene.sna_kb_kaboom_collection)[self.sna_index].kaboom_col
        hidden = None
        hidden = False
        bpy.ops.object.select_all(action='DESELECT')
        for obj in bpy.data.collections[kb_col.name].all_objects:
            if obj.hide_viewport == False:
                obj.select_set(True)
        if len(bpy.context.selected_objects) > 0:
            bpy.context.view_layer.objects.active = bpy.context.selected_objects[0]
        else:
            hidden = True
        #bpy.data.collections[col_name].objects
        if hidden:
            self.report({'ERROR'}, message='Shards Are Hidden')
        else:
            bpy.context.scene.sna_kb_col_index = self.sna_index
        return {"FINISHED"}

    def invoke(self, context, event):
        return self.execute(context)


class SNA_OT_Kb_Op_Select_Dynamic_Shards_150Ec(bpy.types.Operator):
    bl_idname = "sna.kb_op_select_dynamic_shards_150ec"
    bl_label = "KB_OP_Select_dynamic_shards"
    bl_description = "Select Moved Dynamic Shards"
    bl_options = {"REGISTER", "UNDO"}
    sna_dynamic: bpy.props.BoolProperty(name='dynamic', description='', default=False)
    sna_extend_selection: bpy.props.BoolProperty(name='extend selection', description='', default=False)

    @classmethod
    def poll(cls, context):
        if bpy.app.version >= (3, 0, 0) and False:
            cls.poll_message_set()
        return not False

    def execute(self, context):
        kb_col = list(bpy.context.scene.sna_kb_kaboom_collection)[bpy.context.scene.sna_kb_col_index].kaboom_col
        dynamic = self.sna_dynamic
        extend = self.sna_extend_selection
        if extend:
            pass
        else:
            bpy.ops.object.select_all(action='DESELECT')
        for obj in bpy.data.collections[kb_col.name].all_objects:
            if obj.animation_data:
                for f in obj.animation_data.action.fcurves:
                    if f.data_path == 'rigid_body.kinematic':
                        if dynamic:
                            if f.evaluate(bpy.context.scene.frame_current) == 0.0:
                                obj.select_set(True)
                        else:
                            if f.evaluate(bpy.context.scene.frame_current) == 1.0:
                                obj.select_set(True)
        if len(bpy.context.selected_objects) > 0:
            bpy.context.view_layer.objects.active = bpy.context.selected_objects[0]
        #bpy.data.collections[col_name].objects
        return {"FINISHED"}

    def invoke(self, context, event):
        return self.execute(context)


def sna_fu_test_if_active_group_is_not_baked_A638D():
    kb_col = bpy.context.scene.sna_kb_kaboom_collection
    kb_index = bpy.context.scene.sna_kb_col_index
    out = None
    out = False
    if len(kb_col)>0:
        out = not (kb_col[kb_index].is_baked)
    return out


_95AF5_running = False
class SNA_OT_Modop_Kb_Enable_Rough_Cut_95Af5(bpy.types.Operator):
    bl_idname = "sna.modop_kb_enable_rough_cut_95af5"
    bl_label = "MODOP_KB_Enable_Rough_Cut"
    bl_description = ""
    bl_options = {"REGISTER", "UNDO"}
    sna_nb_obj: bpy.props.IntProperty(name='nb_obj', description='', default=0, subtype='NONE')
    sna_i: bpy.props.IntProperty(name='i', description='', default=0, subtype='NONE')
    sna_kb_i: bpy.props.IntProperty(name='kb_i', description='', default=0, subtype='NONE')
    sna_id: bpy.props.StringProperty(name='id', description='', default='', subtype='NONE', maxlen=0)
    cursor = "STOP"
    _handle = None
    _event = {}

    @classmethod
    def poll(cls, context):
        if bpy.app.version >= (3, 0, 0) and False:
            cls.poll_message_set()
        if not False or context.area.spaces[0].bl_rna.identifier == 'SpaceView3D':
            return not False
        return False

    def save_event(self, event):
        event_options = ["type", "value", "alt", "shift", "ctrl", "oskey", "mouse_region_x", "mouse_region_y", "mouse_x", "mouse_y", "pressure", "tilt"]
        if bpy.app.version >= (3, 2, 1):
            event_options += ["type_prev", "value_prev"]
        for option in event_options: self._event[option] = getattr(event, option)

    def draw_callback_px(self, context):
        event = self._event
        if event.keys():
            event = dotdict(event)
            try:
                pass
            except Exception as error:
                print(error)

    def execute(self, context):
        global _95AF5_running
        _95AF5_running = False
        context.window.cursor_set("DEFAULT")
        list(bpy.context.scene.sna_kb_kaboom_collection)[self.sna_kb_i].is_noisy_inner = True
        bpy.context.scene.sna_kb_progress_percent = 0.0
        list(bpy.context.scene.sna_kb_kaboom_collection)[self.sna_kb_i].noisy_inner_show_view = True
        exec('bpy.context.view_layer.objects.update()')
        for area in context.screen.areas:
            area.tag_redraw()
        return {"FINISHED"}

    def modal(self, context, event):
        global _95AF5_running
        if not context.area or not _95AF5_running:
            self.execute(context)
            return {'CANCELLED'}
        self.save_event(event)
        context.window.cursor_set('STOP')
        try:
            if (self.sna_i < self.sna_nb_obj):
                id = self.sna_id
                kb_index = self.sna_kb_i
                iterator = list(bpy.context.scene.sna_kb_kaboom_collection)[self.sna_kb_i].is_iteration
                ob = noisy_innerrough_cut['sna_objects_list'][self.sna_i]
                if ob.type == 'MESH':
                    ob.hide_viewport = False
                    bpy.ops.object.select_all(action='DESELECT')
                    name = id + '_frag_' + f'{random.randrange(16**4):x}'
                    ob.name = name
                    ob.select_set(True)
                    bpy.context.view_layer.objects.active = ob
                    bpy.ops.object.editmode_toggle()
                    bpy.ops.mesh.select_mode(use_extend=False, use_expand=False, type='FACE')
                    bpy.ops.mesh.select_all(action='DESELECT')
                    ######################### méthode bmesh
                    me  = ob.data
                    bm = bmesh.from_edit_mesh(me)        
                    selection = False
                    for face in bm.faces:    
                        if face.material_index == 0:
                            face.select_set(True)
                            bm.faces.active = face
                            selection = True
                    ###################### methode oprtaor
                    #bpy.context.object.active_material_index = 0
                    #bpy.ops.object.material_slot_select()
                    #selection = False
                    #for p in ob.data.polygons:
                    #    if p.select == True:
                    #        selection = True
                    #########################################
                    #bpy.context.view_layer.update()
                    if selection:
                        bpy.context.view_layer.update()
                        bpy.ops.mesh.separate(type = 'SELECTED')
                        bpy.ops.mesh.select_all(action='SELECT')
                        bpy.ops.mesh.vert_connect_concave()
                        bpy.ops.object.editmode_toggle()
                        ob.name = name + '_I'
                        outer = bpy.context.selected_objects[1]
                        outer.name = name + '_O'
                        bpy.ops.object.select_all(action='DESELECT')
                        ob.select_set(True)
                        bpy.context.view_layer.objects.active = ob
                        try:
                            for m in outer.modifiers:
                                if 'Debris_' in m.name:
                                    outer.modifiers.remove(m)
                        except:
                            pass
                        try:
                            outer.modifiers.remove(outer.modifiers['Fluid'])
                        except:
                            pass      
                    else:
                        bpy.ops.object.editmode_toggle()
                        ob.name = name + '_I'
                    if iterator:
                        try:
                            bpy.ops.object.editmode_toggle()
                            bpy.ops.mesh.select_mode(use_extend=False, use_expand=False, type='VERT')
                            bpy.ops.mesh.select_all(action='DESELECT')
                            bpy.ops.mesh.select_non_manifold()
                            bpy.ops.mesh.select_all(action='INVERT')
                            v_data = []
                            me  = ob.data
                            bm = bmesh.from_edit_mesh(me)        
                            selection = False
                            for v in bm.verts:    
                                print('v.select = ',v.select)
                                if v.select:
                                    print('v.index = ',v.index)
                                    v_data.append(v.index)
                            bpy.ops.object.editmode_toggle()
                            ob.vertex_groups['Interior'].add( v_data, 1.0, 'ADD' )
                            print('v_data = ',v_data)       
                        except:
                            pass
                    subdive_mod = ob.modifiers.new(('kb_subdive'),'SUBSURF')
                    subdive_mod.subdivision_type = 'SIMPLE'
                    levelv_driver = subdive_mod.driver_add('levels')
                    levelv_driver.driver.type='SCRIPTED'
                    levelv_var = levelv_driver.driver.variables.new()
                    levelv_var.name = 'levelv'
                    levelv_var.targets[0].id_type = 'SCENE'
                    levelv_var.targets[0].id = bpy.context.scene
                    levelv_var.targets[0].data_path = 'sna_kb_kaboom_collection[' + str(kb_index) + '].noisy_inner_level'
                    view_var = levelv_driver.driver.variables.new()
                    view_var.name = 'view'
                    view_var.targets[0].id_type = 'SCENE'
                    view_var.targets[0].id = bpy.context.scene
                    view_var.targets[0].data_path = 'sna_kb_kaboom_collection[' + str(kb_index) + '].noisy_inner_show_view'
                    levelv_driver.driver.expression = 'levelv * view'
                    levelr_driver = subdive_mod.driver_add('render_levels')
                    levelr_driver.driver.type='SCRIPTED'
                    levelr_var = levelr_driver.driver.variables.new()
                    levelr_var.name = 'levelr'
                    levelr_var.targets[0].id_type = 'SCENE'
                    levelr_var.targets[0].id = bpy.context.scene
                    levelr_var.targets[0].data_path = 'sna_kb_kaboom_collection[' + str(kb_index) + '].noisy_inner_level'
                    render_var = levelr_driver.driver.variables.new()
                    render_var.name = 'render'
                    render_var.targets[0].id_type = 'SCENE'
                    render_var.targets[0].id = bpy.context.scene
                    render_var.targets[0].data_path = 'sna_kb_kaboom_collection[' + str(kb_index) + '].noisy_inner_hide_render'
                    levelr_driver.driver.expression = 'levelr*render'
                    if selection:
                        edit_weight_mod = ob.modifiers.new(('kb_w_edit'),'VERTEX_WEIGHT_EDIT')
                        edit_weight_mod.vertex_group = 'Interior'
                        edit_weight_mod.use_add = True
                        edit_weight_mod.default_weight = 1.0
                        proximity_weight_mod = ob.modifiers.new(('kb_w_proximity'),'VERTEX_WEIGHT_PROXIMITY')
                        proximity_weight_mod.vertex_group = 'Interior'
                        proximity_weight_mod.target = outer
                        proximity_weight_mod.proximity_mode = 'GEOMETRY'
                        proximity_weight_mod.proximity_geometry = {'EDGE'}
                        proximity_weight_mod.falloff_type = 'ICON_SPHERECURVE'
                    displace_mod = ob.modifiers.new(('kb_disp'),'DISPLACE')
                    displace_mod.texture = bpy.data.textures['tex_' + id]
                    displace_mod.strength = 1.2
                    displace_mod.vertex_group = 'Interior'
                    disp_driver = displace_mod.driver_add('strength')
                    disp_driver.driver.type='SCRIPTED'
                    disp_var = disp_driver.driver.variables.new()
                    disp_var.name = 'displace'
                    disp_var.targets[0].id_type = 'SCENE'
                    disp_var.targets[0].id = bpy.context.scene
                    disp_var.targets[0].data_path = 'sna_kb_kaboom_collection[' + str(kb_index) + '].noisy_inner_amount'
                    view_var = disp_driver.driver.variables.new()
                    view_var.name = 'view'
                    view_var.targets[0].id_type = 'SCENE'
                    view_var.targets[0].id = bpy.context.scene
                    view_var.targets[0].data_path = 'sna_kb_kaboom_collection[' + str(kb_index) + '].noisy_inner_show_view'
                    render_var = disp_driver.driver.variables.new()
                    render_var.name = 'render'
                    render_var.targets[0].id_type = 'SCENE'
                    render_var.targets[0].id = bpy.context.scene
                    render_var.targets[0].data_path = 'sna_kb_is_rendering'
                    disp_driver.driver.expression = 'displace * (max(view,render))'
                    decimate_mod = ob.modifiers.new(('kb_decimate'),'DECIMATE')
                    decimate_mod.ratio = .08
                    decimate_driver = decimate_mod.driver_add('ratio')
                    decimate_driver.driver.type='SCRIPTED'
                    decimate_var = decimate_driver.driver.variables.new()
                    decimate_var.name = 'decimate'
                    decimate_var.targets[0].id_type = 'SCENE'
                    decimate_var.targets[0].id = bpy.context.scene
                    decimate_var.targets[0].data_path = 'sna_kb_kaboom_collection[' + str(kb_index) + '].noisy_inner_decimate'
                    view_var = decimate_driver.driver.variables.new()
                    view_var.name = 'view'
                    view_var.targets[0].id_type = 'SCENE'
                    view_var.targets[0].id = bpy.context.scene
                    view_var.targets[0].data_path = 'sna_kb_kaboom_collection[' + str(kb_index) + '].noisy_inner_show_view'
                    render_var = decimate_driver.driver.variables.new()
                    render_var.name = 'render'
                    render_var.targets[0].id_type = 'SCENE'
                    render_var.targets[0].id = bpy.context.scene
                    render_var.targets[0].data_path = 'sna_kb_is_rendering'
                    decimate_driver.driver.expression = 'max(decimate, 1- max(view,render))'
                    if ob.animation_data.action:
                        for f in ob.animation_data.action.fcurves:
                            if f.data_path == 'rigid_body.kinematic':
                                for p in f.keyframe_points:
                                    subdive_mod.show_render = int(1-p.co[1])
                                    displace_mod.show_render = int(1-p.co[1])
                                    decimate_mod.show_render = int(1-p.co[1])
                                    subdive_mod.keyframe_insert('show_render',frame=p.co[0])
                                    displace_mod.keyframe_insert('show_render',frame=p.co[0])
                                    decimate_mod.keyframe_insert('show_render',frame=p.co[0])
                                    subdive_mod.show_viewport = int(1-p.co[1])
                                    displace_mod.show_viewport = int(1-p.co[1])
                                    decimate_mod.show_viewport = int(1-p.co[1])
                                    subdive_mod.keyframe_insert('show_viewport',frame=p.co[0])
                                    displace_mod.keyframe_insert('show_viewport',frame=p.co[0])
                                    decimate_mod.keyframe_insert('show_viewport',frame=p.co[0])
                bpy.context.scene.sna_kb_progress_percent = ((self.sna_i+1) / self.sna_nb_obj)*100 
                #self.report({'INFO'},ob.name)
                self.sna_i += 1
                return {"RUNNING_MODAL"}
            else:
                if event.type in ['RIGHTMOUSE', 'ESC']:
                    self.execute(context)
                    return {'CANCELLED'}
                self.execute(context)
                return {"FINISHED"}
        except Exception as error:
            print(error)
        return {'RUNNING_MODAL'}

    def invoke(self, context, event):
        global _95AF5_running
        if _95AF5_running:
            _95AF5_running = False
            return {'FINISHED'}
        else:
            self.save_event(event)
            self.start_pos = (event.mouse_x, event.mouse_y)
            list(bpy.context.scene.sna_kb_kaboom_collection)[self.sna_kb_i].noisy_inner_show_view = False
            self.sna_id = list(bpy.context.scene.sna_kb_kaboom_collection)[self.sna_kb_i].id
            kb_col = list(bpy.context.scene.sna_kb_kaboom_collection)[self.sna_kb_i].kaboom_col
            id = list(bpy.context.scene.sna_kb_kaboom_collection)[self.sna_kb_i].id
            show_view = list(bpy.context.scene.sna_kb_kaboom_collection)[self.sna_kb_i].noisy_inner_show_view
            tex = None
            bpy.context.scene.sna_kb_progress_job = 'Enabling ...'
            kb_index = bpy.context.scene.sna_kb_col_index
            tex = bpy.data.textures.new('tex_' + id, 'CLOUDS')
            tex_driver = tex.driver_add('noise_scale')
            tex_driver.driver.type="AVERAGE"
            scale_var = tex_driver.driver.variables.new()
            scale_var.name = 'scale'
            scale_var.targets[0].id_type = 'SCENE'
            scale_var.targets[0].id = bpy.context.scene
            scale_var.targets[0].data_path = 'sna_kb_kaboom_collection[' + str(kb_index) + '].noisy_inner_size'
            collection = bpy.data.collections[kb_col.name]
            for o in collection.objects:
                o.hide_viewport = False
            kb_col = list(bpy.context.scene.sna_kb_kaboom_collection)[self.sna_kb_i].kaboom_col
            list_ob = None
            collection = bpy.data.collections[kb_col.name]
            list_ob = collection.objects[:]
            noisy_innerrough_cut['sna_objects_list'] = list_ob
            self.sna_nb_obj = len(list_ob)
            self.sna_i = 0
            context.window_manager.modal_handler_add(self)
            _95AF5_running = True
            return {'RUNNING_MODAL'}


_E18E2_running = False
class SNA_OT_Modop_Kb_Remove_Rough_Cut_E18E2(bpy.types.Operator):
    bl_idname = "sna.modop_kb_remove_rough_cut_e18e2"
    bl_label = "MODOP_KB_Remove_Rough_Cut"
    bl_description = ""
    bl_options = {"REGISTER", "UNDO"}
    sna_nb_obj: bpy.props.IntProperty(name='nb_obj', description='', default=0, subtype='NONE')
    sna_i: bpy.props.IntProperty(name='i', description='', default=0, subtype='NONE')
    sna_kb_i: bpy.props.IntProperty(name='kb_i', description='', default=0, subtype='NONE')
    cursor = "STOP"
    _handle = None
    _event = {}

    @classmethod
    def poll(cls, context):
        if bpy.app.version >= (3, 0, 0) and False:
            cls.poll_message_set()
        if not False or context.area.spaces[0].bl_rna.identifier == 'SpaceView3D':
            return not False
        return False

    def save_event(self, event):
        event_options = ["type", "value", "alt", "shift", "ctrl", "oskey", "mouse_region_x", "mouse_region_y", "mouse_x", "mouse_y", "pressure", "tilt"]
        if bpy.app.version >= (3, 2, 1):
            event_options += ["type_prev", "value_prev"]
        for option in event_options: self._event[option] = getattr(event, option)

    def draw_callback_px(self, context):
        event = self._event
        if event.keys():
            event = dotdict(event)
            try:
                pass
            except Exception as error:
                print(error)

    def execute(self, context):
        global _E18E2_running
        _E18E2_running = False
        context.window.cursor_set("DEFAULT")
        k_col = list(bpy.context.scene.sna_kb_kaboom_collection)[self.sna_kb_i].kaboom_col
        for o in k_col.objects[:]:
            if o.type == 'MESH' and o.animation_data:
                for fcu in o.animation_data.action.fcurves:
                    if fcu.data_path in ['modifiers["kb_subdive"].show_render',
                                        'modifiers["kb_disp"].show_render',
                                        'modifiers["kb_subdive"].show_viewport',
                                        'modifiers["kb_disp"].show_viewport',
                                        'modifiers["kb_decimate"].show_viewport',
                                        'modifiers["kb_decimate"].show_render']:
                                            o.animation_data.action.fcurves.remove(fcu)
                for dp in ['modifiers["kb_subdive"].levels',
                           'modifiers["kb_disp"].strength',
                           'modifiers["kb_decimate"].ratio']:
                               o.driver_remove(dp,-1)
        list(bpy.context.scene.sna_kb_kaboom_collection)[self.sna_kb_i].is_noisy_inner = False
        bpy.context.scene.sna_kb_progress_percent = 0.0
        exec('bpy.ops.outliner.orphans_purge(num_deleted=1, do_recursive=True)')
        for area in context.screen.areas:
            area.tag_redraw()
        return {"FINISHED"}

    def modal(self, context, event):
        global _E18E2_running
        if not context.area or not _E18E2_running:
            self.execute(context)
            return {'CANCELLED'}
        self.save_event(event)
        context.window.cursor_set('STOP')
        try:
            if (self.sna_i < self.sna_nb_obj):
                ob = noisy_innerrough_cut['sna_objects_list'][self.sna_i]
                bpy.ops.object.select_all(action='DESELECT')
                ob.select_set(True) 
                bpy.context.view_layer.objects.active = ob
                ob.name = ob.name[:-2]   
                for m in ob.modifiers:
                    if m.name in  ['kb_subdive','kb_w_edit','kb_w_proximity','kb_disp','kb_decimate']:
                        ob.modifiers.remove(m)
                try:
                    bpy.data.objects[ob.name + '_O'].select_set(True)
                    bpy.ops.object.join()
                except:
                    pass
                bpy.context.scene.sna_kb_progress_percent = ((self.sna_i+1) / self.sna_nb_obj)*100 
                self.report({'INFO'},ob.name)
                self.sna_i += 1
                if event.type in ['RIGHTMOUSE', 'ESC']:
                    self.execute(context)
                    return {'CANCELLED'}
                return {"RUNNING_MODAL"}
            else:
                if event.type in ['RIGHTMOUSE', 'ESC']:
                    self.execute(context)
                    return {'CANCELLED'}
                self.execute(context)
                return {"FINISHED"}
        except Exception as error:
            print(error)
        return {'RUNNING_MODAL'}

    def invoke(self, context, event):
        global _E18E2_running
        if _E18E2_running:
            _E18E2_running = False
            return {'FINISHED'}
        else:
            self.save_event(event)
            self.start_pos = (event.mouse_x, event.mouse_y)
            list(bpy.context.scene.sna_kb_kaboom_collection)[self.sna_kb_i].noisy_inner_show_view = False
            kb_col = list(bpy.context.scene.sna_kb_kaboom_collection)[self.sna_kb_i].kaboom_col
            collection = bpy.data.collections[kb_col.name]
            bpy.context.scene.sna_kb_progress_job = 'Removing ...'
            for o in collection.objects:
                o.hide_viewport = False
            kb_col = list(bpy.context.scene.sna_kb_kaboom_collection)[self.sna_kb_i].kaboom_col
            list_ob = None
            collection = bpy.data.collections[kb_col.name]
            list_ob = [o for o in collection.objects[:] if o.name[-2:] == '_I']
            noisy_innerrough_cut['sna_objects_list'] = list_ob
            self.sna_nb_obj = len(list_ob)
            self.sna_i = 0
            context.window_manager.modal_handler_add(self)
            _E18E2_running = True
            return {'RUNNING_MODAL'}


_1A6E2_running = False
class SNA_OT_Modop_Kb_Apply_Rough_Cut_1A6E2(bpy.types.Operator):
    bl_idname = "sna.modop_kb_apply_rough_cut_1a6e2"
    bl_label = "MODOP_KB_Apply_Rough_Cut"
    bl_description = ""
    bl_options = {"REGISTER", "UNDO"}
    sna_nb_obj: bpy.props.IntProperty(name='nb_obj', description='', default=0, subtype='NONE')
    sna_i: bpy.props.IntProperty(name='i', description='', default=0, subtype='NONE')
    sna_kb_i: bpy.props.IntProperty(name='kb_i', description='', default=0, subtype='NONE')
    cursor = "STOP"
    _handle = None
    _event = {}

    @classmethod
    def poll(cls, context):
        if bpy.app.version >= (3, 0, 0) and False:
            cls.poll_message_set()
        if not False or context.area.spaces[0].bl_rna.identifier == 'SpaceView3D':
            return not False
        return False

    def save_event(self, event):
        event_options = ["type", "value", "alt", "shift", "ctrl", "oskey", "mouse_region_x", "mouse_region_y", "mouse_x", "mouse_y", "pressure", "tilt"]
        if bpy.app.version >= (3, 2, 1):
            event_options += ["type_prev", "value_prev"]
        for option in event_options: self._event[option] = getattr(event, option)

    def draw_callback_px(self, context):
        event = self._event
        if event.keys():
            event = dotdict(event)
            try:
                pass
            except Exception as error:
                print(error)

    def execute(self, context):
        global _1A6E2_running
        _1A6E2_running = False
        context.window.cursor_set("DEFAULT")
        k_col = list(bpy.context.scene.sna_kb_kaboom_collection)[self.sna_kb_i].kaboom_col
        for o in k_col.objects[:]:
            if o.type == 'MESH' and o.animation_data:
                for fcu in o.animation_data.action.fcurves:
                    if fcu.data_path in ['modifiers["kb_subdive"].show_render',
                                        'modifiers["kb_disp"].show_render',
                                        'modifiers["kb_subdive"].show_viewport',
                                        'modifiers["kb_disp"].show_viewport',
                                        'modifiers["kb_decimate"].show_viewport',
                                        'modifiers["kb_decimate"].show_render']:
                                            o.animation_data.action.fcurves.remove(fcu)
                for dp in ['modifiers["kb_subdive"].levels',
                           'modifiers["kb_disp"].strength',
                           'modifiers["kb_decimate"].ratio']:
                               o.driver_remove(dp,-1)
        list(bpy.context.scene.sna_kb_kaboom_collection)[self.sna_kb_i].is_noisy_inner = False
        bpy.context.scene.sna_kb_progress_percent = 0.0
        bpy.ops.sna.kb_op_remove_particles_3b470('INVOKE_DEFAULT', sna_index=self.sna_kb_i, sna_particles_mode='Debris')
        bpy.ops.sna.kb_op_remove_particles_3b470('INVOKE_DEFAULT', sna_index=self.sna_kb_i, sna_particles_mode='Smoke_part')
        for area in context.screen.areas:
            area.tag_redraw()
        return {"FINISHED"}

    def modal(self, context, event):
        global _1A6E2_running
        if not context.area or not _1A6E2_running:
            self.execute(context)
            return {'CANCELLED'}
        self.save_event(event)
        context.window.cursor_set('STOP')
        try:
            if (self.sna_i < self.sna_nb_obj):
                ob = noisy_innerrough_cut['sna_objects_list'][self.sna_i]
                if ob.type == 'MESH':
                    bpy.ops.object.select_all(action='DESELECT')
                    ob.name = ob.name[:-2]
                    ob.select_set(True)    
                    bpy.context.view_layer.objects.active = ob
                    try:
                        bpy.data.objects[ob.name + '_O'].select_set(True)
                        bpy.ops.object.join()
                    except:
                        pass
                    for fcu in ob.animation_data.action.fcurves:
                        if fcu.data_path in ['modifiers["kb_subdive"].show_render',
                                            'modifiers["kb_disp"].show_render',
                                            'modifiers["kb_subdive"].show_viewport',
                                            'modifiers["kb_disp"].show_viewport',
                                            'modifiers["kb_decimate"].show_viewport',
                                            'modifiers["kb_decimate"].show_render']:
                                                ob.animation_data.action.fcurves.remove(fcu)
                bpy.context.scene.sna_kb_progress_percent = ((self.sna_i+1) / self.sna_nb_obj)*100
                self.report({'INFO'},ob.name)
                self.sna_i += 1
                return {"RUNNING_MODAL"}
            else:
                if event.type in ['RIGHTMOUSE', 'ESC']:
                    self.execute(context)
                    return {'CANCELLED'}
                self.execute(context)
                return {"FINISHED"}
        except Exception as error:
            print(error)
        return {'RUNNING_MODAL'}

    def invoke(self, context, event):
        global _1A6E2_running
        if _1A6E2_running:
            _1A6E2_running = False
            return {'FINISHED'}
        else:
            self.save_event(event)
            self.start_pos = (event.mouse_x, event.mouse_y)
            list(bpy.context.scene.sna_kb_kaboom_collection)[self.sna_kb_i].noisy_inner_show_view = True
            kb_col = list(bpy.context.scene.sna_kb_kaboom_collection)[self.sna_kb_i].kaboom_col
            collection = bpy.data.collections[kb_col.name]
            bpy.context.scene.sna_kb_progress_job = 'Applying ...'
            bpy.ops.object.select_all(action='DESELECT')
            for o in collection.objects:
                o.hide_viewport = False
                o.select_set(True)
            bpy.context.view_layer.objects.active = bpy.context.selected_objects[0]
            bpy.ops.object.convert(target='MESH')
            bpy.ops.object.select_all(action='DESELECT')
            bpy.context.view_layer.objects.update()
            kb_col = list(bpy.context.scene.sna_kb_kaboom_collection)[self.sna_kb_i].kaboom_col
            list_ob = None
            collection = bpy.data.collections[kb_col.name]
            list_ob = [o for o in collection.objects[:] if o.name[-2:] == '_I']
            noisy_innerrough_cut['sna_objects_list'] = list_ob
            self.sna_nb_obj = len(list_ob)
            self.sna_i = 0
            context.window_manager.modal_handler_add(self)
            _1A6E2_running = True
            return {'RUNNING_MODAL'}


@persistent
def render_complete_handler_9F4FF(dummy):
    bpy.context.scene.sna_kb_is_rendering = False


@persistent
def render_cancel_handler_0621B(dummy):
    bpy.context.scene.sna_kb_is_rendering = False


@persistent
def render_init_handler_2F894(dummy):
    bpy.context.scene.sna_kb_is_rendering = True


class SNA_OT_Kb_Op_Copy_Rough_Cut_Params_4E192(bpy.types.Operator):
    bl_idname = "sna.kb_op_copy_rough_cut_params_4e192"
    bl_label = "KB_OP_COPY_ROUGH_CUT_PARAMS"
    bl_description = ""
    bl_options = {"REGISTER", "UNDO"}
    sna_index: bpy.props.IntProperty(name='index', description='', default=0, subtype='NONE')

    @classmethod
    def poll(cls, context):
        if bpy.app.version >= (3, 0, 0) and False:
            cls.poll_message_set()
        return not False

    def execute(self, context):
        kb = list(bpy.context.scene.sna_kb_kaboom_collection)[self.sna_index]
        params = []
        params.append(kb.noisy_inner_level)
        params.append(kb.noisy_inner_amount)
        params.append(kb.noisy_inner_size)
        #params.append(kb.noisy_inner_shape)
        params.append(kb.noisy_inner_decimate)
        noisy_innerrough_cut['sna_rough_cut_copy'] = params
        return {"FINISHED"}

    def invoke(self, context, event):
        return self.execute(context)


class SNA_OT_Kb_Op_Paste_Rough_Cut_Params_E6C01(bpy.types.Operator):
    bl_idname = "sna.kb_op_paste_rough_cut_params_e6c01"
    bl_label = "KB_OP_PASTE_ROUGH_CUT_PARAMS"
    bl_description = ""
    bl_options = {"REGISTER", "UNDO"}
    sna_index: bpy.props.IntProperty(name='index', description='', default=0, subtype='NONE')

    @classmethod
    def poll(cls, context):
        if bpy.app.version >= (3, 0, 0) and False:
            cls.poll_message_set()
        return not False

    def execute(self, context):
        kb = list(bpy.context.scene.sna_kb_kaboom_collection)[self.sna_index]
        kb.noisy_inner_level = noisy_innerrough_cut['sna_rough_cut_copy'][0]
        kb.noisy_inner_amount = noisy_innerrough_cut['sna_rough_cut_copy'][1]
        kb.noisy_inner_size = noisy_innerrough_cut['sna_rough_cut_copy'][2]
        #kb.noisy_inner_shape = noisy_innerrough_cut['sna_rough_cut_copy'][3]
        kb.noisy_inner_decimate = noisy_innerrough_cut['sna_rough_cut_copy'][3]
        return {"FINISHED"}

    def invoke(self, context, event):
        return self.execute(context)


def sna_test_has_particles_AE61A(objet, particle_mode):
    ob = objet
    particle_name = particle_mode
    out = None
    out = False
    try:
        for m in ob.modifiers:
            if particle_name in m.name:
                out = True
    except:
        pass
    return out


def sna_test_is_smoke_domain_32786(objet):
    ob = objet
    out = None
    out = False
    try:
        for m in ob.modifiers:
            if m.type == 'FLUID' and m.fluid_type == 'DOMAIN':
                out = True
    except:
        pass
    return out


def sna_kb_fc_particle_collection_asset_exist_71EA4():
    out = None
    out = False
    for col in bpy.data.collections:
        if 'KB_debris_particle_instances' in col.name:
            out = True
    return out


def sna_fc_test_noisy_cut_9F0ED(Input):
    index = Input
    out = None
    kb = bpy.context.scene.sna_kb_kaboom_collection
    if kb[index].is_noisy_inner and kb[index].noisy_inner_show_view:
        out = True
    else:
        out = False
    return out


def sna_test_has_smoke_emit_0EBFC(ob):
    ob = ob
    out = None
    out = False
    try:
        for m in ob.modifiers:
            if m.name == 'Fluid':
                out = True
    except:
        pass
    return out


class SNA_OT_Kb_Op_Show_Hide_Particles_Af372(bpy.types.Operator):
    bl_idname = "sna.kb_op_show_hide_particles_af372"
    bl_label = "KB_OP_Show_Hide_Particles"
    bl_description = "Show / Hide Particles In Viewport"
    bl_options = {"REGISTER", "UNDO"}
    sna_particle_type: bpy.props.StringProperty(name='particle_type', description='', default='', subtype='NONE', maxlen=0)

    @classmethod
    def poll(cls, context):
        if bpy.app.version >= (3, 0, 0) and False:
            cls.poll_message_set()
        return not False

    def execute(self, context):
        particles_type = self.sna_particle_type
        show_bool = None
        #particles_type
        #show_bool
        #show_debris
        #show_smoke
        wm = bpy.context.window_manager
        show_debris = wm.sna_kb_show_debris_parts
        show_smoke = wm.sna_kb_show_smoke_parts
        #if show_bool == True:
        #    show_bool = False
        #    if particles_type == 'Debris':
        #        show_debris = False
        #    else:
        #        show_smoke = False
        #else:
        #    show_bool = True
        #    if particles_type == 'Debris':
        #        show_debris = True
        #    else:
        #        show_smoke = True
        if particles_type == 'Debris':
            show_bool = show_debris
        else:
            show_bool = show_smoke
        for kb in bpy.context.scene.sna_kb_kaboom_collection:
            for ob in kb.kaboom_col.objects:
                for m in ob.modifiers:
                    if particles_type in m.name:
                        m.show_viewport = show_bool
        return {"FINISHED"}

    def invoke(self, context, event):
        return self.execute(context)


class SNA_OT_Kb_Op_Copy_Smoke_Params_41685(bpy.types.Operator):
    bl_idname = "sna.kb_op_copy_smoke_params_41685"
    bl_label = "KB_OP_Copy_Smoke_params"
    bl_description = "Copy Selected Object Smoke Parametters to All Fractured Group Objects"
    bl_options = {"REGISTER", "UNDO"}
    sna_index: bpy.props.IntProperty(name='index', description='', default=0, subtype='NONE')

    @classmethod
    def poll(cls, context):
        if bpy.app.version >= (3, 0, 0) and False:
            cls.poll_message_set()
        return not False

    def execute(self, context):
        kb_col = list(bpy.context.scene.sna_kb_kaboom_collection)[self.sna_index].kaboom_col
        ob = bpy.context.view_layer.objects.active
        collection = bpy.data.collections[kb_col.name]
        ob_set = []
        try:
            ob_set.append(ob.modifiers["Fluid"].flow_settings.flow_behavior)
            ob_set.append(ob.modifiers["Fluid"].flow_settings.use_inflow)
            ob_set.append(ob.modifiers["Fluid"].flow_settings.subframes)
            ob_set.append(ob.modifiers["Fluid"].flow_settings.smoke_color)
            ob_set.append(ob.modifiers["Fluid"].flow_settings.use_absolute)
            ob_set.append(ob.modifiers["Fluid"].flow_settings.temperature)
            #ob_set.append(ob.modifiers["Fluid"].flow_settings.density)
            #ob_set.append(ob.modifiers["Fluid"].flow_settings.density_vertex_group)
            #ob_set.append(ob.modifiers["Fluid"].flow_settings.use_particle_size)
            #ob_set.append(ob.modifiers["Fluid"].flow_settings.particle_size)
            #ob_set.append(ob.modifiers["Fluid"].flow_settings.use_initial_velocity)
            ob_set.append(ob.modifiers["Fluid"].flow_settings.velocity_factor)
            ob_set.append(ob.modifiers["Fluid"].flow_settings.use_texture)
            ob_set.append(ob.modifiers["Fluid"].flow_settings.noise_texture)
            ob_set.append(ob.modifiers["Fluid"].flow_settings.texture_map_type)
            ob_set.append(ob.modifiers["Fluid"].flow_settings.texture_size)
            ob_set.append(ob.modifiers["Fluid"].flow_settings.texture_offset)
        except:
            print('No ',particle_name, ' in Selected Object')
        Slaves =[o for o in collection.objects if o != ob]
        if len(ob_set) > 1:
            for o in Slaves: 
                prt_mod = o.modifiers.get("Fluid", None)
                if not prt_mod:
                    continue
                else:                       
                    o.modifiers["Fluid"].flow_settings.flow_behavior = ob_set[0]
                    o.modifiers["Fluid"].flow_settings.use_inflow = ob_set[1]
                    o.modifiers["Fluid"].flow_settings.subframes= ob_set[2]
                    o.modifiers["Fluid"].flow_settings.smoke_color= ob_set[3]
                    o.modifiers["Fluid"].flow_settings.use_absolute= ob_set[4]
                    o.modifiers["Fluid"].flow_settings.temperature= ob_set[5]
                    #o.modifiers["Fluid"].flow_settings.density= ob_set[6]
                    #o.modifiers["Fluid"].flow_settings.density_vertex_group= ob_set[7]
                    #o.modifiers["Fluid"].flow_settings.use_particle_size= ob_set[8]
                    #o.modifiers["Fluid"].flow_settings.particle_size= ob_set[9]
                    #o.modifiers["Fluid"].flow_settings.use_initial_velocity= ob_set[10]
                    o.modifiers["Fluid"].flow_settings.velocity_factor= ob_set[6]
                    o.modifiers["Fluid"].flow_settings.use_texture= ob_set[7]
                    o.modifiers["Fluid"].flow_settings.noise_texture= ob_set[8]
                    o.modifiers["Fluid"].flow_settings.texture_map_type= ob_set[9]
                    o.modifiers["Fluid"].flow_settings.texture_size= ob_set[10]
                    o.modifiers["Fluid"].flow_settings.texture_offset= ob_set[11]
        return {"FINISHED"}

    def invoke(self, context, event):
        return self.execute(context)


class SNA_OT_Kb_Op_Remove_Particles_3B470(bpy.types.Operator):
    bl_idname = "sna.kb_op_remove_particles_3b470"
    bl_label = "KB_OP_Remove_Particles"
    bl_description = "Delete All Selected Type Particles of All Fractured Group Objects"
    bl_options = {"REGISTER", "UNDO"}
    sna_index: bpy.props.IntProperty(name='index', description='', default=0, subtype='NONE')
    sna_particles_mode: bpy.props.StringProperty(name='Particles_mode', description='', default='', subtype='NONE', maxlen=0)

    @classmethod
    def poll(cls, context):
        if bpy.app.version >= (3, 0, 0) and False:
            cls.poll_message_set()
        return not False

    def execute(self, context):
        kb_col = list(bpy.context.scene.sna_kb_kaboom_collection)[self.sna_index].kaboom_col
        particles_mode = self.sna_particles_mode
        wm = bpy.context.window_manager
        collection = bpy.data.collections[kb_col.name]
        for o in collection.all_objects:
            if particles_mode == 'Fluid':
                for d in o.animation_data.drivers:
                    if d.data_path in [ 'modifiers["Fluid"].flow_settings.volume_density',
                                        'modifiers["Fluid"].flow_settings.velocity_factor',
                                        'modifiers["Fluid"].flow_settings.velocity_normal',
                                        'modifiers["Fluid"].flow_settings.density',
                                        'modifiers["Fluid"].flow_settings.velocity_coord',
                                        'modifiers["Fluid"].flow_settings.surface_distance']:
                        o.driver_remove(d.data_path,-1)
                for m in o.modifiers:
                    if m.name == "Fluid":
                        o.modifiers.remove(m)
        #        for f in o.animation_data.action.fcurves:
        #            if f.data_path in ['modifiers["Fluid"].flow_settings.volume_density','modifiers["Fluid"].flow_settings.velocity_normal']:
        #                o.animation_data.action.fcurves.remove(f)
            else:
                for m in o.modifiers:
                    if 'Debris_' in m.name:
                        o.modifiers.remove(m)
        if particles_mode == 'Debris':
            wm.sna_kb_show_debris_parts = True
        else:
            wm.sna_kb_show_smoke_parts = True
        if (self.sna_particles_mode == 'Debris'):
            list(bpy.context.scene.sna_kb_kaboom_collection)[self.sna_index].has_debris = False
        else:
            list(bpy.context.scene.sna_kb_kaboom_collection)[self.sna_index].has_smoke = False
        bpy.ops.sna.kb_op_reset_rigid_body_world_88fc2('INVOKE_DEFAULT', )
        return {"FINISHED"}

    def invoke(self, context, event):
        return self.execute(context)


class SNA_OT_Kb_Op_Remove_Selected_Objects_Particles_9B69E(bpy.types.Operator):
    bl_idname = "sna.kb_op_remove_selected_objects_particles_9b69e"
    bl_label = "KB_OP_Remove_Selected_objects_particles"
    bl_description = "Remove Selected Objects Emission"
    bl_options = {"REGISTER", "UNDO"}
    sna_particles_mode: bpy.props.StringProperty(name='Particles_mode', description='', default='', subtype='NONE', maxlen=0)

    @classmethod
    def poll(cls, context):
        if bpy.app.version >= (3, 0, 0) and False:
            cls.poll_message_set()
        return not False

    def execute(self, context):
        particles_mode = self.sna_particles_mode
        selection = bpy.context.view_layer.objects.selected
        for o in selection:
            prt_mod = None
            for m in o.modifiers:
                if particles_mode in m.name:
                    modifier_name = m.name
                    prt_mod = o.modifiers.get(modifier_name, None)
                if not prt_mod:
                    continue
                else:
                    o.select_set(True)
                    bpy.context.view_layer.objects.active = o
                    try:
                        o.modifiers.remove(prt_mod)
                    except:
                        print('no ',prt_mod, ' modifier for ',o.name)
        if particles_mode == 'Debris':
            wm.sna_kb_show_debris_parts = True
        else:
            wm.sna_kb_show_smoke_parts = True
        return {"FINISHED"}

    def invoke(self, context, event):
        return self.execute(context)


class SNA_OT_Kb_Op_Create_Smoke_Domain_7F35A(bpy.types.Operator):
    bl_idname = "sna.kb_op_create_smoke_domain_7f35a"
    bl_label = "KB_OP_Create_Smoke_Domain"
    bl_description = "Create Smoke Domain With The Size of The Selected Objects Bounding Box of "
    bl_options = {"REGISTER", "UNDO"}

    @classmethod
    def poll(cls, context):
        if bpy.app.version >= (3, 0, 0) and False:
            cls.poll_message_set()
        return not False

    def execute(self, context):
        if (len(list(bpy.context.view_layer.objects.selected)) > 0):
            domain_obj = None
            import numpy as np
            context = bpy.context
            #context.scene.frame_set(context.scene.frame_start)
            # multiply 3d coord list by matrix

            def np_matmul_coords(coords, matrix, space=None):
                M = (space @ matrix @ space.inverted()
                     if space else matrix).transposed()
                ones = np.ones((coords.shape[0], 1))
                coords4d = np.hstack((coords, ones))
                return np.dot(coords4d, M)[:,:-1]
                return coords4d[:,:-1]
            if len(context.selected_objects)>0:
                bpy.ops.view3d.snap_cursor_to_selected()
                # get the global coordinates of all object bounding box corners    
                coords = np.vstack(
                    tuple(np_matmul_coords(np.array(o.bound_box), o.matrix_world.copy())
                         for o in  
                            context.selected_objects
                            if o.type == 'MESH'
                            )
                        )
                # bottom front left (all the mins)
                bfl = coords.min(axis=0)
                # top back right
                tbr = coords.max(axis=0)
                G  = np.array((bfl, tbr)).T
                # bound box coords ie the 8 combinations of bfl tbr.
                bbc = [i for i in itertools.product(*G)]
                X = np.array(bbc)[4][0] - np.array(bbc)[0][0]
                Y = np.array(bbc)[2][1] - np.array(bbc)[0][1]
                Z = np.array(bbc)[1][2] - np.array(bbc)[0][2]
                bpy.ops.object.select_all(action='DESELECT')
                bpy.ops.mesh.primitive_cube_add(size=2, enter_editmode=False, align='WORLD', scale=(X/1.5, Y/1.5, Z/1.5))
                bpy.ops.object.modifier_add(type='FLUID')
                bpy.context.object.modifiers["Fluid"].name = "KB_Smoke_Domain"
                domain_obj = context.object
                domain_obj.display_type = 'BOUNDS'
                domain_obj.name = 'KB_Smoke_Domain'
                domain_obj.modifiers[0].fluid_type = 'DOMAIN'
                domain_obj.modifiers["KB_Smoke_Domain"].domain_settings.resolution_max = 64
                domain_obj.modifiers["KB_Smoke_Domain"].domain_settings.use_dissolve_smoke = True
                domain_obj.modifiers["KB_Smoke_Domain"].domain_settings.dissolve_speed = 50
                domain_obj.modifiers["KB_Smoke_Domain"].domain_settings.use_adaptive_domain = True
                domain_obj.modifiers["KB_Smoke_Domain"].domain_settings.cache_frame_start = context.scene.frame_start
                domain_obj.modifiers["KB_Smoke_Domain"].domain_settings.cache_frame_end = context.scene.frame_end
                domain_obj.modifiers["KB_Smoke_Domain"].domain_settings.use_adaptive_domain = False
                domain_obj.modifiers["KB_Smoke_Domain"].domain_settings.alpha = 1 # buoyancy density
                domain_obj.modifiers["KB_Smoke_Domain"].domain_settings.beta = -1  # Heat
                domain_obj.modifiers["KB_Smoke_Domain"].domain_settings.use_noise = False
                domain_obj.modifiers["KB_Smoke_Domain"].domain_settings.delete_in_obstacle = False
                domain_obj.modifiers["KB_Smoke_Domain"].domain_settings.use_collision_border_bottom = True
            ############################## ADD SMOKE MATERIAL
                new_mat = bpy.data.materials.get('KB_Smoke_Material')
                if not new_mat:
                    new_mat = bpy.data.materials.new('KB_Smoke_Material')
                    new_mat.use_nodes = True
                    node_tree = new_mat.node_tree
                    nodes = node_tree.nodes
                    nodes.clear()
                    links = node_tree.links
                    links.clear()
                    # Nodes :
                    new_node = nodes.new(type='ShaderNodeVolumePrincipled')
                    new_node.color = (0.6079999804496765, 0.6079999804496765, 0.6079999804496765)
                    new_node.location = (-50.49128341674805, 257.7391662597656)
                    new_node.name = 'Principled Volume'
                    new_node.select = False
                    new_node.width = 240.0
                    new_node.inputs[0].default_value = [0.5, 0.37445971369743347, 0.20905278623104095, 1.0]
                    #new_node.inputs[1].default_value = 
                    new_node.inputs[2].default_value = 2.0
                    #new_node.inputs[3].default_value = density
                    new_node.inputs[4].default_value = 0.0
                    new_node.inputs[5].default_value = [0.0, 0.0, 0.0, 1.0]
                    new_node.inputs[6].default_value = 0.0
                    new_node.inputs[7].default_value = [1.0, 1.0, 1.0, 1.0]
                    new_node.inputs[8].default_value = 0.0
                    new_node.inputs[9].default_value = [1.0, 1.0, 1.0, 1.0]
                    new_node.inputs[10].default_value = 1000.0
                    #new_node.inputs[11].default_value = temperature
                    new_node.inputs[12].default_value = 0.0
                    new_node = nodes.new(type='ShaderNodeOutputMaterial')
                    new_node.color = (0.6079999804496765, 0.6079999804496765, 0.6079999804496765)
                    new_node.is_active_output = True
                    new_node.location = (300.0, 300.0)
                    new_node.name = 'Material Output'
                    new_node.target = 'ALL'
                    new_node.width = 140.0
                    new_node.inputs[2].default_value = [0.0, 0.0, 0.0]
                    new_node.inputs[3].default_value = 0.0
                    # Links :
                    links.new(nodes["Principled Volume"].outputs[0], nodes["Material Output"].inputs[1])
                domain_obj.data.materials.append(new_mat)
                #domain_obj.modifiers[0].domain_settings.effector_group = bpy.data.collections["KB_Smoke"]
            sna_move_outliner_collection_object_A90B9_9A727(domain_obj, 'KB_Smoke')
        else:
            self.report({'ERROR'}, message='Please select fragments fist')
        return {"FINISHED"}

    def invoke(self, context, event):
        return self.execute(context)


class SNA_OT_Kb_Op_Refresh_Smoke_Domain_C9C70(bpy.types.Operator):
    bl_idname = "sna.kb_op_refresh_smoke_domain_c9c70"
    bl_label = "KB_OP_Refresh_Smoke_Domain"
    bl_description = "Delete Cache Selected Smoke Domain "
    bl_options = {"REGISTER", "UNDO"}

    @classmethod
    def poll(cls, context):
        if bpy.app.version >= (3, 0, 0) and False:
            cls.poll_message_set()
        return not False

    def execute(self, context):
        bpy.context.object.modifiers[0].domain_settings.resolution_max += 1
        bpy.context.object.modifiers[0].domain_settings.resolution_max -= 1
        return {"FINISHED"}

    def invoke(self, context, event):
        return self.execute(context)


class SNA_OT_Kb_Op_Partcles_Time_Offset_04B7A(bpy.types.Operator):
    bl_idname = "sna.kb_op_partcles_time_offset_04b7a"
    bl_label = "KB_OP_partcles_time_offset"
    bl_description = "Decal Particles Time Emission ( in frame )"
    bl_options = {"REGISTER", "UNDO"}
    sna_index: bpy.props.IntProperty(name='index', description='', default=0, subtype='NONE')
    sna_particles_mode: bpy.props.StringProperty(name='Particles_mode', description='', default='', subtype='NONE', maxlen=0)
    sna_offset: bpy.props.IntProperty(name='offset', description='', default=0, subtype='NONE', min=-100, soft_min=-20, max=100, soft_max=20)

    @classmethod
    def poll(cls, context):
        if bpy.app.version >= (3, 0, 0) and False:
            cls.poll_message_set()
        return not False

    def execute(self, context):
        kb_col = list(bpy.context.scene.sna_kb_kaboom_collection)[self.sna_index].kaboom_col
        offset = self.sna_offset
        mode = self.sna_particles_mode
        collection = bpy.data.collections.get(kb_col.name)
        for o in collection.objects: 
            for m in o.modifiers:
                if 'Debris_' in m.name:
                    psys = o.particle_systems[m.name]
                    psys.settings.frame_start  += offset
                    psys.settings.frame_end  += offset
        return {"FINISHED"}

    def draw(self, context):
        layout = self.layout
        layout.label(text='How Many Frames ?', icon_value=1)
        layout.prop(self, 'sna_offset', text='', icon_value=219, emboss=True, expand=False, slider=True, toggle=False)

    def invoke(self, context, event):
        return context.window_manager.invoke_props_dialog(self, width=300)


class SNA_OT_Kb_Op_Create_Smoke_Turbulence_6C76A(bpy.types.Operator):
    bl_idname = "sna.kb_op_create_smoke_turbulence_6c76a"
    bl_label = "KB_OP_Create_Smoke_Turbulence"
    bl_description = ""
    bl_options = {"REGISTER", "UNDO"}

    @classmethod
    def poll(cls, context):
        if bpy.app.version >= (3, 0, 0) and False:
            cls.poll_message_set()
        return not False

    def execute(self, context):
        turbulence_field = None
        bpy.ops.object.effector_add(type='TURBULENCE', enter_editmode=False, align='WORLD', location=(-1.91332, 0.138426, 0.829164), scale=(1, 1, 1))
        turbulence_field = bpy.context.object
        turbulence_field.field.strength = 1.0
        turbulence_field.field.size = .5
        turbulence_field.field.flow = .3
        driv = turbulence_field.driver_add('location', 2)
        driv.driver.type = 'SCRIPTED'
        driv.driver.expression = 'frame/40'
        #if bpy.data.collections['KB_Smoke']:
        #    bpy.data.collections['KB_Smoke'].objects.link(turbulence_field)
        sna_move_outliner_collection_object_A90B9_46FD3(turbulence_field, 'KB_Smoke')
        return {"FINISHED"}

    def invoke(self, context, event):
        return self.execute(context)


class SNA_OT_Kb_Op_Smoke_Emit_Time_Offset_Aba8E(bpy.types.Operator):
    bl_idname = "sna.kb_op_smoke_emit_time_offset_aba8e"
    bl_label = "KB_OP_smoke_emit_time_offset"
    bl_description = "Decal Smoke Emission Time ( in frame )"
    bl_options = {"REGISTER", "UNDO"}
    sna_index: bpy.props.IntProperty(name='index', description='', default=0, subtype='NONE')
    sna_particles_mode: bpy.props.StringProperty(name='Particles_mode', description='', default='', subtype='NONE', maxlen=0)
    sna_offset: bpy.props.IntProperty(name='offset', description='', default=0, subtype='NONE', min=-100, soft_min=-20, max=100, soft_max=20)

    @classmethod
    def poll(cls, context):
        if bpy.app.version >= (3, 0, 0) and False:
            cls.poll_message_set()
        return not False

    def execute(self, context):
        kb_col = list(bpy.context.scene.sna_kb_kaboom_collection)[self.sna_index].kaboom_col
        offset = self.sna_offset
        collection = bpy.data.collections.get(kb_col.name)
        for o in collection.objects: 
            smoke_mod = o.modifiers.get('Fluid', None)
            if not smoke_mod:
                continue
            else:
                for f in o.animation_data.action.fcurves:
                    if f.data_path in ['modifiers["Fluid"].flow_settings.volume_density','modifiers["Fluid"].flow_settings.velocity_normal']:
                        for k in f.keyframe_points:
                            k.co.x += int(offset)
        return {"FINISHED"}

    def draw(self, context):
        layout = self.layout
        layout.label(text='How Many Frames ?', icon_value=1)
        layout.prop(self, 'sna_offset', text='', icon_value=219, emboss=True, expand=False, slider=True, toggle=False)

    def invoke(self, context, event):
        return context.window_manager.invoke_props_dialog(self, width=300)


class SNA_OT_Kb_Op_Update_Smoke_20F0A(bpy.types.Operator):
    bl_idname = "sna.kb_op_update_smoke_20f0a"
    bl_label = "KB_OP_Update_Smoke"
    bl_description = ""
    bl_options = {"REGISTER", "UNDO"}
    sna_index: bpy.props.IntProperty(name='Index', description='', default=0, subtype='NONE')

    @classmethod
    def poll(cls, context):
        if bpy.app.version >= (3, 0, 0) and True:
            cls.poll_message_set('')
        return not False

    def execute(self, context):
        kb_col = list(bpy.context.scene.sna_kb_kaboom_collection)[self.sna_index].kaboom_col
        wm = bpy.context.window_manager
        collection = bpy.data.collections[kb_col.name]
        for o in collection.objects:
            try:
                for d in o.animation_data.drivers:            
                    if d.data_path == 'modifiers["Fluid"].flow_settings.surface_distance':
                        d.driver.expression = '(' + str(wm.sna_kb_smoke_emission_moving) + '*vel+' + str(wm.sna_kb_smoke_emission_exploding) + '*acc)*noise.random()'
                    elif d.data_path == 'modifiers["Fluid"].flow_settings.density':
                        d.driver.expression = '(' + str(wm.sna_kb_smoke_emission_moving) + '*vel+' + str(wm.sna_kb_smoke_emission_exploding) + '*acc)*noise.random()'
                    elif d.data_path == 'modifiers["Fluid"].flow_settings.velocity_normal':
                        exp_strip = d.driver.expression.strip('*')
                        d.driver.expression = str(wm.sna_kb_smoke_emission_exploding) + '*noise.random()*acc*5'
                    elif d.data_path == 'modifiers["Fluid"].flow_settings.velocity_coord':
                        if len(d.driver.expression) > 10:
                            d.driver.expression = '(' + str(wm.sna_kb_smoke_z_velocity) + '*noise.random()*acc) if (real_acc < 0) else 0'
            except:
                pass
        self.report({'INFO'}, message='Smoke updated...')
        return {"FINISHED"}

    def invoke(self, context, event):
        return self.execute(context)


class SNA_OT_Kb_Op_Update_Debris_79841(bpy.types.Operator):
    bl_idname = "sna.kb_op_update_debris_79841"
    bl_label = "KB_OP_Update_Debris"
    bl_description = ""
    bl_options = {"REGISTER", "UNDO"}
    sna_index: bpy.props.IntProperty(name='Index', description='', default=0, subtype='NONE')

    @classmethod
    def poll(cls, context):
        if bpy.app.version >= (3, 0, 0) and True:
            cls.poll_message_set('')
        return not False

    def execute(self, context):
        return {"FINISHED"}

    def invoke(self, context, event):
        return self.execute(context)


class SNA_OT_Kb_Op_Copy_Particle_Params_Bb41D(bpy.types.Operator):
    bl_idname = "sna.kb_op_copy_particle_params_bb41d"
    bl_label = "KB_OP_Copy_particle_params"
    bl_description = "Copy Selected Object Particles Parametters to All Fractured Group Objects"
    bl_options = {"REGISTER", "UNDO"}
    sna_index: bpy.props.IntProperty(name='index', description='', default=0, subtype='NONE')

    @classmethod
    def poll(cls, context):
        if bpy.app.version >= (3, 0, 0) and False:
            cls.poll_message_set()
        return not False

    def execute(self, context):
        kb_col = list(bpy.context.scene.sna_kb_kaboom_collection)[self.sna_index].kaboom_col
        ob = bpy.context.view_layer.objects.active
        wm = bpy.context.window_manager
        collection = bpy.data.collections[kb_col.name]
        try:
            ob_set = ob.particle_systems.active.settings.copy()
        except:
            print('No ',particle_name, ' in Selected Object')
        Slaves =[o for o in collection.objects if o != ob]
        if ob_set:
            for o in collection.objects:
                for m in o.modifiers:
                    if 'Debris_' in m.name:
                        psys = o.particle_systems[m.name]        
                        pset = psys.settings  
                        #save own start end and count
                        sav_start = psys.settings.frame_start
                        sav_end = psys.settings.frame_end
                        sav_count =  psys.settings.count 
                        #apply God settings copy
                        #ob_set = ob.particle_systems.active.settings.copy()
                        psys.settings = ob_set.copy()
                        #restore own start end and count
                        psys.settings.frame_start = sav_start
                        psys.settings.frame_end = sav_end
                        psys.settings.count = sav_count
                        print(sav_start,' ',sav_end)            
        return {"FINISHED"}

    def invoke(self, context, event):
        return self.execute(context)


class SNA_OT_Kb_Op_Add_Particles_63F33(bpy.types.Operator):
    bl_idname = "sna.kb_op_add_particles_63f33"
    bl_label = "KB_OP_ADD_Particles"
    bl_description = "Creates Deris Particles On All of Active Fractured Group Objects"
    bl_options = {"REGISTER", "UNDO"}
    sna_index: bpy.props.IntProperty(name='index', description='', default=0, subtype='NONE')
    sna_particles_mode: bpy.props.StringProperty(name='Particles_mode', description='', default='', subtype='NONE', maxlen=0)
    sna_update: bpy.props.BoolProperty(name='update', description='', default=False)

    @classmethod
    def poll(cls, context):
        if bpy.app.version >= (3, 0, 0) and False:
            cls.poll_message_set()
        return not False

    def execute(self, context):
        if sna_fc_test_noisy_cut_9F0ED(self.sna_index):
            particles['sna_tmp_bool'] = True
            list(bpy.context.scene.sna_kb_kaboom_collection)[self.sna_index].noisy_inner_show_view = False
        if (self.sna_particles_mode == 'Debris'):
            if bpy.context.window_manager.sna_kb_debris_part_collection:
                pass
            else:
                if sna_kb_fc_particle_collection_asset_exist_71EA4():
                    bpy.context.window_manager.sna_kb_debris_part_collection = bpy.data.collections['KB_debris_particle_instances']
                else:
                    asset_path = os.path.join(os.path.dirname(__file__), 'assets', 'KB_asset.blend')
                    kb_col = list(bpy.context.scene.sna_kb_kaboom_collection)[self.sna_index].kaboom_col
                    Variable = None

                    def traverse_tree(t):
                        yield t
                        for child in t.children:
                            yield from traverse_tree(child)

                    def parent_lookup(coll):
                        parent_lookup = {}
                        for coll in traverse_tree(coll):
                            for c in coll.children.keys():
                                parent_lookup.setdefault(c, coll)
                        return parent_lookup
                    ############## append collection particule instances:
                    bpy.ops.wm.append(directory=asset_path + r'\Collection', filename='KB_debris_particle_instances', link=False)
                    ########################################################### find new collection in scene:
                    coll_scene = bpy.context.scene.collection
                    coll_parents = parent_lookup(coll_scene)
                    # Get collection references
                    active_coll = bpy.data.collections['KB_debris_particle_instances']
                    # Get parent of *active_coll*
                    active_coll_parent = coll_parents.get(active_coll.name)
                    if active_coll_parent:
                        # Unlink *active_coll*
                        active_coll_parent.children.unlink(active_coll)
                    bpy.context.scene.collection.children.link(active_coll)
                    #############################################################@
                    bpy.context.window_manager.sna_kb_debris_part_collection = bpy.data.collections['KB_debris_particle_instances']
                    ############ assign Inner material si existe:
                    collec_frature_obj = bpy.data.collections[kb_col.name]
                    obj_mat_slots = collec_frature_obj.objects[0].material_slots
                    if len(obj_mat_slots) > 1:
                        inner_mat = obj_mat_slots[1].material
                        for part_obj in bpy.data.collections['KB_debris_particle_instances'].objects:
                            part_obj.data.materials.append(inner_mat)
                    bpy.context.view_layer.layer_collection.children['KB_debris_particle_instances'].exclude = True
        if (self.sna_particles_mode == 'Debris'):
            kb_col = list(bpy.context.scene.sna_kb_kaboom_collection)[self.sna_index].kaboom_col
            f_start = (bpy.context.window_manager.sna_kb_custom_f_start if bpy.context.window_manager.sna_kb_custom_range_bool else bpy.context.scene.frame_start)
            f_end = (bpy.context.window_manager.sna_kb_custom_f_end if bpy.context.window_manager.sna_kb_custom_range_bool else bpy.context.scene.frame_end)
            particles_mode = self.sna_particles_mode
            col_id = list(bpy.context.scene.sna_kb_kaboom_collection)[self.sna_index].id
            update = self.sna_update
            wm = bpy.context.window_manager
            collection = bpy.data.collections[kb_col.name]
            duration = wm.sna_kb_particles_duration
            random_val = .4 * duration
            list_ob=[]
            list_vel=[]
            for o in collection.all_objects:
                if o.name[-2:] != '_O':
                    list_ob.append(o)
            bpy.ops.object.select_all(action='DESELECT')
            if update:
                for o in list_ob:
                    for m in o.modifiers:
                        if 'Debris_' in m.name:
                            psys_settings = o.particle_systems.active.settings.copy()
            for o in list_ob:
                for m in o.modifiers:
                    if 'Debris_' in m.name:
                       o.modifiers.remove(m)    
            ################################################
            for o in list_ob:
                list_pb = []
                number_psys = 0  
                if o.type == 'MESH' and not(o.hide_viewport) and not(o.sna_kb_is_iterator_source):
                    for fcu_acc in o.animation_data.action.fcurves:
                        if fcu_acc.data_path == 'sna_kb_shard_acceleration':
                            break
                    for fcu_real_acc in o.animation_data.action.fcurves:
                        if fcu_real_acc.data_path == 'sna_kb_shard_real_acceleration':
                            break
                    rand=random.uniform(-random_val ,random_val)
                    frame = f_start
                    while frame < f_end: 
                        if fcu_acc.evaluate(frame) > wm.sna_kb_velocity_threshold:
                            modifier_name = 'Debris_' + str(number_psys)
                            ps = o.modifiers.new(modifier_name, 'PARTICLE_SYSTEM')
                            psys = o.particle_systems[ps.name]
                            bpy.data.particles["ParticleSettings"].name = 'Debris_' + str(number_psys)
                            ############ pys settings
                            if update:
                                psys.settings = psys_settings.copy()
                            else:
                                psys.settings.subframes = 0
                                psys.settings.object_factor = 1
                                psys.settings.phase_factor_random = 2
                                psys.settings.use_rotations = True
                                psys.settings.use_rotation_instance = True
                                psys.settings.use_multiply_size_mass = True
                                psys.settings.use_dynamic_rotation = True
                                psys.settings.particle_size = 0.2
                                psys.settings.size_random = 4
                                psys.settings.lifetime= 10000   
                                psys.seed = int(random.uniform(1,200))
                                psys.settings.render_type = 'COLLECTION'
                                psys.settings.instance_collection = wm.sna_kb_debris_part_collection
                                psys.settings.use_collection_pick_random = True
                                psys.settings.object_factor = .5
                                psys.settings.factor_random = 2
                                #psys.settings.effector_weights.gravity = random.uniform(0.5,1.5)
                                psys.settings.effector_weights.all = 0.0
                            #################################
                            psys.settings.frame_start = frame - 1
                            psys.settings.frame_end = frame + duration + rand - 1 #psys.settings.frame_start + duration + rand
                            if fcu_real_acc.evaluate(frame) > 0:
                                psys.settings.count = wm.sna_kb_particles_count
                            else:
                                psys.settings.count = int(wm.sna_kb_particles_count * wm.sna_kb_particles_impact_factor / 100)
                            frame += duration + rand 
                            number_psys += 1
                            list_vel.append(o)
                        else:
                            frame += 1
                else:
                     list_pb.append(o)
            if len(list_pb) > 0:
                msg = 'pb with ' + str(len(list_pb)) + 'object(s) selected'
            if (self.sna_particles_mode == 'Debris'):
                list(bpy.context.scene.sna_kb_kaboom_collection)[self.sna_index].has_debris = True
        else:
            kb_col = list(bpy.context.scene.sna_kb_kaboom_collection)[self.sna_index].kaboom_col
            f_start = (bpy.context.window_manager.sna_kb_custom_f_start if bpy.context.window_manager.sna_kb_custom_range_bool else bpy.context.scene.frame_start)
            f_end = (bpy.context.window_manager.sna_kb_custom_f_end if bpy.context.window_manager.sna_kb_custom_range_bool else bpy.context.scene.frame_end)
            particles_mode = self.sna_particles_mode
            col_id = list(bpy.context.scene.sna_kb_kaboom_collection)[self.sna_index].id
            update = self.sna_update
            wm = bpy.context.window_manager
            collection = bpy.data.collections[kb_col.name]
            list_ob=[]
            for o in collection.all_objects:
                if o.name[-2:] != '_O':
                    list_ob.append(o)
            bpy.ops.object.select_all(action='DESELECT')    
            for o in list_ob:
                list_pb = []
                if o.type == 'MESH' and not(o.hide_viewport) and not(o.sna_kb_is_iterator_source):
                    o.modifiers.new('Fluid', 'FLUID')
                    o.modifiers['Fluid'].fluid_type = 'FLOW'
                    o.modifiers['Fluid'].flow_settings.flow_behavior = 'INFLOW'
                    o.modifiers['Fluid'].flow_settings.flow_source = 'MESH'
                    o.modifiers['Fluid'].flow_settings.volume_density = 0
                    o.modifiers["Fluid"].flow_settings.surface_distance = 1.0
                    o.modifiers["Fluid"].flow_settings.temperature = 1.0
                    o.modifiers['Fluid'].flow_settings.temperature = 1.0
                    o.modifiers['Fluid'].flow_settings.use_absolute = False
                    o.modifiers['Fluid'].flow_settings.particle_size = 1
                    o.modifiers['Fluid'].flow_settings.use_initial_velocity = True
                    o.modifiers['Fluid'].flow_settings.velocity_factor = 2
                    o.modifiers['Fluid'].flow_settings.subframes = 0
                    o.modifiers["Fluid"].flow_settings.use_plane_init = True
                    emit_driver = o.driver_add('modifiers["Fluid"].flow_settings.surface_distance')
                    emit_driver.driver.type='SCRIPTED'
                    vel_var = emit_driver.driver.variables.new()
                    vel_var.name = 'vel'
                    vel_var.targets[0].id_type = 'OBJECT'
                    vel_var.targets[0].id = o
                    vel_var.targets[0].data_path = 'sna_kb_shard_velocity'
                    acc_var = emit_driver.driver.variables.new()
                    acc_var.name = 'acc'
                    acc_var.targets[0].id_type = 'OBJECT'
                    acc_var.targets[0].id = o
                    acc_var.targets[0].data_path = 'sna_kb_shard_acceleration'
                    emit_driver.driver.expression = '(' + str(wm.sna_kb_smoke_emission_moving) + '*vel+' + str(wm.sna_kb_smoke_emission_exploding) + '*acc)*noise.random()'
                    density_driver = o.driver_add('modifiers["Fluid"].flow_settings.density')
                    density_driver.driver.type='SCRIPTED'
                    vel_var = density_driver.driver.variables.new()
                    vel_var.name = 'vel'
                    vel_var.targets[0].id_type = 'OBJECT'
                    vel_var.targets[0].id = o
                    vel_var.targets[0].data_path = 'sna_kb_shard_velocity'
                    acc_var = density_driver.driver.variables.new()
                    acc_var.name = 'acc'
                    acc_var.targets[0].id_type = 'OBJECT'
                    acc_var.targets[0].id = o
                    acc_var.targets[0].data_path = 'sna_kb_shard_acceleration'
                    density_driver.driver.expression = '(' + str(wm.sna_kb_smoke_emission_moving) + '*vel+' + str(wm.sna_kb_smoke_emission_exploding) + '*acc)*noise.random()'
                    vel_obj_driver = o.driver_add('modifiers["Fluid"].flow_settings.velocity_coord')
                    vel_obj_driver[2].driver.type='SCRIPTED'
                    acc_var = vel_obj_driver[2].driver.variables.new()
                    acc_var.name = 'acc'
                    acc_var.targets[0].id_type = 'OBJECT'
                    acc_var.targets[0].id = o
                    acc_var.targets[0].data_path = 'sna_kb_shard_acceleration'
                    real_acc_var = vel_obj_driver[2].driver.variables.new()
                    real_acc_var.name = 'real_acc'
                    real_acc_var.targets[0].id_type = 'OBJECT'
                    real_acc_var.targets[0].id = o
                    real_acc_var.targets[0].data_path = 'sna_kb_shard_real_acceleration'
                    vel_obj_driver[2].driver.expression = '(' + str(wm.sna_kb_smoke_z_velocity) + '*noise.random()*acc) if (real_acc < 0) else 0'
                    vel_norm_driver = o.driver_add('modifiers["Fluid"].flow_settings.velocity_normal')
                    vel_norm_driver.driver.type='SCRIPTED'
                    acc_var = vel_norm_driver.driver.variables.new()
                    acc_var.name = 'acc'
                    acc_var.targets[0].id_type = 'OBJECT'
                    acc_var.targets[0].id = o
                    acc_var.targets[0].data_path = 'sna_kb_shard_acceleration'      
                    vel_norm_driver.driver.expression = str(wm.sna_kb_smoke_emission_exploding) + '*noise.random()*acc*5'
            if len(list_pb) > 0:
                msg = 'pb with ' + str(len(list_pb)) + 'object(s) selected'
            bpy.ops.object.select_all(action='DESELECT')         
            for o in list_pb:
                o.select_set(True)
            list(bpy.context.scene.sna_kb_kaboom_collection)[self.sna_index].has_smoke = True
        if particles['sna_tmp_bool']:
            list(bpy.context.scene.sna_kb_kaboom_collection)[self.sna_index].noisy_inner_show_view = True
        return {"FINISHED"}

    def invoke(self, context, event):
        return self.execute(context)


def sna_particles_function_A0EE2(layout_function, ):
    if (len(list(bpy.context.scene.sna_kb_kaboom_collection)) > 0):
        if list(bpy.context.scene.sna_kb_kaboom_collection)[bpy.context.scene.sna_kb_col_index].is_baked:
            col_B3507 = layout_function.column(heading='', align=False)
            col_B3507.alert = False
            col_B3507.enabled = True
            col_B3507.active = True
            col_B3507.use_property_split = False
            col_B3507.use_property_decorate = False
            col_B3507.scale_x = 1.0
            col_B3507.scale_y = 1.0
            col_B3507.alignment = 'Expand'.upper()
            if not True: col_B3507.operator_context = "EXEC_DEFAULT"
            if (bpy.context.window_manager.sna_kb_particle_mode == 'Debris'):
                col_A7ED0 = col_B3507.column(heading='', align=False)
                col_A7ED0.alert = False
                col_A7ED0.enabled = True
                col_A7ED0.active = True
                col_A7ED0.use_property_split = False
                col_A7ED0.use_property_decorate = False
                col_A7ED0.scale_x = 1.0
                col_A7ED0.scale_y = 1.0
                col_A7ED0.alignment = 'Expand'.upper()
                if not True: col_A7ED0.operator_context = "EXEC_DEFAULT"
                row_4A528 = col_A7ED0.row(heading='', align=False)
                row_4A528.alert = False
                row_4A528.enabled = True
                row_4A528.active = True
                row_4A528.use_property_split = False
                row_4A528.use_property_decorate = False
                row_4A528.scale_x = 1.0
                row_4A528.scale_y = 1.0
                row_4A528.alignment = 'Expand'.upper()
                if not True: row_4A528.operator_context = "EXEC_DEFAULT"
                row_4A528.prop(bpy.context.window_manager, 'sna_kb_show_debris_parts', text='', icon_value=(254 if bpy.context.window_manager.sna_kb_show_debris_parts else 253), emboss=False, expand=False, toggle=True)
                row_4A528.label(text='Debris Particles', icon_value=654)
                box_6D989 = col_A7ED0.box()
                box_6D989.alert = False
                box_6D989.enabled = bpy.context.window_manager.sna_kb_show_debris_parts
                box_6D989.active = True
                box_6D989.use_property_split = False
                box_6D989.use_property_decorate = False
                box_6D989.alignment = 'Expand'.upper()
                box_6D989.scale_x = 1.0
                box_6D989.scale_y = 1.0
                if not True: box_6D989.operator_context = "EXEC_DEFAULT"
                box_6D989.prop_search(bpy.context.window_manager, 'sna_kb_debris_part_collection', bpy.context.scene.collection, 'children', text='Parts', icon='NONE')
                if list(bpy.context.scene.sna_kb_kaboom_collection)[bpy.context.scene.sna_kb_col_index].has_debris:
                    col_C4E15 = box_6D989.column(heading='', align=False)
                    col_C4E15.alert = False
                    col_C4E15.enabled = True
                    col_C4E15.active = True
                    col_C4E15.use_property_split = False
                    col_C4E15.use_property_decorate = False
                    col_C4E15.scale_x = 1.0
                    col_C4E15.scale_y = 1.0
                    col_C4E15.alignment = 'Expand'.upper()
                    if not True: col_C4E15.operator_context = "EXEC_DEFAULT"
                    row_24766 = col_C4E15.row(heading='', align=True)
                    row_24766.alert = False
                    row_24766.enabled = True
                    row_24766.active = True
                    row_24766.use_property_split = False
                    row_24766.use_property_decorate = False
                    row_24766.scale_x = 1.0
                    row_24766.scale_y = 1.0
                    row_24766.alignment = 'Expand'.upper()
                    if not True: row_24766.operator_context = "EXEC_DEFAULT"
                    op = row_24766.operator('sna.kb_op_remove_particles_3b470', text='Remove Debris', icon_value=33, emboss=True, depress=False)
                    op.sna_index = bpy.context.scene.sna_kb_col_index
                    op.sna_particles_mode = 'Debris'
                else:
                    op = box_6D989.operator('sna.kb_op_add_particles_63f33', text='Add Debris', icon_value=31, emboss=True, depress=False)
                    op.sna_index = bpy.context.scene.sna_kb_col_index
                    op.sna_particles_mode = 'Debris'
                    op.sna_update = False
                if list(bpy.context.scene.sna_kb_kaboom_collection)[bpy.context.scene.sna_kb_col_index].has_debris:
                    col_9E43C = box_6D989.column(heading='', align=False)
                    col_9E43C.alert = False
                    col_9E43C.enabled = True
                    col_9E43C.active = True
                    col_9E43C.use_property_split = False
                    col_9E43C.use_property_decorate = False
                    col_9E43C.scale_x = 1.0
                    col_9E43C.scale_y = 1.0
                    col_9E43C.alignment = 'Expand'.upper()
                    if not True: col_9E43C.operator_context = "EXEC_DEFAULT"
                    col_9E43C.prop(bpy.context.window_manager, 'sna_kb_velocity_threshold', text='Threshold', icon_value=0, emboss=True)
                    col_9E43C.prop(bpy.context.window_manager, 'sna_kb_particles_duration', text='Emit Duration', icon_value=0, emboss=True)
                    col_B682A = col_9E43C.column(heading='', align=True)
                    col_B682A.alert = False
                    col_B682A.enabled = True
                    col_B682A.active = True
                    col_B682A.use_property_split = False
                    col_B682A.use_property_decorate = False
                    col_B682A.scale_x = 1.0
                    col_B682A.scale_y = 1.0
                    col_B682A.alignment = 'Expand'.upper()
                    if not True: col_B682A.operator_context = "EXEC_DEFAULT"
                    col_B682A.prop(bpy.context.window_manager, 'sna_kb_particles_count', text='Count', icon_value=0, emboss=True)
                    row_B4669 = col_B682A.row(heading='', align=False)
                    row_B4669.alert = False
                    row_B4669.enabled = True
                    row_B4669.active = True
                    row_B4669.use_property_split = False
                    row_B4669.use_property_decorate = False
                    row_B4669.scale_x = 1.0
                    row_B4669.scale_y = 1.0
                    row_B4669.alignment = 'Right'.upper()
                    if not True: row_B4669.operator_context = "EXEC_DEFAULT"
                    row_B4669.label(text='Impact', icon_value=0)
                    row_B4669.prop(bpy.context.window_manager, 'sna_kb_particles_impact_factor', text='', icon_value=0, emboss=True, slider=True)
                    row_05E31 = col_9E43C.row(heading='', align=False)
                    row_05E31.alert = False
                    row_05E31.enabled = True
                    row_05E31.active = True
                    row_05E31.use_property_split = False
                    row_05E31.use_property_decorate = False
                    row_05E31.scale_x = 1.0
                    row_05E31.scale_y = 1.0
                    row_05E31.alignment = 'Expand'.upper()
                    if not True: row_05E31.operator_context = "EXEC_DEFAULT"
                    row_05E31.template_icon(icon_value=692, scale=2.0)
                    row_9EACD = row_05E31.row(heading='', align=False)
                    row_9EACD.alert = False
                    row_9EACD.enabled = True
                    row_9EACD.active = True
                    row_9EACD.use_property_split = False
                    row_9EACD.use_property_decorate = False
                    row_9EACD.scale_x = 1.0
                    row_9EACD.scale_y = 2.0
                    row_9EACD.alignment = 'Expand'.upper()
                    if not True: row_9EACD.operator_context = "EXEC_DEFAULT"
                    op = row_9EACD.operator('sna.kb_op_add_particles_63f33', text='Update Debris', icon_value=0, emboss=True, depress=False)
                    op.sna_index = bpy.context.scene.sna_kb_col_index
                    op.sna_particles_mode = 'Debris'
                    op.sna_update = True
                    op = col_9E43C.operator('sna.kb_op_partcles_time_offset_04b7a', text='Time Offset', icon_value=73, emboss=True, depress=False)
                    op.sna_index = bpy.context.scene.sna_kb_col_index
                    op.sna_particles_mode = 'Debris'
                    op.sna_offset = 0
                box_B2DB8 = col_A7ED0.box()
                box_B2DB8.alert = False
                box_B2DB8.enabled = bpy.context.window_manager.sna_kb_show_debris_parts
                box_B2DB8.active = True
                box_B2DB8.use_property_split = False
                box_B2DB8.use_property_decorate = False
                box_B2DB8.alignment = 'Expand'.upper()
                box_B2DB8.scale_x = 1.0
                box_B2DB8.scale_y = 1.0
                if not True: box_B2DB8.operator_context = "EXEC_DEFAULT"
                box_B2DB8.label(text='Selected Particles:', icon_value=0)
                row_0D9D3 = box_B2DB8.row(heading='', align=False)
                row_0D9D3.alert = False
                row_0D9D3.enabled = sna_test_has_particles_AE61A(bpy.context.view_layer.objects.active, 'Debris')
                row_0D9D3.active = True
                row_0D9D3.use_property_split = False
                row_0D9D3.use_property_decorate = False
                row_0D9D3.scale_x = 1.0
                row_0D9D3.scale_y = 1.0
                row_0D9D3.alignment = 'Expand'.upper()
                if not True: row_0D9D3.operator_context = "EXEC_DEFAULT"
                row_0D9D3.template_icon(icon_value=_icons['deploy_settings_icon.png'].icon_id, scale=2.0)
                row_3CD07 = row_0D9D3.row(heading='', align=False)
                row_3CD07.alert = False
                row_3CD07.enabled = True
                row_3CD07.active = True
                row_3CD07.use_property_split = False
                row_3CD07.use_property_decorate = False
                row_3CD07.scale_x = 1.0
                row_3CD07.scale_y = 2.0
                row_3CD07.alignment = 'Expand'.upper()
                if not True: row_3CD07.operator_context = "EXEC_DEFAULT"
                op = row_3CD07.operator('sna.kb_op_copy_particle_params_bb41d', text='Deploy Particles', icon_value=0, emboss=True, depress=False)
                op.sna_index = bpy.context.scene.sna_kb_col_index
                op = row_3CD07.operator('sna.kb_op_remove_selected_objects_particles_9b69e', text='', icon_value=3, emboss=True, depress=False)
                op.sna_particles_mode = 'Debris'
                col_EA354 = col_A7ED0.column(heading='', align=False)
                col_EA354.alert = False
                col_EA354.enabled = True
                col_EA354.active = True
                col_EA354.use_property_split = False
                col_EA354.use_property_decorate = False
                col_EA354.scale_x = 1.0
                col_EA354.scale_y = 1.0
                col_EA354.alignment = 'Expand'.upper()
                if not True: col_EA354.operator_context = "EXEC_DEFAULT"
                col_EA354.label(text='Particles Cache', icon_value=722)
                box_B7FA0 = col_EA354.box()
                box_B7FA0.alert = False
                box_B7FA0.enabled = True
                box_B7FA0.active = True
                box_B7FA0.use_property_split = False
                box_B7FA0.use_property_decorate = False
                box_B7FA0.alignment = 'Expand'.upper()
                box_B7FA0.scale_x = 1.0
                box_B7FA0.scale_y = 1.0
                if not True: box_B7FA0.operator_context = "EXEC_DEFAULT"
                op = box_B7FA0.operator('ptcache.bake_all', text='Bake All Dynamics', icon_value=115, emboss=True, depress=False)
                op = box_B7FA0.operator('ptcache.free_bake_all', text='Delete All Bakes', icon_value=3, emboss=True, depress=False)
            else:
                col_85606 = col_B3507.column(heading='', align=False)
                col_85606.alert = False
                col_85606.enabled = True
                col_85606.active = True
                col_85606.use_property_split = False
                col_85606.use_property_decorate = False
                col_85606.scale_x = 1.0
                col_85606.scale_y = 1.0
                col_85606.alignment = 'Expand'.upper()
                if not True: col_85606.operator_context = "EXEC_DEFAULT"
                row_D8FD9 = col_85606.row(heading='', align=False)
                row_D8FD9.alert = False
                row_D8FD9.enabled = True
                row_D8FD9.active = True
                row_D8FD9.use_property_split = False
                row_D8FD9.use_property_decorate = False
                row_D8FD9.scale_x = 1.0
                row_D8FD9.scale_y = 1.0
                row_D8FD9.alignment = 'Expand'.upper()
                if not True: row_D8FD9.operator_context = "EXEC_DEFAULT"
                row_D8FD9.prop(bpy.context.window_manager, 'sna_kb_show_smoke_parts', text='', icon_value=(254 if bpy.context.window_manager.sna_kb_show_smoke_parts else 253), emboss=False, expand=False, toggle=True)
                row_D8FD9.label(text='Smoke', icon_value=657)
                box_FE289 = col_85606.box()
                box_FE289.alert = False
                box_FE289.enabled = bpy.context.window_manager.sna_kb_show_smoke_parts
                box_FE289.active = True
                box_FE289.use_property_split = False
                box_FE289.use_property_decorate = False
                box_FE289.alignment = 'Expand'.upper()
                box_FE289.scale_x = 1.0
                box_FE289.scale_y = 1.0
                if not True: box_FE289.operator_context = "EXEC_DEFAULT"
                if list(bpy.context.scene.sna_kb_kaboom_collection)[bpy.context.scene.sna_kb_col_index].has_smoke:
                    col_BA450 = box_FE289.column(heading='', align=False)
                    col_BA450.alert = False
                    col_BA450.enabled = True
                    col_BA450.active = True
                    col_BA450.use_property_split = False
                    col_BA450.use_property_decorate = False
                    col_BA450.scale_x = 1.0
                    col_BA450.scale_y = 1.0
                    col_BA450.alignment = 'Expand'.upper()
                    if not True: col_BA450.operator_context = "EXEC_DEFAULT"
                    row_0BC0B = col_BA450.row(heading='', align=True)
                    row_0BC0B.alert = False
                    row_0BC0B.enabled = True
                    row_0BC0B.active = True
                    row_0BC0B.use_property_split = False
                    row_0BC0B.use_property_decorate = False
                    row_0BC0B.scale_x = 1.0
                    row_0BC0B.scale_y = 1.0
                    row_0BC0B.alignment = 'Expand'.upper()
                    if not True: row_0BC0B.operator_context = "EXEC_DEFAULT"
                    op = row_0BC0B.operator('sna.kb_op_remove_particles_3b470', text='Remove Smoke Emission', icon_value=33, emboss=True, depress=False)
                    op.sna_index = bpy.context.scene.sna_kb_col_index
                    op.sna_particles_mode = 'Fluid'
                    col_BA450.prop(bpy.context.window_manager, 'sna_kb_smoke_emission_moving', text='On Move', icon_value=_icons['smoke_on_move.png'].icon_id, emboss=True)
                    col_E5EF0 = col_BA450.column(heading='', align=True)
                    col_E5EF0.alert = False
                    col_E5EF0.enabled = True
                    col_E5EF0.active = True
                    col_E5EF0.use_property_split = False
                    col_E5EF0.use_property_decorate = False
                    col_E5EF0.scale_x = 1.0
                    col_E5EF0.scale_y = 1.0
                    col_E5EF0.alignment = 'Expand'.upper()
                    if not True: col_E5EF0.operator_context = "EXEC_DEFAULT"
                    col_E5EF0.prop(bpy.context.window_manager, 'sna_kb_smoke_emission_exploding', text='On Explode', icon_value=0, emboss=True)
                    row_7938F = col_E5EF0.row(heading='', align=False)
                    row_7938F.alert = False
                    row_7938F.enabled = True
                    row_7938F.active = True
                    row_7938F.use_property_split = False
                    row_7938F.use_property_decorate = False
                    row_7938F.scale_x = 1.0
                    row_7938F.scale_y = 1.0
                    row_7938F.alignment = 'Right'.upper()
                    if not True: row_7938F.operator_context = "EXEC_DEFAULT"
                    row_7938F.label(text='On Impact', icon_value=0)
                    row_7938F.prop(bpy.context.window_manager, 'sna_kb_smoke_z_velocity', text='', icon_value=0, emboss=True)
                    row_9291B = col_BA450.row(heading='', align=False)
                    row_9291B.alert = False
                    row_9291B.enabled = True
                    row_9291B.active = True
                    row_9291B.use_property_split = False
                    row_9291B.use_property_decorate = False
                    row_9291B.scale_x = 1.0
                    row_9291B.scale_y = 1.0
                    row_9291B.alignment = 'Expand'.upper()
                    if not True: row_9291B.operator_context = "EXEC_DEFAULT"
                    row_9291B.template_icon(icon_value=692, scale=2.0)
                    row_A4F8B = row_9291B.row(heading='', align=False)
                    row_A4F8B.alert = False
                    row_A4F8B.enabled = True
                    row_A4F8B.active = True
                    row_A4F8B.use_property_split = False
                    row_A4F8B.use_property_decorate = False
                    row_A4F8B.scale_x = 1.0
                    row_A4F8B.scale_y = 2.0
                    row_A4F8B.alignment = 'Expand'.upper()
                    if not True: row_A4F8B.operator_context = "EXEC_DEFAULT"
                    op = row_A4F8B.operator('sna.kb_op_update_smoke_20f0a', text='Update Smoke', icon_value=0, emboss=True, depress=False)
                    op.sna_index = bpy.context.scene.sna_kb_col_index
                else:
                    op = box_FE289.operator('sna.kb_op_add_particles_63f33', text='Add Smoke Emission', icon_value=31, emboss=True, depress=False)
                    op.sna_index = bpy.context.scene.sna_kb_col_index
                    op.sna_particles_mode = 'Smoke'
                    op.sna_update = False
                col_85606.separator(factor=1.0)
                col_85606.separator(factor=1.0)
                box_2E35C = col_85606.box()
                box_2E35C.alert = False
                box_2E35C.enabled = bpy.context.window_manager.sna_kb_show_smoke_parts
                box_2E35C.active = True
                box_2E35C.use_property_split = False
                box_2E35C.use_property_decorate = False
                box_2E35C.alignment = 'Expand'.upper()
                box_2E35C.scale_x = 1.0
                box_2E35C.scale_y = 1.0
                if not True: box_2E35C.operator_context = "EXEC_DEFAULT"
                row_93F60 = box_2E35C.row(heading='', align=False)
                row_93F60.alert = False
                row_93F60.enabled = sna_test_has_smoke_emit_0EBFC(bpy.context.view_layer.objects.active)
                row_93F60.active = True
                row_93F60.use_property_split = False
                row_93F60.use_property_decorate = False
                row_93F60.scale_x = 1.0
                row_93F60.scale_y = 1.0
                row_93F60.alignment = 'Expand'.upper()
                if not True: row_93F60.operator_context = "EXEC_DEFAULT"
                row_93F60.template_icon(icon_value=_icons['deploy_smoke_icon.png'].icon_id, scale=2.0)
                row_97C33 = row_93F60.row(heading='', align=False)
                row_97C33.alert = False
                row_97C33.enabled = True
                row_97C33.active = True
                row_97C33.use_property_split = False
                row_97C33.use_property_decorate = False
                row_97C33.scale_x = 1.0
                row_97C33.scale_y = 2.0
                row_97C33.alignment = 'Expand'.upper()
                if not True: row_97C33.operator_context = "EXEC_DEFAULT"
                op = row_97C33.operator('sna.kb_op_copy_smoke_params_41685', text='Deploy Fluid', icon_value=0, emboss=True, depress=False)
                op.sna_index = bpy.context.scene.sna_kb_col_index
                op = row_97C33.operator('sna.kb_op_remove_selected_objects_particles_9b69e', text='', icon_value=3, emboss=True, depress=False)
                op.sna_particles_mode = 'Fluid'
                op = box_2E35C.operator('sna.kb_op_create_smoke_domain_7f35a', text='Add Smoke Domain', icon_value=93, emboss=True, depress=False)
                op = box_2E35C.operator('sna.kb_op_create_smoke_turbulence_6c76a', text='Add Turbulence Field', icon_value=348, emboss=True, depress=False)
                if sna_test_is_smoke_domain_32786(bpy.context.view_layer.objects.active):
                    row_6C7E3 = box_2E35C.row(heading='', align=False)
                    row_6C7E3.alert = False
                    row_6C7E3.enabled = True
                    row_6C7E3.active = True
                    row_6C7E3.use_property_split = False
                    row_6C7E3.use_property_decorate = False
                    row_6C7E3.scale_x = 1.0
                    row_6C7E3.scale_y = 1.0
                    row_6C7E3.alignment = 'Expand'.upper()
                    if not True: row_6C7E3.operator_context = "EXEC_DEFAULT"
                    row_6C7E3.label(text=bpy.context.view_layer.objects.active.name, icon_value=_icons['Smoke_Domain_Icon.png'].icon_id)
                    op = row_6C7E3.operator('sna.kb_op_refresh_smoke_domain_c9c70', text='', icon_value=692, emboss=True, depress=False)
        else:
            layout_function.label(text='Bake Before to Use', icon_value=2)
    else:
        layout_function.label(text='No Fracture Group', icon_value=110)


class SNA_OT_Kb_Op_Apply_Strenght_4E9Ae(bpy.types.Operator):
    bl_idname = "sna.kb_op_apply_strenght_4e9ae"
    bl_label = "kb_op_apply_strenght"
    bl_description = "Apply Strenght to Breakable Constraints of Selected Objects"
    bl_options = {"REGISTER", "UNDO"}

    @classmethod
    def poll(cls, context):
        if bpy.app.version >= (3, 0, 0) and False:
            cls.poll_message_set()
        return not False

    def execute(self, context):
        if (len(list(bpy.context.view_layer.objects.selected)) > 1):
            list_ob = bpy.context.selected_objects
            active_ob = bpy.context.object
            strenght = bpy.context.window_manager.sna_kb_constraint_strenght
            bpy.ops.object.select_all(action='DESELECT')
            for o in list_ob:
                if o.rigid_body:
                    try:
                        for c in bpy.data.collections['KB_Constraints'].objects:
                            if c.rigid_body_constraint.use_breaking:
                                o1=c.rigid_body_constraint.object1 
                                o2=c.rigid_body_constraint.object2
                                if (o == o1) or (o == o2):
                                    c.rigid_body_constraint.breaking_threshold = strenght       
                    except:
                        print('no constraints')
            bpy.ops.object.select_all(action='DESELECT')
            for o in list_ob:
                o.select_set(True)
            bpy.context.view_layer.objects.active = active_ob
            bpy.context.view_layer.update()
        else:
            self.report({'ERROR'}, message='Select at least 2 objects')
        return {"FINISHED"}

    def invoke(self, context, event):
        return self.execute(context)


class SNA_OT_Kb_Op_Add_Constraint_F02C2(bpy.types.Operator):
    bl_idname = "sna.kb_op_add_constraint_f02c2"
    bl_label = "kb_op_add_constraint"
    bl_description = "Add Constarints to Selected Objects"
    bl_options = {"REGISTER", "UNDO"}
    sna_breakable: bpy.props.BoolProperty(name='breakable', description='', default=False)

    @classmethod
    def poll(cls, context):
        if bpy.app.version >= (3, 0, 0) and False:
            cls.poll_message_set()
        return not False

    def execute(self, context):
        if (len(list(bpy.context.view_layer.objects.selected)) > 1):
            id_kb = None
            go_1 = None
            go_2 = None
            wm = bpy.context.window_manager
            id_kb = None
            collection = None
            list_objs = bpy.context.selected_objects
            for o in list_objs:
                for kb in bpy.context.scene.sna_kb_kaboom_collection:
                    if o in kb.kaboom_col.objects[:]:
                        fisrt_ob = o
                        id_kb = kb.id
                        collection = bpy.data.collections[kb.kaboom_col.name]
                        obj_src = kb.object_src
                        break
            go_1 = True
            go_2 = False
            frame = bpy.context.scene.frame_start
            try:
                for f in obj_src.animation_data.action.fcurves:
                    if f.data_path == 'hide_render':
                        frame = f.keyframe_points[-1].co[0]
            except:
                print('Object source has no visibility keyframe')
            bpy.context.scene.frame_set(int(frame))
            bpy.context.view_layer.update()
            mass = wm.sna_kb_constraint_mass
            strenght = wm.sna_kb_constraint_strenght
            bpy.ops.object.select_all(action='DESELECT')
            for ob in list_objs:
                if ob.type == 'MESH' and ob.rigid_body:
                    go_2 = True
                    ob.select_set(True)
                    if ob not in collection.objects[:]:
                         go_1 = False
            try:
                bpy.context.view_layer.objects.active = bpy.context.selected_objects[0]
            except:
                print('list object is empty')
            bpy.context.space_data.overlay.show_relationship_lines = False
            if go_1:
                if go_2:
                    col_id = id_kb
                    breakable = self.sna_breakable
                    constraint_list = []
                    bpy.ops.rigidbody.mass_calculate(material='Custom', density=mass)
                    bpy.ops.rigidbody.connect(connection_pattern='CHAIN_DISTANCE')
                    for ob in bpy.data.objects:
                        if ob.name[:10] == "Constraint":
                            ob.name = col_id + "_KB_Link"
                            ob.empty_display_type = 'PLAIN_AXES'
                            ob.empty_display_size = 0.04
                            constraint_list.append(ob)
                            if breakable:
                                ob.rigid_body_constraint.use_breaking = True
                                ob.rigid_body_constraint.breaking_threshold = strenght
                            object_old_coll = ob.users_collection
                            collection = bpy.data.collections.get( 'KB_Constraints' )
                            if collection not in object_old_coll:
                                if collection is None:
                                    collection = bpy.data.collections.new( 'KB_Constraints' )
                                    bpy.context.scene.collection.children.link( collection )
                            collection.objects.link( ob )
                            for col in  object_old_coll:   
                                if col.name != bpy.context.scene.rigidbody_world.constraints.name:
                                    col.objects.unlink(ob)
                    bpy.context.view_layer.update()
                    #bpy.ops.screen.animation_play()
                    index_0_f643c = sna_kb_fc_kaboom_index_by_id_3F8AD(id_kb)
                else:
                    self.report({'ERROR'}, message='No Rigid Body')
            else:
                self.report({'ERROR'}, message='Objects are not in the same Fracrured Group')
        else:
            self.report({'ERROR'}, message='Select at least 2 objects')
        return {"FINISHED"}

    def invoke(self, context, event):
        return self.execute(context)


class SNA_OT_Kb_Op_Apply_Mass_D9047(bpy.types.Operator):
    bl_idname = "sna.kb_op_apply_mass_d9047"
    bl_label = "kb_op_apply_mass"
    bl_description = "Apply Mass to Fratured Group Objects"
    bl_options = {"REGISTER", "UNDO"}
    sna_index: bpy.props.IntProperty(name='index', description='', default=0, subtype='NONE')

    @classmethod
    def poll(cls, context):
        if bpy.app.version >= (3, 0, 0) and False:
            cls.poll_message_set()
        return not False

    def execute(self, context):
        kb_col = list(bpy.context.scene.sna_kb_kaboom_collection)[self.sna_index].kaboom_col
        list_ob = bpy.context.selected_objects
        active_ob = bpy.context.object
        wm = bpy.context.window_manager
        collection = bpy.data.collections[kb_col.name]
        mass = wm.sna_kb_constraint_mass
        bpy.ops.object.select_all(action='DESELECT')
        bpy.context.scene.frame_set(bpy.context.scene.frame_start)
        bpy.context.view_layer.update()
        for ob in collection.all_objects:
            ob.select_set(True)
            bpy.context.view_layer.objects.active = ob
        try:
            bpy.ops.rigidbody.mass_calculate(material='Custom', density=mass)
        except:
            print('No rigibody found')
        bpy.ops.object.select_all(action='DESELECT')
        for o in list_ob:
            o.select_set(True)
        bpy.context.view_layer.objects.active = active_ob
        bpy.context.view_layer.update()
        return {"FINISHED"}

    def invoke(self, context, event):
        return self.execute(context)


def sna_test_object_is_in_rigibody_world_collection_0E5E5(object):
    ob = object
    out = None
    out = False
    if bpy.context.scene.rigidbody_world:
        if ob in bpy.context.scene.rigidbody_world.collection.objects[:]:
            out = True
    return [out, None]


class SNA_OT_Kb_Op_Set_Passiv_Rg_30C43(bpy.types.Operator):
    bl_idname = "sna.kb_op_set_passiv_rg_30c43"
    bl_label = "KB_OP_set_passiv_RG"
    bl_description = "Set Passiv Rigid Body Object"
    bl_options = {"REGISTER", "UNDO"}

    @classmethod
    def poll(cls, context):
        if bpy.app.version >= (3, 0, 0) and False:
            cls.poll_message_set()
        return not False

    def execute(self, context):
        ob = bpy.context.view_layer.objects.active
        bpy.ops.rigidbody.object_add()
        bpy.ops.rigidbody.objects_remove()
        bpy.ops.rigidbody.objects_add(type='PASSIVE')
        ob.rigid_body.friction = .9
        for mod in ob.modifiers:
            ob.modifiers.remove(mod)
        bpy.ops.object.modifier_add(type='COLLISION')
        m = ob.modifiers['Collision']
        m.name = 'KB_Collision'
        ob.collision.damping_factor = .9
        ob.collision.damping_random = .3
        ob.collision.friction_factor = .7
        ob.collision.friction_random = .2
        ob.collision.stickiness = 8
        return {"FINISHED"}

    def invoke(self, context, event):
        return self.execute(context)


def sna_test_rg_enable_0252E(ob):
    ob = ob
    type = None
    try:
        type = ob.rigid_body.type
    except:
        type = "No RG"
    return type


def sna_rigidbody1_3B83C(layout_function, ):
    layout_function.label(text='Constraints', icon_value=175)
    if (len(list(bpy.context.scene.sna_kb_kaboom_collection)) > 0):
        box_91504 = layout_function.box()
        box_91504.alert = False
        box_91504.enabled = True
        box_91504.active = True
        box_91504.use_property_split = False
        box_91504.use_property_decorate = False
        box_91504.alignment = 'Expand'.upper()
        box_91504.scale_x = 1.0
        box_91504.scale_y = 1.0
        if not True: box_91504.operator_context = "EXEC_DEFAULT"
        col_E2453 = box_91504.column(heading='', align=True)
        col_E2453.alert = False
        col_E2453.enabled = True
        col_E2453.active = True
        col_E2453.use_property_split = False
        col_E2453.use_property_decorate = False
        col_E2453.scale_x = 1.0
        col_E2453.scale_y = 1.0
        col_E2453.alignment = 'Expand'.upper()
        if not True: col_E2453.operator_context = "EXEC_DEFAULT"
        row_EB267 = col_E2453.row(heading='', align=True)
        row_EB267.alert = False
        row_EB267.enabled = True
        row_EB267.active = True
        row_EB267.use_property_split = False
        row_EB267.use_property_decorate = False
        row_EB267.scale_x = 1.0
        row_EB267.scale_y = 1.0
        row_EB267.alignment = 'Expand'.upper()
        if not True: row_EB267.operator_context = "EXEC_DEFAULT"
        row_C73BD = row_EB267.row(heading='', align=True)
        row_C73BD.alert = False
        row_C73BD.enabled = True
        row_C73BD.active = True
        row_C73BD.use_property_split = False
        row_C73BD.use_property_decorate = False
        row_C73BD.scale_x = 1.0
        row_C73BD.scale_y = 1.0
        row_C73BD.alignment = 'Expand'.upper()
        if not True: row_C73BD.operator_context = "EXEC_DEFAULT"
        op = row_C73BD.operator('sna.kb_op_add_constraint_f02c2', text='Fixed', icon_value=31, emboss=True, depress=False)
        op.sna_breakable = False
        op = row_C73BD.operator('sna.kb_op_add_constraint_f02c2', text='Breakable', icon_value=31, emboss=True, depress=False)
        op.sna_breakable = True
        row_8A18D = col_E2453.row(heading='', align=True)
        row_8A18D.alert = False
        row_8A18D.enabled = True
        row_8A18D.active = True
        row_8A18D.use_property_split = False
        row_8A18D.use_property_decorate = False
        row_8A18D.scale_x = 1.0
        row_8A18D.scale_y = 1.0
        row_8A18D.alignment = 'Expand'.upper()
        if not True: row_8A18D.operator_context = "EXEC_DEFAULT"
        row_8A18D.prop(bpy.context.window_manager, 'sna_kb_constraint_strenght', text='Strength', icon_value=0, emboss=True)
        op = row_8A18D.operator('sna.kb_op_apply_strenght_4e9ae', text='', icon_value=692, emboss=True, depress=False)
        row_2C354 = col_E2453.row(heading='', align=True)
        row_2C354.alert = False
        row_2C354.enabled = True
        row_2C354.active = True
        row_2C354.use_property_split = False
        row_2C354.use_property_decorate = False
        row_2C354.scale_x = 1.0
        row_2C354.scale_y = 1.0
        row_2C354.alignment = 'Expand'.upper()
        if not True: row_2C354.operator_context = "EXEC_DEFAULT"
        row_2C354.label(text='Remove by', icon_value=3)
        op = row_2C354.operator('sna.kb_op_remove_constraint_39cba', text='', icon_value=250, emboss=True, depress=False)
        op.sna_index = bpy.context.scene.sna_kb_col_index
        op = row_2C354.operator('sna.kb_op_remove_selected_objects_constraints_8887f', text='', icon_value=130, emboss=True, depress=False)
    else:
        layout_function.label(text='No Fracture Group', icon_value=2)
    layout_function.label(text='Fragments', icon_value=_icons['Part_icon.png'].icon_id)
    box_7C9D2 = layout_function.box()
    box_7C9D2.alert = False
    box_7C9D2.enabled = True
    box_7C9D2.active = True
    box_7C9D2.use_property_split = False
    box_7C9D2.use_property_decorate = False
    box_7C9D2.alignment = 'Expand'.upper()
    box_7C9D2.scale_x = 1.0
    box_7C9D2.scale_y = 1.0
    if not True: box_7C9D2.operator_context = "EXEC_DEFAULT"
    row_07DEB = box_7C9D2.row(heading='', align=False)
    row_07DEB.alert = False
    row_07DEB.enabled = True
    row_07DEB.active = True
    row_07DEB.use_property_split = False
    row_07DEB.use_property_decorate = False
    row_07DEB.scale_x = 1.0
    row_07DEB.scale_y = 1.0
    row_07DEB.alignment = 'Expand'.upper()
    if not True: row_07DEB.operator_context = "EXEC_DEFAULT"
    row_07DEB.label(text='', icon_value=_icons['mass_icon.png'].icon_id)
    row_07DEB.prop(bpy.context.window_manager, 'sna_kb_constraint_mass', text='Mass', icon_value=0, emboss=True)
    op = row_07DEB.operator('sna.kb_op_apply_mass_d9047', text='', icon_value=692, emboss=True, depress=False)
    op.sna_index = bpy.context.scene.sna_kb_col_index
    layout_function.label(text='Obstacles:', icon_value=156)
    box_7E3BB = layout_function.box()
    box_7E3BB.alert = False
    box_7E3BB.enabled = True
    box_7E3BB.active = True
    box_7E3BB.use_property_split = False
    box_7E3BB.use_property_decorate = False
    box_7E3BB.alignment = 'Expand'.upper()
    box_7E3BB.scale_x = 1.0
    box_7E3BB.scale_y = 1.0
    if not True: box_7E3BB.operator_context = "EXEC_DEFAULT"
    row_8BAF9 = box_7E3BB.row(heading='', align=True)
    row_8BAF9.alert = False
    row_8BAF9.enabled = True
    row_8BAF9.active = True
    row_8BAF9.use_property_split = False
    row_8BAF9.use_property_decorate = False
    row_8BAF9.scale_x = 1.0
    row_8BAF9.scale_y = 1.0
    row_8BAF9.alignment = 'Expand'.upper()
    if not True: row_8BAF9.operator_context = "EXEC_DEFAULT"
    if ((sna_test_rg_enable_0252E(bpy.context.view_layer.objects.active) == 'PASSIVE') and sna_test_object_is_in_rigibody_world_collection_0E5E5(bpy.context.view_layer.objects.active)[0]):
        row_8BAF9.label(text='is Collider', icon_value=(415 if ((sna_test_rg_enable_0252E(bpy.context.view_layer.objects.active) == 'PASSIVE') and sna_test_object_is_in_rigibody_world_collection_0E5E5(bpy.context.view_layer.objects.active)[0]) else 414))
    else:
        op = row_8BAF9.operator('sna.kb_op_set_passiv_rg_30c43', text='Set Passiv Obstacle', icon_value=(415 if ((sna_test_rg_enable_0252E(bpy.context.view_layer.objects.active) == 'PASSIVE') and sna_test_object_is_in_rigibody_world_collection_0E5E5(bpy.context.view_layer.objects.active)[0]) else 414), emboss=True, depress=False)
    if ((sna_test_rg_enable_0252E(bpy.context.view_layer.objects.active) == 'PASSIVE') and sna_test_object_is_in_rigibody_world_collection_0E5E5(bpy.context.view_layer.objects.active)[0]):
        op = row_8BAF9.operator('rigidbody.object_remove', text='remove', icon_value=33, emboss=True, depress=False)


class SNA_OT_Kb_Op_Remove_Selected_Objects_Constraints_8887F(bpy.types.Operator):
    bl_idname = "sna.kb_op_remove_selected_objects_constraints_8887f"
    bl_label = "kb_op_remove_selected_objects_constraints"
    bl_description = "Remove Constraints by Objects"
    bl_options = {"REGISTER", "UNDO"}

    @classmethod
    def poll(cls, context):
        if bpy.app.version >= (3, 0, 0) and False:
            cls.poll_message_set()
        return not False

    def execute(self, context):
        list_ob = bpy.context.selected_objects
        bpy.ops.object.select_all(action='DESELECT')
        for o in list_ob:
            try:
                for c in bpy.data.collections['KB_Constraints'].objects:
                    o1=c.rigid_body_constraint.object1 
                    o2=c.rigid_body_constraint.object2
                    if o == o1 or o == o2:
                        c.select_set(True)       
                        bpy.context.view_layer.objects.active = c
                        bpy.ops.rigidbody.constraint_remove()
                        bpy.data.objects.remove(c)
            except:
                pass
        bpy.context.view_layer.update()
        return {"FINISHED"}

    def invoke(self, context, event):
        return self.execute(context)


class SNA_OT_Kb_Op_Remove_Constraint_39Cba(bpy.types.Operator):
    bl_idname = "sna.kb_op_remove_constraint_39cba"
    bl_label = "kb_op_remove_constraint"
    bl_description = "Remove Constraints by Fratured Group"
    bl_options = {"REGISTER", "UNDO"}
    sna_index: bpy.props.IntProperty(name='index', description='', default=0, subtype='NONE')

    @classmethod
    def poll(cls, context):
        if bpy.app.version >= (3, 0, 0) and False:
            cls.poll_message_set()
        return not False

    def execute(self, context):
        kb_col = list(bpy.context.scene.sna_kb_kaboom_collection)[self.sna_index].kaboom_col
        col_id = list(bpy.context.scene.sna_kb_kaboom_collection)[self.sna_index].id
        wm = bpy.context.window_manager
        collection = bpy.data.collections[kb_col.name]
        bpy.ops.object.select_all(action='DESELECT')
        try:
            for ob in bpy.data.collections['KB_Constraints'].objects:
                if (col_id + '_KB_Link') in ob.name:
                    ob.select_set(True)
                    bpy.context.view_layer.objects.active = ob
                    bpy.ops.rigidbody.constraint_remove()
                    bpy.data.objects.remove(ob)
        except:
            print('Non KB_Constraints collection found')
        bpy.context.view_layer.update()
        list(bpy.context.scene.sna_kb_kaboom_collection)[self.sna_index].has_constraints = False
        return {"FINISHED"}

    def invoke(self, context, event):
        return self.execute(context)


class SNA_OT_Kb_Op_Simulation_Keyframe_3243E(bpy.types.Operator):
    bl_idname = "sna.kb_op_simulation_keyframe_3243e"
    bl_label = "KB_OP_simulation_keyframe"
    bl_description = ""
    bl_options = {"REGISTER", "UNDO"}
    sna_col_name: bpy.props.StringProperty(name='col_name', description='', default='', subtype='NONE', maxlen=0)

    @classmethod
    def poll(cls, context):
        if bpy.app.version >= (3, 0, 0) and False:
            cls.poll_message_set()
        return not False

    def execute(self, context):
        collection_name = self.sna_col_name
        collection = bpy.data.collections[collection_name]
        frame = bpy.context.scene.frame_current
        if bpy.context.scene.rigidbody_world:
            bpy.context.scene.rigidbody_world.enabled = True
        else:
            bpy.ops.rigidbody.world_add()
        if not bpy.context.scene.rigidbody_world.collection:
            RB_World_collection = bpy.data.collections.new( 'RB_World' )
            bpy.context.scene.rigidbody_world.collection = RB_World_collection
        bpy.ops.object.select_all(action='DESELECT')
        #### frame 1
        #bpy.context.scene.frame_set(frame - 1)
        for ob in collection.objects:    
            if ob.animation_data and ob.animation_data.action:
                all_fcurves = ob.animation_data.action.fcurves
                for fcurve in all_fcurves:
                    if fcurve.data_path not in ['display_type','hide_render','rigid_body.collision_collections']:
                        all_fcurves.remove(fcurve)
            if bpy.context.scene.rigidbody_world.collection not in ob.users_collection:
                bpy.context.scene.rigidbody_world.collection.objects.link(ob)
            ob.rigid_body.kinematic = True
            ob.keyframe_insert('rigid_body.kinematic', frame = frame - 1)
            ob.rigid_body.kinematic = False
            ob.keyframe_insert('rigid_body.kinematic', frame = frame)
        bpy.context.scene.frame_set(bpy.context.scene.frame_start)
        bpy.ops.sna.kb_op_select_kaboom_parts_d8203('INVOKE_DEFAULT', sna_index=bpy.context.scene.sna_kb_col_index)
        return {"FINISHED"}

    def invoke(self, context, event):
        return self.execute(context)


class SNA_OT_Kb_Op_Krumble_4Bc1F(bpy.types.Operator):
    bl_idname = "sna.kb_op_krumble_4bc1f"
    bl_label = "KB_OP_Krumble"
    bl_description = ""
    bl_options = {"REGISTER", "UNDO"}

    def sna_mode_enum_items(self, context):
        return [("No Items", "No Items", "No generate enum items node found to create items!", "ERROR", 0)]
    sna_mode: bpy.props.EnumProperty(name='mode', description='', items=[('Selected Fracture Group', 'Selected Fracture Group', '', 0, 0), ('All Fracture Groups', 'All Fracture Groups', '', 0, 1)])

    @classmethod
    def poll(cls, context):
        if bpy.app.version >= (3, 0, 0) and False:
            cls.poll_message_set()
        return not False

    def execute(self, context):
        if ((not bpy.context.window_manager.sna_kb_blast_all_groups) and list(bpy.context.scene.sna_kb_kaboom_collection)[bpy.context.scene.sna_kb_col_index].is_baked):
            self.report({'ERROR'}, message='Fractured Group Is Baked')
        if sna_kb_fc_blaster_frame_range_B6592()[2]:
            bpy.context.scene.frame_current = (bpy.context.window_manager.sna_kb_custom_f_start if bpy.context.window_manager.sna_kb_custom_range_bool else sna_kb_fc_blaster_frame_range_B6592()[0])
            f_start = (bpy.context.window_manager.sna_kb_custom_f_start if bpy.context.window_manager.sna_kb_custom_range_bool else sna_kb_fc_blaster_frame_range_B6592()[0])
            f_end = int((bpy.context.window_manager.sna_kb_custom_f_end if bpy.context.window_manager.sna_kb_custom_range_bool else sna_kb_fc_blaster_frame_range_B6592()[1]) + 5.0)
            all = (not bpy.context.window_manager.sna_kb_blast_all_groups)
            list_reduced_selection = None
            import math
            import time

            def distance_point(point1: Vector, point2: Vector) -> float:   
                """Calculate distance between two points.""" 
                return (point2 - point1).length
            print(" * * * * * *  K R U M B L E * * * * * * ")
            print(" - - - - - -  Setup RB - - - - - - ")
            t = time.time() ######################################### time
            if not bpy.context.scene.rigidbody_world:
                bpy.ops.rigidbody.world_add()
            if not bpy.context.scene.rigidbody_world.collection:
                RB_World_collection = bpy.data.collections.new( 'RB_World' )
                bpy.context.scene.rigidbody_world.collection = RB_World_collection
            bpy.context.scene.frame_current = f_start
            list_obj = []
            #### reset animation
            bpy.ops.object.select_all(action='DESELECT')
            if all:
                index_col = bpy.context.scene.sna_kb_col_index
                collection_name = bpy.context.scene.sna_kb_kaboom_collection[index_col].kaboom_col.name
                collection = bpy.data.collections[collection_name]
                for ob in collection.all_objects:
                    list_obj.append(ob)
                    if not ob.rigid_body or not(ob.name in bpy.context.scene.rigidbody_world.collection.objects):
                        bpy.context.scene.rigidbody_world.collection.objects.link(ob)
            #### clear select animation datas                                 
                    if ob.animation_data and ob.animation_data.action:
                        all_fcurves = ob.animation_data.action.fcurves
                        for fcurve in all_fcurves:
                            if fcurve.data_path not in ['display_type','hide_render','rigid_body.collision_collections']:
                                all_fcurves.remove(fcurve)
             #### set up active fractured part:
                    ob.rigid_body.type = 'ACTIVE'
                    ob.rigid_body.enabled = True
                    ob.rigid_body.collision_shape = 'CONVEX_HULL'
                    ob.rigid_body.collision_margin = 0.0001
                    ob.rigid_body.kinematic = True
                    ob.rigid_body.mesh_source = 'BASE'
                    ob.keyframe_insert('rigid_body.kinematic')
                    for m in ob.modifiers:
                        if 'noisy_inner' in m.name:
                            m.show_viewport = False
                            m.keyframe_insert('show_viewport')
                            m.show_render = False
                            m.keyframe_insert('show_render')
            else:
                for i in range(len(bpy.context.scene.sna_kb_kaboom_collection)):
                    collection_name = bpy.context.scene.sna_kb_kaboom_collection[i].kaboom_col.name
                    collection = bpy.data.collections[collection_name]
                    for ob in collection.all_objects:
                        list_obj.append(ob)
                        if not ob.rigid_body or not(ob.name in bpy.context.scene.rigidbody_world.collection.objects):
                            bpy.context.scene.rigidbody_world.collection.objects.link(ob)
                        ob.rigid_body.kinematic = True
                        ob.keyframe_insert('rigid_body.kinematic')
                        for m in ob.modifiers:
                            if 'noisy_inner' in m.name:
                                m.show_viewport = False
                                m.keyframe_insert('show_viewport')
                                m.show_render = False
                                m.keyframe_insert('show_render')                                  
                            ob.animation_data_clear()
                     #### set up active fractured part:
                            ob.rigid_body.type = 'ACTIVE'
                            ob.rigid_body.enabled = True
                            ob.rigid_body.collision_shape = 'CONVEX_HULL'#'MESH'
                            ob.rigid_body.collision_margin = 0.0001
                            ob.rigid_body.kinematic = True
                            ob.rigid_body.mesh_source = 'BASE'
                            ob.animation_data_clear()
            # set rigibody world range to scene range
            bpy.context.scene.rigidbody_world.point_cache.frame_start = bpy.context.scene.frame_start
            bpy.context.scene.rigidbody_world.point_cache.frame_end = bpy.context.scene.frame_end
            ###################################################### make list of concerned fractured parts:
            list_reduced_selection=[]
            bpy.ops.object.select_all(action='DESELECT')
            for frame in range(f_start,f_end): 
                bpy.context.scene.frame_set(frame)  
                bmb_range = bpy.data.objects.get('WreckingBallOuter-KrumblR')
                bmb_core_size = bmb_range["INNER"]    
                bmb_range_size = bmb_range["OUTER"]  
                p1 = bmb_range.location
                for ob in list_obj:    
                    # DISTANCE        
                    p2 = ob.location
                    dist = distance_point(p1,p2)        
                    if dist<=bmb_range_size/2 :
                        ob.select_set(True)
                        bpy.context.view_layer.objects.active = ob
                        if ob not in list_reduced_selection:
                            list_reduced_selection.append(ob)
            ################################################################################
            #bpy.ops.rigidbody.mass_calculate(material='Brick (Pressed)', density=2400)
            T = time.time() - t
            print('setup RB done in ', T)
            bpy.ops.object.select_all(action='DESELECT')
            kaboomtree['sna_kb_list_tmp'] = list_reduced_selection
            f_start = (bpy.context.window_manager.sna_kb_custom_f_start if bpy.context.window_manager.sna_kb_custom_range_bool else sna_kb_fc_blaster_frame_range_B6592()[0])
            f_end = int((bpy.context.window_manager.sna_kb_custom_f_end if bpy.context.window_manager.sna_kb_custom_range_bool else sna_kb_fc_blaster_frame_range_B6592()[1]) + 5.0)
            list_reduced_selection = list_reduced_selection
            wm = bpy.context.window_manager
            T = None
            from random import randint
            from math import sqrt, radians

            def distance_point(point1: Vector, point2: Vector) -> float: 
                """Calculate distance between two points.""" 
                return (point2 - point1).length
            t = time.time()
            tmp_col = None
            if bpy.context.scene.rigidbody_world.constraints:
                tmp_col = bpy.context.scene.rigidbody_world.constraints
                bpy.context.scene.rigidbody_world.constraints = None
            bpy.context.view_layer.update()
            list_fractured_parts = list_reduced_selection.copy()
            ############################ initialisation
            number_found = 0
            range_list = len(list_fractured_parts)
            blaster = bpy.data.objects.get('WreckingBallOuter-KrumblR')
            blaster_core_radius = blaster["INNER"]/2  
            blaster_range_radius = blaster["OUTER"]/2
            bpy.context.scene.rigidbody_world.enabled = False
            spin = wm.sna_kb_part_spin/100
            spin_rand = wm.sna_kb_part_spin_rand
            blast_radial_rand = wm.sna_kb_bomb_radial_force_rand #vector
            blast_radial = wm.sna_kb_bomb_radial_force/100 #pwr
            blast_directionnal_force = Vector((wm.sna_kb_bomb_directionnal_force[0],
                                               wm.sna_kb_bomb_directionnal_force[1],
                                               wm.sna_kb_bomb_directionnal_force[2]))
            blast_directionnal_force /= 100
            blast_directionnal_force_rand = wm.sna_kb_bomb_directionnal_force_rand
            scene = bpy.context.scene
            ########################### create kdtree
            dict_loc = {}
            forces = {}
            i = 0
            for o in list_fractured_parts:
                o['kb_simu_delay'] = -1
                #o.keyframe_insert('rigid_body.kinematic',frame = f_start)
                dict_loc[i] = o.location.copy()
                forces[i] = blaster_range_radius
                i += 1
            size = len(list_fractured_parts)
            kd = kdtree.KDTree(size)
            for i in range(len(list_fractured_parts)):
                v = dict_loc[i]
                kd.insert(v, i)
            kd.balance()
            ########################### boucle animation
            for frame in range(f_start,f_end):
                scene.frame_set(frame)
                blaster_core_radius = blaster["INNER"]/2  
                blaster_range_radius = blaster["OUTER"]/2
                co_find = blaster.location
                co_founds = kd.find_range(co_find,blaster_range_radius) # recherche dans sphere de centre 'co_find' et de rayon 'blaster_range_radius'
                for co,i,d in co_founds:
                    radial_random = random.uniform(-blast_radial_rand,blast_radial_rand)
                    directionnal_random = random.uniform(-blast_directionnal_force_rand,blast_directionnal_force_rand)
                    spin_random = random.uniform(-spin_rand,spin_rand)
                    k = max ((blaster_core_radius - d),0)
                    radial_force = (co - co_find)
                    if radial_force.length < forces[i]:
                        if (list_fractured_parts[i]['kb_simu_delay'] < 0) or (frame - list_fractured_parts[i]['kb_simu_delay']) < 2:
                            forces[i] = radial_force.length
                            k *= k # k au carré
                            list_fractured_parts[i].location = Vector(dict_loc[i])
                            list_fractured_parts[i].keyframe_insert('location', frame = frame)
                            list_fractured_parts[i].location.x = dict_loc[i][0] +  k*(radial_force.x * blast_radial * (1 + radial_random/100) + blast_directionnal_force.x * (1 + directionnal_random/100))
                            list_fractured_parts[i].location.y = dict_loc[i][1] +  k*(radial_force.y * blast_radial * (1 + radial_random/100) + blast_directionnal_force.y * (1 + directionnal_random/100))
                            list_fractured_parts[i].location.z = dict_loc[i][2] +  k*(radial_force.z * blast_radial * (1 + radial_random/100) + blast_directionnal_force.z * (1 + directionnal_random/100))
                            list_fractured_parts[i].keyframe_insert('location', frame = frame + 1)
                            list_fractured_parts[i].rigid_body.kinematic = True
                            list_fractured_parts[i].keyframe_insert('rigid_body.kinematic',frame = frame + 1)                 
                            list_fractured_parts[i].rigid_body.kinematic = False
                            list_fractured_parts[i].keyframe_insert('rigid_body.kinematic',frame = frame + 2)
                            list_fractured_parts[i].rotation_euler = (0.0, 0.0, 0.0)
                            list_fractured_parts[i].keyframe_insert('rotation_euler', frame = frame)
                            rot = spin * ( 1 + spin_random/100)
                            list_fractured_parts[i].rotation_euler = ( k*rot*random.choice((-1, 1)), 
                                                                       k*rot*random.choice((-1, 1)), 
                                                                       k*rot*random.choice((-1, 1)) )
                            list_fractured_parts[i].keyframe_insert('rotation_euler', frame = frame + 1)
                            list_fractured_parts[i]['kb_simu_delay'] = frame
                if wm.sna_kb_live_blast:
                    bpy.ops.wm.redraw_timer(type='DRAW_WIN_SWAP', iterations=1)
                    bpy.context.view_layer.update()
            for o in list_fractured_parts:
                del o['kb_simu_delay']
            bpy.context.scene.rigidbody_world.enabled = True
            scene.frame_set(scene.frame_start)
            bpy.context.view_layer.update()
            if tmp_col:
                bpy.context.scene.rigidbody_world.constraints = tmp_col
            T = time.time() - t     
            self.report({'INFO'}, message='Blast simu done in ' + str(T) + ' secondes.')
            if bpy.context.window_manager.sna_kb_blast_all_groups:
                for i_7D820 in range(len(bpy.context.scene.sna_kb_kaboom_collection)):
                    bpy.context.scene.sna_kb_kaboom_collection[i_7D820].is_baked = False
            else:
                list(bpy.context.scene.sna_kb_kaboom_collection)[0].is_baked = False
            exec('bpy.ops.screen.animation_play()')
        else:
            self.report({'ERROR'}, message='Blaster has no animation keys')
        return {"FINISHED"}

    def invoke(self, context, event):
        return self.execute(context)


def sna_kb_fc_blaster_frame_range_B6592():
    f_start = None
    f_end = None
    blaster_animated = None
    blaster = bpy.data.objects['WreckingBallOuter-KrumblR']
    blaster_animated = False
    if blaster.animation_data.action:
        blaster_animated = True
        f_start = int(blaster.animation_data.action.frame_range[0])
        f_end = int(blaster.animation_data.action.frame_range[1])
    return [f_start, f_end, blaster_animated]


class SNA_OT_Kb_Op_Reset_Rigid_Body_World_88Fc2(bpy.types.Operator):
    bl_idname = "sna.kb_op_reset_rigid_body_world_88fc2"
    bl_label = "KB_OP_Reset_Rigid_Body_World"
    bl_description = ""
    bl_options = {"REGISTER", "UNDO"}

    @classmethod
    def poll(cls, context):
        if bpy.app.version >= (3, 0, 0) and False:
            cls.poll_message_set()
        return not False

    def execute(self, context):
        if bpy.context.scene.rigidbody_world.collection:
            start = bpy.context.scene.rigidbody_world.point_cache.frame_start
            end = bpy.context.scene.rigidbody_world.point_cache.frame_end
            c_obs = None
            rg_obs = bpy.context.scene.rigidbody_world.collection.objects[:]
            if bpy.context.scene.rigidbody_world.constraints:
                c_obs = bpy.context.scene.rigidbody_world.constraints.objects[:]
            for ob in rg_obs:
                bpy.context.scene.rigidbody_world.collection.objects.unlink(ob)
            if c_obs:
                for ob in c_obs:
                    bpy.context.scene.rigidbody_world.constraints.objects.unlink(ob)
            bpy.ops.rigidbody.world_remove()
            bpy.ops.rigidbody.world_add()
            bpy.ops.outliner.orphans_purge()
            bpy.context.scene.rigidbody_world.collection = bpy.data.collections.new( 'KB_RB_World' )
            for ob in rg_obs:
                bpy.context.scene.rigidbody_world.collection.objects.link(ob)
            if c_obs:
                bpy.context.scene.rigidbody_world.constraints = bpy.data.collections.new( 'KB_RB_Constraints' )
                for ob in c_obs:
                    bpy.context.scene.rigidbody_world.constraints.objects.link(ob)
            bpy.context.scene.rigidbody_world.point_cache.frame_start = start
            bpy.context.scene.rigidbody_world.point_cache.frame_end = end
        return {"FINISHED"}

    def invoke(self, context, event):
        return self.execute(context)


class SNA_PT_ABOUT_A715E(bpy.types.Panel):
    bl_label = 'About'
    bl_idname = 'SNA_PT_ABOUT_A715E'
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_context = ''
    bl_order = 7
    bl_options = {'DEFAULT_CLOSED'}
    bl_parent_id = 'SNA_PT_KABOOM_21D12'
    bl_ui_units_x=0

    @classmethod
    def poll(cls, context):
        return not (False)

    def draw_header(self, context):
        layout = self.layout

    def draw(self, context):
        layout = self.layout
        layout_function = layout
        sna_interface_about_pictofilmo_5B4B0(layout_function, )


class SNA_PT_BLASTER_FDAD3(bpy.types.Panel):
    bl_label = 'Blaster'
    bl_idname = 'SNA_PT_BLASTER_FDAD3'
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_context = ''
    bl_order = 2
    bl_options = {'DEFAULT_CLOSED'}
    bl_parent_id = 'SNA_PT_KABOOM_21D12'
    bl_ui_units_x=0

    @classmethod
    def poll(cls, context):
        return not (False)

    def draw_header(self, context):
        layout = self.layout
        layout.label(text='', icon_value=_icons['krumble_icon.png'].icon_id)

    def draw(self, context):
        layout = self.layout
        layout_function = layout
        sna_blaster_D0A07(layout_function, )


class SNA_PT_RIGID_BODIES_50DA9(bpy.types.Panel):
    bl_label = 'Rigid Bodies'
    bl_idname = 'SNA_PT_RIGID_BODIES_50DA9'
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_context = ''
    bl_order = 4
    bl_options = {'DEFAULT_CLOSED'}
    bl_parent_id = 'SNA_PT_KABOOM_21D12'
    bl_ui_units_x=0

    @classmethod
    def poll(cls, context):
        return not (False)

    def draw_header(self, context):
        layout = self.layout
        layout.label(text='', icon_value=353)

    def draw(self, context):
        layout = self.layout
        layout_function = layout
        sna_rigidbody1_3B83C(layout_function, )


class SNA_PT_SIMULATION_49B02(bpy.types.Panel):
    bl_label = 'Simulation'
    bl_idname = 'SNA_PT_SIMULATION_49B02'
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_context = ''
    bl_order = 3
    bl_options = {'DEFAULT_CLOSED'}
    bl_parent_id = 'SNA_PT_KABOOM_21D12'
    bl_ui_units_x=0

    @classmethod
    def poll(cls, context):
        return not (False)

    def draw_header(self, context):
        layout = self.layout
        layout.label(text='', icon_value=89)

    def draw(self, context):
        layout = self.layout
        row_62B7E = layout.row(heading='', align=True)
        row_62B7E.alert = False
        row_62B7E.enabled = True
        row_62B7E.active = True
        row_62B7E.use_property_split = False
        row_62B7E.use_property_decorate = False
        row_62B7E.scale_x = 1.0
        row_62B7E.scale_y = 1.0
        row_62B7E.alignment = 'Expand'.upper()
        if not True: row_62B7E.operator_context = "EXEC_DEFAULT"
        row_62B7E.label(text='World', icon_value=503)
        row_62B7E.prop(bpy.context.scene.rigidbody_world.point_cache, 'frame_start', text='', icon_value=0, emboss=True, toggle=True)
        row_62B7E.prop(bpy.context.scene.rigidbody_world.point_cache, 'frame_end', text='', icon_value=0, emboss=True, toggle=True)
        op = layout.operator('sna.kb_op_reset_rigid_body_world_88fc2', text='Reset Rigid Body World', icon_value=216, emboss=True, depress=False)


class SNA_PT_BAKING_SIMULATION_36BA5(bpy.types.Panel):
    bl_label = 'Baking Simulation'
    bl_idname = 'SNA_PT_BAKING_SIMULATION_36BA5'
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_context = ''
    bl_order = 5
    bl_options = {'DEFAULT_CLOSED'}
    bl_parent_id = 'SNA_PT_KABOOM_21D12'
    bl_ui_units_x=0

    @classmethod
    def poll(cls, context):
        return not (False)

    def draw_header(self, context):
        layout = self.layout
        layout.label(text='', icon_value=404)

    def draw(self, context):
        layout = self.layout
        layout.prop(bpy.context.window_manager, 'sna_kb_custom_range_bool', text='Custom Range', icon_value=118, emboss=True, toggle=True)
        if bpy.context.window_manager.sna_kb_custom_range_bool:
            row_6A2C4 = layout.row(heading='', align=False)
            row_6A2C4.alert = False
            row_6A2C4.enabled = True
            row_6A2C4.active = True
            row_6A2C4.use_property_split = False
            row_6A2C4.use_property_decorate = False
            row_6A2C4.scale_x = 1.0
            row_6A2C4.scale_y = 1.0
            row_6A2C4.alignment = 'Expand'.upper()
            if not True: row_6A2C4.operator_context = "EXEC_DEFAULT"
            row_6A2C4.prop(bpy.context.window_manager, 'sna_kb_custom_f_start', text='start', icon_value=0, emboss=True, toggle=True)
            row_6A2C4.prop(bpy.context.window_manager, 'sna_kb_custom_f_end', text='end', icon_value=0, emboss=True, toggle=True)
        row_E841C = layout.row(heading='', align=False)
        row_E841C.alert = False
        row_E841C.enabled = True
        row_E841C.active = True
        row_E841C.use_property_split = False
        row_E841C.use_property_decorate = False
        row_E841C.scale_x = 1.0
        row_E841C.scale_y = 1.0
        row_E841C.alignment = 'Expand'.upper()
        if not True: row_E841C.operator_context = "EXEC_DEFAULT"
        row_E841C.label(text='', icon_value=115)
        op = row_E841C.operator('sna.kb_op_bake_d6841', text='Bake to Keyframes', icon_value=0, emboss=True, depress=False)
        op.sna_index = bpy.context.scene.sna_kb_col_index
        row_4E1C1 = layout.row(heading='', align=False)
        row_4E1C1.alert = False
        row_4E1C1.enabled = True
        row_4E1C1.active = True
        row_4E1C1.use_property_split = False
        row_4E1C1.use_property_decorate = False
        row_4E1C1.scale_x = 1.0
        row_4E1C1.scale_y = 1.0
        row_4E1C1.alignment = 'Expand'.upper()
        if not True: row_4E1C1.operator_context = "EXEC_DEFAULT"
        row_4E1C1.prop(bpy.context.scene, 'sna_kb_lock_bake_flag', text='', icon_value=(41 if bpy.context.scene.sna_kb_lock_bake_flag else 40), emboss=False)
        row_2FAEC = row_4E1C1.row(heading='', align=False)
        row_2FAEC.alert = False
        row_2FAEC.enabled = (not bpy.context.scene.sna_kb_lock_bake_flag)
        row_2FAEC.active = (not bpy.context.scene.sna_kb_lock_bake_flag)
        row_2FAEC.use_property_split = False
        row_2FAEC.use_property_decorate = False
        row_2FAEC.scale_x = 1.0
        row_2FAEC.scale_y = 1.0
        row_2FAEC.alignment = 'Expand'.upper()
        if not True: row_2FAEC.operator_context = "EXEC_DEFAULT"
        row_2FAEC.label(text=list(bpy.context.scene.sna_kb_kaboom_collection)[bpy.context.scene.sna_kb_col_index].kaboom_col.name, icon_value=250)
        row_2FAEC.prop(list(bpy.context.scene.sna_kb_kaboom_collection)[bpy.context.scene.sna_kb_col_index], 'is_baked', text=('is baked' if list(bpy.context.scene.sna_kb_kaboom_collection)[bpy.context.scene.sna_kb_col_index].is_baked else 'is not baked'), icon_value=115, emboss=True)


class SNA_PT_FX_E0914(bpy.types.Panel):
    bl_label = '   FX'
    bl_idname = 'SNA_PT_FX_E0914'
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_context = ''
    bl_order = 6
    bl_options = {'DEFAULT_CLOSED'}
    bl_parent_id = 'SNA_PT_KABOOM_21D12'
    bl_ui_units_x=0

    @classmethod
    def poll(cls, context):
        return not (False)

    def draw_header(self, context):
        layout = self.layout
        row_D8E0B = layout.row(heading='', align=False)
        row_D8E0B.alert = False
        row_D8E0B.enabled = True
        row_D8E0B.active = True
        row_D8E0B.use_property_split = False
        row_D8E0B.use_property_decorate = False
        row_D8E0B.scale_x = 1.0
        row_D8E0B.scale_y = 1.0
        row_D8E0B.alignment = 'Expand'.upper()
        if not True: row_D8E0B.operator_context = "EXEC_DEFAULT"
        row_D8E0B.prop(bpy.context.window_manager, 'sna_kb_particle_mode', text='', icon_value=0, emboss=True, expand=True)

    def draw(self, context):
        layout = self.layout
        layout_function = layout
        sna_particles_function_A0EE2(layout_function, )


class SNA_PT_FRACTURE_GROUPS_B7B66(bpy.types.Panel):
    bl_label = 'Fracture Groups'
    bl_idname = 'SNA_PT_FRACTURE_GROUPS_B7B66'
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_context = ''
    bl_order = 1
    bl_parent_id = 'SNA_PT_KABOOM_21D12'
    bl_ui_units_x=0

    @classmethod
    def poll(cls, context):
        return not (False)

    def draw_header(self, context):
        layout = self.layout
        layout.label(text='', icon_value=250)

    def draw(self, context):
        layout = self.layout
        row_A8886 = layout.row(heading='', align=True)
        row_A8886.alert = False
        row_A8886.enabled = True
        row_A8886.active = True
        row_A8886.use_property_split = False
        row_A8886.use_property_decorate = False
        row_A8886.scale_x = 1.0
        row_A8886.scale_y = 1.0
        row_A8886.alignment = 'Expand'.upper()
        if not True: row_A8886.operator_context = "EXEC_DEFAULT"
        box_6BC1A = row_A8886.box()
        box_6BC1A.alert = False
        box_6BC1A.enabled = True
        box_6BC1A.active = True
        box_6BC1A.use_property_split = False
        box_6BC1A.use_property_decorate = False
        box_6BC1A.alignment = 'Expand'.upper()
        box_6BC1A.scale_x = 1.0
        box_6BC1A.scale_y = 1.0
        if not True: box_6BC1A.operator_context = "EXEC_DEFAULT"
        op = box_6BC1A.operator('sna.kb_op_add_group_from_selection_17be0', text='Add Group From Selection', icon_value=22, emboss=True, depress=False)
        col_83B50 = layout.column(heading='', align=False)
        col_83B50.alert = False
        col_83B50.enabled = True
        col_83B50.active = True
        col_83B50.use_property_split = False
        col_83B50.use_property_decorate = False
        col_83B50.scale_x = 1.0
        col_83B50.scale_y = 1.0
        col_83B50.alignment = 'Expand'.upper()
        if not True: col_83B50.operator_context = "EXEC_DEFAULT"
        coll_id = display_collection_id('A9E63', locals())
        col_83B50.template_list('SNA_UL_display_collection_list_A9E63', coll_id, bpy.context.scene, 'sna_kb_kaboom_collection', bpy.context.scene, 'sna_kb_col_index', rows=1)
        box_06BCC = layout.box()
        box_06BCC.alert = False
        box_06BCC.enabled = True
        box_06BCC.active = sna_fu_test_if_active_group_is_not_baked_A638D()
        box_06BCC.use_property_split = False
        box_06BCC.use_property_decorate = False
        box_06BCC.alignment = 'Expand'.upper()
        box_06BCC.scale_x = 1.0
        box_06BCC.scale_y = 1.0
        if not True: box_06BCC.operator_context = "EXEC_DEFAULT"
        op = box_06BCC.operator('sna.kb_op_select_dynamic_shards_150ec', text='Select Dynamic Shards', icon_value=282, emboss=True, depress=False)
        op.sna_dynamic = True
        op.sna_extend_selection = False
        if (len(list(bpy.context.scene.sna_kb_kaboom_collection)) > 0):
            box_42BF3 = layout.box()
            box_42BF3.alert = False
            box_42BF3.enabled = (list(bpy.context.scene.sna_kb_kaboom_collection)[bpy.context.scene.sna_kb_col_index].is_baked and (bpy.context.scene.sna_kb_progress_percent == 0.0))
            box_42BF3.active = (list(bpy.context.scene.sna_kb_kaboom_collection)[bpy.context.scene.sna_kb_col_index].is_baked and (bpy.context.scene.sna_kb_progress_percent == 0.0))
            box_42BF3.use_property_split = False
            box_42BF3.use_property_decorate = False
            box_42BF3.alignment = 'Expand'.upper()
            box_42BF3.scale_x = 1.0
            box_42BF3.scale_y = 1.0
            if not True: box_42BF3.operator_context = "EXEC_DEFAULT"
            if list(bpy.context.scene.sna_kb_kaboom_collection)[bpy.context.scene.sna_kb_col_index].is_noisy_inner:
                col_21FBE = box_42BF3.column(heading='', align=False)
                col_21FBE.alert = False
                col_21FBE.enabled = True
                col_21FBE.active = True
                col_21FBE.use_property_split = False
                col_21FBE.use_property_decorate = False
                col_21FBE.scale_x = 1.0
                col_21FBE.scale_y = 1.0
                col_21FBE.alignment = 'Expand'.upper()
                if not True: col_21FBE.operator_context = "EXEC_DEFAULT"
                row_613E5 = col_21FBE.row(heading='', align=True)
                row_613E5.alert = False
                row_613E5.enabled = True
                row_613E5.active = True
                row_613E5.use_property_split = False
                row_613E5.use_property_decorate = False
                row_613E5.scale_x = 1.0
                row_613E5.scale_y = 1.0
                row_613E5.alignment = 'Expand'.upper()
                if not True: row_613E5.operator_context = "EXEC_DEFAULT"
                row_613E5.label(text='Level', icon_value=477)
                row_613E5.prop(list(bpy.context.scene.sna_kb_kaboom_collection)[bpy.context.scene.sna_kb_col_index], 'noisy_inner_level', text='', icon_value=0, emboss=True)
                row_613E5.prop(list(bpy.context.scene.sna_kb_kaboom_collection)[bpy.context.scene.sna_kb_col_index], 'noisy_inner_show_view', text='', icon_value=284, emboss=True, expand=False, toggle=True)
                row_613E5.prop(list(bpy.context.scene.sna_kb_kaboom_collection)[bpy.context.scene.sna_kb_col_index], 'noisy_inner_hide_render', text='', icon_value=258, emboss=True, expand=False, toggle=True)
                row_4A21E = col_21FBE.row(heading='', align=True)
                row_4A21E.alert = False
                row_4A21E.enabled = True
                row_4A21E.active = True
                row_4A21E.use_property_split = False
                row_4A21E.use_property_decorate = False
                row_4A21E.scale_x = 1.0
                row_4A21E.scale_y = 1.0
                row_4A21E.alignment = 'Expand'.upper()
                if not True: row_4A21E.operator_context = "EXEC_DEFAULT"
                row_4A21E.label(text='Amount', icon_value=564)
                row_4A21E.prop(list(bpy.context.scene.sna_kb_kaboom_collection)[bpy.context.scene.sna_kb_col_index], 'noisy_inner_amount', text='', icon_value=0, emboss=True)
                row_19BC2 = col_21FBE.row(heading='', align=True)
                row_19BC2.alert = False
                row_19BC2.enabled = True
                row_19BC2.active = True
                row_19BC2.use_property_split = False
                row_19BC2.use_property_decorate = False
                row_19BC2.scale_x = 1.0
                row_19BC2.scale_y = 1.0
                row_19BC2.alignment = 'Expand'.upper()
                if not True: row_19BC2.operator_context = "EXEC_DEFAULT"
                row_19BC2.label(text='Size', icon_value=75)
                row_19BC2.prop(list(bpy.context.scene.sna_kb_kaboom_collection)[bpy.context.scene.sna_kb_col_index], 'noisy_inner_size', text='', icon_value=0, emboss=True)
                row_64D6E = col_21FBE.row(heading='', align=True)
                row_64D6E.alert = False
                row_64D6E.enabled = True
                row_64D6E.active = True
                row_64D6E.use_property_split = False
                row_64D6E.use_property_decorate = False
                row_64D6E.scale_x = 1.0
                row_64D6E.scale_y = 1.0
                row_64D6E.alignment = 'Expand'.upper()
                if not True: row_64D6E.operator_context = "EXEC_DEFAULT"
                row_64D6E.label(text='Decimate', icon_value=445)
                row_64D6E.prop(list(bpy.context.scene.sna_kb_kaboom_collection)[bpy.context.scene.sna_kb_col_index], 'noisy_inner_decimate', text='', icon_value=0, emboss=True, slider=True)
                row_17B77 = col_21FBE.row(heading='', align=True)
                row_17B77.alert = False
                row_17B77.enabled = 'OBJECT'==bpy.context.mode
                row_17B77.active = 'OBJECT'==bpy.context.mode
                row_17B77.use_property_split = False
                row_17B77.use_property_decorate = False
                row_17B77.scale_x = 1.0
                row_17B77.scale_y = 1.0
                row_17B77.alignment = 'Expand'.upper()
                if not True: row_17B77.operator_context = "EXEC_DEFAULT"
                op = row_17B77.operator('sna.modop_kb_remove_rough_cut_e18e2', text='Remove', icon_value=3, emboss=True, depress=False)
                op.sna_nb_obj = 0
                op.sna_i = 0
                op.sna_kb_i = bpy.context.scene.sna_kb_col_index
                op = row_17B77.operator('sna.modop_kb_apply_rough_cut_1a6e2', text='Apply', icon_value=36, emboss=True, depress=False)
                op.sna_nb_obj = 0
                op.sna_i = 0
                op.sna_kb_i = bpy.context.scene.sna_kb_col_index
                op = row_17B77.operator('sna.kb_op_copy_rough_cut_params_4e192', text='', icon_value=598, emboss=True, depress=False)
                op.sna_index = bpy.context.scene.sna_kb_col_index
                if noisy_innerrough_cut['sna_rough_cut_copy']:
                    op = row_17B77.operator('sna.kb_op_paste_rough_cut_params_e6c01', text='', icon_value=599, emboss=True, depress=False)
                    op.sna_index = bpy.context.scene.sna_kb_col_index
            else:
                row_0FD41 = box_42BF3.row(heading='', align=True)
                row_0FD41.alert = False
                row_0FD41.enabled = 'OBJECT'==bpy.context.mode
                row_0FD41.active = 'OBJECT'==bpy.context.mode
                row_0FD41.use_property_split = False
                row_0FD41.use_property_decorate = False
                row_0FD41.scale_x = 1.0
                row_0FD41.scale_y = 1.0
                row_0FD41.alignment = 'Expand'.upper()
                if not True: row_0FD41.operator_context = "EXEC_DEFAULT"
                op = row_0FD41.operator('sna.modop_kb_enable_rough_cut_95af5', text='Enable Rough Cut', icon_value=487, emboss=True, depress=False)
                op.sna_nb_obj = 0
                op.sna_i = 0
                op.sna_kb_i = bpy.context.scene.sna_kb_col_index
                op.sna_id = ''
        if (bpy.context.scene.sna_kb_progress_percent > 0.0):
            layout.prop(bpy.context.scene, 'sna_kb_progress_percent', text=bpy.context.scene.sna_kb_progress_job, icon_value=0, emboss=True, slider=True)


class SNA_PT_FRACTURE_0FB86(bpy.types.Panel):
    bl_label = 'Fracture'
    bl_idname = 'SNA_PT_FRACTURE_0FB86'
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_context = ''
    bl_order = 0
    bl_parent_id = 'SNA_PT_KABOOM_21D12'
    bl_ui_units_x=0

    @classmethod
    def poll(cls, context):
        return not (False)

    def draw_header(self, context):
        layout = self.layout
        layout.label(text='', icon_value=_icons['Cell_Fracture_icon.png'].icon_id)

    def draw(self, context):
        layout = self.layout
        layout_function = layout
        sna_fracture_2BB12(layout_function, )


class SNA_PT_panel001_7441E(bpy.types.Panel):
    bl_label = ''
    bl_idname = 'SNA_PT_panel001_7441E'
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_context = ''
    bl_order = 0
    bl_parent_id = 'SNA_PT_SIMULATION_49B02'
    bl_ui_units_x=0

    @classmethod
    def poll(cls, context):
        return not (False)

    def draw_header(self, context):
        layout = self.layout
        row_249F3 = layout.row(heading='', align=False)
        row_249F3.alert = False
        row_249F3.enabled = True
        row_249F3.active = True
        row_249F3.use_property_split = False
        row_249F3.use_property_decorate = False
        row_249F3.scale_x = 1.0
        row_249F3.scale_y = 1.0
        row_249F3.alignment = 'Expand'.upper()
        if not True: row_249F3.operator_context = "EXEC_DEFAULT"
        row_249F3.label(text='BLAST:', icon_value=_icons['krumble_icon.png'].icon_id)

    def draw(self, context):
        layout = self.layout
        if (len(list(bpy.context.scene.sna_kb_kaboom_collection)) > 0):
            box_C19BA = layout.box()
            box_C19BA.alert = False
            box_C19BA.enabled = True
            box_C19BA.active = True
            box_C19BA.use_property_split = False
            box_C19BA.use_property_decorate = False
            box_C19BA.alignment = 'Expand'.upper()
            box_C19BA.scale_x = 1.0
            box_C19BA.scale_y = 1.0
            if not True: box_C19BA.operator_context = "EXEC_DEFAULT"
            row_24C48 = box_C19BA.row(heading='', align=False)
            row_24C48.alert = False
            row_24C48.enabled = True
            row_24C48.active = True
            row_24C48.use_property_split = False
            row_24C48.use_property_decorate = False
            row_24C48.scale_x = 1.0
            row_24C48.scale_y = 1.0
            row_24C48.alignment = 'Expand'.upper()
            if not True: row_24C48.operator_context = "EXEC_DEFAULT"
            row_24C48.label(text='BLAST:', icon_value=0)
            row_24C48.prop(bpy.context.window_manager, 'sna_kb_blast_all_groups', text='All', icon_value=246, emboss=True, toggle=True)
            row_24C48.prop(bpy.context.window_manager, 'sna_kb_live_blast', text='Live', icon_value=675, emboss=True, toggle=True)
            if property_exists("bpy.data.objects[bpy.context.scene.sna_kb_blaster_object_name]", globals(), locals()):
                col_1592B = box_C19BA.column(heading='', align=False)
                col_1592B.alert = False
                col_1592B.enabled = True
                col_1592B.active = True
                col_1592B.use_property_split = False
                col_1592B.use_property_decorate = False
                col_1592B.scale_x = 1.0
                col_1592B.scale_y = 1.0
                col_1592B.alignment = 'Expand'.upper()
                if not True: col_1592B.operator_context = "EXEC_DEFAULT"
                col_1592B.prop(bpy.context.window_manager, 'sna_kb_custom_range_bool', text='Custom Range', icon_value=118, emboss=True, toggle=True)
                if bpy.context.window_manager.sna_kb_custom_range_bool:
                    row_A4F28 = col_1592B.row(heading='', align=False)
                    row_A4F28.alert = False
                    row_A4F28.enabled = True
                    row_A4F28.active = True
                    row_A4F28.use_property_split = False
                    row_A4F28.use_property_decorate = False
                    row_A4F28.scale_x = 1.0
                    row_A4F28.scale_y = 1.0
                    row_A4F28.alignment = 'Expand'.upper()
                    if not True: row_A4F28.operator_context = "EXEC_DEFAULT"
                    row_A4F28.prop(bpy.context.window_manager, 'sna_kb_custom_f_start', text='start', icon_value=0, emboss=True, toggle=True)
                    row_A4F28.prop(bpy.context.window_manager, 'sna_kb_custom_f_end', text='end', icon_value=0, emboss=True, toggle=True)
                row_8DB18 = col_1592B.row(heading='', align=False)
                row_8DB18.alert = False
                row_8DB18.enabled = True
                row_8DB18.active = True
                row_8DB18.use_property_split = False
                row_8DB18.use_property_decorate = False
                row_8DB18.scale_x = 1.0
                row_8DB18.scale_y = 1.0
                row_8DB18.alignment = 'Expand'.upper()
                if not True: row_8DB18.operator_context = "EXEC_DEFAULT"
                row_8DB18.template_icon(icon_value=_icons['krumble_icon.png'].icon_id, scale=2.0)
                row_F2253 = row_8DB18.row(heading='', align=False)
                row_F2253.alert = True
                row_F2253.enabled = True
                row_F2253.active = True
                row_F2253.use_property_split = False
                row_F2253.use_property_decorate = False
                row_F2253.scale_x = 1.0
                row_F2253.scale_y = 2.0
                row_F2253.alignment = 'Expand'.upper()
                if not True: row_F2253.operator_context = "EXEC_DEFAULT"
                op = row_F2253.operator('sna.kb_op_krumble_4bc1f', text='Blast !', icon_value=0, emboss=True, depress=False)
                op.sna_mode = 'Selected Fracture Group'
            else:
                box_34A93 = box_C19BA.box()
                box_34A93.alert = False
                box_34A93.enabled = True
                box_34A93.active = True
                box_34A93.use_property_split = False
                box_34A93.use_property_decorate = False
                box_34A93.alignment = 'Expand'.upper()
                box_34A93.scale_x = 1.0
                box_34A93.scale_y = 1.0
                if not True: box_34A93.operator_context = "EXEC_DEFAULT"
                if (not property_exists("bpy.data.objects[bpy.context.scene.sna_kb_blaster_object_name]", globals(), locals())):
                    op = box_34A93.operator('sna.kb_op_add_blaster_47645', text='Add Blaster', icon_value=93, emboss=True, depress=False)
        else:
            layout.label(text='Please Create Fractured Group', icon_value=110)


class SNA_PT_krumble_panel_D1729(bpy.types.Panel):
    bl_label = ''
    bl_idname = 'SNA_PT_krumble_panel_D1729'
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_context = ''
    bl_order = 1
    bl_options = {'HEADER_LAYOUT_EXPAND', 'DEFAULT_CLOSED'}
    bl_parent_id = 'SNA_PT_SIMULATION_49B02'
    bl_ui_units_x=0

    @classmethod
    def poll(cls, context):
        return not (False)

    def draw_header(self, context):
        layout = self.layout
        row_F49E1 = layout.row(heading='', align=False)
        row_F49E1.alert = False
        row_F49E1.enabled = True
        row_F49E1.active = True
        row_F49E1.use_property_split = False
        row_F49E1.use_property_decorate = False
        row_F49E1.scale_x = 1.0
        row_F49E1.scale_y = 1.0
        row_F49E1.alignment = 'Expand'.upper()
        if not True: row_F49E1.operator_context = "EXEC_DEFAULT"
        row_F49E1.label(text='KRUMBLE:', icon_value=504)

    def draw(self, context):
        layout = self.layout
        if (len(list(bpy.context.scene.sna_kb_kaboom_collection)) > 0):
            box_9F329 = layout.box()
            box_9F329.alert = False
            box_9F329.enabled = True
            box_9F329.active = True
            box_9F329.use_property_split = True
            box_9F329.use_property_decorate = False
            box_9F329.alignment = 'Expand'.upper()
            box_9F329.scale_x = 1.0
            box_9F329.scale_y = 1.0
            if not True: box_9F329.operator_context = "EXEC_DEFAULT"
            row_EDA90 = box_9F329.row(heading='', align=False)
            row_EDA90.alert = False
            row_EDA90.enabled = True
            row_EDA90.active = True
            row_EDA90.use_property_split = False
            row_EDA90.use_property_decorate = False
            row_EDA90.scale_x = 1.0
            row_EDA90.scale_y = 1.0
            row_EDA90.alignment = 'Expand'.upper()
            if not True: row_EDA90.operator_context = "EXEC_DEFAULT"
            row_EDA90.template_icon(icon_value=504, scale=2.0)
            row_71BF9 = row_EDA90.row(heading='', align=False)
            row_71BF9.alert = True
            row_71BF9.enabled = True
            row_71BF9.active = True
            row_71BF9.use_property_split = False
            row_71BF9.use_property_decorate = False
            row_71BF9.scale_x = 1.0
            row_71BF9.scale_y = 2.0
            row_71BF9.alignment = 'Expand'.upper()
            if not True: row_71BF9.operator_context = "EXEC_DEFAULT"
            op = row_71BF9.operator('sna.kb_op_simulation_keyframe_3243e', text='Krumble !', icon_value=0, emboss=True, depress=False)
            op.sna_col_name = list(bpy.context.scene.sna_kb_kaboom_collection)[bpy.context.scene.sna_kb_col_index].kaboom_col.name
        else:
            layout.label(text='Please Create Fractured Group', icon_value=110)


class SNA_GROUP_sna_kb_kaboom_group(bpy.types.PropertyGroup):
    id: bpy.props.StringProperty(name='id', description='', default='', subtype='NONE', maxlen=4)
    kaboom_col: bpy.props.PointerProperty(name='kaboom_col', description='', type=bpy.types.Collection)
    object_src: bpy.props.PointerProperty(name='object_src', description='', type=bpy.types.Object)
    obj_collection_src: bpy.props.PointerProperty(name='obj_collection_src', description='', type=bpy.types.Collection)
    obj_action_src: bpy.props.PointerProperty(name='obj_action_src', description='', type=bpy.types.Action)
    has_constraints: bpy.props.BoolProperty(name='has_constraints', description='', default=False)
    is_baked: bpy.props.BoolProperty(name='is_baked', description='', default=False)
    has_debris: bpy.props.BoolProperty(name='has_debris', description='', default=False)
    has_smoke: bpy.props.BoolProperty(name='has_smoke', description='', default=False)
    is_noisy_inner: bpy.props.BoolProperty(name='is_noisy_inner', description='', default=False)
    noisy_inner_level: bpy.props.IntProperty(name='noisy_inner_level', description='', default=1, subtype='NONE', min=0, max=6)
    noisy_inner_amount: bpy.props.FloatProperty(name='noisy_inner_amount', description='', default=0.4000000059604645, subtype='NONE', unit='NONE', min=0.0, max=100.0, step=3, precision=2)
    noisy_inner_size: bpy.props.FloatProperty(name='noisy_inner_size', description='', default=0.6000000238418579, subtype='NONE', unit='NONE', min=0.0, max=1000.0, step=3, precision=2)
    noisy_inner_show_view: bpy.props.BoolProperty(name='noisy_inner_show_view', description='', default=True)
    noisy_inner_hide_render: bpy.props.BoolProperty(name='noisy_inner_hide_render', description='', default=True)
    is_iteration: bpy.props.BoolProperty(name='is_iteration', description='', default=False)
    ob_texture_ref: bpy.props.PointerProperty(name='ob_texture_ref', description='', type=bpy.types.Object)
    iteration_degree: bpy.props.IntProperty(name='iteration_degree', description='', default=0, subtype='NONE', min=0)
    noisy_inner_decimate: bpy.props.FloatProperty(name='noisy_inner_decimate', description='', default=0.5, subtype='NONE', unit='NONE', min=9.999999747378752e-05, max=1.0, step=3, precision=6)
    tex_space_loc: bpy.props.FloatVectorProperty(name='tex_space_loc', description='', size=3, default=(0.0, 0.0, 0.0), subtype='COORDINATES', unit='NONE', step=3, precision=6)
    tex_space_scale: bpy.props.FloatVectorProperty(name='tex_space_scale', description='', size=3, default=(0.0, 0.0, 0.0), subtype='COORDINATES', unit='NONE', step=3, precision=6)


def register():
    global _icons
    _icons = bpy.utils.previews.new()
    bpy.utils.register_class(SNA_GROUP_sna_kb_kaboom_group)
    bpy.types.WindowManager.sna_kb_fracture_mode = bpy.props.EnumProperty(name='kb_fracture_mode', description='Fracture Modes', items=[('Own particles', 'Own particles', 'Own particles', 88, 1), ('Child Particles', 'Child Particles', 'Child Particles', 485, 2), ('Own Vertex', 'Own Vertex', 'Own Vertex', 131, 4), ('Child Vertex', 'Child Vertex', 'Child Vertex', 546, 8), ('Grease Pencil', 'Grease Pencil', 'Grease Pencil', 247, 16)], options={'ENUM_FLAG'})
    bpy.types.WindowManager.sna_kb_fracture_count = bpy.props.IntProperty(name='kb_fracture_count', description='', default=100, subtype='NONE', min=0)
    bpy.types.WindowManager.sna_kb_fracture_axis = bpy.props.FloatVectorProperty(name='kb_fracture_axis', description='', size=3, default=(1.0, 1.0, 1.0), subtype='NONE', unit='NONE', step=3, precision=2)
    bpy.types.Scene.sna_kb_kaboom_collection = bpy.props.CollectionProperty(name='kb_kaboom_collection', description='', type=SNA_GROUP_sna_kb_kaboom_group)
    bpy.types.Scene.sna_kb_col_index = bpy.props.IntProperty(name='kb_col_index', description='', default=0, subtype='NONE')
    bpy.types.Scene.sna_kb_blaster_object_name = bpy.props.StringProperty(name='kb_blaster_object_name', description='', default='', subtype='NONE', maxlen=0)
    bpy.types.WindowManager.sna_kb_bomb_radial_force = bpy.props.FloatProperty(name='kb_bomb_radial_force', description='Radial Force Power', default=25.0, subtype='NONE', unit='NONE', min=0.0, max=1000.0, step=3, precision=2)
    bpy.types.WindowManager.sna_kb_bomb_radial_force_rand = bpy.props.FloatProperty(name='kb_bomb_radial_force_rand', description='radial force random percent', default=25.0, subtype='NONE', unit='NONE', min=0.0, max=100.0, step=3, precision=0)
    bpy.types.WindowManager.sna_kb_bomb_directionnal_force = bpy.props.FloatVectorProperty(name='kb_bomb_directionnal_force', description='Directionnal Force Vector', size=3, default=(0.0, 0.0, 0.0), subtype='NONE', unit='NONE', min=-1000.0, max=1000.0, step=3, precision=2)
    bpy.types.WindowManager.sna_kb_bomb_directionnal_force_rand = bpy.props.FloatProperty(name='kb_bomb_directionnal_force_rand', description='Directionnal random percent', default=25.0, subtype='NONE', unit='NONE', min=0.0, max=100.0, step=3, precision=0)
    bpy.types.WindowManager.sna_kb_part_spin = bpy.props.FloatProperty(name='kb_part_spin', description='Fractured Part Spin', default=25.0, subtype='NONE', unit='NONE', min=0.0, max=1000.0, step=3, precision=2)
    bpy.types.WindowManager.sna_kb_part_spin_rand = bpy.props.FloatProperty(name='kb_part_spin_rand', description='Spin random percent', default=25.0, subtype='NONE', unit='NONE', min=0.0, max=100.0, step=3, precision=0)
    bpy.types.WindowManager.sna_kb_custom_range_bool = bpy.props.BoolProperty(name='kb_custom_range_bool', description='', default=False)
    bpy.types.WindowManager.sna_kb_custom_f_start = bpy.props.IntProperty(name='kb_custom_f_start', description='', default=0, subtype='NONE', min=0)
    bpy.types.WindowManager.sna_kb_custom_f_end = bpy.props.IntProperty(name='kb_custom_f_end', description='', default=0, subtype='NONE', min=0)
    bpy.types.WindowManager.sna_kb_constraint_mass = bpy.props.FloatProperty(name='kb_constraint_mass', description='', default=300.0, subtype='NONE', unit='NONE', min=0.0, step=3, precision=2)
    bpy.types.WindowManager.sna_kb_constraint_strenght = bpy.props.FloatProperty(name='kb_constraint_strenght', description='', default=200.0, subtype='NONE', unit='NONE', min=0.0, step=3, precision=2)
    bpy.types.WindowManager.sna_kb_velocity_threshold = bpy.props.FloatProperty(name='kb_velocity_threshold', description='Acceleration limit trigger', default=0.5, subtype='NONE', unit='NONE', min=0.009999999776482582, step=3, precision=2)
    bpy.types.WindowManager.sna_kb_particles_duration = bpy.props.IntProperty(name='kb_particles_duration', description='Time in frame of emission duration', default=10, subtype='NONE', min=1)
    bpy.types.WindowManager.sna_kb_particles_count = bpy.props.IntProperty(name='kb_particles_count', description='Number of particles for each triggering', default=15, subtype='NONE', min=1)
    bpy.types.WindowManager.sna_kb_particles_impact_factor = bpy.props.FloatProperty(name='kb_particles_impact_factor', description='Percent of count for collision triggering', default=50.0, subtype='PERCENTAGE', unit='NONE', min=0.0, max=100.0, step=3, precision=0)
    bpy.types.WindowManager.sna_kb_particles_speed = bpy.props.FloatProperty(name='kb_particles_speed', description='', default=7.0, subtype='NONE', unit='NONE', min=0.009999999776482582, step=3, precision=2)
    bpy.types.WindowManager.sna_kb_particles_mode = bpy.props.EnumProperty(name='kb_particles_mode', description='', items=[('Debris', 'Debris', '', 654, 0), ('Smoke', 'Smoke', '', 658, 1)])
    bpy.types.WindowManager.sna_kb_debris_part_collection = bpy.props.PointerProperty(name='kb_debris_part_collection', description='', type=bpy.types.Collection)
    bpy.types.WindowManager.sna_kb_show_debris_parts = bpy.props.BoolProperty(name='kb_show_debris_parts', description='', default=True, update=sna_update_sna_kb_show_debris_parts_D8E01)
    bpy.types.WindowManager.sna_kb_show_smoke_parts = bpy.props.BoolProperty(name='kb_show_smoke_parts', description='', default=True, update=sna_update_sna_kb_show_smoke_parts_B9F27)
    bpy.types.WindowManager.sna_kb_live_blast = bpy.props.BoolProperty(name='kb_live_blast', description='', default=True)
    bpy.types.WindowManager.sna_kb_particle_mode = bpy.props.EnumProperty(name='kb_particle_mode', description='', items=[('Debris', 'Debris', '', 653, 0), ('Smoke', 'Smoke', '', 656, 1)])
    bpy.types.WindowManager.sna_kb_blast_all_groups = bpy.props.BoolProperty(name='kb_blast_all_groups', description='', default=False)
    bpy.types.Scene.sna_kb_progress_percent = bpy.props.FloatProperty(name='kb_progress_percent', description='', options={'SKIP_SAVE'}, default=0.0, subtype='PERCENTAGE', unit='NONE', min=0.0, max=100.0, step=3, precision=0)
    bpy.types.WindowManager.sna_kb_smoke_emission_moving = bpy.props.FloatProperty(name='kb_smoke_emission_moving', description='Intensity of smoke emission during move', default=0.10000000149011612, subtype='NONE', unit='NONE', min=0.0, max=10.0, step=3, precision=3)
    bpy.types.WindowManager.sna_kb_smoke_emission_exploding = bpy.props.FloatProperty(name='kb_smoke_emission_exploding', description='Intensity of smoke emission for deflagration (detonation and collision)', default=1.0, subtype='NONE', unit='NONE', min=0.0, max=100.0, step=3, precision=3)
    bpy.types.WindowManager.sna_kb_smoke_z_velocity = bpy.props.FloatProperty(name='kb_smoke_z_velocity', description='Intensity of smoke emission on collision', default=0.30000001192092896, subtype='NONE', unit='NONE', min=0.0, max=100.0, step=3, precision=3)
    bpy.types.Object.sna_kb_is_iterator_source = bpy.props.BoolProperty(name='kb_is_iterator_source', description='', default=False)
    bpy.types.Scene.sna_kb_progress_job = bpy.props.StringProperty(name='kb_progress_job', description='', default='', subtype='NONE', maxlen=0)
    bpy.types.Scene.sna_kb_is_rendering = bpy.props.BoolProperty(name='kb_is_rendering', description='', default=False)
    bpy.types.Scene.sna_kb_lock_bake_flag = bpy.props.BoolProperty(name='kb_lock_bake_flag', description='', default=True)
    bpy.types.Object.sna_kb_shard_velocity = bpy.props.FloatProperty(name='kb_shard_velocity', description='', default=0.0, subtype='NONE', unit='NONE', step=3, precision=6)
    bpy.types.Object.sna_kb_shard_acceleration = bpy.props.FloatProperty(name='kb_shard_acceleration', description='', default=0.0, subtype='NONE', unit='NONE', step=3, precision=6)
    bpy.types.Object.sna_kb_shard_real_acceleration = bpy.props.FloatProperty(name='kb_shard_real_acceleration', description='', default=0.0, subtype='NONE', unit='NONE', step=3, precision=6)
    if not 'pictofilmo_icon_128.png' in _icons: _icons.load('pictofilmo_icon_128.png', os.path.join(os.path.dirname(__file__), 'icons', 'pictofilmo_icon_128.png'), "IMAGE")
    if not 'Blender+Market_ico_128.png' in _icons: _icons.load('Blender+Market_ico_128.png', os.path.join(os.path.dirname(__file__), 'icons', 'Blender+Market_ico_128.png'), "IMAGE")
    if not 'gumraod_icon_128.png' in _icons: _icons.load('gumraod_icon_128.png', os.path.join(os.path.dirname(__file__), 'icons', 'gumraod_icon_128.png'), "IMAGE")
    bpy.utils.register_class(SNA_OT_Kb_Op_Web_Link_8F33D)
    bpy.utils.register_class(SNA_OT_Kb_Op_Add_Blaster_47645)
    if not 'Blaster_icon.png' in _icons: _icons.load('Blaster_icon.png', os.path.join(os.path.dirname(__file__), 'icons', 'Blaster_icon.png'), "IMAGE")
    if not 'plusorminus_icon.png' in _icons: _icons.load('plusorminus_icon.png', os.path.join(os.path.dirname(__file__), 'icons', 'plusorminus_icon.png'), "IMAGE")
    if not 'percent_icon.png' in _icons: _icons.load('percent_icon.png', os.path.join(os.path.dirname(__file__), 'icons', 'percent_icon.png'), "IMAGE")
    if not 'plusorminus_icon.png' in _icons: _icons.load('plusorminus_icon.png', os.path.join(os.path.dirname(__file__), 'icons', 'plusorminus_icon.png'), "IMAGE")
    if not 'percent_icon.png' in _icons: _icons.load('percent_icon.png', os.path.join(os.path.dirname(__file__), 'icons', 'percent_icon.png'), "IMAGE")
    if not 'plusorminus_icon.png' in _icons: _icons.load('plusorminus_icon.png', os.path.join(os.path.dirname(__file__), 'icons', 'plusorminus_icon.png'), "IMAGE")
    if not 'percent_icon.png' in _icons: _icons.load('percent_icon.png', os.path.join(os.path.dirname(__file__), 'icons', 'percent_icon.png'), "IMAGE")
    bpy.app.handlers.load_post.append(load_post_handler_0F448)
    bpy.utils.register_class(SNA_OT_Kb_Op_Updatedepncies_0E98C)
    if not 'Cell_Fracture_icon.png' in _icons: _icons.load('Cell_Fracture_icon.png', os.path.join(os.path.dirname(__file__), 'icons', 'Cell_Fracture_icon.png'), "IMAGE")
    bpy.utils.register_class(SNA_OT_Kb_Op_Fracture_614C5)
    bpy.utils.register_class(SNA_OT_Kb_Op_Frature_Help_Video_3F307)
    bpy.utils.register_class(SNA_OT_Kb_Op_Delete_Kaboom_Cf826)
    bpy.utils.register_class(SNA_OT_Kb_Op_Bake_D6841)
    bpy.utils.register_class(SNA_OT_Kb_Op_Delete_Bake_146D2)
    bpy.utils.register_class(SNA_OT_Kb_Op_Clean_Project_Ddaf5)
    bpy.utils.register_class(SNA_PT_KABOOM_21D12)
    bpy.app.handlers.load_pre.append(load_pre_handler_0601A)
    bpy.app.handlers.frame_change_pre.append(frame_change_pre_handler_32C97)
    bpy.utils.register_class(SNA_OT_Kb_Op_Add_Group_From_Selection_17Be0)
    bpy.utils.register_class(SNA_OT_Kb_Op_Select_Kaboom_Parts_D8203)
    bpy.utils.register_class(SNA_OT_Kb_Op_Select_Dynamic_Shards_150Ec)
    bpy.utils.register_class(SNA_OT_Modop_Kb_Enable_Rough_Cut_95Af5)
    bpy.utils.register_class(SNA_OT_Modop_Kb_Remove_Rough_Cut_E18E2)
    bpy.utils.register_class(SNA_OT_Modop_Kb_Apply_Rough_Cut_1A6E2)
    bpy.app.handlers.render_complete.append(render_complete_handler_9F4FF)
    bpy.app.handlers.render_cancel.append(render_cancel_handler_0621B)
    bpy.app.handlers.render_init.append(render_init_handler_2F894)
    bpy.utils.register_class(SNA_OT_Kb_Op_Copy_Rough_Cut_Params_4E192)
    bpy.utils.register_class(SNA_OT_Kb_Op_Paste_Rough_Cut_Params_E6C01)
    bpy.utils.register_class(SNA_OT_Kb_Op_Show_Hide_Particles_Af372)
    bpy.utils.register_class(SNA_OT_Kb_Op_Copy_Smoke_Params_41685)
    bpy.utils.register_class(SNA_OT_Kb_Op_Remove_Particles_3B470)
    bpy.utils.register_class(SNA_OT_Kb_Op_Remove_Selected_Objects_Particles_9B69E)
    bpy.utils.register_class(SNA_OT_Kb_Op_Create_Smoke_Domain_7F35A)
    bpy.utils.register_class(SNA_OT_Kb_Op_Refresh_Smoke_Domain_C9C70)
    bpy.utils.register_class(SNA_OT_Kb_Op_Partcles_Time_Offset_04B7A)
    bpy.utils.register_class(SNA_OT_Kb_Op_Create_Smoke_Turbulence_6C76A)
    bpy.utils.register_class(SNA_OT_Kb_Op_Smoke_Emit_Time_Offset_Aba8E)
    bpy.utils.register_class(SNA_OT_Kb_Op_Update_Smoke_20F0A)
    bpy.utils.register_class(SNA_OT_Kb_Op_Update_Debris_79841)
    bpy.utils.register_class(SNA_OT_Kb_Op_Copy_Particle_Params_Bb41D)
    bpy.utils.register_class(SNA_OT_Kb_Op_Add_Particles_63F33)
    if not 'deploy_settings_icon.png' in _icons: _icons.load('deploy_settings_icon.png', os.path.join(os.path.dirname(__file__), 'icons', 'deploy_settings_icon.png'), "IMAGE")
    if not 'smoke_on_move.png' in _icons: _icons.load('smoke_on_move.png', os.path.join(os.path.dirname(__file__), 'icons', 'smoke_on_move.png'), "IMAGE")
    if not 'deploy_smoke_icon.png' in _icons: _icons.load('deploy_smoke_icon.png', os.path.join(os.path.dirname(__file__), 'icons', 'deploy_smoke_icon.png'), "IMAGE")
    if not 'Smoke_Domain_Icon.png' in _icons: _icons.load('Smoke_Domain_Icon.png', os.path.join(os.path.dirname(__file__), 'icons', 'Smoke_Domain_Icon.png'), "IMAGE")
    bpy.utils.register_class(SNA_OT_Kb_Op_Apply_Strenght_4E9Ae)
    bpy.utils.register_class(SNA_OT_Kb_Op_Add_Constraint_F02C2)
    bpy.utils.register_class(SNA_OT_Kb_Op_Apply_Mass_D9047)
    bpy.utils.register_class(SNA_OT_Kb_Op_Set_Passiv_Rg_30C43)
    if not 'Part_icon.png' in _icons: _icons.load('Part_icon.png', os.path.join(os.path.dirname(__file__), 'icons', 'Part_icon.png'), "IMAGE")
    if not 'mass_icon.png' in _icons: _icons.load('mass_icon.png', os.path.join(os.path.dirname(__file__), 'icons', 'mass_icon.png'), "IMAGE")
    bpy.utils.register_class(SNA_OT_Kb_Op_Remove_Selected_Objects_Constraints_8887F)
    bpy.utils.register_class(SNA_OT_Kb_Op_Remove_Constraint_39Cba)
    bpy.utils.register_class(SNA_OT_Kb_Op_Simulation_Keyframe_3243E)
    bpy.utils.register_class(SNA_OT_Kb_Op_Krumble_4Bc1F)
    bpy.utils.register_class(SNA_OT_Kb_Op_Reset_Rigid_Body_World_88Fc2)
    bpy.utils.register_class(SNA_PT_ABOUT_A715E)
    bpy.utils.register_class(SNA_PT_BLASTER_FDAD3)
    if not 'krumble_icon.png' in _icons: _icons.load('krumble_icon.png', os.path.join(os.path.dirname(__file__), 'icons', 'krumble_icon.png'), "IMAGE")
    bpy.utils.register_class(SNA_PT_RIGID_BODIES_50DA9)
    bpy.utils.register_class(SNA_PT_SIMULATION_49B02)
    bpy.utils.register_class(SNA_PT_BAKING_SIMULATION_36BA5)
    bpy.utils.register_class(SNA_PT_FX_E0914)
    bpy.utils.register_class(SNA_PT_FRACTURE_GROUPS_B7B66)
    bpy.utils.register_class(SNA_UL_display_collection_list_A9E63)
    bpy.utils.register_class(SNA_PT_FRACTURE_0FB86)
    if not 'Cell_Fracture_icon.png' in _icons: _icons.load('Cell_Fracture_icon.png', os.path.join(os.path.dirname(__file__), 'icons', 'Cell_Fracture_icon.png'), "IMAGE")
    bpy.utils.register_class(SNA_PT_panel001_7441E)
    if not 'krumble_icon.png' in _icons: _icons.load('krumble_icon.png', os.path.join(os.path.dirname(__file__), 'icons', 'krumble_icon.png'), "IMAGE")
    if not 'krumble_icon.png' in _icons: _icons.load('krumble_icon.png', os.path.join(os.path.dirname(__file__), 'icons', 'krumble_icon.png'), "IMAGE")
    bpy.utils.register_class(SNA_PT_krumble_panel_D1729)


def unregister():
    global _icons
    bpy.utils.previews.remove(_icons)
    wm = bpy.context.window_manager
    kc = wm.keyconfigs.addon
    for km, kmi in addon_keymaps.values():
        km.keymap_items.remove(kmi)
    addon_keymaps.clear()
    del bpy.types.Object.sna_kb_shard_real_acceleration
    del bpy.types.Object.sna_kb_shard_acceleration
    del bpy.types.Object.sna_kb_shard_velocity
    del bpy.types.Scene.sna_kb_lock_bake_flag
    del bpy.types.Scene.sna_kb_is_rendering
    del bpy.types.Scene.sna_kb_progress_job
    del bpy.types.Object.sna_kb_is_iterator_source
    del bpy.types.WindowManager.sna_kb_smoke_z_velocity
    del bpy.types.WindowManager.sna_kb_smoke_emission_exploding
    del bpy.types.WindowManager.sna_kb_smoke_emission_moving
    del bpy.types.Scene.sna_kb_progress_percent
    del bpy.types.WindowManager.sna_kb_blast_all_groups
    del bpy.types.WindowManager.sna_kb_particle_mode
    del bpy.types.WindowManager.sna_kb_live_blast
    del bpy.types.WindowManager.sna_kb_show_smoke_parts
    del bpy.types.WindowManager.sna_kb_show_debris_parts
    del bpy.types.WindowManager.sna_kb_debris_part_collection
    del bpy.types.WindowManager.sna_kb_particles_mode
    del bpy.types.WindowManager.sna_kb_particles_speed
    del bpy.types.WindowManager.sna_kb_particles_impact_factor
    del bpy.types.WindowManager.sna_kb_particles_count
    del bpy.types.WindowManager.sna_kb_particles_duration
    del bpy.types.WindowManager.sna_kb_velocity_threshold
    del bpy.types.WindowManager.sna_kb_constraint_strenght
    del bpy.types.WindowManager.sna_kb_constraint_mass
    del bpy.types.WindowManager.sna_kb_custom_f_end
    del bpy.types.WindowManager.sna_kb_custom_f_start
    del bpy.types.WindowManager.sna_kb_custom_range_bool
    del bpy.types.WindowManager.sna_kb_part_spin_rand
    del bpy.types.WindowManager.sna_kb_part_spin
    del bpy.types.WindowManager.sna_kb_bomb_directionnal_force_rand
    del bpy.types.WindowManager.sna_kb_bomb_directionnal_force
    del bpy.types.WindowManager.sna_kb_bomb_radial_force_rand
    del bpy.types.WindowManager.sna_kb_bomb_radial_force
    del bpy.types.Scene.sna_kb_blaster_object_name
    del bpy.types.Scene.sna_kb_col_index
    del bpy.types.Scene.sna_kb_kaboom_collection
    del bpy.types.WindowManager.sna_kb_fracture_axis
    del bpy.types.WindowManager.sna_kb_fracture_count
    del bpy.types.WindowManager.sna_kb_fracture_mode
    bpy.utils.unregister_class(SNA_GROUP_sna_kb_kaboom_group)
    bpy.utils.unregister_class(SNA_OT_Kb_Op_Web_Link_8F33D)
    bpy.utils.unregister_class(SNA_OT_Kb_Op_Add_Blaster_47645)
    bpy.app.handlers.load_post.remove(load_post_handler_0F448)
    bpy.utils.unregister_class(SNA_OT_Kb_Op_Updatedepncies_0E98C)
    bpy.utils.unregister_class(SNA_OT_Kb_Op_Fracture_614C5)
    bpy.utils.unregister_class(SNA_OT_Kb_Op_Frature_Help_Video_3F307)
    bpy.utils.unregister_class(SNA_OT_Kb_Op_Delete_Kaboom_Cf826)
    bpy.utils.unregister_class(SNA_OT_Kb_Op_Bake_D6841)
    bpy.utils.unregister_class(SNA_OT_Kb_Op_Delete_Bake_146D2)
    bpy.utils.unregister_class(SNA_OT_Kb_Op_Clean_Project_Ddaf5)
    bpy.utils.unregister_class(SNA_PT_KABOOM_21D12)
    bpy.app.handlers.load_pre.remove(load_pre_handler_0601A)
    bpy.app.handlers.frame_change_pre.remove(frame_change_pre_handler_32C97)
    bpy.utils.unregister_class(SNA_OT_Kb_Op_Add_Group_From_Selection_17Be0)
    bpy.utils.unregister_class(SNA_OT_Kb_Op_Select_Kaboom_Parts_D8203)
    bpy.utils.unregister_class(SNA_OT_Kb_Op_Select_Dynamic_Shards_150Ec)
    bpy.utils.unregister_class(SNA_OT_Modop_Kb_Enable_Rough_Cut_95Af5)
    bpy.utils.unregister_class(SNA_OT_Modop_Kb_Remove_Rough_Cut_E18E2)
    bpy.utils.unregister_class(SNA_OT_Modop_Kb_Apply_Rough_Cut_1A6E2)
    bpy.app.handlers.render_complete.remove(render_complete_handler_9F4FF)
    bpy.app.handlers.render_cancel.remove(render_cancel_handler_0621B)
    bpy.app.handlers.render_init.remove(render_init_handler_2F894)
    bpy.utils.unregister_class(SNA_OT_Kb_Op_Copy_Rough_Cut_Params_4E192)
    bpy.utils.unregister_class(SNA_OT_Kb_Op_Paste_Rough_Cut_Params_E6C01)
    bpy.utils.unregister_class(SNA_OT_Kb_Op_Show_Hide_Particles_Af372)
    bpy.utils.unregister_class(SNA_OT_Kb_Op_Copy_Smoke_Params_41685)
    bpy.utils.unregister_class(SNA_OT_Kb_Op_Remove_Particles_3B470)
    bpy.utils.unregister_class(SNA_OT_Kb_Op_Remove_Selected_Objects_Particles_9B69E)
    bpy.utils.unregister_class(SNA_OT_Kb_Op_Create_Smoke_Domain_7F35A)
    bpy.utils.unregister_class(SNA_OT_Kb_Op_Refresh_Smoke_Domain_C9C70)
    bpy.utils.unregister_class(SNA_OT_Kb_Op_Partcles_Time_Offset_04B7A)
    bpy.utils.unregister_class(SNA_OT_Kb_Op_Create_Smoke_Turbulence_6C76A)
    bpy.utils.unregister_class(SNA_OT_Kb_Op_Smoke_Emit_Time_Offset_Aba8E)
    bpy.utils.unregister_class(SNA_OT_Kb_Op_Update_Smoke_20F0A)
    bpy.utils.unregister_class(SNA_OT_Kb_Op_Update_Debris_79841)
    bpy.utils.unregister_class(SNA_OT_Kb_Op_Copy_Particle_Params_Bb41D)
    bpy.utils.unregister_class(SNA_OT_Kb_Op_Add_Particles_63F33)
    bpy.utils.unregister_class(SNA_OT_Kb_Op_Apply_Strenght_4E9Ae)
    bpy.utils.unregister_class(SNA_OT_Kb_Op_Add_Constraint_F02C2)
    bpy.utils.unregister_class(SNA_OT_Kb_Op_Apply_Mass_D9047)
    bpy.utils.unregister_class(SNA_OT_Kb_Op_Set_Passiv_Rg_30C43)
    bpy.utils.unregister_class(SNA_OT_Kb_Op_Remove_Selected_Objects_Constraints_8887F)
    bpy.utils.unregister_class(SNA_OT_Kb_Op_Remove_Constraint_39Cba)
    bpy.utils.unregister_class(SNA_OT_Kb_Op_Simulation_Keyframe_3243E)
    bpy.utils.unregister_class(SNA_OT_Kb_Op_Krumble_4Bc1F)
    bpy.utils.unregister_class(SNA_OT_Kb_Op_Reset_Rigid_Body_World_88Fc2)
    bpy.utils.unregister_class(SNA_PT_ABOUT_A715E)
    bpy.utils.unregister_class(SNA_PT_BLASTER_FDAD3)
    bpy.utils.unregister_class(SNA_PT_RIGID_BODIES_50DA9)
    bpy.utils.unregister_class(SNA_PT_SIMULATION_49B02)
    bpy.utils.unregister_class(SNA_PT_BAKING_SIMULATION_36BA5)
    bpy.utils.unregister_class(SNA_PT_FX_E0914)
    bpy.utils.unregister_class(SNA_PT_FRACTURE_GROUPS_B7B66)
    bpy.utils.unregister_class(SNA_UL_display_collection_list_A9E63)
    bpy.utils.unregister_class(SNA_PT_FRACTURE_0FB86)
    bpy.utils.unregister_class(SNA_PT_panel001_7441E)
    bpy.utils.unregister_class(SNA_PT_krumble_panel_D1729)
