# -------------
# Sugar
# QQ: 932180146
#-------------


module RBC
  # 加载Lib.
  #
  # @param [String] ext_name
  #
  # @return [Boolean]
  #
  # @since 6.3.0
  def self.check_lib7(ext, mv, rv, fv)
    return false if @lib_update && Sketchup.version.to_i < 17
    unless defined?(RBC::RBC_EXTENSION)
      # require RBC library.
      begin
        require 'RBC_Library_load.rb'
      rescue LoadError => e
        p e
      end
    end
    if defined?(RBC::RBC_VERSION_) && RBC::RBC_VERSION_[0] == mv
      if RBC::RBC_VERSION_[1] >= rv
        update = false
      elsif RBC::RBC_VERSION_[2] >= fv
        update = false
      else
        update = true
      end
    else
      update = true
    end
    # check version.
    if update
      msg = "#{ext.name}: More than #{ext.version} versions of RBC must be installed!(必须安装使用 #{ext.version} 版本以上的RBC Library!)"
      Sketchup.status_text = msg
      if Sketchup.version.to_i >= 17
        UI::Notification.new(ext, msg).show
      else
        UI.messagebox(msg)
      end
      @check_lib = true
      false
    end
    !update
  end
end# module RBC

module RBC
  module Extensions
    module AnimationTools

      NAME         = 'RBC_Animation'.freeze
      VERSION      = '7.6.0'.freeze
      PLUGIN_PATH = __FILE__.force_encoding('UTF-8').freeze
      DIR_NAME     = (NAME+'_v'+VERSION).freeze
      PLUGINS_DIR  = File.join(File.dirname(PLUGIN_PATH), DIR_NAME).freeze

      EXTENSION = SketchupExtension.new(NAME, File.join(PLUGINS_DIR, 'core.rb'))
      EXTENSION.description = 'Used to create animation.'
      EXTENSION.copyright   = "Copyright (c) #{Time.new.year} Sugar All rights reserved."
      EXTENSION.version     = VERSION
      EXTENSION.creator     = 'Sugar'
      if RBC.check_lib7(EXTENSION, 7, 6, 0)
        Sketchup.register_extension(EXTENSION, true)
      end

    end# module ExplodeView
  end# module Extensions
end# module RBC