/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.swing.svg;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;
import org.apache.batik.anim.dom.SVGDOMImplementation;
import org.apache.batik.anim.dom.SVGOMDocument;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.BridgeExtension;
import org.apache.batik.bridge.DefaultFontFamilyResolver;
import org.apache.batik.bridge.DefaultScriptSecurity;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.ExternalResourceSecurity;
import org.apache.batik.bridge.FontFamilyResolver;
import org.apache.batik.bridge.Mark;
import org.apache.batik.bridge.RelaxedExternalResourceSecurity;
import org.apache.batik.bridge.ScriptSecurity;
import org.apache.batik.bridge.UpdateManager;
import org.apache.batik.bridge.UpdateManagerEvent;
import org.apache.batik.bridge.UpdateManagerListener;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.ViewBox;
import org.apache.batik.bridge.svg12.SVG12BridgeContext;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.ext.awt.image.spi.ImageTagRegistry;
import org.apache.batik.gvt.CanvasGraphicsNode;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.event.EventDispatcher;
import org.apache.batik.gvt.renderer.ImageRenderer;
import org.apache.batik.script.Interpreter;
import org.apache.batik.swing.gvt.GVTTreeRendererEvent;
import org.apache.batik.swing.gvt.JGVTComponent;
import org.apache.batik.swing.gvt.JGVTComponentListener;
import org.apache.batik.swing.svg.GVTTreeBuilder;
import org.apache.batik.swing.svg.GVTTreeBuilderEvent;
import org.apache.batik.swing.svg.GVTTreeBuilderListener;
import org.apache.batik.swing.svg.LinkActivationEvent;
import org.apache.batik.swing.svg.LinkActivationListener;
import org.apache.batik.swing.svg.Messages;
import org.apache.batik.swing.svg.SVGDocumentLoader;
import org.apache.batik.swing.svg.SVGDocumentLoaderEvent;
import org.apache.batik.swing.svg.SVGDocumentLoaderListener;
import org.apache.batik.swing.svg.SVGLoadEventDispatcher;
import org.apache.batik.swing.svg.SVGLoadEventDispatcherEvent;
import org.apache.batik.swing.svg.SVGLoadEventDispatcherListener;
import org.apache.batik.swing.svg.SVGUpdateOverlay;
import org.apache.batik.swing.svg.SVGUserAgent;
import org.apache.batik.util.ParsedURL;
import org.apache.batik.util.RunnableQueue;
import org.apache.batik.util.SVGFeatureStrings;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGAElement;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public class JSVGComponent
extends JGVTComponent {
    public static final int AUTODETECT = 0;
    public static final int ALWAYS_DYNAMIC = 1;
    public static final int ALWAYS_STATIC = 2;
    public static final int ALWAYS_INTERACTIVE = 3;
    public static final String SCRIPT_ALERT = "script.alert";
    public static final String SCRIPT_PROMPT = "script.prompt";
    public static final String SCRIPT_CONFIRM = "script.confirm";
    public static final String BROKEN_LINK_TITLE = "broken.link.title";
    protected SVGDocumentLoader documentLoader;
    protected SVGDocumentLoader nextDocumentLoader;
    protected DocumentLoader loader;
    protected GVTTreeBuilder gvtTreeBuilder;
    protected GVTTreeBuilder nextGVTTreeBuilder;
    protected SVGLoadEventDispatcher svgLoadEventDispatcher;
    protected UpdateManager updateManager;
    protected UpdateManager nextUpdateManager;
    protected SVGDocument svgDocument;
    protected List svgDocumentLoaderListeners = new LinkedList();
    protected List gvtTreeBuilderListeners = new LinkedList();
    protected List svgLoadEventDispatcherListeners = new LinkedList();
    protected List linkActivationListeners = new LinkedList();
    protected List updateManagerListeners = new LinkedList();
    protected UserAgent userAgent;
    protected SVGUserAgent svgUserAgent;
    protected BridgeContext bridgeContext;
    protected String fragmentIdentifier;
    protected boolean isDynamicDocument;
    protected boolean isInteractiveDocument;
    protected boolean selfCallingDisableInteractions = false;
    protected boolean userSetDisableInteractions = false;
    protected int documentState;
    protected Dimension prevComponentSize;
    protected Runnable afterStopRunnable = null;
    protected SVGUpdateOverlay updateOverlay;
    protected boolean recenterOnResize = true;
    protected AffineTransform viewingTransform = null;
    protected int animationLimitingMode;
    protected float animationLimitingAmount;
    protected JSVGComponentListener jsvgComponentListener = new JSVGComponentListener();
    protected static final Set FEATURES = new HashSet();

    public JSVGComponent() {
        this(null, false, false);
    }

    public JSVGComponent(SVGUserAgent ua, boolean eventsEnabled, boolean selectableText) {
        super(eventsEnabled, selectableText);
        this.svgUserAgent = ua;
        this.userAgent = new BridgeUserAgentWrapper(this.createUserAgent());
        this.addSVGDocumentLoaderListener((SVGListener)this.listener);
        this.addGVTTreeBuilderListener((SVGListener)this.listener);
        this.addSVGLoadEventDispatcherListener((SVGListener)this.listener);
        if (this.updateOverlay != null) {
            this.getOverlays().add(this.updateOverlay);
        }
    }

    public void dispose() {
        this.setSVGDocument(null);
    }

    @Override
    public void setDisableInteractions(boolean b) {
        super.setDisableInteractions(b);
        if (!this.selfCallingDisableInteractions) {
            this.userSetDisableInteractions = true;
        }
    }

    public void clearUserSetDisableInteractions() {
        this.userSetDisableInteractions = false;
        this.updateZoomAndPanEnable((Document)this.svgDocument);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateZoomAndPanEnable(Document doc) {
        if (this.userSetDisableInteractions) {
            return;
        }
        if (doc == null) {
            return;
        }
        try {
            Element root = doc.getDocumentElement();
            String znp = root.getAttributeNS(null, "zoomAndPan");
            boolean enable = "magnify".equals(znp);
            this.selfCallingDisableInteractions = true;
            this.setDisableInteractions(!enable);
        }
        finally {
            this.selfCallingDisableInteractions = false;
        }
    }

    public boolean getRecenterOnResize() {
        return this.recenterOnResize;
    }

    public void setRecenterOnResize(boolean recenterOnResize) {
        this.recenterOnResize = recenterOnResize;
    }

    public boolean isDynamic() {
        return this.isDynamicDocument;
    }

    public boolean isInteractive() {
        return this.isInteractiveDocument;
    }

    public void setDocumentState(int state) {
        this.documentState = state;
    }

    public UpdateManager getUpdateManager() {
        if (this.svgLoadEventDispatcher != null) {
            return this.svgLoadEventDispatcher.getUpdateManager();
        }
        if (this.nextUpdateManager != null) {
            return this.nextUpdateManager;
        }
        return this.updateManager;
    }

    public void resumeProcessing() {
        if (this.updateManager != null) {
            this.updateManager.resume();
        }
    }

    public void suspendProcessing() {
        if (this.updateManager != null) {
            this.updateManager.suspend();
        }
    }

    @Override
    public void stopProcessing() {
        this.nextDocumentLoader = null;
        this.nextGVTTreeBuilder = null;
        if (this.documentLoader != null) {
            this.documentLoader.halt();
        }
        if (this.gvtTreeBuilder != null) {
            this.gvtTreeBuilder.halt();
        }
        if (this.svgLoadEventDispatcher != null) {
            this.svgLoadEventDispatcher.halt();
        }
        if (this.nextUpdateManager != null) {
            this.nextUpdateManager.interrupt();
            this.nextUpdateManager = null;
        }
        if (this.updateManager != null) {
            this.updateManager.interrupt();
        }
        super.stopProcessing();
    }

    public void loadSVGDocument(String url) {
        String oldURI = null;
        if (this.svgDocument != null) {
            oldURI = this.svgDocument.getURL();
        }
        final ParsedURL newURI = new ParsedURL(oldURI, url);
        this.stopThenRun(new Runnable(){

            @Override
            public void run() {
                String url = newURI.toString();
                JSVGComponent.this.fragmentIdentifier = newURI.getRef();
                JSVGComponent.this.loader = new DocumentLoader(JSVGComponent.this.userAgent);
                JSVGComponent.this.nextDocumentLoader = new SVGDocumentLoader(url, JSVGComponent.this.loader);
                JSVGComponent.this.nextDocumentLoader.setPriority(1);
                Iterator it = JSVGComponent.this.svgDocumentLoaderListeners.iterator();
                while (it.hasNext()) {
                    JSVGComponent.this.nextDocumentLoader.addSVGDocumentLoaderListener((SVGDocumentLoaderListener)it.next());
                }
                JSVGComponent.this.startDocumentLoader();
            }
        });
    }

    private void startDocumentLoader() {
        this.documentLoader = this.nextDocumentLoader;
        this.nextDocumentLoader = null;
        this.documentLoader.start();
    }

    public void setDocument(Document doc) {
        if (doc != null && !(doc.getImplementation() instanceof SVGDOMImplementation)) {
            Document d;
            DOMImplementation impl = SVGDOMImplementation.getDOMImplementation();
            doc = d = DOMUtilities.deepCloneDocument((Document)doc, (DOMImplementation)impl);
        }
        this.setSVGDocument((SVGDocument)doc);
    }

    public void setSVGDocument(SVGDocument doc) {
        if (doc != null && !(doc.getImplementation() instanceof SVGDOMImplementation)) {
            DOMImplementation impl = SVGDOMImplementation.getDOMImplementation();
            Document d = DOMUtilities.deepCloneDocument((Document)doc, (DOMImplementation)impl);
            doc = (SVGDocument)d;
        }
        final SVGDocument svgdoc = doc;
        this.stopThenRun(new Runnable(){

            @Override
            public void run() {
                JSVGComponent.this.installSVGDocument(svgdoc);
            }
        });
    }

    protected void stopThenRun(Runnable r) {
        if (this.afterStopRunnable != null) {
            this.afterStopRunnable = r;
            return;
        }
        this.afterStopRunnable = r;
        this.stopProcessing();
        if (this.documentLoader == null && this.gvtTreeBuilder == null && this.gvtTreeRenderer == null && this.svgLoadEventDispatcher == null && this.nextUpdateManager == null && this.updateManager == null) {
            Runnable asr = this.afterStopRunnable;
            this.afterStopRunnable = null;
            asr.run();
        }
    }

    protected void installSVGDocument(SVGDocument doc) {
        this.svgDocument = doc;
        if (this.bridgeContext != null) {
            this.bridgeContext.dispose();
            this.bridgeContext = null;
        }
        this.releaseRenderingReferences();
        if (doc == null) {
            this.isDynamicDocument = false;
            this.isInteractiveDocument = false;
            this.disableInteractions = true;
            this.initialTransform = new AffineTransform();
            this.setRenderingTransform(this.initialTransform, false);
            Rectangle vRect = this.getRenderRect();
            this.repaint(vRect.x, vRect.y, vRect.width, vRect.height);
            return;
        }
        this.bridgeContext = this.createBridgeContext((SVGOMDocument)doc);
        switch (this.documentState) {
            case 2: {
                this.isDynamicDocument = false;
                this.isInteractiveDocument = false;
                break;
            }
            case 3: {
                this.isDynamicDocument = false;
                this.isInteractiveDocument = true;
                break;
            }
            case 1: {
                this.isDynamicDocument = true;
                this.isInteractiveDocument = true;
                break;
            }
            case 0: {
                this.isDynamicDocument = this.bridgeContext.isDynamicDocument((Document)doc);
                boolean bl = this.isInteractiveDocument = this.isDynamicDocument || this.bridgeContext.isInteractiveDocument((Document)doc);
            }
        }
        if (this.isInteractiveDocument) {
            if (this.isDynamicDocument) {
                this.bridgeContext.setDynamicState(2);
            } else {
                this.bridgeContext.setDynamicState(1);
            }
        }
        this.setBridgeContextAnimationLimitingMode();
        this.updateZoomAndPanEnable((Document)doc);
        this.nextGVTTreeBuilder = new GVTTreeBuilder(doc, this.bridgeContext);
        this.nextGVTTreeBuilder.setPriority(1);
        Iterator it = this.gvtTreeBuilderListeners.iterator();
        while (it.hasNext()) {
            this.nextGVTTreeBuilder.addGVTTreeBuilderListener((GVTTreeBuilderListener)it.next());
        }
        this.initializeEventHandling();
        if (this.gvtTreeBuilder == null && this.documentLoader == null && this.gvtTreeRenderer == null && this.svgLoadEventDispatcher == null && this.updateManager == null) {
            this.startGVTTreeBuilder();
        }
    }

    protected void startGVTTreeBuilder() {
        this.gvtTreeBuilder = this.nextGVTTreeBuilder;
        this.nextGVTTreeBuilder = null;
        this.gvtTreeBuilder.start();
    }

    public SVGDocument getSVGDocument() {
        return this.svgDocument;
    }

    public Dimension2D getSVGDocumentSize() {
        return this.bridgeContext.getDocumentSize();
    }

    public String getFragmentIdentifier() {
        return this.fragmentIdentifier;
    }

    public void setFragmentIdentifier(String fi) {
        this.fragmentIdentifier = fi;
        if (this.computeRenderingTransform()) {
            this.scheduleGVTRendering();
        }
    }

    public void flushImageCache() {
        ImageTagRegistry reg = ImageTagRegistry.getRegistry();
        reg.flushCache();
    }

    @Override
    public void setGraphicsNode(GraphicsNode gn, boolean createDispatcher) {
        Dimension2D dim = this.bridgeContext.getDocumentSize();
        Dimension mySz = new Dimension((int)dim.getWidth(), (int)dim.getHeight());
        this.setMySize(mySz);
        SVGSVGElement elt = this.svgDocument.getRootElement();
        this.prevComponentSize = this.getSize();
        AffineTransform at = this.calculateViewingTransform(this.fragmentIdentifier, elt);
        CanvasGraphicsNode cgn = this.getCanvasGraphicsNode(gn);
        if (cgn != null) {
            cgn.setViewingTransform(at);
        }
        this.viewingTransform = null;
        this.initialTransform = new AffineTransform();
        this.setRenderingTransform(this.initialTransform, false);
        this.jsvgComponentListener.updateMatrix(this.initialTransform);
        this.addJGVTComponentListener(this.jsvgComponentListener);
        this.addComponentListener(this.jsvgComponentListener);
        super.setGraphicsNode(gn, createDispatcher);
    }

    protected BridgeContext createBridgeContext(SVGOMDocument doc) {
        if (this.loader == null) {
            this.loader = new DocumentLoader(this.userAgent);
        }
        Object result = doc.isSVG12() ? new SVG12BridgeContext(this.userAgent, this.loader) : new BridgeContext(this.userAgent, this.loader);
        return result;
    }

    protected void startSVGLoadEventDispatcher(GraphicsNode root) {
        UpdateManager um = new UpdateManager(this.bridgeContext, root, (Document)this.svgDocument);
        this.svgLoadEventDispatcher = new SVGLoadEventDispatcher(root, this.svgDocument, this.bridgeContext, um);
        Iterator it = this.svgLoadEventDispatcherListeners.iterator();
        while (it.hasNext()) {
            this.svgLoadEventDispatcher.addSVGLoadEventDispatcherListener((SVGLoadEventDispatcherListener)it.next());
        }
        this.svgLoadEventDispatcher.start();
    }

    @Override
    protected ImageRenderer createImageRenderer() {
        if (this.isDynamicDocument) {
            return this.rendererFactory.createDynamicImageRenderer();
        }
        return this.rendererFactory.createStaticImageRenderer();
    }

    public CanvasGraphicsNode getCanvasGraphicsNode() {
        return this.getCanvasGraphicsNode(this.gvtRoot);
    }

    protected CanvasGraphicsNode getCanvasGraphicsNode(GraphicsNode gn) {
        if (!(gn instanceof CompositeGraphicsNode)) {
            return null;
        }
        CompositeGraphicsNode cgn = (CompositeGraphicsNode)gn;
        List children = cgn.getChildren();
        if (children.size() == 0) {
            return null;
        }
        gn = (GraphicsNode)children.get(0);
        if (!(gn instanceof CanvasGraphicsNode)) {
            return null;
        }
        return (CanvasGraphicsNode)gn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AffineTransform getViewingTransform() {
        AffineTransform vt;
        JSVGComponent jSVGComponent = this;
        synchronized (jSVGComponent) {
            CanvasGraphicsNode cgn;
            vt = this.viewingTransform;
            if (vt == null && (cgn = this.getCanvasGraphicsNode()) != null) {
                vt = cgn.getViewingTransform();
            }
        }
        return vt;
    }

    public AffineTransform getViewBoxTransform() {
        AffineTransform at = this.getRenderingTransform();
        at = at == null ? new AffineTransform() : new AffineTransform(at);
        AffineTransform vt = this.getViewingTransform();
        if (vt != null) {
            at.concatenate(vt);
        }
        return at;
    }

    @Override
    protected boolean computeRenderingTransform() {
        if (this.svgDocument == null || this.gvtRoot == null) {
            return false;
        }
        boolean ret = this.updateRenderingTransform();
        this.initialTransform = new AffineTransform();
        if (!this.initialTransform.equals(this.getRenderingTransform())) {
            this.setRenderingTransform(this.initialTransform, false);
            ret = true;
        }
        return ret;
    }

    protected AffineTransform calculateViewingTransform(String fragIdent, SVGSVGElement svgElt) {
        Dimension d = this.getSize();
        if (d.width < 1) {
            d.width = 1;
        }
        if (d.height < 1) {
            d.height = 1;
        }
        return ViewBox.getViewTransform((String)fragIdent, (Element)svgElt, (float)d.width, (float)d.height, (BridgeContext)this.bridgeContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean updateRenderingTransform() {
        if (this.svgDocument == null || this.gvtRoot == null) {
            return false;
        }
        try {
            Object pt;
            AffineTransform vt;
            AffineTransform at;
            SVGSVGElement elt = this.svgDocument.getRootElement();
            Dimension d = this.getSize();
            Dimension oldD = this.prevComponentSize;
            if (oldD == null) {
                oldD = d;
            }
            this.prevComponentSize = d;
            if (d.width < 1) {
                d.width = 1;
            }
            if (d.height < 1) {
                d.height = 1;
            }
            if ((at = this.calculateViewingTransform(this.fragmentIdentifier, elt)).equals(vt = this.getViewingTransform())) {
                return oldD.width != d.width || oldD.height != d.height;
            }
            if (this.recenterOnResize) {
                pt = new Point2D.Float((float)oldD.width / 2.0f, (float)oldD.height / 2.0f);
                AffineTransform rendAT = this.getRenderingTransform();
                if (rendAT != null) {
                    try {
                        AffineTransform invRendAT = rendAT.createInverse();
                        pt = invRendAT.transform((Point2D)pt, null);
                    }
                    catch (NoninvertibleTransformException e) {
                        // empty catch block
                    }
                }
                if (vt != null) {
                    try {
                        AffineTransform invVT = vt.createInverse();
                        pt = invVT.transform((Point2D)pt, null);
                    }
                    catch (NoninvertibleTransformException e) {
                        // empty catch block
                    }
                }
                if (at != null) {
                    pt = at.transform((Point2D)pt, null);
                }
                if (rendAT != null) {
                    pt = rendAT.transform((Point2D)pt, null);
                }
                float dx = (float)((double)((float)d.width / 2.0f) - ((Point2D)pt).getX());
                float dy = (float)((double)((float)d.height / 2.0f) - ((Point2D)pt).getY());
                dx = (int)(dx < 0.0f ? (double)dx - 0.5 : (double)dx + 0.5);
                dy = (int)(dy < 0.0f ? (double)dy - 0.5 : (double)dy + 0.5);
                if (dx != 0.0f || dy != 0.0f) {
                    rendAT.preConcatenate(AffineTransform.getTranslateInstance(dx, dy));
                    this.setRenderingTransform(rendAT, false);
                }
            }
            pt = this;
            synchronized (pt) {
                this.viewingTransform = at;
            }
            Runnable r = new Runnable(){
                AffineTransform myAT;
                CanvasGraphicsNode myCGN;
                {
                    this.myAT = at;
                    this.myCGN = JSVGComponent.this.getCanvasGraphicsNode();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    JSVGComponent jSVGComponent = JSVGComponent.this;
                    synchronized (jSVGComponent) {
                        if (this.myCGN != null) {
                            this.myCGN.setViewingTransform(this.myAT);
                        }
                        if (JSVGComponent.this.viewingTransform == this.myAT) {
                            JSVGComponent.this.viewingTransform = null;
                        }
                    }
                }
            };
            UpdateManager um = this.getUpdateManager();
            if (um != null) {
                um.getUpdateRunnableQueue().invokeLater(r);
            } else {
                r.run();
            }
        }
        catch (BridgeException e) {
            this.userAgent.displayError((Exception)((Object)e));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void renderGVTTree() {
        class UpdateRenderingRunnable
        implements Runnable {
            AffineTransform at;
            boolean doubleBuf;
            boolean clearPaintTrans;
            Shape aoi;
            int width;
            int height;
            boolean active;

            public UpdateRenderingRunnable(AffineTransform at, boolean doubleBuf, boolean clearPaintTrans, Shape aoi, int width, int height) {
                this.updateInfo(at, doubleBuf, clearPaintTrans, aoi, width, height);
                this.active = true;
            }

            public void updateInfo(AffineTransform at, boolean doubleBuf, boolean clearPaintTrans, Shape aoi, int width, int height) {
                this.at = at;
                this.doubleBuf = doubleBuf;
                this.clearPaintTrans = clearPaintTrans;
                this.aoi = aoi;
                this.width = width;
                this.height = height;
                this.active = true;
            }

            public void deactivate() {
                this.active = false;
            }

            @Override
            public void run() {
                if (!this.active) {
                    return;
                }
                JSVGComponent.this.updateManager.updateRendering(this.at, this.doubleBuf, this.clearPaintTrans, this.aoi, this.width, this.height);
            }
        }
        if (!this.isInteractiveDocument || this.updateManager == null || !this.updateManager.isRunning()) {
            super.renderGVTTree();
            return;
        }
        Rectangle visRect = this.getRenderRect();
        if (this.gvtRoot == null || visRect.width <= 0 || visRect.height <= 0) {
            return;
        }
        AffineTransform inv = null;
        try {
            inv = this.renderingTransform.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            // empty catch block
        }
        Shape s = inv == null ? visRect : inv.createTransformedShape(visRect);
        RunnableQueue rq = this.updateManager.getUpdateRunnableQueue();
        Object object = rq.getIteratorLock();
        synchronized (object) {
            for (Object next : rq) {
                if (!(next instanceof UpdateRenderingRunnable)) continue;
                ((UpdateRenderingRunnable)next).deactivate();
            }
        }
        rq.invokeLater((Runnable)new UpdateRenderingRunnable(this.renderingTransform, this.doubleBufferedRendering, true, s, visRect.width, visRect.height));
    }

    @Override
    protected void handleException(Exception e) {
        this.userAgent.displayError(e);
    }

    public void addSVGDocumentLoaderListener(SVGDocumentLoaderListener l) {
        this.svgDocumentLoaderListeners.add(l);
    }

    public void removeSVGDocumentLoaderListener(SVGDocumentLoaderListener l) {
        this.svgDocumentLoaderListeners.remove(l);
    }

    public void addGVTTreeBuilderListener(GVTTreeBuilderListener l) {
        this.gvtTreeBuilderListeners.add(l);
    }

    public void removeGVTTreeBuilderListener(GVTTreeBuilderListener l) {
        this.gvtTreeBuilderListeners.remove(l);
    }

    public void addSVGLoadEventDispatcherListener(SVGLoadEventDispatcherListener l) {
        this.svgLoadEventDispatcherListeners.add(l);
    }

    public void removeSVGLoadEventDispatcherListener(SVGLoadEventDispatcherListener l) {
        this.svgLoadEventDispatcherListeners.remove(l);
    }

    public void addLinkActivationListener(LinkActivationListener l) {
        this.linkActivationListeners.add(l);
    }

    public void removeLinkActivationListener(LinkActivationListener l) {
        this.linkActivationListeners.remove(l);
    }

    public void addUpdateManagerListener(UpdateManagerListener l) {
        this.updateManagerListeners.add(l);
    }

    public void removeUpdateManagerListener(UpdateManagerListener l) {
        this.updateManagerListeners.remove(l);
    }

    public void showAlert(String message) {
        JOptionPane.showMessageDialog(this, Messages.formatMessage(SCRIPT_ALERT, new Object[]{message}));
    }

    public String showPrompt(String message) {
        return JOptionPane.showInputDialog(this, (Object)Messages.formatMessage(SCRIPT_PROMPT, new Object[]{message}));
    }

    public String showPrompt(String message, String defaultValue) {
        return (String)JOptionPane.showInputDialog(this, Messages.formatMessage(SCRIPT_PROMPT, new Object[]{message}), null, -1, null, null, defaultValue);
    }

    public boolean showConfirm(String message) {
        return JOptionPane.showConfirmDialog(this, Messages.formatMessage(SCRIPT_CONFIRM, new Object[]{message}), "Confirm", 0) == 0;
    }

    public void setMySize(Dimension d) {
        this.setPreferredSize(d);
        this.invalidate();
    }

    public void setAnimationLimitingNone() {
        this.animationLimitingMode = 0;
        if (this.bridgeContext != null) {
            this.setBridgeContextAnimationLimitingMode();
        }
    }

    public void setAnimationLimitingCPU(float pc) {
        this.animationLimitingMode = 1;
        this.animationLimitingAmount = pc;
        if (this.bridgeContext != null) {
            this.setBridgeContextAnimationLimitingMode();
        }
    }

    public void setAnimationLimitingFPS(float fps) {
        this.animationLimitingMode = 2;
        this.animationLimitingAmount = fps;
        if (this.bridgeContext != null) {
            this.setBridgeContextAnimationLimitingMode();
        }
    }

    public Interpreter getInterpreter(String type) {
        if (this.bridgeContext != null) {
            return this.bridgeContext.getInterpreter(type);
        }
        return null;
    }

    protected void setBridgeContextAnimationLimitingMode() {
        switch (this.animationLimitingMode) {
            case 0: {
                this.bridgeContext.setAnimationLimitingNone();
                break;
            }
            case 1: {
                this.bridgeContext.setAnimationLimitingCPU(this.animationLimitingAmount);
                break;
            }
            case 2: {
                this.bridgeContext.setAnimationLimitingFPS(this.animationLimitingAmount);
            }
        }
    }

    @Override
    protected JGVTComponent.Listener createListener() {
        return new SVGListener();
    }

    protected UserAgent createUserAgent() {
        return new BridgeUserAgent();
    }

    static {
        SVGFeatureStrings.addSupportedFeatureStrings((Set)FEATURES);
    }

    protected class BridgeUserAgent
    implements UserAgent {
        protected Map extensions = new HashMap();

        protected BridgeUserAgent() {
        }

        public Dimension2D getViewportSize() {
            return JSVGComponent.this.getSize();
        }

        public EventDispatcher getEventDispatcher() {
            return JSVGComponent.this.eventDispatcher;
        }

        public void displayError(String message) {
            if (JSVGComponent.this.svgUserAgent != null) {
                JSVGComponent.this.svgUserAgent.displayError(message);
            }
        }

        public void displayError(Exception ex) {
            if (JSVGComponent.this.svgUserAgent != null) {
                JSVGComponent.this.svgUserAgent.displayError(ex);
            }
        }

        public void displayMessage(String message) {
            if (JSVGComponent.this.svgUserAgent != null) {
                JSVGComponent.this.svgUserAgent.displayMessage(message);
            }
        }

        public void showAlert(String message) {
            if (JSVGComponent.this.svgUserAgent != null) {
                JSVGComponent.this.svgUserAgent.showAlert(message);
                return;
            }
            JSVGComponent.this.showAlert(message);
        }

        public String showPrompt(String message) {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.showPrompt(message);
            }
            return JSVGComponent.this.showPrompt(message);
        }

        public String showPrompt(String message, String defaultValue) {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.showPrompt(message, defaultValue);
            }
            return JSVGComponent.this.showPrompt(message, defaultValue);
        }

        public boolean showConfirm(String message) {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.showConfirm(message);
            }
            return JSVGComponent.this.showConfirm(message);
        }

        public float getPixelUnitToMillimeter() {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.getPixelUnitToMillimeter();
            }
            return 0.26458332f;
        }

        public float getPixelToMM() {
            return this.getPixelUnitToMillimeter();
        }

        public String getDefaultFontFamily() {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.getDefaultFontFamily();
            }
            return "Arial, Helvetica, sans-serif";
        }

        public float getMediumFontSize() {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.getMediumFontSize();
            }
            return 228.59999f / (72.0f * this.getPixelUnitToMillimeter());
        }

        public float getLighterFontWeight(float f) {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.getLighterFontWeight(f);
            }
            int weight = (int)((f + 50.0f) / 100.0f) * 100;
            switch (weight) {
                case 100: {
                    return 100.0f;
                }
                case 200: {
                    return 100.0f;
                }
                case 300: {
                    return 200.0f;
                }
                case 400: {
                    return 300.0f;
                }
                case 500: {
                    return 400.0f;
                }
                case 600: {
                    return 400.0f;
                }
                case 700: {
                    return 400.0f;
                }
                case 800: {
                    return 400.0f;
                }
                case 900: {
                    return 400.0f;
                }
            }
            throw new IllegalArgumentException("Bad Font Weight: " + f);
        }

        public float getBolderFontWeight(float f) {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.getBolderFontWeight(f);
            }
            int weight = (int)((f + 50.0f) / 100.0f) * 100;
            switch (weight) {
                case 100: {
                    return 600.0f;
                }
                case 200: {
                    return 600.0f;
                }
                case 300: {
                    return 600.0f;
                }
                case 400: {
                    return 600.0f;
                }
                case 500: {
                    return 600.0f;
                }
                case 600: {
                    return 700.0f;
                }
                case 700: {
                    return 800.0f;
                }
                case 800: {
                    return 900.0f;
                }
                case 900: {
                    return 900.0f;
                }
            }
            throw new IllegalArgumentException("Bad Font Weight: " + f);
        }

        public String getLanguages() {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.getLanguages();
            }
            return "en";
        }

        public String getUserStyleSheetURI() {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.getUserStyleSheetURI();
            }
            return null;
        }

        public void openLink(SVGAElement elt) {
            ParsedURL oldURI;
            String show = XLinkSupport.getXLinkShow((Element)elt);
            String href = elt.getHref().getAnimVal();
            if (show.equals("new")) {
                this.fireLinkActivatedEvent(elt, href);
                if (JSVGComponent.this.svgUserAgent != null) {
                    String oldURI2 = JSVGComponent.this.svgDocument.getURL();
                    ParsedURL newURI = null;
                    if (elt.getOwnerDocument() != JSVGComponent.this.svgDocument) {
                        SVGDocument doc = (SVGDocument)elt.getOwnerDocument();
                        href = new ParsedURL(doc.getURL(), href).toString();
                    }
                    newURI = new ParsedURL(oldURI2, href);
                    href = newURI.toString();
                    JSVGComponent.this.svgUserAgent.openLink(href, true);
                } else {
                    JSVGComponent.this.loadSVGDocument(href);
                }
                return;
            }
            ParsedURL newURI = new ParsedURL(((SVGDocument)elt.getOwnerDocument()).getURL(), href);
            href = newURI.toString();
            if (JSVGComponent.this.svgDocument != null && newURI.sameFile(oldURI = new ParsedURL(JSVGComponent.this.svgDocument.getURL()))) {
                String s = newURI.getRef();
                if (!(JSVGComponent.this.fragmentIdentifier == s || s != null && s.equals(JSVGComponent.this.fragmentIdentifier))) {
                    JSVGComponent.this.fragmentIdentifier = s;
                    if (JSVGComponent.this.computeRenderingTransform()) {
                        JSVGComponent.this.scheduleGVTRendering();
                    }
                }
                this.fireLinkActivatedEvent(elt, href);
                return;
            }
            this.fireLinkActivatedEvent(elt, href);
            if (JSVGComponent.this.svgUserAgent != null) {
                JSVGComponent.this.svgUserAgent.openLink(href, false);
            } else {
                JSVGComponent.this.loadSVGDocument(href);
            }
        }

        protected void fireLinkActivatedEvent(SVGAElement elt, String href) {
            Object[] ll = JSVGComponent.this.linkActivationListeners.toArray();
            if (ll.length > 0) {
                LinkActivationEvent ev = new LinkActivationEvent(JSVGComponent.this, elt, href);
                for (int i = 0; i < ll.length; ++i) {
                    LinkActivationListener l = (LinkActivationListener)ll[i];
                    l.linkActivated(ev);
                }
            }
        }

        public void setSVGCursor(Cursor cursor) {
            if (cursor != JSVGComponent.this.getCursor()) {
                JSVGComponent.this.setCursor(cursor);
            }
        }

        public void setTextSelection(Mark start, Mark end) {
            JSVGComponent.this.select(start, end);
        }

        public void deselectAll() {
            JSVGComponent.this.deselectAll();
        }

        public String getXMLParserClassName() {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.getXMLParserClassName();
            }
            return XMLResourceDescriptor.getXMLParserClassName();
        }

        public boolean isXMLParserValidating() {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.isXMLParserValidating();
            }
            return false;
        }

        public AffineTransform getTransform() {
            return JSVGComponent.this.renderingTransform;
        }

        public void setTransform(AffineTransform at) {
            JSVGComponent.this.setRenderingTransform(at);
        }

        public String getMedia() {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.getMedia();
            }
            return "screen";
        }

        public String getAlternateStyleSheet() {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.getAlternateStyleSheet();
            }
            return null;
        }

        public Point getClientAreaLocationOnScreen() {
            return JSVGComponent.this.getLocationOnScreen();
        }

        public boolean hasFeature(String s) {
            return FEATURES.contains(s);
        }

        public boolean supportExtension(String s) {
            if (JSVGComponent.this.svgUserAgent != null && JSVGComponent.this.svgUserAgent.supportExtension(s)) {
                return true;
            }
            return this.extensions.containsKey(s);
        }

        public void registerExtension(BridgeExtension ext) {
            Iterator i = ext.getImplementedExtensions();
            while (i.hasNext()) {
                this.extensions.put(i.next(), ext);
            }
        }

        public void handleElement(Element elt, Object data) {
            if (JSVGComponent.this.svgUserAgent != null) {
                JSVGComponent.this.svgUserAgent.handleElement(elt, data);
            }
        }

        public ScriptSecurity getScriptSecurity(String scriptType, ParsedURL scriptURL, ParsedURL docURL) {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.getScriptSecurity(scriptType, scriptURL, docURL);
            }
            return new DefaultScriptSecurity(scriptType, scriptURL, docURL);
        }

        public void checkLoadScript(String scriptType, ParsedURL scriptURL, ParsedURL docURL) throws SecurityException {
            if (JSVGComponent.this.svgUserAgent != null) {
                JSVGComponent.this.svgUserAgent.checkLoadScript(scriptType, scriptURL, docURL);
            } else {
                ScriptSecurity s = this.getScriptSecurity(scriptType, scriptURL, docURL);
                if (s != null) {
                    s.checkLoadScript();
                }
            }
        }

        public ExternalResourceSecurity getExternalResourceSecurity(ParsedURL resourceURL, ParsedURL docURL) {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.getExternalResourceSecurity(resourceURL, docURL);
            }
            return new RelaxedExternalResourceSecurity(resourceURL, docURL);
        }

        public void checkLoadExternalResource(ParsedURL resourceURL, ParsedURL docURL) throws SecurityException {
            if (JSVGComponent.this.svgUserAgent != null) {
                JSVGComponent.this.svgUserAgent.checkLoadExternalResource(resourceURL, docURL);
            } else {
                ExternalResourceSecurity s = this.getExternalResourceSecurity(resourceURL, docURL);
                if (s != null) {
                    s.checkLoadExternalResource();
                }
            }
        }

        public SVGDocument getBrokenLinkDocument(Element e, String url, String message) {
            Class<JSVGComponent> cls = JSVGComponent.class;
            URL blURL = cls.getResource("resources/BrokenLink.svg");
            if (blURL == null) {
                throw new BridgeException(JSVGComponent.this.bridgeContext, e, "uri.image.broken", new Object[]{url, message});
            }
            DocumentLoader loader = JSVGComponent.this.bridgeContext.getDocumentLoader();
            SVGDocument doc = null;
            try {
                doc = (SVGDocument)loader.loadDocument(blURL.toString());
                if (doc == null) {
                    return doc;
                }
                DOMImplementation impl = SVGDOMImplementation.getDOMImplementation();
                Element infoE = (doc = (SVGDocument)DOMUtilities.deepCloneDocument((Document)doc, (DOMImplementation)impl)).getElementById("__More_About");
                if (infoE == null) {
                    return doc;
                }
                Element titleE = doc.createElementNS("http://www.w3.org/2000/svg", "title");
                String title = Messages.formatMessage(JSVGComponent.BROKEN_LINK_TITLE, null);
                titleE.appendChild(doc.createTextNode(title));
                Element descE = doc.createElementNS("http://www.w3.org/2000/svg", "desc");
                descE.appendChild(doc.createTextNode(message));
                infoE.insertBefore(descE, infoE.getFirstChild());
                infoE.insertBefore(titleE, descE);
            }
            catch (Exception ex) {
                throw new BridgeException(JSVGComponent.this.bridgeContext, e, ex, "uri.image.broken", new Object[]{url, message});
            }
            return doc;
        }

        public void loadDocument(String url) {
            JSVGComponent.this.loadSVGDocument(url);
        }

        public FontFamilyResolver getFontFamilyResolver() {
            return DefaultFontFamilyResolver.SINGLETON;
        }
    }

    protected static class BridgeUserAgentWrapper
    implements UserAgent {
        protected UserAgent userAgent;

        public BridgeUserAgentWrapper(UserAgent ua) {
            this.userAgent = ua;
        }

        public EventDispatcher getEventDispatcher() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getEventDispatcher();
            }
            class Query
            implements Runnable {
                EventDispatcher result;

                Query() {
                }

                @Override
                public void run() {
                    this.result = BridgeUserAgentWrapper.this.userAgent.getEventDispatcher();
                }
            }
            Query q = new Query();
            this.invokeAndWait(q);
            return q.result;
        }

        public Dimension2D getViewportSize() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getViewportSize();
            }
            class Query
            implements Runnable {
                Dimension2D result;

                Query() {
                }

                @Override
                public void run() {
                    this.result = BridgeUserAgentWrapper.this.userAgent.getViewportSize();
                }
            }
            Query q = new Query();
            this.invokeAndWait(q);
            return q.result;
        }

        public void displayError(final Exception ex) {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.displayError(ex);
            } else {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BridgeUserAgentWrapper.this.userAgent.displayError(ex);
                    }
                });
            }
        }

        public void displayMessage(final String message) {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.displayMessage(message);
            } else {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BridgeUserAgentWrapper.this.userAgent.displayMessage(message);
                    }
                });
            }
        }

        public void showAlert(final String message) {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.showAlert(message);
            } else {
                this.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        BridgeUserAgentWrapper.this.userAgent.showAlert(message);
                    }
                });
            }
        }

        public String showPrompt(final String message) {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.showPrompt(message);
            }
            class Query
            implements Runnable {
                String result;

                Query() {
                }

                @Override
                public void run() {
                    this.result = BridgeUserAgentWrapper.this.userAgent.showPrompt(message);
                }
            }
            Query q = new Query();
            this.invokeAndWait(q);
            return q.result;
        }

        public String showPrompt(final String message, final String defaultValue) {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.showPrompt(message, defaultValue);
            }
            class Query
            implements Runnable {
                String result;

                Query() {
                }

                @Override
                public void run() {
                    this.result = BridgeUserAgentWrapper.this.userAgent.showPrompt(message, defaultValue);
                }
            }
            Query q = new Query();
            this.invokeAndWait(q);
            return q.result;
        }

        public boolean showConfirm(final String message) {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.showConfirm(message);
            }
            class Query
            implements Runnable {
                boolean result;

                Query() {
                }

                @Override
                public void run() {
                    this.result = BridgeUserAgentWrapper.this.userAgent.showConfirm(message);
                }
            }
            Query q = new Query();
            this.invokeAndWait(q);
            return q.result;
        }

        public float getPixelUnitToMillimeter() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getPixelUnitToMillimeter();
            }
            class Query
            implements Runnable {
                float result;

                Query() {
                }

                @Override
                public void run() {
                    this.result = BridgeUserAgentWrapper.this.userAgent.getPixelUnitToMillimeter();
                }
            }
            Query q = new Query();
            this.invokeAndWait(q);
            return q.result;
        }

        public float getPixelToMM() {
            return this.getPixelUnitToMillimeter();
        }

        public String getDefaultFontFamily() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getDefaultFontFamily();
            }
            class Query
            implements Runnable {
                String result;

                Query() {
                }

                @Override
                public void run() {
                    this.result = BridgeUserAgentWrapper.this.userAgent.getDefaultFontFamily();
                }
            }
            Query q = new Query();
            this.invokeAndWait(q);
            return q.result;
        }

        public float getMediumFontSize() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getMediumFontSize();
            }
            class Query
            implements Runnable {
                float result;

                Query() {
                }

                @Override
                public void run() {
                    this.result = BridgeUserAgentWrapper.this.userAgent.getMediumFontSize();
                }
            }
            Query q = new Query();
            this.invokeAndWait(q);
            return q.result;
        }

        public float getLighterFontWeight(float f) {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getLighterFontWeight(f);
            }
            final float ff = f;
            class Query
            implements Runnable {
                float result;

                Query() {
                }

                @Override
                public void run() {
                    this.result = BridgeUserAgentWrapper.this.userAgent.getLighterFontWeight(ff);
                }
            }
            Query q = new Query();
            this.invokeAndWait(q);
            return q.result;
        }

        public float getBolderFontWeight(float f) {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getBolderFontWeight(f);
            }
            final float ff = f;
            class Query
            implements Runnable {
                float result;

                Query() {
                }

                @Override
                public void run() {
                    this.result = BridgeUserAgentWrapper.this.userAgent.getBolderFontWeight(ff);
                }
            }
            Query q = new Query();
            this.invokeAndWait(q);
            return q.result;
        }

        public String getLanguages() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getLanguages();
            }
            class Query
            implements Runnable {
                String result;

                Query() {
                }

                @Override
                public void run() {
                    this.result = BridgeUserAgentWrapper.this.userAgent.getLanguages();
                }
            }
            Query q = new Query();
            this.invokeAndWait(q);
            return q.result;
        }

        public String getUserStyleSheetURI() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getUserStyleSheetURI();
            }
            class Query
            implements Runnable {
                String result;

                Query() {
                }

                @Override
                public void run() {
                    this.result = BridgeUserAgentWrapper.this.userAgent.getUserStyleSheetURI();
                }
            }
            Query q = new Query();
            this.invokeAndWait(q);
            return q.result;
        }

        public void openLink(final SVGAElement elt) {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.openLink(elt);
            } else {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BridgeUserAgentWrapper.this.userAgent.openLink(elt);
                    }
                });
            }
        }

        public void setSVGCursor(final Cursor cursor) {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.setSVGCursor(cursor);
            } else {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BridgeUserAgentWrapper.this.userAgent.setSVGCursor(cursor);
                    }
                });
            }
        }

        public void setTextSelection(final Mark start, final Mark end) {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.setTextSelection(start, end);
            } else {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BridgeUserAgentWrapper.this.userAgent.setTextSelection(start, end);
                    }
                });
            }
        }

        public void deselectAll() {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.deselectAll();
            } else {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BridgeUserAgentWrapper.this.userAgent.deselectAll();
                    }
                });
            }
        }

        public String getXMLParserClassName() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getXMLParserClassName();
            }
            class Query
            implements Runnable {
                String result;

                Query() {
                }

                @Override
                public void run() {
                    this.result = BridgeUserAgentWrapper.this.userAgent.getXMLParserClassName();
                }
            }
            Query q = new Query();
            this.invokeAndWait(q);
            return q.result;
        }

        public boolean isXMLParserValidating() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.isXMLParserValidating();
            }
            class Query
            implements Runnable {
                boolean result;

                Query() {
                }

                @Override
                public void run() {
                    this.result = BridgeUserAgentWrapper.this.userAgent.isXMLParserValidating();
                }
            }
            Query q = new Query();
            this.invokeAndWait(q);
            return q.result;
        }

        public AffineTransform getTransform() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getTransform();
            }
            class Query
            implements Runnable {
                AffineTransform result;

                Query() {
                }

                @Override
                public void run() {
                    this.result = BridgeUserAgentWrapper.this.userAgent.getTransform();
                }
            }
            Query q = new Query();
            this.invokeAndWait(q);
            return q.result;
        }

        public void setTransform(AffineTransform at) {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.setTransform(at);
            } else {
                final AffineTransform affine = at;
                class Query
                implements Runnable {
                    Query() {
                    }

                    @Override
                    public void run() {
                        BridgeUserAgentWrapper.this.userAgent.setTransform(affine);
                    }
                }
                Query q = new Query();
                this.invokeAndWait(q);
            }
        }

        public String getMedia() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getMedia();
            }
            class Query
            implements Runnable {
                String result;

                Query() {
                }

                @Override
                public void run() {
                    this.result = BridgeUserAgentWrapper.this.userAgent.getMedia();
                }
            }
            Query q = new Query();
            this.invokeAndWait(q);
            return q.result;
        }

        public String getAlternateStyleSheet() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getAlternateStyleSheet();
            }
            class Query
            implements Runnable {
                String result;

                Query() {
                }

                @Override
                public void run() {
                    this.result = BridgeUserAgentWrapper.this.userAgent.getAlternateStyleSheet();
                }
            }
            Query q = new Query();
            this.invokeAndWait(q);
            return q.result;
        }

        public Point getClientAreaLocationOnScreen() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getClientAreaLocationOnScreen();
            }
            class Query
            implements Runnable {
                Point result;

                Query() {
                }

                @Override
                public void run() {
                    this.result = BridgeUserAgentWrapper.this.userAgent.getClientAreaLocationOnScreen();
                }
            }
            Query q = new Query();
            this.invokeAndWait(q);
            return q.result;
        }

        public boolean hasFeature(final String s) {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.hasFeature(s);
            }
            class Query
            implements Runnable {
                boolean result;

                Query() {
                }

                @Override
                public void run() {
                    this.result = BridgeUserAgentWrapper.this.userAgent.hasFeature(s);
                }
            }
            Query q = new Query();
            this.invokeAndWait(q);
            return q.result;
        }

        public boolean supportExtension(final String s) {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.supportExtension(s);
            }
            class Query
            implements Runnable {
                boolean result;

                Query() {
                }

                @Override
                public void run() {
                    this.result = BridgeUserAgentWrapper.this.userAgent.supportExtension(s);
                }
            }
            Query q = new Query();
            this.invokeAndWait(q);
            return q.result;
        }

        public void registerExtension(final BridgeExtension ext) {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.registerExtension(ext);
            } else {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BridgeUserAgentWrapper.this.userAgent.registerExtension(ext);
                    }
                });
            }
        }

        public void handleElement(final Element elt, final Object data) {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.handleElement(elt, data);
            } else {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BridgeUserAgentWrapper.this.userAgent.handleElement(elt, data);
                    }
                });
            }
        }

        public ScriptSecurity getScriptSecurity(String scriptType, ParsedURL scriptPURL, ParsedURL docPURL) {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getScriptSecurity(scriptType, scriptPURL, docPURL);
            }
            final String st = scriptType;
            final ParsedURL sPURL = scriptPURL;
            final ParsedURL dPURL = docPURL;
            class Query
            implements Runnable {
                ScriptSecurity result;

                Query() {
                }

                @Override
                public void run() {
                    this.result = BridgeUserAgentWrapper.this.userAgent.getScriptSecurity(st, sPURL, dPURL);
                }
            }
            Query q = new Query();
            this.invokeAndWait(q);
            return q.result;
        }

        public void checkLoadScript(String scriptType, ParsedURL scriptPURL, ParsedURL docPURL) throws SecurityException {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.checkLoadScript(scriptType, scriptPURL, docPURL);
            } else {
                final String st = scriptType;
                final ParsedURL sPURL = scriptPURL;
                final ParsedURL dPURL = docPURL;
                class Query
                implements Runnable {
                    SecurityException se = null;

                    Query() {
                    }

                    @Override
                    public void run() {
                        try {
                            BridgeUserAgentWrapper.this.userAgent.checkLoadScript(st, sPURL, dPURL);
                        }
                        catch (SecurityException se) {
                            this.se = se;
                        }
                    }
                }
                Query q = new Query();
                this.invokeAndWait(q);
                if (q.se != null) {
                    q.se.fillInStackTrace();
                    throw q.se;
                }
            }
        }

        public ExternalResourceSecurity getExternalResourceSecurity(ParsedURL resourcePURL, ParsedURL docPURL) {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getExternalResourceSecurity(resourcePURL, docPURL);
            }
            final ParsedURL rPURL = resourcePURL;
            final ParsedURL dPURL = docPURL;
            class Query
            implements Runnable {
                ExternalResourceSecurity result;

                Query() {
                }

                @Override
                public void run() {
                    this.result = BridgeUserAgentWrapper.this.userAgent.getExternalResourceSecurity(rPURL, dPURL);
                }
            }
            Query q = new Query();
            this.invokeAndWait(q);
            return q.result;
        }

        public void checkLoadExternalResource(ParsedURL resourceURL, ParsedURL docURL) throws SecurityException {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.checkLoadExternalResource(resourceURL, docURL);
            } else {
                final ParsedURL rPURL = resourceURL;
                final ParsedURL dPURL = docURL;
                class Query
                implements Runnable {
                    SecurityException se;

                    Query() {
                    }

                    @Override
                    public void run() {
                        try {
                            BridgeUserAgentWrapper.this.userAgent.checkLoadExternalResource(rPURL, dPURL);
                        }
                        catch (SecurityException se) {
                            this.se = se;
                        }
                    }
                }
                Query q = new Query();
                this.invokeAndWait(q);
                if (q.se != null) {
                    q.se.fillInStackTrace();
                    throw q.se;
                }
            }
        }

        public SVGDocument getBrokenLinkDocument(final Element e, final String url, final String msg) {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getBrokenLinkDocument(e, url, msg);
            }
            class Query
            implements Runnable {
                SVGDocument doc;
                RuntimeException rex = null;

                Query() {
                }

                @Override
                public void run() {
                    try {
                        this.doc = BridgeUserAgentWrapper.this.userAgent.getBrokenLinkDocument(e, url, msg);
                    }
                    catch (RuntimeException re) {
                        this.rex = re;
                    }
                }
            }
            Query q = new Query();
            this.invokeAndWait(q);
            if (q.rex != null) {
                throw q.rex;
            }
            return q.doc;
        }

        protected void invokeAndWait(Runnable r) {
            try {
                EventQueue.invokeAndWait(r);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void loadDocument(String url) {
            this.userAgent.loadDocument(url);
        }

        public FontFamilyResolver getFontFamilyResolver() {
            return this.userAgent.getFontFamilyResolver();
        }
    }

    protected class SVGListener
    extends JGVTComponent.Listener
    implements SVGDocumentLoaderListener,
    GVTTreeBuilderListener,
    SVGLoadEventDispatcherListener,
    UpdateManagerListener {
        protected SVGListener() {
        }

        @Override
        public void documentLoadingStarted(SVGDocumentLoaderEvent e) {
        }

        @Override
        public void documentLoadingCompleted(SVGDocumentLoaderEvent e) {
            if (JSVGComponent.this.nextDocumentLoader != null) {
                JSVGComponent.this.startDocumentLoader();
                return;
            }
            JSVGComponent.this.documentLoader = null;
            if (JSVGComponent.this.afterStopRunnable != null) {
                EventQueue.invokeLater(JSVGComponent.this.afterStopRunnable);
                JSVGComponent.this.afterStopRunnable = null;
                return;
            }
            JSVGComponent.this.setSVGDocument(e.getSVGDocument());
        }

        @Override
        public void documentLoadingCancelled(SVGDocumentLoaderEvent e) {
            if (JSVGComponent.this.nextDocumentLoader != null) {
                JSVGComponent.this.startDocumentLoader();
                return;
            }
            JSVGComponent.this.documentLoader = null;
            if (JSVGComponent.this.afterStopRunnable != null) {
                EventQueue.invokeLater(JSVGComponent.this.afterStopRunnable);
                JSVGComponent.this.afterStopRunnable = null;
                return;
            }
            if (JSVGComponent.this.nextGVTTreeBuilder != null) {
                JSVGComponent.this.startGVTTreeBuilder();
                return;
            }
        }

        @Override
        public void documentLoadingFailed(SVGDocumentLoaderEvent e) {
            if (JSVGComponent.this.nextDocumentLoader != null) {
                JSVGComponent.this.startDocumentLoader();
                return;
            }
            JSVGComponent.this.documentLoader = null;
            JSVGComponent.this.userAgent.displayError(((SVGDocumentLoader)((Object)e.getSource())).getException());
            if (JSVGComponent.this.afterStopRunnable != null) {
                EventQueue.invokeLater(JSVGComponent.this.afterStopRunnable);
                JSVGComponent.this.afterStopRunnable = null;
                return;
            }
            if (JSVGComponent.this.nextGVTTreeBuilder != null) {
                JSVGComponent.this.startGVTTreeBuilder();
                return;
            }
        }

        @Override
        public void gvtBuildStarted(GVTTreeBuilderEvent e) {
            JSVGComponent.this.removeJGVTComponentListener(JSVGComponent.this.jsvgComponentListener);
            JSVGComponent.this.removeComponentListener(JSVGComponent.this.jsvgComponentListener);
        }

        @Override
        public void gvtBuildCompleted(GVTTreeBuilderEvent e) {
            if (JSVGComponent.this.nextGVTTreeBuilder != null) {
                JSVGComponent.this.startGVTTreeBuilder();
                return;
            }
            JSVGComponent.this.loader = null;
            JSVGComponent.this.gvtTreeBuilder = null;
            if (JSVGComponent.this.afterStopRunnable != null) {
                EventQueue.invokeLater(JSVGComponent.this.afterStopRunnable);
                JSVGComponent.this.afterStopRunnable = null;
                return;
            }
            if (JSVGComponent.this.nextDocumentLoader != null) {
                JSVGComponent.this.startDocumentLoader();
                return;
            }
            JSVGComponent.this.gvtRoot = null;
            if (JSVGComponent.this.isDynamicDocument && JSVGComponent.this.eventsEnabled) {
                JSVGComponent.this.startSVGLoadEventDispatcher(e.getGVTRoot());
            } else {
                if (JSVGComponent.this.isInteractiveDocument) {
                    JSVGComponent.this.nextUpdateManager = new UpdateManager(JSVGComponent.this.bridgeContext, e.getGVTRoot(), (Document)JSVGComponent.this.svgDocument);
                }
                JSVGComponent.this.setGraphicsNode(e.getGVTRoot(), false);
                JSVGComponent.this.scheduleGVTRendering();
            }
        }

        @Override
        public void gvtBuildCancelled(GVTTreeBuilderEvent e) {
            if (JSVGComponent.this.nextGVTTreeBuilder != null) {
                JSVGComponent.this.startGVTTreeBuilder();
                return;
            }
            JSVGComponent.this.loader = null;
            JSVGComponent.this.gvtTreeBuilder = null;
            if (JSVGComponent.this.afterStopRunnable != null) {
                EventQueue.invokeLater(JSVGComponent.this.afterStopRunnable);
                JSVGComponent.this.afterStopRunnable = null;
                return;
            }
            if (JSVGComponent.this.nextDocumentLoader != null) {
                JSVGComponent.this.startDocumentLoader();
                return;
            }
            JSVGComponent.this.image = null;
            JSVGComponent.this.repaint();
        }

        @Override
        public void gvtBuildFailed(GVTTreeBuilderEvent e) {
            if (JSVGComponent.this.nextGVTTreeBuilder != null) {
                JSVGComponent.this.startGVTTreeBuilder();
                return;
            }
            JSVGComponent.this.loader = null;
            JSVGComponent.this.gvtTreeBuilder = null;
            if (JSVGComponent.this.afterStopRunnable != null) {
                EventQueue.invokeLater(JSVGComponent.this.afterStopRunnable);
                JSVGComponent.this.afterStopRunnable = null;
                return;
            }
            if (JSVGComponent.this.nextDocumentLoader != null) {
                JSVGComponent.this.startDocumentLoader();
                return;
            }
            GraphicsNode gn = e.getGVTRoot();
            if (gn == null) {
                JSVGComponent.this.image = null;
                JSVGComponent.this.repaint();
            } else {
                JSVGComponent.this.setGraphicsNode(gn, false);
                JSVGComponent.this.computeRenderingTransform();
            }
            JSVGComponent.this.userAgent.displayError(((GVTTreeBuilder)((Object)e.getSource())).getException());
        }

        @Override
        public void svgLoadEventDispatchStarted(SVGLoadEventDispatcherEvent e) {
        }

        @Override
        public void svgLoadEventDispatchCompleted(SVGLoadEventDispatcherEvent e) {
            JSVGComponent.this.nextUpdateManager = JSVGComponent.this.svgLoadEventDispatcher.getUpdateManager();
            JSVGComponent.this.svgLoadEventDispatcher = null;
            if (JSVGComponent.this.afterStopRunnable != null) {
                JSVGComponent.this.nextUpdateManager.interrupt();
                JSVGComponent.this.nextUpdateManager = null;
                EventQueue.invokeLater(JSVGComponent.this.afterStopRunnable);
                JSVGComponent.this.afterStopRunnable = null;
                return;
            }
            if (JSVGComponent.this.nextGVTTreeBuilder != null) {
                JSVGComponent.this.nextUpdateManager.interrupt();
                JSVGComponent.this.nextUpdateManager = null;
                JSVGComponent.this.startGVTTreeBuilder();
                return;
            }
            if (JSVGComponent.this.nextDocumentLoader != null) {
                JSVGComponent.this.nextUpdateManager.interrupt();
                JSVGComponent.this.nextUpdateManager = null;
                JSVGComponent.this.startDocumentLoader();
                return;
            }
            JSVGComponent.this.setGraphicsNode(e.getGVTRoot(), false);
            JSVGComponent.this.scheduleGVTRendering();
        }

        @Override
        public void svgLoadEventDispatchCancelled(SVGLoadEventDispatcherEvent e) {
            JSVGComponent.this.nextUpdateManager = JSVGComponent.this.svgLoadEventDispatcher.getUpdateManager();
            JSVGComponent.this.svgLoadEventDispatcher = null;
            JSVGComponent.this.nextUpdateManager.interrupt();
            JSVGComponent.this.nextUpdateManager = null;
            if (JSVGComponent.this.afterStopRunnable != null) {
                EventQueue.invokeLater(JSVGComponent.this.afterStopRunnable);
                JSVGComponent.this.afterStopRunnable = null;
                return;
            }
            if (JSVGComponent.this.nextGVTTreeBuilder != null) {
                JSVGComponent.this.startGVTTreeBuilder();
                return;
            }
            if (JSVGComponent.this.nextDocumentLoader != null) {
                JSVGComponent.this.startDocumentLoader();
                return;
            }
        }

        @Override
        public void svgLoadEventDispatchFailed(SVGLoadEventDispatcherEvent e) {
            JSVGComponent.this.nextUpdateManager = JSVGComponent.this.svgLoadEventDispatcher.getUpdateManager();
            JSVGComponent.this.svgLoadEventDispatcher = null;
            JSVGComponent.this.nextUpdateManager.interrupt();
            JSVGComponent.this.nextUpdateManager = null;
            if (JSVGComponent.this.afterStopRunnable != null) {
                EventQueue.invokeLater(JSVGComponent.this.afterStopRunnable);
                JSVGComponent.this.afterStopRunnable = null;
                return;
            }
            if (JSVGComponent.this.nextGVTTreeBuilder != null) {
                JSVGComponent.this.startGVTTreeBuilder();
                return;
            }
            if (JSVGComponent.this.nextDocumentLoader != null) {
                JSVGComponent.this.startDocumentLoader();
                return;
            }
            GraphicsNode gn = e.getGVTRoot();
            if (gn == null) {
                JSVGComponent.this.image = null;
                JSVGComponent.this.repaint();
            } else {
                JSVGComponent.this.setGraphicsNode(gn, false);
                JSVGComponent.this.computeRenderingTransform();
            }
            JSVGComponent.this.userAgent.displayError(((SVGLoadEventDispatcher)((Object)e.getSource())).getException());
        }

        @Override
        public void gvtRenderingCompleted(GVTTreeRendererEvent e) {
            super.gvtRenderingCompleted(e);
            if (JSVGComponent.this.afterStopRunnable != null) {
                if (JSVGComponent.this.nextUpdateManager != null) {
                    JSVGComponent.this.nextUpdateManager.interrupt();
                    JSVGComponent.this.nextUpdateManager = null;
                }
                EventQueue.invokeLater(JSVGComponent.this.afterStopRunnable);
                JSVGComponent.this.afterStopRunnable = null;
                return;
            }
            if (JSVGComponent.this.nextGVTTreeBuilder != null) {
                if (JSVGComponent.this.nextUpdateManager != null) {
                    JSVGComponent.this.nextUpdateManager.interrupt();
                    JSVGComponent.this.nextUpdateManager = null;
                }
                JSVGComponent.this.startGVTTreeBuilder();
                return;
            }
            if (JSVGComponent.this.nextDocumentLoader != null) {
                if (JSVGComponent.this.nextUpdateManager != null) {
                    JSVGComponent.this.nextUpdateManager.interrupt();
                    JSVGComponent.this.nextUpdateManager = null;
                }
                JSVGComponent.this.startDocumentLoader();
                return;
            }
            if (JSVGComponent.this.nextUpdateManager != null) {
                JSVGComponent.this.updateManager = JSVGComponent.this.nextUpdateManager;
                JSVGComponent.this.nextUpdateManager = null;
                JSVGComponent.this.updateManager.addUpdateManagerListener((UpdateManagerListener)this);
                JSVGComponent.this.updateManager.manageUpdates(JSVGComponent.this.renderer);
            }
        }

        @Override
        public void gvtRenderingCancelled(GVTTreeRendererEvent e) {
            super.gvtRenderingCancelled(e);
            if (JSVGComponent.this.afterStopRunnable != null) {
                if (JSVGComponent.this.nextUpdateManager != null) {
                    JSVGComponent.this.nextUpdateManager.interrupt();
                    JSVGComponent.this.nextUpdateManager = null;
                }
                EventQueue.invokeLater(JSVGComponent.this.afterStopRunnable);
                JSVGComponent.this.afterStopRunnable = null;
                return;
            }
            if (JSVGComponent.this.nextGVTTreeBuilder != null) {
                if (JSVGComponent.this.nextUpdateManager != null) {
                    JSVGComponent.this.nextUpdateManager.interrupt();
                    JSVGComponent.this.nextUpdateManager = null;
                }
                JSVGComponent.this.startGVTTreeBuilder();
                return;
            }
            if (JSVGComponent.this.nextDocumentLoader != null) {
                if (JSVGComponent.this.nextUpdateManager != null) {
                    JSVGComponent.this.nextUpdateManager.interrupt();
                    JSVGComponent.this.nextUpdateManager = null;
                }
                JSVGComponent.this.startDocumentLoader();
                return;
            }
        }

        @Override
        public void gvtRenderingFailed(GVTTreeRendererEvent e) {
            super.gvtRenderingFailed(e);
            if (JSVGComponent.this.afterStopRunnable != null) {
                if (JSVGComponent.this.nextUpdateManager != null) {
                    JSVGComponent.this.nextUpdateManager.interrupt();
                    JSVGComponent.this.nextUpdateManager = null;
                }
                EventQueue.invokeLater(JSVGComponent.this.afterStopRunnable);
                JSVGComponent.this.afterStopRunnable = null;
                return;
            }
            if (JSVGComponent.this.nextGVTTreeBuilder != null) {
                if (JSVGComponent.this.nextUpdateManager != null) {
                    JSVGComponent.this.nextUpdateManager.interrupt();
                    JSVGComponent.this.nextUpdateManager = null;
                }
                JSVGComponent.this.startGVTTreeBuilder();
                return;
            }
            if (JSVGComponent.this.nextDocumentLoader != null) {
                if (JSVGComponent.this.nextUpdateManager != null) {
                    JSVGComponent.this.nextUpdateManager.interrupt();
                    JSVGComponent.this.nextUpdateManager = null;
                }
                JSVGComponent.this.startDocumentLoader();
                return;
            }
        }

        public void managerStarted(final UpdateManagerEvent e) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JSVGComponent.this.suspendInteractions = false;
                    Object[] dll = JSVGComponent.this.updateManagerListeners.toArray();
                    if (dll.length > 0) {
                        for (int i = 0; i < dll.length; ++i) {
                            ((UpdateManagerListener)dll[i]).managerStarted(e);
                        }
                    }
                }
            });
        }

        public void managerSuspended(final UpdateManagerEvent e) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Object[] dll = JSVGComponent.this.updateManagerListeners.toArray();
                    if (dll.length > 0) {
                        for (int i = 0; i < dll.length; ++i) {
                            ((UpdateManagerListener)dll[i]).managerSuspended(e);
                        }
                    }
                }
            });
        }

        public void managerResumed(final UpdateManagerEvent e) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Object[] dll = JSVGComponent.this.updateManagerListeners.toArray();
                    if (dll.length > 0) {
                        for (int i = 0; i < dll.length; ++i) {
                            ((UpdateManagerListener)dll[i]).managerResumed(e);
                        }
                    }
                }
            });
        }

        public void managerStopped(final UpdateManagerEvent e) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JSVGComponent.this.updateManager = null;
                    Object[] dll = JSVGComponent.this.updateManagerListeners.toArray();
                    if (dll.length > 0) {
                        for (int i = 0; i < dll.length; ++i) {
                            ((UpdateManagerListener)dll[i]).managerStopped(e);
                        }
                    }
                    if (JSVGComponent.this.afterStopRunnable != null) {
                        EventQueue.invokeLater(JSVGComponent.this.afterStopRunnable);
                        JSVGComponent.this.afterStopRunnable = null;
                        return;
                    }
                    if (JSVGComponent.this.nextGVTTreeBuilder != null) {
                        JSVGComponent.this.startGVTTreeBuilder();
                        return;
                    }
                    if (JSVGComponent.this.nextDocumentLoader != null) {
                        JSVGComponent.this.startDocumentLoader();
                        return;
                    }
                }
            });
        }

        public void updateStarted(final UpdateManagerEvent e) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Object[] dll;
                    if (!JSVGComponent.this.doubleBufferedRendering) {
                        JSVGComponent.this.image = e.getImage();
                    }
                    if ((dll = JSVGComponent.this.updateManagerListeners.toArray()).length > 0) {
                        for (int i = 0; i < dll.length; ++i) {
                            ((UpdateManagerListener)dll[i]).updateStarted(e);
                        }
                    }
                }
            });
        }

        public void updateCompleted(final UpdateManagerEvent e) {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        List l;
                        JSVGComponent.this.image = e.getImage();
                        if (e.getClearPaintingTransform()) {
                            JSVGComponent.this.paintingTransform = null;
                        }
                        if ((l = e.getDirtyAreas()) != null) {
                            for (Rectangle r : l) {
                                if (JSVGComponent.this.updateOverlay != null) {
                                    JSVGComponent.this.updateOverlay.addRect(r);
                                    r = JSVGComponent.this.getRenderRect();
                                }
                                if (JSVGComponent.this.doubleBufferedRendering) {
                                    JSVGComponent.this.repaint(r);
                                    continue;
                                }
                                JSVGComponent.this.paintImmediately(r);
                            }
                            if (JSVGComponent.this.updateOverlay != null) {
                                JSVGComponent.this.updateOverlay.endUpdate();
                            }
                        }
                        JSVGComponent.this.suspendInteractions = false;
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Object[] dll = JSVGComponent.this.updateManagerListeners.toArray();
                    if (dll.length > 0) {
                        for (int i = 0; i < dll.length; ++i) {
                            ((UpdateManagerListener)dll[i]).updateCompleted(e);
                        }
                    }
                }
            });
        }

        public void updateFailed(final UpdateManagerEvent e) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Object[] dll = JSVGComponent.this.updateManagerListeners.toArray();
                    if (dll.length > 0) {
                        for (int i = 0; i < dll.length; ++i) {
                            ((UpdateManagerListener)dll[i]).updateFailed(e);
                        }
                    }
                }
            });
        }

        @Override
        protected void dispatchKeyTyped(final KeyEvent e) {
            if (!JSVGComponent.this.isDynamicDocument) {
                super.dispatchKeyTyped(e);
                return;
            }
            if (JSVGComponent.this.updateManager != null && JSVGComponent.this.updateManager.isRunning()) {
                JSVGComponent.this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JSVGComponent.this.eventDispatcher.keyTyped(e);
                    }
                });
            }
        }

        @Override
        protected void dispatchKeyPressed(final KeyEvent e) {
            if (!JSVGComponent.this.isDynamicDocument) {
                super.dispatchKeyPressed(e);
                return;
            }
            if (JSVGComponent.this.updateManager != null && JSVGComponent.this.updateManager.isRunning()) {
                JSVGComponent.this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JSVGComponent.this.eventDispatcher.keyPressed(e);
                    }
                });
            }
        }

        @Override
        protected void dispatchKeyReleased(final KeyEvent e) {
            if (!JSVGComponent.this.isDynamicDocument) {
                super.dispatchKeyReleased(e);
                return;
            }
            if (JSVGComponent.this.updateManager != null && JSVGComponent.this.updateManager.isRunning()) {
                JSVGComponent.this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JSVGComponent.this.eventDispatcher.keyReleased(e);
                    }
                });
            }
        }

        @Override
        protected void dispatchMouseClicked(final MouseEvent e) {
            if (!JSVGComponent.this.isInteractiveDocument) {
                super.dispatchMouseClicked(e);
                return;
            }
            if (JSVGComponent.this.updateManager != null && JSVGComponent.this.updateManager.isRunning()) {
                JSVGComponent.this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JSVGComponent.this.eventDispatcher.mouseClicked(e);
                    }
                });
            }
        }

        @Override
        protected void dispatchMousePressed(final MouseEvent e) {
            if (!JSVGComponent.this.isDynamicDocument) {
                super.dispatchMousePressed(e);
                return;
            }
            if (JSVGComponent.this.updateManager != null && JSVGComponent.this.updateManager.isRunning()) {
                JSVGComponent.this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JSVGComponent.this.eventDispatcher.mousePressed(e);
                    }
                });
            }
        }

        @Override
        protected void dispatchMouseReleased(final MouseEvent e) {
            if (!JSVGComponent.this.isDynamicDocument) {
                super.dispatchMouseReleased(e);
                return;
            }
            if (JSVGComponent.this.updateManager != null && JSVGComponent.this.updateManager.isRunning()) {
                JSVGComponent.this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JSVGComponent.this.eventDispatcher.mouseReleased(e);
                    }
                });
            }
        }

        @Override
        protected void dispatchMouseEntered(final MouseEvent e) {
            if (!JSVGComponent.this.isInteractiveDocument) {
                super.dispatchMouseEntered(e);
                return;
            }
            if (JSVGComponent.this.updateManager != null && JSVGComponent.this.updateManager.isRunning()) {
                JSVGComponent.this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JSVGComponent.this.eventDispatcher.mouseEntered(e);
                    }
                });
            }
        }

        @Override
        protected void dispatchMouseExited(final MouseEvent e) {
            if (!JSVGComponent.this.isInteractiveDocument) {
                super.dispatchMouseExited(e);
                return;
            }
            if (JSVGComponent.this.updateManager != null && JSVGComponent.this.updateManager.isRunning()) {
                JSVGComponent.this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JSVGComponent.this.eventDispatcher.mouseExited(e);
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void dispatchMouseDragged(MouseEvent e) {
            if (!JSVGComponent.this.isDynamicDocument) {
                super.dispatchMouseDragged(e);
                return;
            }
            if (JSVGComponent.this.updateManager != null && JSVGComponent.this.updateManager.isRunning()) {
                class MouseDraggedRunnable
                implements Runnable {
                    MouseEvent event;

                    MouseDraggedRunnable(MouseEvent evt) {
                        this.event = evt;
                    }

                    @Override
                    public void run() {
                        JSVGComponent.this.eventDispatcher.mouseDragged(this.event);
                    }
                }
                RunnableQueue rq = JSVGComponent.this.updateManager.getUpdateRunnableQueue();
                Object object = rq.getIteratorLock();
                synchronized (object) {
                    for (Object next : rq) {
                        if (!(next instanceof MouseDraggedRunnable)) continue;
                        MouseDraggedRunnable mdr = (MouseDraggedRunnable)next;
                        MouseEvent mev = mdr.event;
                        if (mev.getModifiers() == e.getModifiers()) {
                            mdr.event = e;
                        }
                        return;
                    }
                }
                rq.invokeLater((Runnable)new MouseDraggedRunnable(e));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void dispatchMouseMoved(MouseEvent e) {
            if (!JSVGComponent.this.isInteractiveDocument) {
                super.dispatchMouseMoved(e);
                return;
            }
            if (JSVGComponent.this.updateManager != null && JSVGComponent.this.updateManager.isRunning()) {
                class MouseMovedRunnable
                implements Runnable {
                    MouseEvent event;

                    MouseMovedRunnable(MouseEvent evt) {
                        this.event = evt;
                    }

                    @Override
                    public void run() {
                        JSVGComponent.this.eventDispatcher.mouseMoved(this.event);
                    }
                }
                RunnableQueue rq = JSVGComponent.this.updateManager.getUpdateRunnableQueue();
                int i = 0;
                Object object = rq.getIteratorLock();
                synchronized (object) {
                    for (Object next : rq) {
                        if (next instanceof MouseMovedRunnable) {
                            MouseMovedRunnable mmr = (MouseMovedRunnable)next;
                            MouseEvent mev = mmr.event;
                            if (mev.getModifiers() == e.getModifiers()) {
                                mmr.event = e;
                            }
                            return;
                        }
                        ++i;
                    }
                }
                rq.invokeLater((Runnable)new MouseMovedRunnable(e));
            }
        }

        @Override
        protected void dispatchMouseWheelMoved(final MouseWheelEvent e) {
            if (!JSVGComponent.this.isInteractiveDocument) {
                super.dispatchMouseWheelMoved(e);
                return;
            }
            if (JSVGComponent.this.updateManager != null && JSVGComponent.this.updateManager.isRunning()) {
                JSVGComponent.this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JSVGComponent.this.eventDispatcher.mouseWheelMoved(e);
                    }
                });
            }
        }
    }

    protected class JSVGComponentListener
    extends ComponentAdapter
    implements JGVTComponentListener {
        float prevScale = 0.0f;
        float prevTransX = 0.0f;
        float prevTransY = 0.0f;

        protected JSVGComponentListener() {
        }

        @Override
        public void componentResized(ComponentEvent ce) {
            if (JSVGComponent.this.isDynamicDocument && JSVGComponent.this.updateManager != null && JSVGComponent.this.updateManager.isRunning()) {
                JSVGComponent.this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            JSVGComponent.this.updateManager.dispatchSVGResizeEvent();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                });
            }
        }

        @Override
        public void componentTransformChanged(ComponentEvent event) {
            boolean dispatchScroll;
            AffineTransform at = JSVGComponent.this.getRenderingTransform();
            float currScale = (float)Math.sqrt(at.getDeterminant());
            float currTransX = (float)at.getTranslateX();
            float currTransY = (float)at.getTranslateY();
            final boolean dispatchZoom = currScale != this.prevScale;
            boolean bl = dispatchScroll = currTransX != this.prevTransX || currTransY != this.prevTransY;
            if (JSVGComponent.this.isDynamicDocument && JSVGComponent.this.updateManager != null && JSVGComponent.this.updateManager.isRunning()) {
                JSVGComponent.this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (dispatchZoom) {
                                JSVGComponent.this.updateManager.dispatchSVGZoomEvent();
                            }
                            if (dispatchScroll) {
                                JSVGComponent.this.updateManager.dispatchSVGScrollEvent();
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                });
            }
            this.prevScale = currScale;
            this.prevTransX = currTransX;
            this.prevTransY = currTransY;
        }

        public void updateMatrix(AffineTransform at) {
            this.prevScale = (float)Math.sqrt(at.getDeterminant());
            this.prevTransX = (float)at.getTranslateX();
            this.prevTransY = (float)at.getTranslateY();
        }
    }
}

