class CAHW
{
	public var menu : CInGameConfigWrapper;
	public var combatready : bool;
	public var lastsword : int;
	public var cloakslot : EEquipmentSlots;
	public var cloakid : SItemUniqueId;
	public var globalvis : bool;
	default globalvis = true;
	function Init()
	{
		menu = theGame.GetInGameConfigWrapper();
		if ( Enabled() && IsCloakModEquipped()) { SetAllVisible(false); if (!FactsDoesExist('AHW')) FactsAdd('AHW'); }
		theInput.RegisterListener( this, 'OnAHWtoggle', 'AHWtoggle' );
	}
	
	function Enabled() : bool
	{
		return menu.GetVarValue('AHW','ahwen');
	}

	function IsCloakMod(item:SItemUniqueId) : bool
	{
		var id : SItemUniqueId;
		var iname : CName;
		
		iname = thePlayer.inv.GetItemName(item);
		
		if(thePlayer.inv.ItemHasTag(item,'AHW') || StrContains( NameToString(thePlayer.inv.GetItemName(item)), "Cloak" ) || StrContains( NameToString(thePlayer.inv.GetItemName(item)), "Cape" ) || iname == 'Traveler Kontusz' || iname == 'NGP Traveler Kontusz' )
		{
			cloakid = item; 
			cloakslot = GetWitcherPlayer().GetItemSlot(item); 
			return true; 
		}
		return false;
	}
	
	function IsCloakModEquipped() : bool
	{
		var equipped : array<SItemUniqueId>;
		var i : int;
		
		equipped = GetWitcherPlayer().GetEquippedItems();
		for ( i=0; i < equipped.Size() ; i+=1 ) if (IsCloakMod(equipped[i])) return true;
		return false;
	}
	
	function SetSteelVisible(visible:bool)
	{
		var id : SItemUniqueId;
		var sword : CEntity;
		
		if ( thePlayer.inv.GetItemEquippedOnSlot(EES_SteelSword, id) && !thePlayer.IsWeaponHeld('steelsword') )
		{
			sword = thePlayer.inv.GetItemEntityUnsafe(id);
			sword.SetHideInGame(!visible);
		}
	}

	function SetSilverVisible(visible:bool)
	{
		var id : SItemUniqueId;
		var sword : CEntity;
		
		if ( thePlayer.inv.GetItemEquippedOnSlot(EES_SilverSword, id) && !thePlayer.IsWeaponHeld('silversword') )
		{
			sword = thePlayer.inv.GetItemEntityUnsafe(id);
			sword.SetHideInGame(!visible);
		}
	}
	
	function SetSteelScabbardVisible(visible:bool)
	{
		var scabbards : array<SItemUniqueId>;
		var scabbard : CDrawableComponent;
		var i : int;

		scabbards = thePlayer.inv.GetItemsByCategory('steel_scabbards');
		for ( i=0; i < scabbards.Size() ; i+=1 )
		{
			scabbard = (CDrawableComponent)((thePlayer.inv.GetItemEntityUnsafe(scabbards[i])).GetMeshComponent());
			scabbard.SetVisible(visible);
		}
	}
	
	function SetSilverScabbardVisible(visible:bool)
	{
		var scabbards : array<SItemUniqueId>;
		var scabbard : CDrawableComponent;
		var i : int;
		
		scabbards = thePlayer.inv.GetItemsByCategory('silver_scabbards');
		for ( i=0; i < scabbards.Size() ; i+=1 )
		{
			scabbard = (CDrawableComponent)((thePlayer.inv.GetItemEntityUnsafe(scabbards[i])).GetMeshComponent());
			scabbard.SetVisible(visible);
		}
	}
	
	function SetCbowVisible(visible:bool)
	{
		var id : SItemUniqueId;
		var crossbow : CEntity;
		
		if ( thePlayer.inv.GetItemEquippedOnSlot( EES_RangedWeapon, id ) )
		{
			crossbow = thePlayer.inv.GetItemEntityUnsafe(id);
			crossbow.SetHideInGame(!visible);
			
			if (!visible) thePlayer.rangedWeapon.ClearDeployedEntity(true);
		}
	}
	
	function SetAllVisible(visible:bool)
	{	
		globalvis = visible;
		
		SetSteelVisible(visible);
		SetSilverVisible(visible);
		SetSteelScabbardVisible(visible);
		SetSilverScabbardVisible(visible);
		SetCbowVisible(visible);
	}
	
	function Combat(ready:bool,optional sword:int)
	{
		if (combatready != ready || lastsword != sword)
		{
			combatready = ready;
			if (combatready)
			{
				if (menu.GetVarValue('AHW','ahwhidec')) thePlayer.UnequipItem(cloakid);
				if (menu.GetVarValue('AHW','ahwcbow')) thePlayer.AddTimer('AHWDelaySetCbowVisible',0.1,false);
				if (sword==1)
				{
					thePlayer.AddTimer('AHWDelaySetSteelVisible',0.1,false);
					if (menu.GetVarValue('AHW','ahwscab')) thePlayer.AddTimer('AHWDelaySetSteelScabbardVisible',0.1,false);
					if (menu.GetVarValue('AHW','ahwsecond')) 
					{ 
						thePlayer.AddTimer('AHWDelaySetSilverVisible',0.1,false); 
						if (menu.GetVarValue('AHW','ahwscab')) thePlayer.AddTimer('AHWDelaySetSilverScabbardVisible',0.1,false); 
					}
					else 
					{
						thePlayer.AddTimer('AHWDelaySetSilverInvisible',1.5+StringToFloat(menu.GetVarValue('AHW','ahwdelay')),false);
						if (menu.GetVarValue('AHW','ahwscab')) thePlayer.AddTimer('AHWDelaySetSilverScabbardInvisible',1.5+StringToFloat(menu.GetVarValue('AHW','ahwdelay')),false);
					}
				}
				else 
				{
					thePlayer.AddTimer('AHWDelaySetSilverVisible',0.1,false);
					if (menu.GetVarValue('AHW','ahwscab')) thePlayer.AddTimer('AHWDelaySetSilverScabbardVisible',0.1,false);
					if (menu.GetVarValue('AHW','ahwsecond')) 
					{
						thePlayer.AddTimer('AHWDelaySetSteelVisible',0.1,false);
						if (menu.GetVarValue('AHW','ahwscab')) thePlayer.AddTimer('AHWDelaySetSteelScabbardVisible',0.1,false); 
					}	
					else 
					{
						thePlayer.AddTimer('AHWDelaySetSteelInvisible',1.5+StringToFloat(menu.GetVarValue('AHW','ahwdelay')),false);
						if (menu.GetVarValue('AHW','ahwscab')) thePlayer.AddTimer('AHWDelaySetSteelScabbardInvisible',1.5+StringToFloat(menu.GetVarValue('AHW','ahwdelay')),false);
					}
				}
				lastsword = sword;
			}
			else 
			{
				if (menu.GetVarValue('AHW','ahwhidec')) thePlayer.EquipItem(cloakid, cloakslot);
				thePlayer.AddTimer('AHWDelaySetAllInvisible',StringToFloat(menu.GetVarValue('AHW','ahwdelay')),false);
			}
		}
	}
	
	event OnAHWtoggle( action : SInputAction )
	{
		if(IsPressed(action))
		{
			SetAllVisible(!globalvis);
		}
	}
}

exec function steelrune()
{
	var id : SItemUniqueId;
	thePlayer.inv.GetItemEquippedOnSlot(EES_SteelSword, id);
	thePlayer.inv.PlayItemEffect(id, 'rune_blast_loop');
}

