/*
 * Decompiled with CFR 0.152.
 */
package com.chenlb.mmseg4j.analysis;

import com.chenlb.mmseg4j.MMSeg;
import com.chenlb.mmseg4j.Seg;
import com.chenlb.mmseg4j.Word;
import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;

public class MMSegTokenizer
extends Tokenizer {
    private MMSeg mmSeg;
    private CharTermAttribute termAtt;
    private OffsetAttribute offsetAtt;
    private TypeAttribute typeAtt;

    public MMSegTokenizer(Seg seg, Reader input) {
        super(input);
        this.mmSeg = new MMSeg(input, seg);
        this.termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
        this.offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
        this.typeAtt = (TypeAttribute)this.addAttribute(TypeAttribute.class);
    }

    public void reset() throws IOException {
        this.mmSeg.reset(this.input);
    }

    public final boolean incrementToken() throws IOException {
        this.clearAttributes();
        Word word = this.mmSeg.next();
        if (word != null) {
            this.termAtt.copyBuffer(word.getSen(), word.getWordOffset(), word.getLength());
            this.offsetAtt.setOffset(word.getStartOffset(), word.getEndOffset());
            this.typeAtt.setType(word.getType());
            return true;
        }
        this.end();
        return false;
    }
}

