/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;
import org.apache.lucene.util.SorterTemplate;

public final class CollectionUtil {
    private CollectionUtil() {
    }

    private static <T> SorterTemplate getSorter(List<T> list, final Comparator<? super T> comp) {
        if (!(list instanceof RandomAccess)) {
            throw new IllegalArgumentException("CollectionUtil can only sort random access lists in-place.");
        }
        return new ListSorterTemplate<T>(list){

            @Override
            protected int compare(T a, T b) {
                return comp.compare(a, b);
            }
        };
    }

    private static <T extends Comparable<? super T>> SorterTemplate getSorter(List<T> list) {
        if (!(list instanceof RandomAccess)) {
            throw new IllegalArgumentException("CollectionUtil can only sort random access lists in-place.");
        }
        return new ListSorterTemplate<T>((List)list){

            @Override
            protected int compare(T a, T b) {
                return a.compareTo(b);
            }
        };
    }

    private static <T> SorterTemplate getMergeSorter(List<T> list, final Comparator<? super T> comp) {
        if (!(list instanceof RandomAccess)) {
            throw new IllegalArgumentException("CollectionUtil can only sort random access lists in-place.");
        }
        if (list.size() < 1500) {
            return CollectionUtil.getSorter(list, comp);
        }
        return new ListMergeSorterTemplate<T>(list, 0.01f){

            @Override
            protected int compare(T a, T b) {
                return comp.compare(a, b);
            }
        };
    }

    private static <T extends Comparable<? super T>> SorterTemplate getMergeSorter(List<T> list) {
        if (!(list instanceof RandomAccess)) {
            throw new IllegalArgumentException("CollectionUtil can only sort random access lists in-place.");
        }
        if (list.size() < 1500) {
            return CollectionUtil.getSorter(list);
        }
        return new ListMergeSorterTemplate<T>((List)list, 0.01f){

            @Override
            protected int compare(T a, T b) {
                return a.compareTo(b);
            }
        };
    }

    public static <T> void quickSort(List<T> list, Comparator<? super T> comp) {
        int size = list.size();
        if (size <= 1) {
            return;
        }
        CollectionUtil.getSorter(list, comp).quickSort(0, size - 1);
    }

    public static <T extends Comparable<? super T>> void quickSort(List<T> list) {
        int size = list.size();
        if (size <= 1) {
            return;
        }
        CollectionUtil.getSorter(list).quickSort(0, size - 1);
    }

    public static <T> void mergeSort(List<T> list, Comparator<? super T> comp) {
        int size = list.size();
        if (size <= 1) {
            return;
        }
        CollectionUtil.getMergeSorter(list, comp).mergeSort(0, size - 1);
    }

    public static <T extends Comparable<? super T>> void mergeSort(List<T> list) {
        int size = list.size();
        if (size <= 1) {
            return;
        }
        CollectionUtil.getMergeSorter(list).mergeSort(0, size - 1);
    }

    public static <T> void timSort(List<T> list, Comparator<? super T> comp) {
        int size = list.size();
        if (size <= 1) {
            return;
        }
        CollectionUtil.getMergeSorter(list, comp).timSort(0, size - 1);
    }

    public static <T extends Comparable<? super T>> void timSort(List<T> list) {
        int size = list.size();
        if (size <= 1) {
            return;
        }
        CollectionUtil.getMergeSorter(list).timSort(0, size - 1);
    }

    public static <T> void insertionSort(List<T> list, Comparator<? super T> comp) {
        int size = list.size();
        if (size <= 1) {
            return;
        }
        CollectionUtil.getSorter(list, comp).insertionSort(0, size - 1);
    }

    public static <T extends Comparable<? super T>> void insertionSort(List<T> list) {
        int size = list.size();
        if (size <= 1) {
            return;
        }
        CollectionUtil.getSorter(list).insertionSort(0, size - 1);
    }

    public static <T> void binarySort(List<T> list, Comparator<? super T> comp) {
        int size = list.size();
        if (size <= 1) {
            return;
        }
        CollectionUtil.getSorter(list, comp).binarySort(0, size - 1);
    }

    public static <T extends Comparable<? super T>> void binarySort(List<T> list) {
        int size = list.size();
        if (size <= 1) {
            return;
        }
        CollectionUtil.getSorter(list).binarySort(0, size - 1);
    }

    private static abstract class ListMergeSorterTemplate<T>
    extends ListSorterTemplate<T> {
        private final int threshold;
        private final T[] tmp;

        ListMergeSorterTemplate(List<T> list, float overheadRatio) {
            super(list);
            this.threshold = (int)((float)list.size() * overheadRatio);
            Object[] tmpBuf = new Object[this.threshold];
            this.tmp = tmpBuf;
        }

        private void mergeWithExtraMemory(int lo, int pivot, int hi, int len1, int len2) {
            int i;
            for (i = 0; i < len1; ++i) {
                this.tmp[i] = this.list.get(lo + i);
            }
            i = 0;
            int j = pivot;
            int dest = lo;
            while (i < len1 && j < hi) {
                if (this.compare(this.tmp[i], this.list.get(j)) <= 0) {
                    this.list.set(dest++, this.tmp[i++]);
                    continue;
                }
                this.list.set(dest++, this.list.get(j++));
            }
            while (i < len1) {
                this.list.set(dest++, this.tmp[i++]);
            }
            assert (j == dest);
        }

        @Override
        protected void merge(int lo, int pivot, int hi, int len1, int len2) {
            if (len1 <= this.threshold) {
                this.mergeWithExtraMemory(lo, pivot, hi, len1, len2);
            } else {
                super.merge(lo, pivot, hi, len1, len2);
            }
        }
    }

    private static abstract class ListSorterTemplate<T>
    extends SorterTemplate {
        protected final List<T> list;
        private T pivot;

        ListSorterTemplate(List<T> list) {
            this.list = list;
        }

        protected abstract int compare(T var1, T var2);

        @Override
        protected void swap(int i, int j) {
            Collections.swap(this.list, i, j);
        }

        @Override
        protected int compare(int i, int j) {
            return this.compare(this.list.get(i), this.list.get(j));
        }

        @Override
        protected void setPivot(int i) {
            this.pivot = this.list.get(i);
        }

        @Override
        protected int comparePivot(int j) {
            return this.compare(this.pivot, this.list.get(j));
        }
    }
}

