/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.corpus.dependency.CoNll;

import com.hankcs.hanlp.corpus.dependency.CoNll.CoNLLWord;
import com.hankcs.hanlp.corpus.dependency.CoNll.CoNllLine;
import java.util.List;

public class CoNLLSentence {
    public CoNLLWord[] word;

    public CoNLLSentence(List<CoNllLine> lineList) {
        CoNllLine[] lineArray = lineList.toArray(new CoNllLine[0]);
        this.word = new CoNLLWord[lineList.size()];
        int i = 0;
        for (CoNllLine line : lineList) {
            this.word[i++] = new CoNLLWord(line);
        }
        for (CoNLLWord nllWord : this.word) {
            int head = Integer.parseInt(lineArray[nllWord.ID - 1].value[6]) - 1;
            nllWord.HEAD = head != -1 ? this.word[head] : CoNLLWord.ROOT;
        }
    }

    public CoNLLSentence(CoNLLWord[] word) {
        this.word = word;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.word.length * 50);
        for (CoNLLWord word : this.word) {
            sb.append(word);
            sb.append('\n');
        }
        return sb.toString();
    }

    public String[][] getEdgeArray() {
        String[][] edge = new String[this.word.length + 1][this.word.length + 1];
        for (CoNLLWord coNLLWord : this.word) {
            edge[coNLLWord.ID][coNLLWord.HEAD.ID] = coNLLWord.DEPREL;
        }
        return edge;
    }

    public CoNLLWord[] getWordArrayWithRoot() {
        CoNLLWord[] wordArray = new CoNLLWord[this.word.length + 1];
        wordArray[0] = CoNLLWord.ROOT;
        System.arraycopy(this.word, 0, wordArray, 1, this.word.length);
        return wordArray;
    }
}

