/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dictionary.py;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.collection.set.UnEmptyStringSet;
import com.hankcs.hanlp.corpus.dictionary.StringDictionary;
import com.hankcs.hanlp.corpus.io.IOUtil;
import com.hankcs.hanlp.dictionary.py.Head;
import com.hankcs.hanlp.dictionary.py.Pinyin;
import com.hankcs.hanlp.dictionary.py.PinyinDictionary;
import com.hankcs.hanlp.dictionary.py.PinyinUtil;
import com.hankcs.hanlp.dictionary.py.Shengmu;
import com.hankcs.hanlp.dictionary.py.Yunmu;
import com.hankcs.hanlp.utility.Predefine;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class SYTDictionary {
    static Set<String> smSet = new UnEmptyStringSet();
    static Set<String> ymSet = new UnEmptyStringSet();
    static Set<String> ydSet = new UnEmptyStringSet();
    static Map<String, String[]> map = new TreeMap<String, String[]>();

    public static void dumpEnum(String path) {
        SYTDictionary.dumpEnum(smSet, path + "sm.txt");
        SYTDictionary.dumpEnum(ymSet, path + "ym.txt");
        SYTDictionary.dumpEnum(ydSet, path + "yd.txt");
        TreeSet<String> hdSet = new TreeSet<String>();
        for (Pinyin pinyin : PinyinDictionary.pinyins) {
            hdSet.add(pinyin.getHeadString());
        }
        SYTDictionary.dumpEnum(hdSet, path + "head.txt");
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String[]> entry : map.entrySet()) {
            String[] value = entry.getValue();
            Pinyin pinyin = Pinyin.valueOf(entry.getKey());
            sb.append(entry.getKey() + "(" + Shengmu.class.getSimpleName() + "." + value[0] + ", " + Yunmu.class.getSimpleName() + "." + value[1] + ", " + value[2] + ", \"" + value[3] + "\", \"" + entry.getKey().substring(0, entry.getKey().length() - 1) + "\"" + ", " + Head.class.getSimpleName() + "." + pinyin.getHeadString() + ", '" + pinyin.getFirstChar() + "'" + "),\n");
        }
        IOUtil.saveTxt(path + "py.txt", sb.toString());
    }

    private static boolean dumpEnum(Set<String> set, String path) {
        StringBuilder sb = new StringBuilder();
        for (String s : set) {
            sb.append(s);
            sb.append(",\n");
        }
        return IOUtil.saveTxt(path, sb.toString());
    }

    static {
        StringDictionary dictionary = new StringDictionary();
        if (dictionary.load(HanLP.Config.SYTDictionaryPath)) {
            Predefine.logger.info("\u8f7d\u5165\u58f0\u6bcd\u97f5\u6bcd\u97f3\u8c03\u8bcd\u5178" + HanLP.Config.SYTDictionaryPath + "\u6210\u529f");
            for (Map.Entry entry : dictionary.entrySet()) {
                String[] args = ((String)entry.getValue()).split(",");
                if (args[0].length() == 0) {
                    args[0] = "none";
                }
                smSet.add(args[0]);
                ymSet.add(args[1]);
                ydSet.add(args[2]);
                String[] valueArray = new String[4];
                System.arraycopy(args, 0, valueArray, 0, args.length);
                valueArray[3] = PinyinUtil.convertToneNumber2ToneMark(entry.getKey());
                map.put(entry.getKey(), valueArray);
            }
        } else {
            Predefine.logger.warning("\u8f7d\u5165\u58f0\u6bcd\u97f5\u6bcd\u97f3\u8c03\u8bcd\u5178" + HanLP.Config.SYTDictionaryPath + "\u5931\u8d25");
        }
    }
}

