/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.LabelFactory;
import edu.stanford.nlp.trees.CopulaHeadFinder;
import edu.stanford.nlp.trees.DateTreeTransformer;
import edu.stanford.nlp.trees.DependencyTreeTransformer;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.MemoryTreebank;
import edu.stanford.nlp.trees.PennTreeReader;
import edu.stanford.nlp.trees.QPTreeTransformer;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.trees.tregex.TregexPattern;
import edu.stanford.nlp.trees.tregex.tsurgeon.Tsurgeon;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonPattern;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.StringUtils;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class CoordinationTransformer
implements TreeTransformer {
    private static final boolean VERBOSE = System.getProperty("CoordinationTransformer", null) != null;
    private final TreeTransformer tn = new DependencyTreeTransformer();
    private final TreeTransformer qp = new QPTreeTransformer();
    private final TreeTransformer dates = new DateTreeTransformer();
    private final HeadFinder headFinder;
    private static TregexPattern findFlatConjpTregex = TregexPattern.compile("/^(S|PP|VP)/ < (/^(S|PP|VP)/ $++ (CC=start $+ (RB|ADVP $+ /^(S|PP|VP)/) [ (< and $+ (RB=end < yet)) |   (< and $+ (RB=end < so)) |   (< and $+ (ADVP=end < (RB|IN < so))) ] ))");
    private static TsurgeonPattern addConjpTsurgeon = Tsurgeon.parseOperation("createSubtree CONJP start end");
    private static TregexPattern moveRBTregex = TregexPattern.compile("/^S|PP|VP/ < (/^(S|PP|VP)/ $++ (/^([,]|CC|CONJP)$/ $+ (RB=adv $+ /^(S|PP|VP)/=dest [ < not | < then ] ))) ");
    private static TsurgeonPattern moveRBTsurgeon = Tsurgeon.parseOperation("move adv >0 dest");
    private static TregexPattern flattenSQTregex = TregexPattern.compile("SBARQ < ((WHNP=what < WP) $+ (SQ=sq < (/^VB/=verb < /^(?i:am|is|are|r|be|being|'s|'re|'m|was|were|been|s|ai|m|art|ar|wase|seem|seems|seemed|seeming|appear|appears|appeared|stay|stays|stayed|remain|remains|remained|resemble|resembles|resembled|resembling|become|becomes|became|becoming)$/)  !< (/^VB/ < !/^(?i:am|is|are|r|be|being|'s|'re|'m|was|were|been|s|ai|m|art|ar|wase|seem|seems|seemed|seeming|appear|appears|appeared|stay|stays|stayed|remain|remains|remained|resemble|resembles|resembled|resembling|become|becomes|became|becoming)$/)  !< (/^V/ < /^VB/ < !/^(?i:am|is|are|r|be|being|'s|'re|'m|was|were|been|s|ai|m|art|ar|wase|seem|seems|seemed|seeming|appear|appears|appeared|stay|stays|stayed|remain|remains|remained|resemble|resembles|resembled|resembling|become|becomes|became|becoming)$/)  !< (PP $- =verb)  !<, (/^VB/ < /^(?i:am|is|are|r|be|being|'s|'re|'m|was|were|been|s|ai|m|art|ar|wase|seem|seems|seemed|seeming|appear|appears|appeared|stay|stays|stayed|remain|remains|remained|resemble|resembles|resembled|resembling|become|becomes|became|becoming)$/ $+ (NP < (EX < there)))))");
    private static TsurgeonPattern flattenSQTsurgeon = Tsurgeon.parseOperation("excise sq sq");
    private static TregexPattern removeXOverXTregex = TregexPattern.compile("__=repeat <: (~repeat < __)");
    private static TsurgeonPattern removeXOverXTsurgeon = Tsurgeon.parseOperation("excise repeat repeat");
    private static final TregexPattern[][] matchPatterns = new TregexPattern[][]{{TregexPattern.compile("/^UCP/=ucp <, /^JJ|ADJP/"), TregexPattern.compile("/^UCP/=ucp <, (DT $+ /^JJ|ADJP/)")}, {TregexPattern.compile("/^UCP/=ucp <, /^N/"), TregexPattern.compile("/^UCP/=ucp <, (DT $+ /^N/)")}};
    private static final TsurgeonPattern[] operations = new TsurgeonPattern[]{Tsurgeon.parseOperation("relabel ucp /^UCP(.*)$/ADJP$1/"), Tsurgeon.parseOperation("relabel ucp /^UCP(.*)$/NP$1/")};

    public CoordinationTransformer(HeadFinder hf) {
        this.headFinder = hf;
    }

    @Override
    public Tree transformTree(Tree t) {
        if (VERBOSE) {
            System.err.println("Input to CoordinationTransformer: " + t);
        }
        Tree tx = this.tn.transformTree(t);
        if (VERBOSE) {
            System.err.println("After DependencyTreeTransformer:  " + tx);
        }
        if (tx == null) {
            return tx;
        }
        Tree tt = CoordinationTransformer.UCPtransform(tx);
        if (VERBOSE) {
            System.err.println("After UCPTransformer:             " + tt);
        }
        Tree ttt = CoordinationTransformer.CCtransform(tt);
        if (VERBOSE) {
            System.err.println("After CCTransformer:              " + ttt);
        }
        Tree tttt = this.qp.transformTree(ttt);
        if (VERBOSE) {
            System.err.println("After QPTreeTransformer:          " + tttt);
        }
        Tree flatSQ = this.SQflatten(tttt);
        if (VERBOSE) {
            System.err.println("After SQ flattening:              " + flatSQ);
        }
        Tree fixedDates = this.dates.transformTree(flatSQ);
        if (VERBOSE) {
            System.err.println("After DateTreeTransformer:        " + fixedDates);
        }
        Tree removedXX = CoordinationTransformer.removeXOverX(fixedDates);
        if (VERBOSE) {
            System.err.println("After removeXoverX:               " + removedXX);
        }
        Tree conjp = this.combineConjp(removedXX);
        if (VERBOSE) {
            System.err.println("After combineConjp:               " + conjp);
        }
        Tree movedRB = this.moveRB(conjp);
        if (VERBOSE) {
            System.err.println("After moveRB:                     " + movedRB);
        }
        return movedRB;
    }

    public Tree combineConjp(Tree t) {
        if (t == null) {
            return null;
        }
        return Tsurgeon.processPattern(findFlatConjpTregex, addConjpTsurgeon, t);
    }

    public Tree moveRB(Tree t) {
        if (t == null) {
            return null;
        }
        return Tsurgeon.processPattern(moveRBTregex, moveRBTsurgeon, t);
    }

    public Tree SQflatten(Tree t) {
        if (this.headFinder != null && this.headFinder instanceof CopulaHeadFinder && ((CopulaHeadFinder)((Object)this.headFinder)).makesCopulaHead()) {
            return t;
        }
        if (t == null) {
            return null;
        }
        return Tsurgeon.processPattern(flattenSQTregex, flattenSQTsurgeon, t);
    }

    public static Tree removeXOverX(Tree t) {
        return Tsurgeon.processPattern(removeXOverXTregex, removeXOverXTsurgeon, t);
    }

    public static Tree UCPtransform(Tree t) {
        if (t == null) {
            return null;
        }
        Tree firstChild = t.firstChild();
        if (firstChild != null) {
            ArrayList<Pair<TregexPattern, TsurgeonPattern>> ops = Generics.newArrayList();
            for (int i = 0; i < operations.length; ++i) {
                for (TregexPattern pattern : matchPatterns[i]) {
                    ops.add(Generics.newPair(pattern, operations[i]));
                }
            }
            return Tsurgeon.processPatternsOnTree(ops, t);
        }
        return t;
    }

    public static Tree CCtransform(Tree t) {
        boolean notDone = true;
        while (notDone) {
            Tree cc = CoordinationTransformer.findCCparent(t, t);
            if (cc != null) {
                t = cc;
                continue;
            }
            notDone = false;
        }
        return t;
    }

    private static String getHeadTag(Tree t) {
        if (t.value().startsWith("NN")) {
            return "NP";
        }
        if (t.value().startsWith("JJ")) {
            return "ADJP";
        }
        return "NP";
    }

    private static Tree transformCC(Tree t, int ccIndex) {
        if (VERBOSE) {
            System.err.println("transformCC in:  " + t);
        }
        TreeFactory tf = t.treeFactory();
        LabelFactory lf = t.label().labelFactory();
        Tree[] ccSiblings = t.children();
        ArrayList<Integer> ccPositions = new ArrayList<Integer>();
        for (int i = ccIndex + 1; i < ccSiblings.length; ++i) {
            if (!ccSiblings[i].value().startsWith("CC") || i >= ccSiblings.length - 1) continue;
            ccPositions.add(i);
        }
        String beforeSibling = ccSiblings[ccIndex - 1].value();
        if (!(ccIndex != 1 || !beforeSibling.equals("DT") && !beforeSibling.equals("JJ") && !beforeSibling.equals("RB") && ccSiblings[ccIndex + 1].value().equals("DT") || beforeSibling.startsWith("NP") || beforeSibling.equals("ADJP") || beforeSibling.equals("NNS"))) {
            int i;
            String leftHead = CoordinationTransformer.getHeadTag(ccSiblings[ccIndex - 1]);
            Tree left = tf.newTreeNode(lf.newLabel(leftHead), null);
            for (i = 0; i < ccIndex + 2; ++i) {
                left.addChild(ccSiblings[i]);
            }
            if (VERBOSE) {
                System.out.println("print left tree");
                left.pennPrint();
                System.out.println();
            }
            for (i = 0; i < ccIndex + 2; ++i) {
                t.removeChild(0);
            }
            if (VERBOSE && t.numChildren() == 0) {
                System.out.println("Youch! No t children");
            }
            if (!ccPositions.isEmpty()) {
                boolean comma = false;
                int index = (Integer)ccPositions.get(0);
                if (VERBOSE) {
                    System.err.println("more CC index " + index);
                }
                if (ccSiblings[index - 1].value().equals(",")) {
                    --index;
                    comma = true;
                }
                if (VERBOSE) {
                    System.err.println("more CC index " + index);
                }
                String head = CoordinationTransformer.getHeadTag(ccSiblings[index - 1]);
                if (ccIndex + 2 < index) {
                    Tree tree = tf.newTreeNode(lf.newLabel(head), null);
                    tree.addChild(0, left);
                    int k = 1;
                    for (int j = ccIndex + 2; j < index; ++j) {
                        if (VERBOSE) {
                            ccSiblings[j].pennPrint();
                        }
                        t.removeChild(0);
                        tree.addChild(k, ccSiblings[j]);
                        ++k;
                    }
                    if (VERBOSE) {
                        System.out.println("print t");
                        t.pennPrint();
                        System.out.println("print tree");
                        tree.pennPrint();
                        System.out.println();
                    }
                    t.addChild(0, tree);
                } else {
                    t.addChild(0, left);
                }
                Tree rightTree = tf.newTreeNode(lf.newLabel("NP"), null);
                int start = 2;
                if (comma) {
                    ++start;
                }
                while (start < t.numChildren()) {
                    Tree sib = t.getChild(start);
                    t.removeChild(start);
                    rightTree.addChild(sib);
                }
                t.addChild(rightTree);
            } else {
                t.addChild(0, left);
            }
        } else if (ccIndex == 2 && ccSiblings[0].value().startsWith("DT") && !ccSiblings[ccIndex - 1].value().equals("NNS") && (ccSiblings.length == 5 || !ccPositions.isEmpty() && (Integer)ccPositions.get(0) == 5)) {
            int i;
            String head = CoordinationTransformer.getHeadTag(ccSiblings[ccIndex - 1]);
            Tree child = tf.newTreeNode(lf.newLabel(head), null);
            for (i = 1; i < ccIndex + 2; ++i) {
                child.addChild(ccSiblings[i]);
            }
            if (VERBOSE && child.numChildren() == 0) {
                System.out.println("Youch! No child children");
            }
            for (i = 1; i < ccIndex + 2; ++i) {
                t.removeChild(1);
            }
            t.addChild(1, child);
        } else if (ccIndex > 2 && ccSiblings[ccIndex - 2].value().equals(",") && !ccSiblings[ccIndex - 1].value().equals("NNS")) {
            int i;
            String head = CoordinationTransformer.getHeadTag(ccSiblings[ccIndex - 1]);
            Tree child = tf.newTreeNode(lf.newLabel(head), null);
            for (i = ccIndex - 3; i < ccIndex + 2; ++i) {
                child.addChild(ccSiblings[i]);
            }
            if (VERBOSE && child.numChildren() == 0) {
                System.out.println("Youch! No child children");
            }
            for (i = ccIndex - 4; i > 0 && ccSiblings[i].value().equals(","); i -= 2) {
                child.addChild(0, ccSiblings[i]);
                child.addChild(0, ccSiblings[i - 1]);
            }
            if (i < 0) {
                i = -1;
            }
            for (int j = i + 1; j < ccIndex + 2; ++j) {
                t.removeChild(i + 1);
            }
            t.addChild(i + 1, child);
        } else {
            int i;
            boolean commaLeft = false;
            boolean commaRight = false;
            boolean preconj = false;
            int indexBegin = 0;
            Tree conjT = tf.newTreeNode(lf.newLabel("CC"), null);
            String leftHead = CoordinationTransformer.getHeadTag(ccSiblings[ccIndex - 1]);
            Tree left = tf.newTreeNode(lf.newLabel(leftHead), null);
            Tree first = ccSiblings[0];
            String leaf = first.firstChild().value().toLowerCase();
            if (leaf.equals("either") || leaf.equals("neither") || leaf.equals("both")) {
                preconj = true;
                indexBegin = 1;
                conjT.addChild(first.firstChild());
            }
            for (int i2 = indexBegin; i2 < ccIndex - 1; ++i2) {
                left.addChild(ccSiblings[i2]);
            }
            if (ccSiblings[ccIndex - 1].value().equals(",")) {
                commaLeft = true;
            } else {
                left.addChild(ccSiblings[ccIndex - 1]);
            }
            Tree cc = ccSiblings[ccIndex];
            int nextCC = ccPositions.isEmpty() ? ccSiblings.length : (Integer)ccPositions.get(0);
            String rightHead = CoordinationTransformer.getHeadTag(ccSiblings[nextCC - 1]);
            Tree right = tf.newTreeNode(lf.newLabel(rightHead), null);
            for (i = ccIndex + 1; i < nextCC - 1; ++i) {
                right.addChild(ccSiblings[i]);
            }
            if (ccSiblings[nextCC - 1].value().equals(",")) {
                commaRight = true;
            } else {
                right.addChild(ccSiblings[nextCC - 1]);
            }
            if (VERBOSE) {
                if (left.numChildren() == 0) {
                    System.out.println("Youch! No left children");
                }
                if (right.numChildren() == 0) {
                    System.out.println("Youch! No right children");
                }
            }
            for (i = 0; i < nextCC; ++i) {
                t.removeChild(0);
            }
            if (!ccPositions.isEmpty()) {
                Tree tree = tf.newTreeNode(lf.newLabel("NP"), null);
                if (preconj) {
                    tree.addChild(conjT);
                }
                if (left.numChildren() > 0) {
                    tree.addChild(left);
                }
                if (commaLeft) {
                    tree.addChild(ccSiblings[ccIndex - 1]);
                }
                tree.addChild(cc);
                if (right.numChildren() > 0) {
                    tree.addChild(right);
                }
                if (commaRight) {
                    t.addChild(0, ccSiblings[nextCC - 1]);
                }
                t.addChild(0, tree);
            } else {
                if (preconj) {
                    t.addChild(conjT);
                }
                if (left.numChildren() > 0) {
                    t.addChild(left);
                }
                if (commaLeft) {
                    t.addChild(ccSiblings[ccIndex - 1]);
                }
                t.addChild(cc);
                if (right.numChildren() > 0) {
                    t.addChild(right);
                }
                if (commaRight) {
                    t.addChild(ccSiblings[nextCC - 1]);
                }
            }
        }
        if (VERBOSE) {
            System.err.println("transformCC out: " + t);
        }
        return t;
    }

    private static boolean notNP(List<Tree> children, int ccIndex) {
        int sz = children.size();
        for (int i = ccIndex; i < sz; ++i) {
            if (!children.get(i).value().startsWith("NP")) continue;
            return false;
        }
        return true;
    }

    private static Tree findCCparent(Tree t, Tree root) {
        if (t.isPreTerminal()) {
            Tree parent;
            if (t.value().startsWith("CC") && (parent = t.parent(root)).value().startsWith("NP")) {
                List<Tree> children = parent.getChildrenAsList();
                int ccIndex = children.indexOf(t);
                if (children.size() > ccIndex + 2 && CoordinationTransformer.notNP(children, ccIndex) && ccIndex != 0 && (ccIndex == children.size() - 1 || !children.get(ccIndex + 1).value().startsWith("CC"))) {
                    CoordinationTransformer.transformCC(parent, ccIndex);
                    if (VERBOSE) {
                        System.err.println("After transformCC:             " + root);
                    }
                    return root;
                }
            }
        } else {
            for (Tree child : t.getChildrenAsList()) {
                Tree cur = CoordinationTransformer.findCCparent(child, root);
                if (cur == null) continue;
                return cur;
            }
        }
        return null;
    }

    public static void main(String[] args) {
        CoordinationTransformer transformer = new CoordinationTransformer(null);
        MemoryTreebank tb = new MemoryTreebank();
        Properties props = StringUtils.argsToProperties(args);
        String treeFileName = props.getProperty("treeFile");
        if (treeFileName != null) {
            try {
                Tree t;
                PennTreeReader tr = new PennTreeReader(new BufferedReader(new InputStreamReader(new FileInputStream(treeFileName))), new LabeledScoredTreeFactory());
                while ((t = tr.readTree()) != null) {
                    ((AbstractCollection)tb).add(t);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("File problem: " + e);
            }
        }
        for (Tree t : tb) {
            System.out.println("Original tree");
            t.pennPrint();
            System.out.println();
            System.out.println("Tree transformed");
            Tree tree = transformer.transformTree(t);
            tree.pennPrint();
            System.out.println();
            System.out.println("----------------------------");
        }
    }
}

