/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex.tsurgeon;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.LabelFactory;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonPattern;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonRuntimeException;
import edu.stanford.nlp.util.Generics;
import java.util.ArrayList;

public class CreateSubtreeNode
extends TsurgeonPattern {
    private final String newLabel;

    public CreateSubtreeNode(TsurgeonPattern start, String newLabel) {
        super("combineSubtrees", new TsurgeonPattern[]{start});
        this.newLabel = newLabel;
    }

    public CreateSubtreeNode(TsurgeonPattern start, TsurgeonPattern end, String newLabel) {
        super("combineSubtrees", new TsurgeonPattern[]{start, end});
        this.newLabel = newLabel;
    }

    @Override
    public Tree evaluate(Tree t, TregexMatcher tm) {
        Label label;
        Tree startChild = this.children[0].evaluate(t, tm);
        Tree endChild = this.children.length == 2 ? this.children[1].evaluate(t, tm) : startChild;
        Tree parent = startChild.parent(t);
        if (parent != endChild.parent(t)) {
            throw new TsurgeonRuntimeException("Parents did not match for trees when applied to " + this);
        }
        LabelFactory lf = parent.labelFactory();
        if (lf == null) {
            lf = t.labelFactory();
        }
        if (lf == null) {
            label = new CoreLabel();
            label.setValue(this.newLabel);
        } else {
            label = lf.newLabel(this.newLabel);
        }
        ArrayList<Tree> children = Generics.newArrayList();
        ArrayList<Tree> innerChildren = Generics.newArrayList();
        boolean insideSpan = false;
        for (Tree child : parent.children()) {
            if (child == startChild || child == endChild) {
                if (!insideSpan && startChild != endChild) {
                    insideSpan = true;
                    innerChildren.add(child);
                    continue;
                }
                insideSpan = false;
                innerChildren.add(child);
                Tree newNode = t.treeFactory().newTreeNode(label, innerChildren);
                children.add(newNode);
                continue;
            }
            if (insideSpan) {
                innerChildren.add(child);
                continue;
            }
            children.add(child);
        }
        parent.setChildren(children);
        return t;
    }
}

