//---------------------------------------------------------------------------------------
//  EDAOMTagProcessor.h created by erik
//  @(#)$Id: EDAOMTagProcessor.h,v 2.4 2003-05-26 19:35:50 erik Exp $
//
//  Copyright (c) 2002 by Erik Doernenburg. All rights reserved.
//
//  Permission to use, copy, modify and distribute this software and its documentation
//  is hereby granted, provided that both the copyright notice and this permission
//  notice appear in all copies of the software, derivative works or modified versions,
//  and any portions thereof, and that both notices appear in supporting documentation,
//  and that credit is given to Erik Doernenburg in all documents and publicity
//  pertaining to direct or indirect use of this code or its derivatives.
//
//  THIS IS EXPERIMENTAL SOFTWARE AND IT IS KNOWN TO HAVE BUGS, SOME OF WHICH MAY HAVE
//  SERIOUS CONSEQUENCES. THE COPYRIGHT HOLDER ALLOWS FREE USE OF THIS SOFTWARE IN ITS
//  "AS IS" CONDITION. THE COPYRIGHT HOLDER DISCLAIMS ANY LIABILITY OF ANY KIND FOR ANY
//  DAMAGES WHATSOEVER RESULTING DIRECTLY OR INDIRECTLY FROM THE USE OF THIS SOFTWARE
//  OR OF ANY DERIVATIVE WORK.
//---------------------------------------------------------------------------------------

#import "EDMLTagProcessorProtocol.h"

@class EDMLParser;


struct _EDATPFlags
{
    unsigned 		ignoresUnknownNamespaces : 1;
    unsigned		ignoresUnknownTags : 1;
    unsigned		ignoresUnknownAttributes : 1;
    unsigned		acceptsUnknownAttributes : 1;
    unsigned		textRespondsToSetText : 1;
    unsigned		spaceRespondsToSetText : 1;
    unsigned		spaceIgnoresString : 1;
};


@interface EDAOMTagProcessor : NSObject < EDMLTagProcessor >
{
    struct _EDATPFlags	flags;							/*" All instance variables are private. "*/	
    NSDictionary		*tagDefinitions;				/*" "*/
    NSDictionary		*textObjectDefinition;			/*" "*/
    NSDictionary		*spaceObjectDefinition;			/*" "*/
    NSDictionary		*documentObjectDefinition;		/*" "*/
    NSSet				*rootElementClasses;			/*" "*/
}

/*" Creating AOM tag processors "*/
- (id)initWithTagDefinitions:(NSDictionary *)someTagDefinitions;

/*" Configuring the tag processor "*/
- (void)setIgnoresUnknownNamespaces:(BOOL)flag;
- (BOOL)ignoresUnknownNamespaces;

- (void)setIgnoresUnknownTags:(BOOL)flag;
- (BOOL)ignoresUnknownTags;

- (void)setIgnoresUnknownAttributes:(BOOL)flag;
- (BOOL)ignoresUnknownAttributes;

- (void)setAcceptsUnknownAttributes:(BOOL)flag;
- (BOOL)acceptsUnknownAttributes;

@end


// convenience method on EDMLParser to initialise it with an AOM processor

@interface EDMLParser(AOMProcessorFactory)
+ (id)parserWithTagDefinitions:(NSDictionary *)someTagDefinitions;
@end


/*" Method to be implemented by the document class for the object model generated by the EDAOMTagProcessor. See class description of that class for more information. "*/

@protocol EDAOMDocument
- (void)setRootElement:(id)rootElement;
@end


/*" Method to be implemented by all element classes for the object model generated by the EDAOMTagProcessor. See class description of that class for more information. "*/

@protocol EDAOMElement
- (void)takeValue:(id)value forAttribute:(NSString *)attribute;
@end


/*" Method to be implemented by all container element classes for the object model generated by the EDAOMTagProcessor. See class description of that class for more information. "*/

@protocol EDAOMContainerElement <EDAOMElement>
- (void)setContainedElements:(NSArray *)elements;
@end


/*" Method to be implemented by text/space classes for the object model generated by the EDAOMTagProcessor. See class description of that class for more information. "*/

@protocol EDAOMText
- (void)setText:(NSString *)text;
@end

