local config = require("config")

print("[refugeesMod] refugeesMod v1.0 loaded!!\n")
print("[refugeesMod] Mod created by YinjiD")
print("[refugeesMod] https://next.nexusmods.com/profile/YinjiD/about-me")

alreadyTicking = false

function initializeConfigFile()
    ExecuteWithDelay(60000, function ()
        local RTSMultiEngineCPP = FindFirstOf("RTSMultiEngineCPP")
        if not RTSMultiEngineCPP:IsValid() then
            print("[refugeesMod] Couldn't get RTSMultiEngineCPP instance.\n")
            return
        end
        local currentDaysTotal = RTSMultiEngineCPP:getDaysTotal()

        if currentDaysTotal <= 5 then
            print(string.format("currentDaysTotal = %s", currentDaysTotal))
            print("[refugeesMod] New game detected, initializing config file.")
            updateConfigFile("registered_keybind_y", 0)
            updateConfigFile("registered_keybind_n", 0)
            updateConfigFile("refugees_popup_message_1", 1)
            updateConfigFile("refugees_popup_message_2", 1)
            updateConfigFile("refugees_popup_message_3", 1)
            updateConfigFile("refugees_popup_message_4", 1)
            updateConfigFile("spawn_refugees", 0)
            updateConfigFile("refugees_spawned_popup_message", 0)
            updateConfigFile("refugees_region_spawn", 0)
            updateConfigFile("refugees_spawn_current_chance", 25)
            updateConfigFile("refugees_spawned_year", 0)
            updateConfigFile("current_checked_year", 0)
            updateConfigFile("refugees_popup_message_1_day", 0)
            updateConfigFile("refugees_popup_message_2_day", 0)
            updateConfigFile("refugees_popup_message_3_day", 0)
            updateConfigFile("refugees_spawned_popup_message_day", 0)
            updateConfigFile("refugees_spawned", 0)
        end
    end)
end

function updateConfigFile(varName, varValue)
    local function deepen(str, r)
      return (" "):rep(r) .. str
    end

    local function basicSerial(value, depth) -- depth only used internally
      depth = depth or 0
      if type(value) == "table" then
        local s = deepen("{\n", depth)
        for k, v in pairs(value) do
          if type(k) == "table" or type(k) == "function" then
            error("Cannot serialize table or function reference as key.", depth / 2 + 2)
          end
          s = s .. deepen(string.format("%s = %s,\n",  basicSerial(k, 0), basicSerial(v, depth + 2)), depth + 2)
        end
        return s .. deepen("}", depth)
      elseif type(value) == "string" then
        return value
      elseif type(value) == "function" then
        error("Cannot serialize type: function", depth / 2 + 2)
      end
      return tostring(value)
    end

    local function basicUnserial(text)
      return load("return " .. text)() -- really lazy way, but works. Be warned of potential code injection with this though.
    end

    local file = io.open("Mods/refugeesMod/scripts/config.lua", "w")

    config[varName] = varValue
    file:write(string.format("local _yd_mod_config = " .. basicSerial(config) .. "\nreturn _yd_mod_config"))
    file:close()
end


function returnMainPlayerPawn()
    local RTSMultiEngineCPP = FindFirstOf("RTSMultiEngineCPP")
    if not RTSMultiEngineCPP:IsValid() then
        print("[randomBattles] Couldn't get RTSMultiEngineCPP instance.\n")
        return 0
    end

    local mainPlayerPawn = 0
    local pawns = RTSMultiEngineCPP.pawns
    for i=1, #pawns do
        local pawn = pawns[i]
        if pawn.isMainPlayer == true then
            mainPlayerPawn = pawn
        end
    end

    return mainPlayerPawn
end

function checkCurrentYear(mainPlayerPawn)
    local yearsSurvived = mainPlayerPawn:getNumYearsSurvived()
    if yearsSurvived < config.grace_years then
        return false
    end
    if config.current_checked_year < yearsSurvived then
        return true
    else
        return false
    end
end

function checkIfToSpawnRefugees(mainPlayerPawn)
    local spawnChance = config.refugees_spawn_current_chance
    if spawnChance > 100 then
        spawnChance = 100
    end

    if spawnChance < 0 then
        spawnChance = 0
    end

    local yearsSurvived = mainPlayerPawn:getNumYearsSurvived()
    updateConfigFile("current_checked_year", yearsSurvived)

    if math.random(1,100) <= spawnChance then
        updateConfigFile("refugees_spawn_current_chance", config.refugees_spawn_base_chance)
        return true
    else
        updateConfigFile("refugees_spawn_current_chance", config.refugees_spawn_current_chance + config.refugees_spawn_incremental) -- Increase refugees spawn chance
        return false
    end
end

function spawnAtRandomDay(mainPlayerPawn)
    local dayOfYear = mainPlayerPawn:getDayOfTheYear()
    local yearsSurvived = mainPlayerPawn:getNumYearsSurvived()
    -- if true then
    if dayOfYear > math.random(2,360) then -- Temp disabled for debugging
        return true
    else
        return false
    end
end

function getBiggestPlayerRegion()
    local mainPlayerPawn = returnMainPlayerPawn()
    local regions = mainPlayerPawn:getAllCommandedRegions()
    local biggestRegionResidents = 0
    local biggestRegion = 0
    for i=1, #regions do
        local region = regions[i]:get()
        local residents = region.residents
        if #residents > biggestRegionResidents then
            biggestRegion = region
            biggestRegionResidents = #residents
        end
    end
    return biggestRegion
end

function getRandomSettledRegion()
    local mainPlayerPawn = returnMainPlayerPawn()
    local regions = mainPlayerPawn:getAllCommandedRegions()
    local settledRegions = {}
    local regionCnt = 1
    for i=1, #regions do
        local region = regions[i]:get()
        local residents = region.residents
        if #residents > 0 then
            settledRegions[regionCnt] = region
            regionCnt = regionCnt + 1
        end
    end
    return settledRegions[math.random(1, #settledRegions)]
end

function getRegionByRegionName(name)
    local mainPlayerPawn = returnMainPlayerPawn()
    local regions = mainPlayerPawn:getAllCommandedRegions()
    for i=1, #regions do
        local region = regions[i]:get()
        if region.regionName:ToString() == name then
            return region
        end
    end
    return 0
end

function spawnRefugeePopupMessage(mainPlayerPawn)
    -- local region = getBiggestPlayerRegion()
    local region = getRandomSettledRegion()
    local regionName = region.regionName:ToString()
    local stringPopUp = "\n\nRefugees seeking shelter!\n\nYou have 30 days to decide before they leave\n\nPress Ctrl+Y to accept refugees\nPress Ctrl+N to deny refugees"
    print(stringPopUp)
    mainPlayerPawn:playPopupMessageGUI(FName(stringPopUp), region);

    updateConfigFile("registered_keybind_y", 1)
    updateConfigFile("registered_keybind_n", 1)

    local RTSMultiEngineCPP = FindFirstOf("RTSMultiEngineCPP")
    if not RTSMultiEngineCPP:IsValid() then
        print("[refugeesMod] Couldn't get RTSMultiEngineCPP instance.\n")
        return
    end

    local daysTotal = RTSMultiEngineCPP:getDaysTotal()
    updateConfigFile("refugees_spawned_popup_message_day", daysTotal)
    updateConfigFile("refugees_spawned_popup_message", 1)
    updateConfigFile("refugees_popup_message_1", 0)
    updateConfigFile("refugees_popup_message_2", 0)
    updateConfigFile("refugees_popup_message_3", 0)
    updateConfigFile("refugees_popup_message_4", 0)
    -- updateConfigFile("refugees_region_spawn", "\"" .. regionName .. "\"")
    updateConfigFile("refugees_popup_message_1_day", daysTotal+16)
    updateConfigFile("refugees_popup_message_2_day", daysTotal+23)
    updateConfigFile("refugees_popup_message_3_day", daysTotal+29)
    
end

function addNewFamilies(region) 
    local mainPlayerPawn = returnMainPlayerPawn()

    local RTSMultiEngineCPP = FindFirstOf("RTSMultiEngineCPP")
    if not RTSMultiEngineCPP:IsValid() then
        print("[refugeesMod] Couldn't get RTSMultiEngineCPP instance.\n")
        return
    end

    local currentAmountFamilies = region:getTotalNumFamilies()

    local regionFVectorBorderRandomSide = region.regionBorder[math.random(1, #region.regionBorder)]
    local countFamilies = 0
    local initVector = 0
    for i=1, math.ceil(currentAmountFamilies/config.refugges_min_amount_divisor, currentAmountFamilies/config.refugees_max_amount_divisor) do
        local spawnFVectorVillager = {X = regionFVectorBorderRandomSide.X, Y = regionFVectorBorderRandomSide.Y, Z = regionFVectorBorderRandomSide.Z}
        if initVector == 0 then
            initVector = spawnFVectorVillager
        end
        spawnFVectorVillager.X = spawnFVectorVillager.X + i*250
        local husband = RTSMultiEngineCPP:spawnStartingVillager(0, spawnFVectorVillager, region, nil, mainPlayerPawn);
        local wife = RTSMultiEngineCPP:spawnStartingVillager(1, spawnFVectorVillager, region, nil, mainPlayerPawn);
        local familyID = region:addNewFamily({husband, wife})
        region:addNewFamilyMember(familyID, husband)
        region:addNewFamilyMember(familyID, wife)
        countFamilies = countFamilies + 1
    end
    
    mainPlayerPawn:playFeedbackText("Refugees coming!", initVector, 1)

    mainPlayerPawn:updateResidentsUI()
    return countFamilies

end

function spawnRefugees()
    local mainPlayerPawn = returnMainPlayerPawn()
    -- local region = getBiggestPlayerRegion()
    local region = getRandomSettledRegion()
    local regionName = region.regionName:ToString()
    local amountFamilies = addNewFamilies(region)
    mainPlayerPawn:playEventMessage(FName("Refugees"), "Refugees accepted!", "Refugees are now arriving from the border to " .. regionName)
    print(string.format("[refugeesMod] Spawned %s families", amountFamilies))

    local yearsSurvived = mainPlayerPawn:getNumYearsSurvived()
    updateConfigFile("refugees_spawned_year", yearsSurvived)

    local RTSMultiEngineCPP = FindFirstOf("RTSMultiEngineCPP")
    if not RTSMultiEngineCPP:IsValid() then
        print("[refugeesMod] Couldn't get RTSMultiEngineCPP instance.\n")
        return
    end

    local monthsTotal = RTSMultiEngineCPP:getMonthsTotal()
    updateConfigFile("refugees_spawned_month", monthsTotal)
    

end

gameLoaded = 0

RegisterHook("/Script/Engine.PlayerController:ClientRestart", function()
    print("ClientRestart - Game Loaded")
    gameLoaded = gameLoaded + 1
    if gameLoaded >= 2 then
        initializeConfigFile()
    end
end)

ExecuteWithDelay(60000, function ()
    RegisterHook("/Game/CPP_BP/MyPawnCPP_BP3.MyPawnCPP_BP3_C:ReceiveTick", function()
        if not alreadyTicking and gameLoaded >= 2 then
            -- initializeConfigFile()
            alreadyTicking = true
            ExecuteWithDelay(10000, function ()
                ExecuteInGameThread(function()
                    local RTSMultiEngineCPP = FindFirstOf("RTSMultiEngineCPP")
                    if not RTSMultiEngineCPP:IsValid() then
                        print("[refugeesMod] Couldn't get RTSMultiEngineCPP instance.\n")
                        return
                    end

                    local mainPlayerPawn = returnMainPlayerPawn()
                    if mainPlayerPawn == 0 then
                        print("[refugeesMod] Couldn't get mainPlayerPawn.\n")
                        return
                    end
                    
                    if checkCurrentYear(mainPlayerPawn) and config.spawn_refugees == 0 then
                        if checkIfToSpawnRefugees(mainPlayerPawn) then 
                            updateConfigFile("spawn_refugees", 1)
                        end
                    end
                    if config.spawn_refugees == 1 and config.refugees_spawned_popup_message == 0 then
                        if spawnAtRandomDay(mainPlayerPawn) then
                            print("Spawning refugee popup Message")
                            spawnRefugeePopupMessage(mainPlayerPawn)
                        end
                    end
                    
                    alreadyTicking = false

                    local daysTotal = RTSMultiEngineCPP:getDaysTotal()

                    if config.refugees_popup_message_1 == 0 and daysTotal > config.refugees_popup_message_1_day then
                        updateConfigFile("refugees_popup_message_1", 1)
                        mainPlayerPawn:playEventMessage(FName("Refugees_msg1"), "Refugees will leave in 14 days", "You have 14 days remaining to decide if to accept refugees")
                    end

                    if config.refugees_popup_message_2 == 0 and daysTotal > config.refugees_popup_message_2_day then
                        updateConfigFile("refugees_popup_message_2", 1)
                        mainPlayerPawn:playEventMessage(FName("Refugees_msg2"), "Refugees will leave in 7 days", "You have 7 days remaining to decide if to accept refugees")
                    end

                    -- if config.refugees_popup_message_3 == 0 and daysTotal > config.refugees_popup_message_3_day then
                    --     updateConfigFile("refugees_popup_message_3", 1)
                    --     mainPlayerPawn:playEventMessage(FName("Refugees_msg3"), "Refugees will leave tomorrow!", "You have until tomorrow to decide if to accept refugees")
                    -- end

                    if config.refugees_popup_message_4 == 0 and daysTotal > config.refugees_spawned_popup_message_day + 31 then
                        updateConfigFile("refugees_popup_message_4", 1)
                        updateConfigFile("registered_keybind_y", 0)
                        updateConfigFile("registered_keybind_n", 0)
                        updateConfigFile("spawn_refugees", 0)
                        updateConfigFile("refugees_spawned_popup_message", 0)
                        mainPlayerPawn:playEventMessage(FName("Refugees_leave"), "Refugees have left", "Refugees have left to find shelter somewhere else")
                    end

                    -- if config.check_lowered_approval == 1 then
                    --     removePastLoweredApprovalType21()
                    -- end

                    return 
                end)
            end)
        else
            -- print("[refugeesMod] Already running alreadyUpdateProblemUI")
        end
    end)
end)

RegisterKeyBind(Key.Y, { ModifierKey.CONTROL }, function()
    -- print("[refugeesMod] Key pressed\n")
    if config.registered_keybind_y == 1 then
        ExecuteInGameThread(function()
            print("[refugeesMod] Pressed Ctrl+Y - Refugees accepted")
            updateConfigFile("registered_keybind_y", 0)
            updateConfigFile("registered_keybind_n", 0)
            updateConfigFile("refugees_popup_message_1", 1)
            updateConfigFile("refugees_popup_message_2", 1)
            updateConfigFile("refugees_popup_message_3", 1)
            updateConfigFile("refugees_popup_message_4", 1)
            updateConfigFile("spawn_refugees", 0)
            updateConfigFile("refugees_spawned_popup_message", 0)
            updateConfigFile("refugees_region_spawn", 0)
            spawnRefugees()
        end)
    end
end)

RegisterKeyBind(Key.N, { ModifierKey.CONTROL }, function()
    -- print("[refugeesMod] Key pressed\n")
    if config.registered_keybind_n == 1 then
        ExecuteInGameThread(function()
            print("[refugeesMod] Pressed Ctrl+N - Refugees denied")
            updateConfigFile("registered_keybind_y", 0)
            updateConfigFile("registered_keybind_n", 0)
            updateConfigFile("refugees_popup_message_1", 1)
            updateConfigFile("refugees_popup_message_2", 1)
            updateConfigFile("refugees_popup_message_3", 1)
            updateConfigFile("refugees_popup_message_4", 1)
            updateConfigFile("spawn_refugees", 0)
            updateConfigFile("refugees_spawned_popup_message", 0)
            updateConfigFile("refugees_region_spawn", 0)
            local mainPlayerPawn = returnMainPlayerPawn()
            mainPlayerPawn:playEventMessage(FName("Refugees_denied"), "Refugees denied!", "Refugees have been denied access")
        end)
    end
end)